/***********************************************************************

Routine Name:           Windows Application Template

Source Filename:        TEMPL.C

Date:                   

Programmer:             

Modification Log:       

Description:

************************************************************************/

#include "templ.h"

char       szAppName[]     = "WINTEMPL";
char       FullAppName[]   = "Windows Application Template";



int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
   HWND        hwnd;
   MSG         msg;
   WNDCLASS    wndclass;
   HANDLE      hAccel;

   if (!hPrevInstance)
   {
      wndclass.style          = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc    = WndProc;
      wndclass.cbClsExtra     = 0;
      wndclass.cbWndExtra     = DLGWINDOWEXTRA;
      wndclass.hInstance      = hInstance;
      wndclass.hIcon          = LoadIcon (hInstance, szAppName);
      wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground  = COLOR_WINDOW + 1;
      wndclass.lpszMenuName   = NULL;
      wndclass.lpszClassName  = "WINTEMPL";

      RegisterClass (&wndclass);
   }

   hwnd = CreateDialog (hInstance, szAppName, 0, NULL);

   ShowWindow (hwnd, nCmdShow);

   hAccel = LoadAccelerators( hInstance, szAppName );

   while (GetMessage (&msg, NULL, 0, 0))
   {
      if( !TranslateAccelerator( hwnd, hAccel, &msg ) )
      {
         TranslateMessage (&msg);
         DispatchMessage (&msg);
      }
   }
   return msg.wParam;
}





long FAR PASCAL _export WndProc (HWND hwnd, UINT message,
                                 UINT wParam, LONG lParam)
{
   static FARPROC lpfnAboutBox;
   static HANDLE  hInstance;

   char buffer[256];

   switch (message)
   {
      case WM_CREATE:
           hInstance = ( (LPCREATESTRUCT) lParam)->hInstance;
           lpfnAboutBox = MakeProcInstance( (FARPROC) AboutBox, hInstance );
           return 0;


      case WM_COMMAND:
           switch( wParam )
           {
             case IDM_FILENEW:
             case IDM_FILEOPEN:
             case IDM_FILESAVE:
             case IDM_FILESAVEAS:
             case IDM_FILEPRINT:
             case IDM_FILEPAGESETUP:
             case IDM_FILEPRINTSETUP:

             case IDM_EDITUNDO:
             case IDM_EDITCUT:
             case IDM_EDITCOPY:
             case IDM_EDITPASTE:
             case IDM_EDITDELETE:
                  MessageBox( hwnd, (LPSTR) "Function Not Yet Implemented.",
                              (LPSTR) FullAppName,
                              MB_ICONINFORMATION | MB_OK );
                  return( 0 );

             case IDM_HELPCONTENTS:
                  WinHelp( hwnd, (LPSTR) "TEMPL.HLP",
                           HELP_CONTENTS, 0L );
                  return( 0 );

             case IDM_HELPSEARCH:
                  strcpy( buffer, "" );
                  WinHelp( hwnd, (LPSTR) "TEMPL.HLP",
                           HELP_PARTIALKEY, (DWORD) (LPSTR) buffer );
                  return( 0 );

             case IDM_HELPHELP:
                  WinHelp( hwnd, (LPSTR) "TEMPL.HLP",
                           HELP_HELPONHELP, 0L );
                  return( 0 );

             case IDM_FILEEXIT:
                  SendMessage( hwnd, WM_CLOSE, 0, 0L );
                  return( 0 );

             case IDM_HELPABOUT:
                  if( DialogBox( hInstance, "ABOUTBOX",
                                 hwnd, lpfnAboutBox ) );
                     InvalidateRect( hwnd, NULL, TRUE );
                  return( 0 );

           }
           break;

      case WM_CLOSE:
           DestroyWindow( hwnd );
           return 0;

      case WM_DESTROY:
           PostQuitMessage (0);
           return 0;
   }
   return DefWindowProc (hwnd, message, wParam, lParam);
}
