/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	__STDIO_H
#define	__STDIO_H

#ifndef	NULL
#define	NULL (void *) 0
#endif

typedef	struct
{
	int	fd;
	unsigned flags;
	int	modes;

	/* Buffering stuff */

	unsigned char	ungetchar;
	int	bufsize;
	int	bufidx;
	int	readsize;
	unsigned char	*buffer;
}	FILE;

#define	__FL_ERROR	0x0001
#define	__FL_EOF	0x0002
#define	__FL_UNGET	0x0004
#define	__FL_MODIFIED	0x0008
#define	__FL_EMPTY	0x0010
#define	__FL_READ	0x0020
#define	__FL_WRITE	0x0040

extern	FILE	_iob[];

#define	stdin	&_iob[0]
#define	stdout	&_iob[1]
#define	stderr	&_iob[2]

#define	EOF	((int) -1)

/* Buffered I/O functions. We supply these */
/* Input */
extern	int	ungetc(char __c, FILE *__fp);
extern	int	getc(FILE * __fp);
extern	int	scanf(char const *__format, ...);
extern	int	fscanf(FILE *__fp, char const *__format, ...);
extern	int	vfscanf(FILE *__fp, char const *__format, void *__arglist);
extern	char	*fgets(char *__buffer, int __size, FILE *__fp);
extern	char	*gets(char *__buffer);
extern	int	fread(char *__buffer, int __size, int __count, FILE *__fp);

/* Output */
extern	int	putc(char __c, FILE *__fp);
extern	int	printf(char const *__format, ...);
extern	int	fprintf(FILE *__fp, char const *__format, ...);
extern	int	vfprintf(FILE *__fp, char const *__format, void *__arglist);
extern	int	fputs(char const *__buffer, FILE *__fp);
extern	int	puts(char const *__buffer);
extern	int	fwrite(char const *__buffer, int __size, int __count, FILE *__fp);

/* Open/close */
extern	FILE	*fopen(char const *__filename, char const *__mode);
extern	FILE	*fdopen(int __fd, char const *__mode);
extern	FILE	*freopen(char const *__path, char const *__mode, FILE *__fp);
extern	int	fclose(FILE *__fp);
extern	FILE	*tmpfile(void);

/* Positioning */
extern	long	ftell(FILE *__fp);
extern	long	fseek(FILE *__fp, long __offset, int __from);
extern	void	rewind(FILE *__fp);
extern	int	feof(FILE *__fp);
extern	int	ferror(FILE *__fp);

/* Buffering */
extern	int	fflush(FILE *__fp);
extern	int	flushall(FILE *__fp);

#define	fileno(f)	(f)->fd
#define	_fileno(f)	(f)->fd


#define	getchar() getc(stdin)
#define	ungetchar() ungetc(stdin)
#define putchar(c) putc(c, stdout)
#define	vprintf(f, v) vfprintf(stdout, f, v)
#define	vscanf(f, v) vfscanf(stdin, f, v)

/* Other stdio functions - we expect these to be supplied by the native
 * C library.
 */

extern	int	system(char const *__command);
extern	void	perror(char const *__string);
extern	char	*strerror(int __errno);
extern	int	remove(char const *__path);
extern	int	rename(char const *__from, char const *__to);
extern	char	*sscanf(char const *__string, char const *__format, ...);
extern	char	*sprintf(char *__string, char const *__format, ...);
extern	char	*tmpnam(char *__seed);
extern	int	vsprintf(char *__string, char const *__format, void *__arglist);
extern	int	vsscanf(char const *__string, char const *__format, void *__arglist);
		 

#endif /* __STDIO_H */
