/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __task_h
#define __task_h

#define	UFILE_MAX	20
#define	TNTASK		20 /* Total number of tasks */

#define	HTASK_FLEDGELING	((HTASK) -1)

struct	task
{
	HTASK	hTask;
	short	pid;
	int	iFledgeling;	/* For our fork()			*/
	int	iParent;	/* For easy reference during fork/exec	*/
	int	nChildren;	/* Number of children executed		*/
	int	nZombies;	/* Number of zombies waiting for reaping */
	HFILE	files[UFILE_MAX];
	char	**argv;
	char	**envp;
	unsigned nFlags;
	int	nError;
};

#define	TF_ASLEEP	1	/* Task is sleeping		*/
#define	TF_EXEC		2	/* Task is execing a child	*/

/* An MS-Windows TASK handle is almost, but not quite, entirely unlike a process ID.
 * While the task is running, it uniquely identifies the task. The difference is, if
 * the parent process isn't careful, the task may terminate, and a new one may be
 * started with the same task handle. We need to have the parent task being capable
 * of knowing when its children die. Consequently, we need to keep a record of all
 * processes entering and leaving the system. If the process in question was started
 * using tkexec, and it exits it becomes a zombie until the parent waits for it.
 *
 * If the parent exits first, its parent pid becomes 1 (the process 1 doesn't exist,
 * but this mirrors Ken's OS), its parent hTask becomes 0, and the process is reaped
 * automatically on exit. This is getting scarily close to POSIX realities.
 *
 * Valid task handles are 2-32767. If a process exits while its child still lives,
 * the child is reaped on exit. Essentially, we try to maintain parent-child
 * relationships even though windows itself doesn't.
 *
 * We cannot maintain parent-child relationships if the child is WinExec'd. See
 * tkern.c for the reasoning. I think the cause is a Windows bug (gasp).
 *
 * One wonders why NT doesn't do something like this.
 */

struct	tk_process
{
	short	pid;		/* 0 for an empty entry					*/
	short	pidParent;	/* 1 for a task without a parent			*/
	HTASK	hTask;		/* 0 for a zombie					*/
	HTASK	hTaskParent;	/* 0 for a task without a parent			*/
	int	iParent;	/* -1 if the parent wasn't tkexec'd			*/
	int	nRetCode;	/* Return code of the program				*/
};

#define	N_TKPROCS	100	/* If we exceed this, we are in deep benji by-product	*/

#endif /* __task_h */
