/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __tdevice_h
#define __tdevice_h
#ifndef __tfile_h
#include <sys/tfile.h>
#endif

struct	tdevice
{
	int	(*open_strat)(char const *, int, int);
	long	(*seek_strat)(int, long, int);
	int	(*read_strat)(int, char *, int);
	int	(*write_strat)(int, char const *, int);
	int	(*close_strat)(int);
	int	(*ioctl_strat)(int, struct tk_ioctl *);
	char	const	*devname;
	int	flags;
};

#define	DF_TTY	1

extern	struct	tdevice	dev_list[];

#endif
