/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* tfile.h - definition of the tsh file structure */

#ifndef __tfile__h
#define	__tfile__h

#ifndef	__device_t
#include <sys/tdevice.h>
#endif

/* The tfile structure contains the per open file information for all of tkern */
struct	tfile
{
	int	tf_id;		/* the file id				*/
	int	tf_cnt;		/* The reference count			*/
	int	tf_dev;		/* The device number			*/
	int	tf_eof;		/* EOF seen by TKERN but not by program	*/
};

/*
 * tk_ioctl is the structure containing ioctl stuff for TKFMANGR
 */
#define	_TKIO_MAXBUF	256
struct	tk_ioctl
{
	long	nIOCtl;
	char	achBuffer[_TKIO_MAXBUF];
	int	nSize;
};

/* tfunc contains information used by file functions. This works by sending a message
 * to the tkern file manager such as:
 *
 * SendMessage(hManagerWindow, TKWM_function, tf_id, tfunc_info)
 *
 * TKWM_function is one of the TKWM_ constants defined in this file.
 * tf_id is from the tfile entry.
 * tfunc_info is the address of a tfunc structure, which must have been allocated as
 * a DDESHARE chunk of memory.
 * Note that we declare buffers in tfunc rather than pointers into the
 * original executable because we can't guarantee that TKFMANGR can
 * always read the original memory locations in all implimentations of
 * Win16.
 */

#define	_FNLEN	256
#define	_FBUFSZ	1024

struct	tfunc
{
	int	iDevice;		/* Device number	*/
	char	achFile[_FNLEN];	/* Open, GetDevNo	*/
	char	achBuffer[_FBUFSZ];	/* Read, Write		*/
	int	nBytes;			/* Read, Write		*/
	long	nPosition;		/* Seek			*/
	int	nFrom;			/* Seek			*/
	int	nMode;			/* Open			*/
	int	nAccess;		/* Open			*/
	int	iTask;			/* The task index	*/
	struct tk_ioctl tki;		/* Ioctl information	*/
};

#define	TKWM_OPEN	(WM_USER + 1)
#define	TKWM_CLOSE	(WM_USER + 2)
#define TKWM_IOCTL	(WM_USER + 3)
#define	TKWM_READ	(WM_USER + 4)
#define	TKWM_WRITE	(WM_USER + 5)
#define	TKWM_SEEK	(WM_USER + 6)
#define	TKWM_GETDEVNO	(WM_USER + 7)
#define	TKWM_ISATTY	(WM_USER + 8)
#define	TKWM_ALLDONE	(WM_USER + 9)

#define	TNFILE	50

/* File error return codes. Only -1 should get back to the user
 * program
 */

#define	FR_ERROR	-1	/* Genuine error - fail		*/
#define	FR_NOTREADY	-2	/* Flush messsages and retry	*/


int	get_device_number(char const *pchName);

#endif
