/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	__TKTTY_H
#define	__TKTTY_H

#ifndef __TKIOCTL_H
#include <sys/ioctl.h>
#endif

/* Type of ARG for TIOCGETC and TIOCSETC requests.  */
struct tchars
{
  char t_intrc;			/* Interrupt character.  */
  char t_quitc;			/* Quit character.  */
  char t_startc;		/* Start-output character.  */
  char t_stopc;			/* Stop-output character.  */
  char t_eofc;			/* End-of-file character.  */
  char t_brkc;			/* Input delimiter character.  */
};

/* Type of ARG for TIOCGLTC and TIOCSLTC requests. */
struct ltchars
{
  char t_suspc;			/* Suspend character.  */
  char t_dsuspc;		/* Delayed suspend character.  */
  char t_rprntc;		/* Reprint-line character.  */
  char t_flushc;		/* Flush-output character.  */
  char t_werasc;		/* Word-erase character.  */
  char t_lnextc;		/* Literal-next character.  */
};

/* Type of ARG for TIOCGETP and TIOCSETP requests (and gtty and stty).  */
struct sgttyb
{
  char sg_ispeed;		/* Input speed.  */
  char sg_ospeed;		/* Output speed.  */
  char sg_erase;		/* Erase character.  */
  char sg_kill;			/* Kill character.  */
  unsigned long sg_flags;	/* Mode flags.  */
};

/* Type of ARG for TIOCGWINSZ and TIOCSWINSZ requests.  */
struct winsize
{
  unsigned short int ws_row;	/* Rows, in characters.  */
  unsigned short int ws_col;	/* Columns, in characters.  */

  unsigned short int ws_xpixel;	/* Horizontal pixels.  */
  unsigned short int ws_ypixel;	/* Vertical pixels.  */
};

struct ttysize
{
  unsigned short int ts_lines;
  unsigned short int ts_cols;
  unsigned short int ts_xxx;
  unsigned short int ts_yyy;
};

#define	TIOCGETP	_IOW('t', 1, struct sgttyb)
#define	TIOCSETP	_IOR('t', 2, struct sgttyb)
#define	TIOCGLTC	_IOW('t', 3, struct ltchars)
#define	TIOCSLTC	_IOR('t', 4, struct ltchars)
#define	TIOCGETC	_IOW('t', 5, struct tchars)
#define	TIOCSETC	_IOR('t', 6, struct tchars)
#define	TIOCGWINSZ	_IOW('t', 7, struct winsize)
#define	TIOCSWINSZ	_IOR('t', 8, struct winsize)
#define	TIOCGSIZE	TIOCGWINSZ
#define	TIOCSSIZE	TIOCSWINSZ

#define	CBREAK	0x00001	/* Pass on each char as received (no edit box)	*/
#define	ECHO	0x0002	/* Echo input (Move edit box on screen)		*/
#define	CRMOD	0x0004	/* Convert ^M  to ^J on input			*/
#define	LITOUT	0x0008	/* No preprocessing of output chars		*/
#define	RAW	0x0010	/* Treat input and output as a raw byte stream	*/
#define	FLUSHO	0x0020	/* Flush output					*/
#define	DECCTQ	0x0040	/* Only startc restarts after stopc		*/
#define	NOFLSH	0x0080	/* Don't flush on interrupt etc			*/

/* The following options don't really apply to TKERN, but
 * some programs that might reasonably use TKERN might use
 * them anyway.
 */
#define	TANDEM	0x0100
#define	XTABS	0x0200
#define	NOHANG	0x0400
#define	CRTBS	0x0800
#define	PRTERA	0x1000
#define	CRTERA	0x2000
#define	PASS8	0x4000
#define	CTLECH	0x8000

#endif /* __TKTTY_H */
