/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <errno.h>
#include <sys/tdevice.h>

extern	int	nError;

#pragma argsused
static	long
invalid_seek(	int	id,
		long	loc,
		int	from)
{
	nError = EINVAL;
	return -1;
}

extern	int	window_open(	char const *,
				int,
				int);
extern	int	window_close(	int);
extern	int	window_read(	int,
				char *,
				int);
extern	int	window_write(	int,
				char const *,
				int);
extern	int	window_ioctl(	int,
				struct	tk_ioctl *);
				

extern	int	file_open(	char const *,
				int,
				int);
extern	int	file_close(	int);
extern	long	file_seek(	int,
				long,
				int);
extern	int	file_read(	int,
				char *,
				int);
extern	int	file_write(	int,
				char const *,
				int);
extern	int	file_ioctl(	int,
				struct	tk_ioctl *);
				

struct	tdevice	dev_list[] =
{
    {
	window_open,	invalid_seek,	window_read,	window_write,
	window_close,	window_ioctl,	"window",	DF_TTY,	/* 00 */
    },

    {
	file_open,	file_seek,	file_read,	file_write,
	file_close,	file_ioctl,	"file",		0	/* 01 */
    }
};

int	num_devs = sizeof(dev_list) / sizeof(dev_list[0]);


int
get_device_number(char const *pchDevice)
{
	int	i;
	char	achDevice[256];
	char	const *c;

	c = strchr(pchDevice, '/');
	if (c)
	{
		if (c - pchDevice >= 256)
			return -1;
		strncpy(achDevice, pchDevice, c - pchDevice);
		achDevice[c - pchDevice] = 0;
	}
	else
	{
		strcpy(achDevice, pchDevice);
	}

	for (i = 0; i < num_devs; i++)
	{
		if (!strcmp(achDevice, dev_list[i].devname))
			return i;
	}
	return 0;
}
