/*
 *	Include file for the TOOLBAR library
 *	Copyright (C) Stephen Chung, 1991.
 *	All rights reserved.
 *
 *	Class wrapper (C) Tim Liddelow 1992
 */

#define TOOLBARCLASS        "Toolbar"
#define TOOLBARBUTTONCLASS  "Toolbar Button"

typedef struct {
	int id;                     /* Initialize these fields */
	int x, y;
	int width, height;
	int state, cycle;
	char *disabled;
	char *undepressed;
	char *depressed;
	char *grayed;
	char *pressing;

	HWND hwnd;                  /* The following fields are only used by */
	int oldstate;               /* the library. DO NOT TOUCH THEM.       */
} TOOLBARICON;

class ToolBar
{
	HWND hwnd;
	static BOOL ClassRegistered;
	static BOOL Capturing;

	public:
		static long FAR PASCAL ToolbarProc (HWND, WORD, WORD, LONG);
		static long FAR PASCAL ToolbarButtonProc (HWND, WORD, WORD, LONG);

		ToolBar(HWND parent, int x, int y, int width, int height,
					int thickness, int id, int n, HANDLE hInstance,
					TOOLBARICON *icons, char *xcursor);
		void Show() { ShowWindow (hwnd, SW_SHOW); };
		void Hide() { ShowWindow (hwnd, SW_HIDE); };
		HWND Window() { return hwnd; };
		void Resize (int x, int y, int width, int height, BOOL bRepaint);
		void EnableToolbarButton(int id, BOOL enabled);
		HWND GetToolbarButton (int id, TOOLBARICON *ip);
		void ModifyToolbarButton (TOOLBARICON *icon);
};



extern void Create3DEffect (HDC, RECT *, int, int);
