;**************************************************************************
;*  TOOLHELP.INC
;*
;*      Assembly-language public include file for TOOLHELP.DLL
;*
;**************************************************************************

;** General symbol values
MAX_DATA        EQU     11
MAX_PATH        EQU     255
MAX_MODULE_NAME EQU     8 + 1           ;Leave room for the zero and padding
MAX_CLASSNAME   EQU     255

; ----- Global heap walking -----

GLOBALENTRY STRUC
ge_dwSize       DD      ?               ;Structure version
ge_dwAddress    DD      ?               ;This block's address
ge_dwBlockSize  DD      ?               ;This block's size
ge_hBlock       DW      ?               ;This block's handle
ge_wcLock       DW      ?               ;Lock count
ge_wcPageLock   DW      ?               ;Page lock count
ge_wFlags       DW      ?               ;Block flags
ge_wHeapPresent DW      ?               ;Size of available local heap
ge_hOwner       DW      ?               ;Owner handle
ge_wType        DW      ?               ;Block type
ge_wData        DW      ?               ;Type-specific data
ge_dwNext       DD      ?               ;Pointer to next block
ge_dwNextAlt    DD      ?               ;Next free/LRU block in chain
GLOBALENTRY ENDS

; ** GlobalFirst()/GlobalNext() flags
GLOBAL_ALL      EQU     0
GLOBAL_LRU      EQU     1
GLOBAL_FREE     EQU     2

; ** GLOBALENTRY.ge_wType entries
GT_UNKNOWN      EQU     0
GT_DGROUP       EQU     1
GT_DATA         EQU     2
GT_CODE         EQU     3
GT_TASK         EQU     4
GT_RESOURCE     EQU     5
GT_MODULE       EQU     6
GT_FREE         EQU     7
GT_INTERNAL     EQU     8
GT_SENTINEL     EQU     9
GT_BURGERMASTER EQU     10

; ** if GLOBALENTRY.wType==GT_RESOURCE, the following is GLOBALENTRY.wData:
GD_USERDEFINED          EQU     0
GD_CURSORCOMPONENT      EQU     1
GD_BITMAP               EQU     2
GD_ICONCOMPONENT        EQU     3
GD_MENU                 EQU     4
GD_DIALOG               EQU     5
GD_STRING               EQU     6
GD_FONTDIR              EQU     7
GD_FONT                 EQU     8
GD_ACCELERATORS         EQU     9
GD_RCDATA               EQU     10
GD_ERRTABLE             EQU     11
GD_CURSOR               EQU     12
GD_ICON                 EQU     14
GD_NAMETABLE            EQU     15
GD_MAX_RESOURCE         EQU     15

;** GLOBALENTRY.wFlags
GF_PDB_OWNER    EQU     100h            ;Low byte is KERNEL flags

; ----- Local heap walking -----

LOCALENTRY STRUC
le_dwSize       DD      ?
le_hHandle      DW      ?
le_wAddress     DW      ?
le_wSize        DW      ?
le_wFlags       DW      ?
le_wcLock       DW      ?
le_wType        DW      ?
le_hHeap        DW      ?
le_wHeapType    DW      ?
le_wNext        DW      ?
LOCALENTRY ENDS

; ** LOCALENTRY.wHeapType flags
NORMAL_HEAP     EQU     0
USER_HEAP       EQU     1
GDI_HEAP        EQU     2

;** LOCALENTRY.wFlags
LF_FIXED                EQU     1
LF_FREE                 EQU     2
LF_MOVEABLE             EQU     4

;** LOCALENTRY.wType
LT_NORMAL               EQU     0
LT_GDI_PEN              EQU     1
LT_GDI_BRUSH            EQU     2
LT_GDI_FONT             EQU     3
LT_GDI_PALETTE          EQU     4
LT_GDI_BITMAP           EQU     5
LT_GDI_RGN              EQU     6
LT_GDI_DC               EQU     7
LT_GDI_DISABLED_DC      EQU     8
LT_GDI_METADC           EQU     9
LT_GDI_METAFILE         EQU     10
LT_GDI_MAX              EQU     LT_GDI_METAFILE
LT_FREE                 EQU     0ffh

; ----- Stack tracing -----

STACKTRACEENTRY STRUC
st_dwSize       DD      ?
st_hTask        DW      ?
st_wSS          DW      ?
st_wBP          DW      ?
st_wCS          DW      ?
st_wIP          DW      ?
st_hModule      DW      ?
st_wSegment     DW      ?
st_wFlags       DW      ?
STACKTRACEENTRY ENDS

;** STACKTRACEENTRY.wFlags values
FRAME_FAR       EQU     0
FRAME_NEAR      EQU     1

; ----- Module list walking -----

MODULEENTRY STRUC
me_dwSize       DD      ?
me_szModule     DB      MAX_MODULE_NAME + 1 DUP(?)
me_hModule      DW      ?
me_wUsageFlags  DW      ?
me_szExePath    DB      MAX_PATH + 1 + 1 DUP(?)
me_wNext        DW      ?
MODULEENTRY ENDS

; ----- Task list walking -----

TASKENTRY STRUC
te_dwSize               DD      ?
te_hTask                DW      ?
te_hTaskParent          DW      ?
te_hInst                DW      ?
te_hModule              DW      ?
te_wSS                  DW      ?
te_wSP                  DW      ?
te_wStackTop            DW      ?
te_wStackMinimum        DW      ?
te_wStackBottom         DW      ?
te_wcEvents             DW      ?
te_hQueue               DW      ?
te_szModule             DB      MAX_MODULE_NAME + 1 DUP(?)
te_wPSPOffset           DW      ?
te_hNext                DW      ?
TASKENTRY ENDS

;** TaskSwitch() return values
TS_ERROR    EQU         0
TS_NEW      EQU         1
TS_OLD      EQU         2

; ----- Window Class enumeration -----

CLASSENTRY STRUC
ce_dwSize               DD      ?
ce_hInst                DW      ?
ce_szClassName          DB      MAX_CLASSNAME + 1 DUP(?)
ce_wNext                DW      ?
CLASSENTRY ENDS

; ----- Information functions -----

VMEMMANINFO STRUC
vmm_dwSize              DD      ?
vmm_dwLargestFreeBlock  DD      ?
vmm_dwMaxPagesAvailable DD      ?
vmm_dwMaxPagesLockable  DD      ?
vmm_dwTotalLinearSpace  DD      ?
vmm_dwTotalUnlockedPages DD     ?
vmm_dwFreePages         DD      ?
vmm_dwTotalPages        DD      ?
vmm_dwFreeLinearSpace   DD      ?
vmm_dwSwapFilePages     DD      ?
vmm_wPageSize           DW      ?
VMEMMANINFO ENDS

USERHEAPINFO STRUC
ui_dwSize               DD      ?
ui_wHeapFree            DW      ?
ui_wMaxHeapSize         DW      ?
ui_wPercentFree         DW      ?
ui_hSegment             DW      ?
USERHEAPINFO ENDS

GDIHEAPINFO STRUC
gi_dwSize               DD      ?
gi_wHeapFree            DW      ?
gi_wMaxHeapSize         DW      ?
gi_wPercentFree         DW      ?
gi_hSegment             DW      ?
GDIHEAPINFO ENDS

; ----- Notifications -----

;* NFY_UNKNOWN:  An unknown notification has been returned from KERNEL.  Apps
;*      should ignore these.
;*
NFY_UNKNOWN     EQU     0

;** NFY_LOADSEG:  dwData points to a NFYLOADSEG structure
NFY_LOADSEG     EQU     1
NFYLOADSEG STRUC
nls_dwSize              DD      ?
nls_wSelector           DW      ?
nls_wSegNum             DW      ?
nls_wType               DW      ?
nls_hInstance           DW      ?
nls_lpstrModuleName     DD      ?
NFYLOADSEG ENDS

;** NFY_FREESEG:  LOWORD(dwData) is the selector of the segment being freed
NFY_FREESEG     EQU     2

;** NFY_STARTTASK:  dwData points to a NFYSTARTTASK structure
NFY_STARTTASK   EQU     3
NFYSTARTTASK STRUC
nst_dwSize              DD      ?
nst_hInstance           DW      ?
nst_wCS                 DW      ?
nst_wIP                 DW      ?
NFYSTARTTASK ENDS

;** NFY_EXITTASK:  The low byte of dwData contains the program exit code
NFY_EXITTASK    EQU     4

;** NFY_LOADDLL:  dwData points to a NFYLOADDLL structure
NFY_LOADDLL     EQU     5
NFYLOADDLL STRUC
nld_dwSize              DD      ?
nld_hModule             DW      ?
nld_wCS                 DW      ?
nld_wIP                 DW      ?
NFYLOADDLL ENDS

;** NFY_DELMODULE:  LOWORD(dwData) is the handle of the module to be freed
NFY_DELMODULE   EQU     6

;** NFY_DEBUGSTR:  dwData points to the string to be output
NFY_DEBUGSTR    EQU     7

;** NFY_RIP:  dwData points to a NFYRIP structure
NFY_RIP         EQU     8
NFYRIP STRUC
nrp_wExitCode           DW      ?
nrp_wCS                 DW      ?
nrp_wIP                 DW      ?
NFYRIP ENDS

;** NFY_TASKIN:  LOWORD(dwData) is the hTask for the entering task
NFY_TASKIN      EQU     9

;** NFY_TASKOUT:  LOWORD(dwData) is the hTask for the task being left
NFY_TASKOUT     EQU     10

;** NFY_INCHAR:  Return value of callback is used.  If FALSE, mapped to 'i'
NFY_INCHAR      EQU     11

;** NFY_OUTSTR:  dwData points to the string to be displayed
NFY_OUTSTR      EQU     12

;** NFY_CTLALTSYSRQ:  dwData points to instruction to set breakpoint at
NFY_CTLALTSYSRQ EQU     13

;** NotifyRegister() flags
NF_NORMAL       EQU     0
NF_TASKSWITCH   EQU     1
NF_RIP          EQU     2
NF_DEBUGSTR     EQU     4

;** TerminateApp() flag values
UAE_BOX         EQU     0
NO_UAE_BOX      EQU     1

TIMERINFO STRUC
ti_dwSize               DD      ?
ti_dwmsSinceStart       DD      ?
ti_dwmsThisVM           DD      ?
TIMERINFO ENDS

