Program Trash;

{$R-,I-,G+,W-,S-,D-,L-}

{$R TRASH}

Uses
 WinTypes,WinProcs,Win31,ShellAPI,WObjects,Strings;

Type
  PTrashWin = ^TTrashWin;
  TTrashWin = Object(TWindow)
                Procedure SetupWindow;
                  Virtual;

                Function GetClassName : PChar;
                  Virtual;

                Procedure GetWindowClass(Var AWndClass : TWndClass);
                  Virtual;

                Procedure WMQueryOpen(Var Msg : TMessage);
                  Virtual wm_QueryOpen;

                Procedure WMDropFiles(var Msg : TMessage);
                  Virtual wm_first + wm_DropFiles;

                Procedure FileDropped(FileName : PChar;
                                      Var DropPos : TPoint;
                                      InClient : Boolean);
                  Virtual;
              End;

 TMyApp = Object(TApplication)
            Procedure InitMainWindow;
              Virtual;
          End;

Const
  AppName = 'Trash Can';

{---------------------------------------------------}

{ --- Application Methods --- }

Procedure TMyApp.InitMainWindow;

Begin
  MainWindow := New(PTrashWin,Init(nil,AppName));
End;

{---------------------------------------------------}

{ --- Window Methods --- }

Procedure TTrashWin.SetupWindow;

Begin
  TWindow.SetupWindow;

  DragAcceptFiles(hWindow,True); { Inform Windows that we accept file drops }
End {SetupWindow};

{---------------------------------------------------}

Procedure TTrashWin.WMDropFiles;

Var
 NumFiles : word;
 FileName : array[0..127] of char;
 i : word;
 DropPoint : TPoint;
 InClientArea : boolean;

Begin
 { Msg.wParam contains a handle to the "drop info" }

 { First, find out how many files were dropped }
 NumFiles := DragQueryFile(Msg.wParam,$FFFF,Nil,0);

 { Next, find out where the file was dropped }
 InClientArea := DragQueryPoint(Msg.wParam,DropPoint);

 { Finally, retrieve the dropped files and call the virtual method
   "FileDropped" }
 For i := 0 to Pred(NumFiles) Do
 Begin
   DragQueryFile(Msg.wParam,i,FileName,Pred(Sizeof(FileName)));
   FileDropped(FileName,DropPoint,InClientArea);
 End;

 { Cleanup - tell Windows that we're done with the "drop info" }
 DragFinish(Msg.wParam);

End {WMDropFiles};

{---------------------------------------------------}

Procedure TTrashWin.FileDropped(FileName : PChar;
                                       Var DropPos : TPoint;
                                       InClient : Boolean);

Var
  TrashFile : File;
  Tx : Array [0..80] of Char;
  Res : Word;

Begin
  SetClassWord(HWindow,gcw_HIcon,LoadIcon(HInstance,'CANFLAME'));
  InvalidateRect(HWindow,Nil,True);

  StrCopy(Tx,'Trash ');
  StrCat(Tx,FileName);
  StrCat(Tx,'?');

  Res := MessageBox(HWindow,Tx,'Trash Can',mb_YesNo or mb_IconQuestion);

  If Res = id_Yes
    Then Begin
           SetClassWord(HWindow,gcw_HIcon,LoadIcon(HInstance,'CANDEL'));
           InvalidateRect(HWindow,Nil,True);
           UpdateWindow(HWindow);

           Assign(TrashFile,FileName);
           Erase(TrashFile);
         End;

  SetClassWord(HWindow,gcw_HIcon,LoadIcon(HInstance,'CAN'));
  InvalidateRect(HWindow,Nil,True);

End {FileDropped};

{---------------------------------------------------}

Procedure TTrashWin.WMQueryOpen(Var Msg : TMessage);

Begin
  Msg.Result := 0;       { Deny open }
End {WMQueryOpen};

{---------------------------------------------------}

Function TTrashWin.GetClassName;

Begin
  GetClassName := AppName;
End {GetClassName};

{---------------------------------------------------}

Procedure TTrashWin.GetWindowClass(Var AWndClass : TWndClass);

Begin
  TWindow.GetWindowClass(AWndClass);

  AWndClass.hIcon := LoadIcon(HInstance,'CAN');
End {GetWindowClass};

{---------------------------------------------------}

Var
  MyApp : TMyApp;

Begin
  CmdShow := sw_ShowMinNoActive;

  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
End.
