      SUBROUTINE CHCASE(INNAME,OUTNAM,ITYPE,IERR,IOCHEK [REFERENCE])
C
C     ------------------------------------------------------------------
C     PURPOSE:
C              CONVERT ALL CHARACTERS IN A FILE TO UPPER OR LOWER CASE.
C              STRIPS OFF ANYTHING PAST COLUMN 72, HOWEVER.
C
C     ------------------------------------------------------------------
C     INPUT PARAMETERS WHICH MUST BE SUPPLIED BY THE CALLING PROGRAM:
C
C     INNAME  IS NAME OF (INPUT) FILE (MAX CHARS=64) TO BE CONVERTED.
C             THE CALLING PROGRAM SHOULD CHECK FOR EXISTENCE!
C
C     OUTNAME IS NAME (MAX CHARS=64) OF FILE TO USE FOR OUTPUT.
C             THE CALLER SHOULD HANDLE DECICIONS ON PREEXISTING FILES
C             SINCE THIS ROUTINE WILL OVERWRITE THEM UNCONDITINALLY.
C
C     ITYPE: (TYPE OF CONVERSION DESIRED):
C            1 - CONVERT ALL CHARACTERS TO UPPER CASE.
C            2 - CONVERT ALL CHARACTERS TO LOWER CASE.
C
C     ------------------------------------------------------------------
C
C     RETURNED PARAMETERS:
C
C     IERR:   (ERROR RETURN CODE):
C             0 <-> NO PROBLEM
C             1 <-> INPUT FILE COULD NOT BE OPENED.
C             2 <-> OUPUT FILE COULD NOT BE OPENED.
C
C
C     IOCHEK: SEE THE FORTRAN MANUALS.
C     ------------------------------------------------------------------
C
C THIS IS PART OF AN ATTEMPT TO SEE IF I CAN CREATE A DLL USING
C MICROSOFT FROTRAN 5.1 AND THEN CALL IT TROM TURBOPASCAL FOR WINDOWS.
C
C
C      STRIPS COLS 72-80 FROM FORTRAN SOURCE CODES
C      AND CHANGES CASE UPPER TO LOWER OR VICE VERSA
C
      CHARACTER ALINE(80)
      CHARACTER*64 INNAME,OUTNAM
      CHARACTER SPC
C
      DATA IOIN/2/  IOUT /3/
C
      IERR = 0
      OPEN (IOIN,FILE=INNAME,STATUS='OLD',IOSTAT=IOCHEK,ERR = 910)
      OPEN (IOUT,FILE=OUTNAM,STATUS='UNKNOWN',IOSTAT=IOCHEK,ERR=920)
C
   40 FORMAT(80A1)
      SPC=CHAR(32)
      IAU=65
      IZU=90
      IAL=97
      IZL=122
C
  140 CONTINUE
C
C     READ A LINE OF CODE FROM THE INPUT FILE

      READ(IOIN,40,END=500,ERR= 930,IOSTAT=IOCHEK) ALINE
C
C     FIND THE LENGTH OF THE LINE W/O TRAILING SPACES
C
      LEN=73
      DO 150 I=1,72
      LEN=LEN-1
      IF(ALINE(LEN).NE.SPC) GOTO 152
  150 CONTINUE
  152 CONTINUE
C
      IF (ITYPE.EQ.1) THEN

C
C     NOW CONVERT THE CHARACTERS TO UPPER CASE
C
      DO 155 I=1,LEN
      INX=ICHAR(ALINE(I))
      IF(INX.GE.IAL.AND.INX.LE.IZL) ALINE(I)=CHAR(INX-32)
  155 CONTINUE
C
      ELSE
C
C     OR  CONVERT TO LOWER CASE
C
      DO 158 I=1,LEN
      INX=ICHAR(ALINE(I))
      IF(INX.GE.IAU .AND. INX.LE.IZU) ALINE(I)=CHAR(INX+32)
  158 CONTINUE   
      END IF
C
C     WRITE SIGINIFICANT PORTION TO THE OUTPUT FILE
C
  160 WRITE(IOUT,40)(ALINE(I),I=1,LEN)
C
C     GO BACK FOR THE NEXT LINE
C

      GOTO 140
C
C     AT END OF INPUT FILE, CLOSE BOTH IOUT AND IOIN
C 
  500 CLOSE(IOUT)
      CLOSE(IOIN)
      RETURN
  910 IERR = 1
      RETURN
  920 IERR = 2
      RETURN
  930 IERR = 3
      RETURN
      END
