{***********************************************************************}
{                                                                       }
{  Microsoft Multimedia Player Function Prototypes                      }
{  Links to the mmp.dll in the Microsoft Multimedia Extensions          }
{  Converted by Steve Milton @ ISOMEDIA, Inc. for use with              }
{  Borland's Turbo Pascal for Windows                                   }
{                                                                       }
{  These units are provided as-is with no warranty.  Any damages to     }
{  equipment, peripherals, software, or anything else is solely the     }
{  responsibility of the user.                                          }
{                                                                       }
{  Microsoft Multimedia Extensions is a trademark of Microsoft, Corp.   }
{  Turbo Pascal for Windows is a trademakr of Borland International     }
{                                                                       }
{***********************************************************************}

unit MMP;

INTERFACE

uses WinTypes, MMPTYPES;

FUNCTION mmpOpen(hWndStage: HWND; wOptions: WORD) : MMPID;
FUNCTION mmpClose(idMovie: MMPID; wOptions: WORD) : BOOLEAN;
FUNCTION mmpStartAnimating(idMovie: MMPID; wOptions: WORD) : BOOLEAN;
FUNCTION mmpAnimate(idMovie: MMPID) : INTEGER;
FUNCTION mmpAnimStatus(idMovie: MMPID) : INTEGER;
FUNCTION mmpStopAnimating(idMovie: MMPID; wOptions: WORD) : BOOLEAN;
FUNCTION mmpGoToFrame(idMovie: MMPID; sNewFrame: SHORTINT;
         wOptions: WORD) : BOOLEAN;
FUNCTION mmpUpdate(idMovie: MMPID; hDC: HDC; lprectArea: LP_RECT) : BOOLEAN;
FUNCTION mmpSetFrameHook(idMovie: MMPID;
         lpFrameHook: LP_MMPFRAMEHOOK) : BOOLEAN;
FUNCTION mmpGetFrameHook(idMovie: MMPID) : LP_MMPFRAMEHOOK;
FUNCTION mmpGetFileInfo(lpszFileName: POINTER;
         lpInfo: LP_MMPMOVIEINFO) : BOOLEAN;
FUNCTION mmpGetMovieInfo(idMovie: MMPID; lpInfo: LP_MMPMOVIEINFO) : BOOLEAN;
FUNCTION mmpLoadFile(idMovie: MMPID; lpszFileName: POINTER;
         wOptions: WORD) : BOOLEAN;
FUNCTION mmpFreeFile(idMovie: MMPID; wOptions: WORD) : BOOLEAN;
FUNCTION mmpFileLoaded(idMovie: MMPID) : BOOLEAN;
FUNCTION mmpError(idMovie: MMPID; szErrorString: POINTER;
         wLen: WORD) : SHORTINT;
FUNCTION mmpAnimStopped(idMovie: MMPID) : BOOLEAN;
FUNCTION mmpGetCurFrame(idMovie: MMPID) : SHORTINT;
FUNCTION mmpGetMute(idMovie: MMPID) : BOOLEAN;
FUNCTION mmpSetMute(idMovie: MMPID; bMuteOn: BOOLEAN) : BOOLEAN;
FUNCTION mmpSetStage(idMovie: MMPID; hWndStage: HWND;
         lprectStage: LP_RECT; wOptions: WORD) : BOOLEAN;
FUNCTION mmpGetStage(idMovie: MMPID; hWndStage : HWND;
         lprectStage: LP_RECT; lpwOptions: LP_WORD) : BOOLEAN;
FUNCTION mmpSetRepeat(idMovie: MMPID; bbRepeat: BOOLEAN) : BOOLEAN;
FUNCTION mmpGetRepeat(idMovie: MMPID) : BOOLEAN;
FUNCTION mmpSetDC(idMovie: MMPID; theDC: HDC) : BOOLEAN;
FUNCTION mmpGetPaletteHandle(idMovie: MMPID) : HPALETTE;
FUNCTION mmpSetTempo(idMovie: MMPID; sTempo: SHORTINT) : BOOLEAN;
FUNCTION mmpGetTempo(idMovie: MMPID) : SHORTINT;
FUNCTION mmpGetInfo(idMovie: MMPID; nIndex: INTEGER; lpData: LPVOID;
         wLen: WORD) : BOOLEAN;
FUNCTION mmpSetInfo(idMovie: MMPID; nIndex: INTEGER; lpData: LPVOID;
         wLen: WORD) : BOOLEAN;


IMPLEMENTATION

FUNCTION mmpGetRepeat; 				external 'mmp' index  20;
FUNCTION mmpGetMovieInfo;			external 'mmp' index  97;
FUNCTION mmpGetPaletteHandle;			external 'mmp' index 100;
FUNCTION mmpClose;				external 'mmp' index   2;
FUNCTION mmpSetRepeat;				external 'mmp' index  19;
FUNCTION mmpError;				external 'mmp' index   3;
FUNCTION mmpLoadFile;				external 'mmp' index   4;
FUNCTION mmpFreeFile;				external 'mmp' index   5;
FUNCTION mmpGetTempo;				external 'mmp' index  23;
FUNCTION mmpSetTempo; 				external 'mmp' index  22;
FUNCTION mmpAnimStatus;				external 'mmp' index 103;
FUNCTION mmpAnimate;				external 'mmp' index   8;
FUNCTION mmpUpdate;				external 'mmp' index  16;
FUNCTION mmpGotoFrame;				external 'mmp' index  13;
FUNCTION mmpFileLoaded;				external 'mmp' index   6;
FUNCTION mmpStartAnimating;			external 'mmp' index 7;
FUNCTION mmpGetInfo;				external 'mmp' index 101;
FUNCTION mmpGetFileInfo;			external 'mmp' index 59;
FUNCTION mmpSetInfo;				external 'mmp' index 102;
FUNCTION mmpOpen;				external 'mmp' index 1;
FUNCTION mmpGetMute;				external 'mmp' index 98;
{FUNCTION mmpIsLastFrame;			external 'mmp' index 58;}
FUNCTION mmpSetMute;				external 'mmp' index 57;
FUNCTION mmpGetCurFrame;			external 'mmp' index 14;
FUNCTION mmpSetDC;				external 'mmp' index 54;
FUNCTION mmpGetStage;				external 'mmp' index 18;
FUNCTION mmpGetFrameHook;			external 'mmp' index 53;
FUNCTION mmpSetStage;				external 'mmp' index 17;
FUNCTION mmpStopAnimating;			external 'mmp' index 10;
FUNCTION mmpSetFrameHook;			external 'mmp' index 52;
FUNCTION mmpAnimStopped;			external 'mmp' index 11;


BEGIN
END.
