{***********************************************************************}
{                                                                       }
{  Microsoft Multimedia Player Structures and Constants                 }
{  Links to the mmp.dll in the Microsoft Multimedia Extensions          }
{  Converted by Steve Milton @ ISOMEDIA, Inc. for use with              }
{  Borland's Turbo Pascal for Windows                                   }
{                                                                       }
{  These units are provided as-is with no warranty.  Any damages to     }
{  equipment, peripherals, software, or anything else is solely the     }
{  responsibility of the user.                                          }
{                                                                       }
{  Microsoft Multimedia Extensions is a trademark of Microsoft, Corp.   }
{  Turbo Pascal for Windows is a trademakr of Borland International     }
{                                                                       }
{***********************************************************************}

unit MMPTYPES;

INTERFACE

uses wintypes;

CONST
{***************************************************************************

                          MMP error return values

***************************************************************************}

MMPERR_NO_ERROR      =  0;        { no error                               }
MMPERR_FATAL_ERROR   =  (-101);   { fatal error                            }
MMPERR_STAGE_ERROR   =  (-102);   { error creating stage window            }
MMPERR_FILE_VER      =  (-110);   { wrong file version                     }
MMPERR_FILE_TYPE     =  (-111);   { not an MMP movie file                  }
MMPERR_OPEN_ERROR    =  (-112);   { DOS error opening file                 }
MMPERR_READ_ERROR    =  (-113);   { DOS read error on file                 }
MMPERR_EOF_ERROR     =  (-115);   { unexpected end of file                 }
MMPERR_REC_HEADER    =  (-116);   { invalid record header                  }
MMPERR_CAST_ERROR    =  (-117);   { error reading cast                     }
MMPERR_CAST_MAP_ERROR=  (-118);   { cast/bitmap mismatch                   }
MMPERR_MEM_ALLOC     =  (-121);   { memory allocation error                }
MMPERR_USER_ABORT    =  (-122);   { user canceled operation                }
MMPERR_MMP_BUSY      =  (-412);   { re-entered from frame callback or      }
                                        { other task with different ID    }
MMPERR_BAD_PARM      =  (-426);   { bad parameters                         }

MMP_MOVEOK           =  1;        { boolean field definition               }
SCRIPTCHANNEL        =  (-1);     { script channel action code             }

MMP_MAXERRORLENGTH   =  128;      { maximum length of error strings        }


{***************************************************************************

                              MMP constants

***************************************************************************}

{ flags for wOptions parameter of mmpGoToFrame() function                 }
MMP_FRAME_FIRST    =  1;
MMP_FRAME_LAST        = $7FFF;

{ messages passed to wMsg parameter of frame callback                     }
MMP_HOOK_FRAME        = $0003;
MMP_HOOK_SCRIPT       = $0004;
MMP_HOOK_LOAD         = $0005;

{ flags for nTempo parameter of mmpSetTempo() function                    }
MMPTEMPO_SOUNDWAIT1  = (-121);
MMPTEMPO_MOUSEWAIT   = (-128);

{ animation status returned from mmpAnimate() and mmpAnimStatus() functions}
MMP_TEMPO_WAIT       = 1;     { waiting to advance frame                    }
MMP_ANIM_DRAW        = 2;     { drawing in progress                         }
MMP_ANIM_DRAWN       = 3;     { frame drawn, frame callback not called      }
MMP_SCRIPT_PROCESSED = 4;     { frame callback just executed                }
MMP_FRAME_DONE       = 5;     { all processing for current frame done       }
MMP_MOUSE_WAIT       = (-1);  { waiting for mouse click                     }
MMP_DEVICE_WAIT      = (-2);  { waiting for device to finish                }
MMP_ANIM_STOPPED     = (-3);  { animation is stopped                        }

{ flags for nIndex parameter of mmpGetInfo() function                     }
MMPINFO_LABELLIST  = (-6);    { label-list array                            }
MMPINFO_LABELTEXT  = (-7);    { label-text block                            }
MMPINFO_LABELCOUNT = (-8);    { count of label entries                      }
MMPINFO_ACTIONLIST = (-9);    { action-list array                           }
MMPINFO_ACTIONTEXT = (-10);   { action-text block                           }
MMPINFO_ACTIONCOUNT= (-11);   { count of action entries                     }

{ flags for wOptions parameter of mmpSetStage() and mmpGetStage() functions}
MMP_STAGE_CENTER     = $1;     { centered in stage window                    }
MMP_STAGE_OFFSET     = $2;     { offset to a fixed location                  }
MMP_STAGE_BORDER     = $4;     { border is drawn around stage rect           }
MMP_STAGE_FIXED      = $8;     { stage size isconstant between movies        }

{ flags for wOptions parameter of mmpLoadFile() function                  }
MMP_LOAD_REFERENCED  = $1;     { load if referenced from score               }
MMP_LOAD_NOSTATIC    = $2;     { use system reserved colors                  }
MMP_LOAD_ONDEMAND    = $8;     { load DIBs as they are used                  }
MMP_LOAD_EXPANDDIBS  = $10;    { convert DIBs to RLE format at load time     }
MMP_DRAW_FRAME       = $C000;  { draw frame                                  }
MMP_ERASE_FRAME      = $2000;  { erase entire stage                          }



TYPE
{***************************************************************************

                              MMP data types

***************************************************************************}

{ movie ID}
MMPID = longint;

{ movie information structure}
LP_MMPINFO = ^MMPINFO;
MMPINFO = record
  dwFileVersion : LONGINT;
  dwTotalFrames : LONGINT;
  dwInitialFramesPerSecond : LONGINT;
  wPixelDepth : WORD;
  dwMovieExtentX : LONGINT;
  dwMovieExtentY : LONGINT;
  achFullMacName : array [0..32] of char;
end;
MMPMOVIEINFO = MMPINFO;
LP_MMPMOVIEINFO = ^ MMPMOVIEINFO;

{ label-list information structure}
MMPLABEL = record
  wFrameNum : WORD;
  wTextOffset : WORD;
end;

{ action-list information structure}
MMPACTION = record
  bMenuItem : BYTE;
  bActionCode : BYTE;
  wTextOffset : WORD;
end;


TYPE
  LP_RECT =	 	^TRect;
  LP_MMPFRAMEHOOK = 	pointer;
  LP_WORD =		^WORD;


IMPLEMENTATION



BEGIN
END.
