{***********************************************************************}
{                                                                       }
{  Microsoft Multimedia System Function Prototypes                      }
{  Links to the mmsystem.dll in the Microsoft Multimedia Extensions     }
{  Converted by Steve Milton @ ISOMEDIA, Inc. for use with              }
{  Borland's Turbo Pascal for Windows                                   }
{                                                                       }
{  These units are provided as-is with no warranty.  Any damages to     }
{  equipment, peripherals, software, or anything else is solely the     }
{  responsibility of the user.                                          }
{                                                                       }
{  Microsoft Multimedia Extensions is a trademark of Microsoft, Corp.   }
{  Turbo Pascal for Windows is a trademakr of Borland International     }
{                                                                       }
{***********************************************************************}

UNIT MMSYSTEM;

INTERFACE

USES WinTypes, MMTypes;

{ installable driver function prototypes}
FUNCTION DrvClose(hDriver : THandle; lParam1: LONGINT; lParam2: LONGINT) : LONGINT;
FUNCTION DrvOpen(szDriverName: PChar; szSectionName: PChar;
    lParam2: LONGINT) : THandle;
FUNCTION DrvSendMessage(hDriver: THandle; message: WORD; lParam1: LONGINT;
    lParam2: LONGINT) : LONGINT;
FUNCTION DrvGetModuleHandle(hDriver: THandle) : THandle;
FUNCTION DefDriverProc(dwDriverIdentifier: LONGINT; driverID: THandle;
    message: WORD; lParam1: LONGINT; lParam2: LONGINT) : LONGINT;

{***************************************************************************

                    General MMSYSTEM support

***************************************************************************}

FUNCTION mmsystemGetVersion : WORD;
{PROCEDURE OutputDebugStr(OutStr : PChar);}

{***************************************************************************

                            Sound support

***************************************************************************}

FUNCTION sndPlaySound(lpszSoundName: PChar; wFlags: WORD) : BOOLEAN;

{ waveform audio functiron prototypes	  }
FUNCTION waveOutGetNumDevs : WORD;
FUNCTION waveOutGetDevCaps(wDeviceID: WORD; lpCaps: LP_WAVEOUTCAPS;
    wSize: WORD) : WORD;
FUNCTION waveOutGetVolume(wDeviceID: WORD; lpdwVolume: LP_Longint) : WORD;
FUNCTION waveOutSetVolume(wDeviceID: WORD; dwVolume: LONGINT) : WORD;
FUNCTION waveOutGetErrorText(wError: WORD; lpText: PChar; wSize: WORD) : WORD;
FUNCTION waveOutOpen(lphWaveOut: LPH_WAVEOUT; wDeviceID: WORD;
    lpFormat: LP_WAVEFORMAT; dwCallback: LONGINT; dwInstance: LONGINT; dwFlags: LONGINT) : WORD;
FUNCTION waveOutClose(hWaveOut: H_WAVEOUT) : WORD;
FUNCTION waveOutPrepareHeader(hWaveOut: H_WAVEOUT;
     lpWaveOutHdr: LP_WAVEHDR; wSize: WORD) : WORD;
FUNCTION waveOutUnprepareHeader(hWaveOut: H_WAVEOUT;
    lpWaveOutHdr: LP_WAVEHDR ; wSize: WORD) : WORD;
FUNCTION waveOutWrite(hWaveOut: H_WAVEOUT; lpWaveOutHdr: LP_WAVEHDR;
    wSize: WORD) : WORD;
FUNCTION waveOutPause(hWaveOut: H_WAVEOUT) : WORD;
FUNCTION waveOutRestart(hWaveOut: H_WAVEOUT) : WORD;
FUNCTION waveOutReset(hWaveOut: H_WAVEOUT) : WORD;
FUNCTION waveOutBreakLoop(hWaveOut: H_WAVEOUT) : WORD;
FUNCTION waveOutGetPosition(hWaveOut: H_WAVEOUT; lpInfo: LP_MMTIME;
    wSize: WORD) : WORD;
FUNCTION waveOutGetPitch(hWaveOut: H_WAVEOUT; lpdwPitch: LP_Longint) : WORD;
FUNCTION waveOutSetPitch(hWaveOut: H_WAVEOUT; dwPitch: LONGINT) : WORD;
FUNCTION waveOutGetPlaybackRate(hWaveOut: H_WAVEOUT; lpdwRate: LP_Longint) : WORD;
FUNCTION waveOutSetPlaybackRate(hWaveOut: H_WAVEOUT; dwRate: LONGINT) : WORD;
FUNCTION waveOutGetID(hWaveOut: H_WAVEOUT; lpwDeviceID: LP_WORD) : WORD;

FUNCTION waveInGetNumDevs : WORD;
FUNCTION waveInGetDevCaps(wDeviceID: WORD; lpCaps: LP_WAVEINCAPS;
    wSize: WORD) : WORD;
FUNCTION waveInGetErrorText(wError: WORD; lpText: PChar; wSize: WORD) : WORD;
FUNCTION waveInOpen(lphWaveIn: LPH_WAVEIN; wDeviceID: WORD;
    lpFormat: LP_WAVEFORMAT; dwCallback: LONGINT; dwInstance: LONGINT; dwFlags: LONGINT) : WORD;
FUNCTION waveInClose(hWaveIn: H_WAVEIN) : WORD;
FUNCTION waveInPrepareHeader(hWaveIn: H_WAVEIN;
    lpWaveInHdr: LP_WAVEHDR; wSize: WORD) : WORD;
FUNCTION waveInUnprepareHeader(hWaveIn: H_WAVEIN;
    lpWaveInHdr: LP_WAVEHDR; wSize: WORD)  : WORD;
FUNCTION waveInAddBuffer(hWaveIn: H_WAVEIN;
    lpWaveInHdr: LP_WAVEHDR; wSize: WORD) : WORD;
FUNCTION waveInStart(hWaveIn: H_WAVEIN) : WORD;
FUNCTION waveInStop(hWaveIn: H_WAVEIN) : WORD;
FUNCTION waveInReset(hWaveIn: H_WAVEIN) : WORD;
FUNCTION waveInGetPosition(hWaveIn: H_WAVEIN; lpInfo: LP_MMTIME;
    wSize: WORD) : WORD;
FUNCTION waveInGetID(hWaveIn: H_WAVEIN; lpwDeviceID: LP_WORD) : WORD;

{ MIDI function prototypes						}
FUNCTION midiOutGetNumDevs : WORD;
FUNCTION midiOutGetDevCaps(wDeviceID: WORD;
    lpCaps: LP_MIDIOUTCAPS; wSize: WORD) : WORD;
FUNCTION midiOutGetVolume(wDeviceID: WORD; lpdwVolume: LP_Longint) : WORD;
FUNCTION midiOutSetVolume(wDeviceID: WORD; dwVolume: LONGINT) : WORD;
FUNCTION midiOutGetErrorText(wError: WORD; lpText: PChar; wSize : WORD) : WORD;
FUNCTION midiOutOpen(lphMidiOut: LP_HMIDIOUT; wDeviceID: WORD;
    dwCallback: LONGINT; dwInstance: LONGINT; dwFlags: LONGINT) : WORD;
FUNCTION midiOutClose(hMidiOut: H_MIDIOUT) : WORD;
FUNCTION midiOutPrepareHeader(hMidiOut: H_MIDIOUT;
    lpMidiOutHdr: LP_MIDIHDR; wSize: WORD) : WORD;
FUNCTION midiOutUnprepareHeader(hMidiOut: H_MIDIOUT;
    lpMidiOutHdr: LP_MIDIHDR; wSize: WORD) : WORD;
FUNCTION midiOutShortMsg(hMidiOut: H_MIDIOUT; dwMsg: LONGINT) : WORD;
FUNCTION midiOutLongMsg(hMidiOut: H_MIDIOUT;
    lpMidiOutHdr: LP_MIDIHDR; wSize: WORD) : WORD;
FUNCTION midiOutReset(hMidiOut: H_MIDIOUT) : WORD;
FUNCTION midiOutGetID(hMidiOut: H_MIDIOUT; lpwDeviceID: LP_WORD) : WORD;

FUNCTION midiInGetNumDevs : WORD;
FUNCTION midiInGetDevCaps(wDeviceID: WORD;
    lpCaps: LP_MIDIINCAPS; wSize: WORD) : WORD;
FUNCTION midiInGetErrorText(wError: WORD; lpText: PChar; wSize: WORD) : WORD;
FUNCTION midiInOpen(lphMidiIn: LPH_MIDIIN; wDeviceID: WORD;
    dwCallback: LONGINT; dwInstance: LONGINT; dwFlags: LONGINT) : WORD;
FUNCTION midiInClose(hMidiIn: H_MIDIIN) : WORD;
FUNCTION midiInPrepareHeader(hMidiIn: H_MIDIIN;
    lpMidiInHdr: LP_MIDIHDR; wSize: WORD) : WORD;
FUNCTION midiInUnprepareHeader(hMidiIn: H_MIDIIN;
    lpMidiInHdr: LP_MIDIHDR; wSize: WORD) : WORD;
FUNCTION midiInAddBuffer(hMidiIn: H_MIDIIN;
    lpMidiInHdr: LP_MIDIHDR; wSize: WORD) : WORD;
FUNCTION midiInStart(hMidiIn: H_MIDIIN) : WORD;
FUNCTION midiInStop(hMidiIn: H_MIDIIN) : WORD;
FUNCTION midiInReset(hMidiIn: H_MIDIIN) : WORD;
FUNCTION midiInGetID(hMidiIn: H_MIDIIN; lpwDeviceID: LP_WORD) : WORD;

{ auxiliary audio function prototypes		 }
FUNCTION auxGetNumDevs : WORD;
FUNCTION auxGetDevCaps(wDeviceID: WORD; lpCaps: LP_AUXCAPS; wSize: WORD) : WORD;
FUNCTION auxSetVolume(wDeviceID: WORD; dwVolume: LONGINT) : WORD;
FUNCTION auxGetVolume(wDeviceID: WORD; lpdwVolume: LP_Longint) : WORD;

{ timer function prototypes					  }
FUNCTION timeGetSystemTime(lpTime: LP_MMTIME; wSize: WORD) : WORD;
FUNCTION timeGetTime : LONGINT;
FUNCTION timeSetEvent(wDelay: WORD; wResolution: WORD;
    lpFunction: LP_TIMECALLBACK; dwUser: LONGINT; wFlags: WORD) : WORD;
FUNCTION timeKillEvent(wId: WORD) : WORD;
FUNCTION timeGetDevCaps(lpTimeCaps: LP_TIMECAPS; wSize: WORD) : WORD;
PROCEDURE timeBeginPeriod(wPeriod: WORD);
PROCEDURE timeEndPeriod(wPeriod: WORD);

{ joystick function prototypes					}
FUNCTION joyGetDevCaps(id: WORD; lpCaps: LP_JOYCAPS; wSize: WORD) : WORD;
FUNCTION joyGetNumDevs : WORD;
FUNCTION joyGetPos(id: WORD; lpInfo: LP_JOYINFO) : WORD;
FUNCTION joyGetThreshold(id: WORD;lpwThreshold: LP_WORD) : WORD;
FUNCTION joyReleaseCapture(id: WORD) : WORD;
FUNCTION joySetCapture(hwnd: HWND; wId: WORD; wPeriod: WORD;
    bChanged: BOOL) : WORD;
FUNCTION joySetThreshold(id: WORD; wThreshold: WORD) : WORD;

{ MMIO function prototypes							 }
FUNCTION mmioStringToFOURCC(sz: PChar; wFlags: WORD) : FOURCC;
FUNCTION mmioInstallIOProc(fccIOProc: FOURCC; pIOProc: LP_MMIOPROC;
    dwFlags: LONGINT) : LP_MMIOPROC;
FUNCTION mmioOpen(szFileName: PChar; lpmmioinfo: LP_MMIOINFO;
    dwOpenFlags: LONGINT) : H_MMIO;
FUNCTION mmioClose(hmmio: H_MMIO; wFlags: WORD) : WORD;
FUNCTION mmioRead(hmmio: H_MMIO; pch: H_PSTR; cch: LONGINT) : LONGINT;
FUNCTION mmioWrite(hmmio: H_MMIO; pch: H_PSTR; cch: LONGINT) : LONGINT;
FUNCTION mmioSeek(hmmio: H_MMIO; lOffset: LONGINT; iOrigin: INTEGER) : LONGINT;
FUNCTION mmioGetInfo(hmmio: H_MMIO; lpmmioinfo: LP_MMIOINFO; wFlags: WORD) : WORD;
FUNCTION mmioSetInfo(hmmio: H_MMIO; lpmmioinfo: LP_MMIOINFO; wFlags: WORD) : WORD;
FUNCTION mmioSetBuffer(hmmio: H_MMIO; pchBuffer: PChar; cchBuffer: LONGINT;
    wFlags: WORD) : WORD;
FUNCTION mmioFlush(hmmio: H_MMIO; wFlags: WORD) : WORD;
FUNCTION mmioAdvance(hmmio: H_MMIO; lpmmioinfo: LP_MMIOINFO; wFlags: WORD) : WORD;
FUNCTION mmioSendMessage(hmmio: THandle; wMsg: WORD;
    lParam1: LONGINT; lParam2: LONGINT) : LONGINT;
FUNCTION mmioDescend(hmmio: THandle; lpck: LP_MMCKINFO;
    lpckParent: LP_MMCKINFO; wFlags: WORD) : WORD;
FUNCTION mmioAscend(hmmio: THandle; lpck: LP_MMCKINFO; wFlags: WORD) : WORD;
FUNCTION mmioCreateChunk(hmmio: THandle; lpck: LP_MMCKINFO; wFlags: WORD) : WORD;

{ MCI function prototypes							  }
FUNCTION mciSendCommand (wDeviceID: WORD; wMessage: WORD;
    dwParam1: LONGINT; dwParam2: LONGINT) : LONGINT;
FUNCTION mciSendString (lpstrCommand: Pointer;
    lpstrReturnString: Pointer; wReturnLength: WORD; hCallback: THandle) : LONGINT;
FUNCTION mciGetDeviceID (lpstrName: pointer) : WORD;
FUNCTION mciGetDeviceIDFromElementID (dwElementID: LONGINT;
    lpstrType: pointer) : WORD;
FUNCTION mciGetErrorString (wError: LONGINT; lpstrBuffer: pointer;
    wLength: WORD) : WORD;
FUNCTION mciExecute (lpstrCommand: Pointer) : BOOLEAN;
FUNCTION mciSetYieldProc (wDeviceID: WORD; fpYieldProc: YIELDPROC;
    dwYieldData: LONGINT) : WORD;


IMPLEMENTATION

FUNCTION AUXGETDEVCAPS          ; EXTERNAL 'MMSYSTEM' INDEX   351;
FUNCTION AUXGETNUMDEVS          ; EXTERNAL 'MMSYSTEM' INDEX   350;
FUNCTION AUXGETVOLUME           ; EXTERNAL 'MMSYSTEM' INDEX   352;
FUNCTION AUXSETVOLUME           ; EXTERNAL 'MMSYSTEM' INDEX   353;
FUNCTION DEFDRIVERPROC          ; EXTERNAL 'MMSYSTEM' INDEX  1104;
FUNCTION DRVCLOSE               ; EXTERNAL 'MMSYSTEM' INDEX  1101;
FUNCTION DRVGETMODULEHANDLE     ; EXTERNAL 'MMSYSTEM' INDEX  1103;
FUNCTION DRVOPEN                ; EXTERNAL 'MMSYSTEM' INDEX  1100;
FUNCTION DRVSENDMESSAGE         ; EXTERNAL 'MMSYSTEM' INDEX  1102;
FUNCTION JOYGETDEVCAPS          ; EXTERNAL 'MMSYSTEM' INDEX   102;
FUNCTION JOYGETNUMDEVS          ; EXTERNAL 'MMSYSTEM' INDEX   101;
FUNCTION JOYGETPOS              ; EXTERNAL 'MMSYSTEM' INDEX   103;
FUNCTION JOYGETTHRESHOLD        ; EXTERNAL 'MMSYSTEM' INDEX   104;
FUNCTION JOYRELEASECAPTURE      ; EXTERNAL 'MMSYSTEM' INDEX   105;
FUNCTION JOYSETCAPTURE          ; EXTERNAL 'MMSYSTEM' INDEX   106;
FUNCTION JOYSETTHRESHOLD        ; EXTERNAL 'MMSYSTEM' INDEX   107;
FUNCTION MCIEXECUTE             ; EXTERNAL 'MMSYSTEM' INDEX   712;
FUNCTION MCIGETDEVICEID         ; EXTERNAL 'MMSYSTEM' INDEX   703;
FUNCTION MCIGETDEVICEIDFROMELEMENTID   ; EXTERNAL 'MMSYSTEM' INDEX   715;
FUNCTION MCIGETERRORSTRING      ; EXTERNAL 'MMSYSTEM' INDEX   706;
FUNCTION MCISENDCOMMAND         ; EXTERNAL 'MMSYSTEM' INDEX   701;
FUNCTION MCISENDSTRING          ; EXTERNAL 'MMSYSTEM' INDEX   702;
FUNCTION MCISETYIELDPROC        ; EXTERNAL 'MMSYSTEM' INDEX   714;
FUNCTION MIDIINADDBUFFER        ; EXTERNAL 'MMSYSTEM' INDEX   308;
FUNCTION MIDIINCLOSE            ; EXTERNAL 'MMSYSTEM' INDEX   305;
FUNCTION MIDIINGETDEVCAPS       ; EXTERNAL 'MMSYSTEM' INDEX   302;
FUNCTION MIDIINGETERRORTEXT     ; EXTERNAL 'MMSYSTEM' INDEX   303;
FUNCTION MIDIINGETID            ; EXTERNAL 'MMSYSTEM' INDEX   312;
FUNCTION MIDIINGETNUMDEVS       ; EXTERNAL 'MMSYSTEM' INDEX   301;
FUNCTION MIDIINOPEN             ; EXTERNAL 'MMSYSTEM' INDEX   304;
FUNCTION MIDIINPREPAREHEADER    ; EXTERNAL 'MMSYSTEM' INDEX   306;
FUNCTION MIDIINRESET            ; EXTERNAL 'MMSYSTEM' INDEX   311;
FUNCTION MIDIINSTART            ; EXTERNAL 'MMSYSTEM' INDEX   309;
FUNCTION MIDIINSTOP             ; EXTERNAL 'MMSYSTEM' INDEX   310;
FUNCTION MIDIINUNPREPAREHEADER   ; EXTERNAL 'MMSYSTEM' INDEX   307;
FUNCTION MIDIOUTCLOSE           ; EXTERNAL 'MMSYSTEM' INDEX   205;
FUNCTION MIDIOUTGETDEVCAPS      ; EXTERNAL 'MMSYSTEM' INDEX   202;
FUNCTION MIDIOUTGETERRORTEXT    ; EXTERNAL 'MMSYSTEM' INDEX   203;
FUNCTION MIDIOUTGETID           ; EXTERNAL 'MMSYSTEM' INDEX   215;
FUNCTION MIDIOUTGETNUMDEVS      ; EXTERNAL 'MMSYSTEM' INDEX   201;
FUNCTION MIDIOUTGETVOLUME       ; EXTERNAL 'MMSYSTEM' INDEX   211;
FUNCTION MIDIOUTLONGMSG         ; EXTERNAL 'MMSYSTEM' INDEX   209;
FUNCTION MIDIOUTOPEN            ; EXTERNAL 'MMSYSTEM' INDEX   204;
FUNCTION MIDIOUTPREPAREHEADER   ; EXTERNAL 'MMSYSTEM' INDEX   206;
FUNCTION MIDIOUTRESET           ; EXTERNAL 'MMSYSTEM' INDEX   210;
FUNCTION MIDIOUTSETVOLUME       ; EXTERNAL 'MMSYSTEM' INDEX   212;
FUNCTION MIDIOUTSHORTMSG        ; EXTERNAL 'MMSYSTEM' INDEX   208;
FUNCTION MIDIOUTUNPREPAREHEADER   ; EXTERNAL 'MMSYSTEM' INDEX   207;
FUNCTION MMIOADVANCE            ; EXTERNAL 'MMSYSTEM' INDEX  1219;
FUNCTION MMIOASCEND             ; EXTERNAL 'MMSYSTEM' INDEX  1224;
FUNCTION MMIOCLOSE              ; EXTERNAL 'MMSYSTEM' INDEX  1211;
FUNCTION MMIOCREATECHUNK        ; EXTERNAL 'MMSYSTEM' INDEX  1225;
FUNCTION MMIODESCEND            ; EXTERNAL 'MMSYSTEM' INDEX  1223;
FUNCTION MMIOFLUSH              ; EXTERNAL 'MMSYSTEM' INDEX  1218;
FUNCTION MMIOGETINFO            ; EXTERNAL 'MMSYSTEM' INDEX  1215;
FUNCTION MMIOINSTALLIOPROC      ; EXTERNAL 'MMSYSTEM' INDEX  1221;
FUNCTION MMIOOPEN               ; EXTERNAL 'MMSYSTEM' INDEX  1210;
FUNCTION MMIOREAD               ; EXTERNAL 'MMSYSTEM' INDEX  1212;
FUNCTION MMIOSEEK               ; EXTERNAL 'MMSYSTEM' INDEX  1214;
FUNCTION MMIOSENDMESSAGE        ; EXTERNAL 'MMSYSTEM' INDEX  1222;
FUNCTION MMIOSETBUFFER          ; EXTERNAL 'MMSYSTEM' INDEX  1217;
FUNCTION MMIOSETINFO            ; EXTERNAL 'MMSYSTEM' INDEX  1216;
FUNCTION MMIOSTRINGTOFOURCC     ; EXTERNAL 'MMSYSTEM' INDEX  1220;
FUNCTION MMIOWRITE              ; EXTERNAL 'MMSYSTEM' INDEX  1213;
FUNCTION MMSYSTEMGETVERSION     ; EXTERNAL 'MMSYSTEM' INDEX     5;
FUNCTION SNDPLAYSOUND           ; EXTERNAL 'MMSYSTEM' INDEX     2;
PROCEDURE TIMEBEGINPERIOD;  EXTERNAL 'MMSYSTEM' INDEX 605;
PROCEDURE TIMEENDPERIOD;  EXTERNAL 'MMSYSTEM' INDEX 606;
FUNCTION TIMEGETDEVCAPS         ; EXTERNAL 'MMSYSTEM' INDEX   604;
FUNCTION TIMEGETSYSTEMTIME      ; EXTERNAL 'MMSYSTEM' INDEX   601;
FUNCTION TIMEGETTIME            ; EXTERNAL 'MMSYSTEM' INDEX   607;
FUNCTION TIMEKILLEVENT          ; EXTERNAL 'MMSYSTEM' INDEX   603;
FUNCTION TIMESETEVENT           ; EXTERNAL 'MMSYSTEM' INDEX   602;
FUNCTION WAVEINADDBUFFER        ; EXTERNAL 'MMSYSTEM' INDEX   508;
FUNCTION WAVEINCLOSE            ; EXTERNAL 'MMSYSTEM' INDEX   505;
FUNCTION WAVEINGETDEVCAPS       ; EXTERNAL 'MMSYSTEM' INDEX   502;
FUNCTION WAVEINGETERRORTEXT     ; EXTERNAL 'MMSYSTEM' INDEX   503;
FUNCTION WAVEINGETID            ; EXTERNAL 'MMSYSTEM' INDEX   513;
FUNCTION WAVEINGETNUMDEVS       ; EXTERNAL 'MMSYSTEM' INDEX   501;
FUNCTION WAVEINGETPOSITION      ; EXTERNAL 'MMSYSTEM' INDEX   512;
FUNCTION WAVEINOPEN             ; EXTERNAL 'MMSYSTEM' INDEX   504;
FUNCTION WAVEINPREPAREHEADER    ; EXTERNAL 'MMSYSTEM' INDEX   506;
FUNCTION WAVEINRESET            ; EXTERNAL 'MMSYSTEM' INDEX   511;
FUNCTION WAVEINSTART            ; EXTERNAL 'MMSYSTEM' INDEX   509;
FUNCTION WAVEINSTOP             ; EXTERNAL 'MMSYSTEM' INDEX   510;
FUNCTION WAVEINUNPREPAREHEADER   ; EXTERNAL 'MMSYSTEM' INDEX   507;
FUNCTION WAVEOUTBREAKLOOP       ; EXTERNAL 'MMSYSTEM' INDEX   419;
FUNCTION WAVEOUTCLOSE           ; EXTERNAL 'MMSYSTEM' INDEX   405;
FUNCTION WAVEOUTGETDEVCAPS      ; EXTERNAL 'MMSYSTEM' INDEX   402;
FUNCTION WAVEOUTGETERRORTEXT    ; EXTERNAL 'MMSYSTEM' INDEX   403;
FUNCTION WAVEOUTGETID           ; EXTERNAL 'MMSYSTEM' INDEX   420;
FUNCTION WAVEOUTGETNUMDEVS      ; EXTERNAL 'MMSYSTEM' INDEX   401;
FUNCTION WAVEOUTGETPITCH        ; EXTERNAL 'MMSYSTEM' INDEX   413;
FUNCTION WAVEOUTGETPLAYBACKRATE   ; EXTERNAL 'MMSYSTEM' INDEX   417;
FUNCTION WAVEOUTGETPOSITION     ; EXTERNAL 'MMSYSTEM' INDEX   412;
FUNCTION WAVEOUTGETVOLUME       ; EXTERNAL 'MMSYSTEM' INDEX   415;
FUNCTION WAVEOUTOPEN            ; EXTERNAL 'MMSYSTEM' INDEX   404;
FUNCTION WAVEOUTPAUSE           ; EXTERNAL 'MMSYSTEM' INDEX   409;
FUNCTION WAVEOUTPREPAREHEADER   ; EXTERNAL 'MMSYSTEM' INDEX   406;
FUNCTION WAVEOUTRESET           ; EXTERNAL 'MMSYSTEM' INDEX   411;
FUNCTION WAVEOUTRESTART         ; EXTERNAL 'MMSYSTEM' INDEX   410;
FUNCTION WAVEOUTSETPITCH        ; EXTERNAL 'MMSYSTEM' INDEX   414;
FUNCTION WAVEOUTSETPLAYBACKRATE   ; EXTERNAL 'MMSYSTEM' INDEX   418;
FUNCTION WAVEOUTSETVOLUME       ; EXTERNAL 'MMSYSTEM' INDEX   416;
FUNCTION WAVEOUTUNPREPAREHEADER   ; EXTERNAL 'MMSYSTEM' INDEX   407;
FUNCTION WAVEOUTWRITE           ; EXTERNAL 'MMSYSTEM' INDEX   408;


BEGIN
END.

