{***********************************************************************}
{                                                                       }
{  Microsoft Multimedia System Structures and Constants                 }
{  Links to the mmsystem.dll in the Microsoft Multimedia Extensions     }
{  Converted by Steve Milton @ ISOMEDIA, Inc. for use with              }
{  Borland's Turbo Pascal for Windows                                   }
{                                                                       }
{  These units are provided as-is with no warranty.  Any damages to     }
{  equipment, peripherals, software, or anything else is solely the     }
{  responsibility of the user.                                          }
{                                                                       }
{  Microsoft Multimedia Extensions is a trademark of Microsoft, Corp.   }
{  Turbo Pascal for Windows is a trademakr of Borland International     }
{                                                                       }
{***********************************************************************}

UNIT MMTypes;

INTERFACE

uses WinTypes;

CONST
  SND_SYNC =           $0000;  { play synchronously (default)           }
  SND_ASYNC =          $0001;  { play asynchronously                    }
  SND_NODEFAULT =      $0002;  { don't use default sound                }
  SND_MEMORY =         $0004;  { lpszSoundName points to a memory file  }
  SND_LOOP =           $0008;  { loop the sound until next sndPlaySound }
  SND_NOSTOP =         $0010;  { don't stop any currently playing sound }

  MAXPNAMELEN =     32;     { max product name length (including NULL)   }
  MAXERRORLENGTH =  128;    { max error text length (including NULL)     }

  TIME_MS         = $0001;  { time in milliseconds    }
  TIME_SAMPLES    = $0002;  { number of wave samples    }
  TIME_BYTES      = $0004;  { current byte offset    }
  TIME_SMPTE      = $0008;  { SMPTE time      }
  TIME_MIDI       = $0010;  { MIDI time      }

{****************************************************************************

                    Multimedia Extensions Window Messages

***************************************************************************}

  MM_JOY1MOVE         = $03A0;           { joystick        }
  MM_JOY2MOVE         = $03A1;
  MM_JOY1ZMOVE        = $03A2;
  MM_JOY2ZMOVE        = $03A3;
  MM_JOY1BUTTONDOWN   = $03B5;
  MM_JOY2BUTTONDOWN   = $03B6;
  MM_JOY1BUTTONUP     = $03B7;
  MM_JOY2BUTTONUP     = $03B8;

  MM_MCINOTIFY        = $03B9;           { MCI          }
  MM_MCISYSTEM_STRING = $03CA;

  MM_WOM_OPEN         = $03BB;           { waveform output      }
  MM_WOM_CLOSE        = $03BC;
  MM_WOM_DONE         = $03BD;

  MM_WIM_OPEN         = $03BE;           { waveform input      }
  MM_WIM_CLOSE        = $03BF;
  MM_WIM_DATA         = $03C0;
         
  MM_MIM_OPEN         = $03C1;           { MIDI input       }
  MM_MIM_CLOSE        = $03C2;
  MM_MIM_DATA         = $03C3;
  MM_MIM_LONGDATA     = $03C4;
  MM_MIM_ERROR        = $03C5;
  MM_MIM_LONGERROR    = $03C6;
         
  MM_MOM_OPEN         = $03C7;           { MIDI output       }
  MM_MOM_CLOSE        = $03C8;
  MM_MOM_DONE         = $03C9;


{***************************************************************************

                String resource number bases (internal use)

***************************************************************************}

  MMSYSERR_BASE      =    0;
  WAVERR_BASE        =    32;
  MIDIERR_BASE       =    64;
  TIMERR_BASE        =    96;
  JOYERR_BASE        =    160;
  MCIERR_BASE        =    256;

  MCI_STRING_OFFSET  =    512;
  MCI_VD_OFFSET      =    1024;
  MCI_CD_OFFSET      =    1088;
  MCI_WAVE_OFFSET    =    1152;
  MCI_SEQ_OFFSET     =    1216;

{***************************************************************************

                        General error return values

***************************************************************************}

{ general error return values               }
  MMSYSERR_NOERROR   =   0;                    { no error      }
  MMSYSERR_ERROR     =   (MMSYSERR_BASE + 1);  { unspecified error   }
  MMSYSERR_BADDEVICEID=  (MMSYSERR_BASE + 2);  { device ID out of range }
  MMSYSERR_NOTENABLED =  (MMSYSERR_BASE + 3);  { driver failed enable  }
  MMSYSERR_ALLOCATED  =  (MMSYSERR_BASE + 4);  { device already allocated}
  MMSYSERR_INVALHANDLE=  (MMSYSERR_BASE + 5);  { device handle is invalid}
  MMSYSERR_NODRIVER   =  (MMSYSERR_BASE + 6);  { no device driver present}
  MMSYSERR_NOMEM      =  (MMSYSERR_BASE + 7);  { memory allocation error }
  MMSYSERR_NOTSUPPORTED= (MMSYSERR_BASE + 8);  { function isn't supported}
  MMSYSERR_BADERRNUM   = (MMSYSERR_BASE + 9);  { error value out of range}
  MMSYSERR_LASTERROR   = (MMSYSERR_BASE + 9);  { last error in range   }
         

{***************************************************************************

                        Installable driver support

***************************************************************************}

{ return values from DriverProc() function           }
  DRV_CANCEL             = $0000;
  DRV_OK                 = $0001;
  DRV_RESTART            = $0002;

{ messages sent to DriverProc() function            }
  DRV_LOAD               = $0001;
  DRV_ENABLE             = $0002;
  DRV_OPEN               = $0003;
  DRV_CLOSE              = $0004;
  DRV_DISABLE            = $0005;
  DRV_FREE               = $0006;
  DRV_CONFIGURE          = $0007;
  DRV_QUERYCONFIGURE     = $0008;
  DRV_INSTALL            = $0009;
  DRV_REMOVE             = $000A;

  DRV_RESERVED           = $0800;

  DRV_MCI_FIRST        =  DRV_RESERVED;
  DRV_MCI_LAST         =  (DRV_RESERVED + $0FFF);

  DRV_USER               = $4000;

{***************************************************************************

                          Driver callback support

***************************************************************************}

{ flags used with waveOutOpen(), waveInOpen(), midiInOpen(), and     }
{ midiOutOpen() to specify the type of the dwCallback parameter.   }
  CALLBACK_TYPEMASK   = $00070000;    { callback type mask     }
  CALLBACK_NULL       = $00000000;    { no callback       }
  CALLBACK_WINDOW     = $00010000;    { dwCallback is a HWND    }
  CALLBACK_TASK       = $00020000;    { dwCallback is a HTASK    }
  CALLBACK_FUNCTION   = $00030000;    { dwCallback is a FARPROC   }
{***************************************************************************

                         Manufacturer and product IDs

    Used with wMid and wPid fields in WAVEOUTCAPS, WAVEINCAPS, 
    MIDIOUTCAPS, MIDIINCAPS, AUXCAPS, JOYCAPS structures.

***************************************************************************}

{ manufacturer IDs                  }
  MM_MICROSOFT         =   1;       { Microsoft Corp.

{ product IDs                     }
  MM_MIDI_MAPPER       =   1;       { MIDI Mapper         }
  MM_WAVE_MAPPER       =   2;       { Wave Mapper         }

  MM_SNDBLST_MIDIOUT   =   3;       { Sound Blaster MIDI output port  }
  MM_SNDBLST_MIDIIN    =   4;       { Sound Blaster MIDI input port   }
  MM_SNDBLST_SYNTH     =   5;       { Sound Blaster internal synthesizer }
  MM_SNDBLST_WAVEOUT   =   6;       { Sound Blaster waveform output   }
  MM_SNDBLST_WAVEIN    =   7;       { Sound Blaster waveform input   }
                        
  MM_ADLIB             =   9;       { Ad Lib-compatible synthesizer   }

  MM_MPU401_MIDIOUT    =   10;      { MPU401-compatible MIDI output port }
  MM_MPU401_MIDIIN     =   11;      { MPU401-compatible MIDI input port }

  MM_PC_JOYSTICK       =   12;      { Joystick adapter       }

{ waveform audio error return values            }
  WAVERR_BADFORMAT     = (WAVERR_BASE + 0);    { unsupported wave format }
  WAVERR_STILLPLAYING  = (WAVERR_BASE + 1);    { still something playing }
  WAVERR_UNPREPARED    = (WAVERR_BASE + 2);    { header not prepared  }
  WAVERR_LASTERROR     = (WAVERR_BASE + 2);    { last error in range  }

{ wave callback messages                }
  WOM_OPEN      =  MM_WOM_OPEN;
  WOM_CLOSE     =  MM_WOM_CLOSE;
  WOM_DONE      =  MM_WOM_DONE;
  WIM_OPEN      =  MM_WIM_OPEN;
  WIM_CLOSE     =  MM_WIM_CLOSE;
  WIM_DATA      =  MM_WIM_DATA;
      
{ device ID for wave device mapper             }
  WAVE_MAPPER   =  -1;

{ flags for dwFlags parameter in waveOutOpen() and waveInOpen()   }
   WAVE_FORMAT_QUERY     = $0001;

{ flags for dwFlags field of WAVEHDR            }
  WHDR_DONE       = $00000001;  { done bit           }
  WHDR_PREPARED   = $00000002;  { set if this header has been prepared }
  WHDR_BEGINLOOP  = $00000004;  { loop start block        }
  WHDR_ENDLOOP    = $00000008;  { loop end block         }
  WHDR_INQUEUE    = $00000010;  { reserved for driver       }

{ flags for dwSupport field of WAVEOUTCAPS          }
  WAVECAPS_PITCH          = $0001;   { supports pitch control    }
  WAVECAPS_PLAYBACKRATE   = $0002;   { supports playback rate control  }
  WAVECAPS_VOLUME         = $0004;   { supports volume control    }
  WAVECAPS_LRVOLUME       = $0008;   { separate left-right volume control}
                        
{ defines for dwFormat field of WAVEINCAPS and WAVEOUTCAPS     }
  WAVE_INVALIDFORMAT     = $00000000;       { invalid format     }
  WAVE_FORMAT_1M08       = $00000001;       { 11.025 kHz, Mono,   8-bit }
  WAVE_FORMAT_1S08       = $00000002;       { 11.025 kHz, Stereo, 8-bit }
  WAVE_FORMAT_1M16       = $00000004;       { 11.025 kHz, Mono,   16-bit }
  WAVE_FORMAT_1S16       = $00000008;       { 11.025 kHz, Stereo, 16-bit }
  WAVE_FORMAT_2M08       = $00000010;       { 22.05  kHz, Mono,   8-bit }
  WAVE_FORMAT_2S08       = $00000020;       { 22.05  kHz, Stereo, 8-bit }
  WAVE_FORMAT_2M16       = $00000040;       { 22.05  kHz, Mono,   16-bit }
  WAVE_FORMAT_2S16       = $00000080;       { 22.05  kHz, Stereo, 16-bit }
  WAVE_FORMAT_4M08       = $00000100;       { 44.1   kHz, Mono,   8-bit }
  WAVE_FORMAT_4S08       = $00000200;       { 44.1   kHz, Stereo, 8-bit }
  WAVE_FORMAT_4M16       = $00000400;       { 44.1   kHz, Mono,   16-bit }
  WAVE_FORMAT_4S16       = $00000800;       { 44.1   kHz, Stereo, 16-bit }

{ flags for wFormatTag field of WAVEFORMAT          }
  WAVE_FORMAT_PCM   =  1;

{ MIDI error return values                }
  MIDIERR_UNPREPARED    =(MIDIERR_BASE + 0);   { header not prepared  }
  MIDIERR_STILLPLAYING  =(MIDIERR_BASE + 1);   { still something playing }
  MIDIERR_NOMAP         =(MIDIERR_BASE + 2);   { no current map    }
  MIDIERR_NOTREADY      =(MIDIERR_BASE + 3);   { hardware is still busy }
  MIDIERR_NODEVICE      =(MIDIERR_BASE + 4);   { port no longer connected }
  MIDIERR_LASTERROR     =(MIDIERR_BASE + 4);   { last error in range  }

{ MIDI callback messages                }
  MIM_OPEN        = MM_MIM_OPEN;
  MIM_CLOSE       = MM_MIM_CLOSE;
  MIM_DATA        = MM_MIM_DATA;
  MIM_LONGDATA    = MM_MIM_LONGDATA;
  MIM_ERROR       = MM_MIM_ERROR;
  MIM_LONGERROR   = MM_MIM_LONGERROR;
  MOM_OPEN        = MM_MOM_OPEN;
  MOM_CLOSE       = MM_MOM_CLOSE;
  MOM_DONE        = MM_MOM_DONE;

{ device ID for MIDI mapper               }
  MIDIMAPPER   =  (-1);

  MOD_MIDIPORT   = 1;  { output port             }
  MOD_SYNTH      = 2;  { generic internal synth         }
  MOD_SQSYNTH    = 3;  { square wave internal synth        }
  MOD_FMSYNTH    = 4;  { FM internal synth           }
  MOD_MAPPER     = 5;  { MIDI mapper             }
                          
{ flags for dwSupport field of MIDIOUTCAPS structure       }
  MIDICAPS_VOLUME          = $0001;  { supports volume control    }
  MIDICAPS_LRVOLUME        = $0002;  { separate left-right volume control}

{ flags for dwFlags field of MIDIHDR structure         }
  MHDR_DONE       = $00000001;       { done bit         }
  MHDR_PREPARED   = $00000002;       { set if header prepared    }
  MHDR_INQUEUE    = $00000004;       { reserved for driver     }
                        	  
{ flags for wTechnology field in AUXCAPS structure        }
  AUXCAPS_CDAUDIO  =  1;       { audio from internal CD-ROM drive   }
  AUXCAPS_AUXIN    =  2;       { audio from auxiliary input jacks   }
                        
{ flags for dwSupport field in AUXCAPS structure        }
  AUXCAPS_VOLUME          = $0001;  { supports volume control    }
  AUXCAPS_LRVOLUME        = $0002;  { separate left-right volume control }

{ timer error return values               }
  TIMERR_NOERROR    =    (0);                  { no error      }
  TIMERR_NOCANDO    =    (TIMERR_BASE+1);      { request not completed  }
  TIMERR_STRUCT     =    (TIMERR_BASE+33);     { time struct size   }

{ flags for wFlags parameter of timeSetEvent() function      }
  TIME_ONESHOT   = 0;   { program timer for single event      }
  TIME_PERIODIC  = 1;   { program for continuous periodic event    }
                        
{ joystick error return values              }
  JOYERR_NOERROR    =    (0);                  { no error      }
  JOYERR_PARMS      =    (JOYERR_BASE+5);      { bad parameters    }
  JOYERR_NOCANDO    =    (JOYERR_BASE+6);      { request not completed  }
  JOYERR_UNPLUGGED  =    (JOYERR_BASE+7);      { joystick is unplugged  }

{ constants used with JOYINFO structure and MM_JOY* messages    }
  JOY_BUTTON1         = $0001;
  JOY_BUTTON2         = $0002;
  JOY_BUTTON3         = $0004;
  JOY_BUTTON4         = $0008;
  JOY_BUTTON1CHG      = $0100;
  JOY_BUTTON2CHG      = $0200;
  JOY_BUTTON3CHG      = $0400;
  JOY_BUTTON4CHG      = $0800;

{ joystick ID constants                 }
  JOYSTICKID1      =   0;
  JOYSTICKID2      =   1;

{ MMIO error return values                }
  MMIOERR_BASE      =      256;
  MMIOERR_FILENOTFOUND  =  (MMIOERR_BASE + 1);  { file not found    }
  MMIOERR_OUTOFMEMORY   =  (MMIOERR_BASE + 2);  { out of memory    }
  MMIOERR_CANNOTOPEN    =  (MMIOERR_BASE + 3);  { cannot open     }
  MMIOERR_CANNOTCLOSE   =  (MMIOERR_BASE + 4);  { cannot close    }
  MMIOERR_CANNOTREAD    =  (MMIOERR_BASE + 5);  { cannot read     }
  MMIOERR_CANNOTWRITE   =  (MMIOERR_BASE + 6);  { cannot write    }
  MMIOERR_CANNOTSEEK    =  (MMIOERR_BASE + 7);  { cannot seek     }
  MMIOERR_CANNOTEXPAND  =  (MMIOERR_BASE + 8);  { cannot expand file  }
  MMIOERR_CHUNKNOTFOUND =  (MMIOERR_BASE + 9);  { chunk not found   }
  MMIOERR_UNBUFFERED    =  (MMIOERR_BASE + 10); { file is unbuffered  }
                        
{ MMIO constants                   }
  CFSEPCHAR    =   '+';             { compound file name separator char. }

{ bit field masks                   }
  MMIO_RWMODE     = $00000003;      { open file for reading/writing/both }
  MMIO_SHAREMODE  = $00000070;      { file sharing mode number    }

{ constants for dwFlags field of MMIOINFO           }
  MMIO_CREATE     = $00001000;      { create new file (or truncate file) }
  MMIO_DELETE     = $00000200;      { create new file (or truncate file) }
  MMIO_ALLOCBUF   = $00010000;      { mmioOpen() should allocate a buffer}

  MMIO_DIRTY      = $10000000;      { I/O buffer is dirty      }

{ read/write mode numbers (bit field MMIO_RWMODE)        }
  MMIO_READ       = $00000000;      { open file for reading only   }
  MMIO_WRITE      = $00000001;      { open file for writing only   }
  MMIO_READWRITE  = $00000002;      { open file for reading and writing }

{ share mode numbers (bit field MMIO_SHAREMODE)         }
  MMIO_COMPAT     = $00000000;      { compatibility mode      }
  MMIO_EXCLUSIVE  = $00000010;      { exclusive-access mode     }
  MMIO_DENYWRITE  = $00000020;      { deny writing to other processes  }
  MMIO_DENYREAD   = $00000030;      { deny reading to other processes  }
  MMIO_DENYNONE   = $00000040;      { deny nothing to other processes  }
                        
{ various MMIO flags                  }
  MMIO_FHOPEN             = $0010;  { mmioClose: keep file handle open }
  MMIO_EMPTYBUF           = $0010;  { mmioFlush: empty the I/O buffer  }
  MMIO_TOUPPER            = $0010;  { mmioStringToFOURCC: to u-case  }
  MMIO_INSTALLPROC    = $00010000;  { mmioInstallIOProc: install MMIOProc}
  MMIO_REMOVEPROC     = $00020000;  { mmioInstallIOProc: remove MMIOProc }
  MMIO_FINDPROC       = $00040000;  { mmioInstallIOProc: find an MMIOProc}
  MMIO_FINDCHUNK          = $0010;  { mmioDescend: find a chunk by ID  }
  MMIO_FINDRIFF           = $0020;  { mmioDescend: find a LIST chunk  }
  MMIO_FINDLIST           = $0040;  { mmioDescend: find a RIFF chunk  }
  MMIO_CREATERIFF         = $0020;  { mmioCreateChunk: make a LIST chunk }
  MMIO_CREATELIST         = $0040;  { mmioCreateChunk: make a RIFF chunk }

{ message numbers for MMIOPROC I/O procedure functions      }
  MMIOM_READ    =  MMIO_READ;       { read           }
  MMIOM_WRITE   = MMIO_WRITE;       { write           }
  MMIOM_SEEK    =          2;       { seek to a new position in file  }
  MMIOM_OPEN    =          3;       { open file         }
  MMIOM_CLOSE   =          4;       { close file         }
  MMIOM_WRITEFLUSH     =   5;       { write and flush       }
  MMIOM_USER         = $8000;       { beginning of user-defined messages }

{ flags for mmioSeek()                 }
  SEEK_SET     =   0;               { seek to an absolute position   }
  SEEK_CUR     =   1;               { seek relative to current position }
  SEEK_END     =   2;               { seek relative to end of file   }
						  
{ other constants                   }
  MMIO_DEFAULTBUFFER   =   8192;    { default buffer size      }

{ MCI error return values                }
  MCIERR_INVALID_DEVICE_ID      =  (MCIERR_BASE + 1);
  MCIERR_UNRECOGNIZED_KEYWORD   =  (MCIERR_BASE + 3);
  MCIERR_UNRECOGNIZED_COMMAND   =  (MCIERR_BASE + 5);
  MCIERR_HARDWARE               =  (MCIERR_BASE + 6);
  MCIERR_INVALID_DEVICE_NAME    =  (MCIERR_BASE + 7);
  MCIERR_OUT_OF_MEMORY          =  (MCIERR_BASE + 8);
  MCIERR_DEVICE_OPEN            =  (MCIERR_BASE + 9);
  MCIERR_CANNOT_LOAD_DRIVER     =  (MCIERR_BASE + 10);
  MCIERR_MISSING_COMMAND_STRING =  (MCIERR_BASE + 11);
  MCIERR_PARAM_OVERFLOW         =  (MCIERR_BASE + 12);
  MCIERR_MISSING_STRING_ARGUMENT=  (MCIERR_BASE + 13);
  MCIERR_BAD_INTEGER            =  (MCIERR_BASE + 14);
  MCIERR_PARSER_INTERNAL        =  (MCIERR_BASE + 15);
  MCIERR_DRIVER_INTERNAL        =  (MCIERR_BASE + 16);
  MCIERR_MISSING_PARAMETER      =  (MCIERR_BASE + 17);
  MCIERR_UNSUPPORTED_FUNCTION   =  (MCIERR_BASE + 18);
  MCIERR_FILE_NOT_FOUND         =  (MCIERR_BASE + 19);
  MCIERR_DEVICE_NOT_READY       =  (MCIERR_BASE + 20);
  MCIERR_INTERNAL               =  (MCIERR_BASE + 21);
  MCIERR_DRIVER                 =  (MCIERR_BASE + 22);
  MCIERR_CANNOT_USE_ALL         =  (MCIERR_BASE + 23);
  MCIERR_MULTIPLE               =  (MCIERR_BASE + 24);
  MCIERR_EXTENSION_NOT_FOUND    =  (MCIERR_BASE + 25);
  MCIERR_OUTOFRANGE             =  (MCIERR_BASE + 26);
  MCIERR_FLAGS_NOT_COMPATIBLE   =  (MCIERR_BASE + 28);
  MCIERR_FILE_NOT_SAVED         =  (MCIERR_BASE + 30);
  MCIERR_DEVICE_TYPE_REQUIRED   =  (MCIERR_BASE + 31);
  MCIERR_DEVICE_LOCKED          =  (MCIERR_BASE + 32);
  MCIERR_DUPLICATE_ALIAS        =  (MCIERR_BASE + 33);
  MCIERR_BAD_CONSTANT           =  (MCIERR_BASE + 34);
  MCIERR_MUST_USE_SHAREABLE     =  (MCIERR_BASE + 35);
  MCIERR_MISSING_DEVICE_NAME    =  (MCIERR_BASE + 36);
  MCIERR_BAD_TIME_FORMAT        =  (MCIERR_BASE + 37);
  MCIERR_NO_CLOSING_QUOTE       =  (MCIERR_BASE + 38);
  MCIERR_DUPLICATE_FLAGS        =  (MCIERR_BASE + 39);
  MCIERR_INVALID_FILE           =  (MCIERR_BASE + 40);
  MCIERR_NULL_PARAMETER_BLOCK   =  (MCIERR_BASE + 41);
  MCIERR_UNNAMED_RESOURCE       =  (MCIERR_BASE + 42);
  MCIERR_NEW_REQUIRES_ALIAS     =  (MCIERR_BASE + 43);
  MCIERR_NOTIFY_ON_AUTO_OPEN    =  (MCIERR_BASE + 44);
  MCIERR_NO_ELEMENT_ALLOWED     =  (MCIERR_BASE + 45);
  MCIERR_NONAPPLICABLE_FUNCTION =  (MCIERR_BASE + 46);
  MCIERR_ILLEGAL_FOR_AUTO_OPEN  =  (MCIERR_BASE + 47);
  MCIERR_FILENAME_REQUIRED      =  (MCIERR_BASE + 48);
  MCIERR_EXTRA_CHARACTERS       =  (MCIERR_BASE + 49);

  MCIERR_WAVE_OUTPUTSINUSE      =  (MCIERR_BASE + 64);
  MCIERR_WAVE_SETOUTPUTINUSE    =  (MCIERR_BASE + 65);
  MCIERR_WAVE_INPUTSINUSE       =  (MCIERR_BASE + 66);
  MCIERR_WAVE_SETINPUTINUSE     =  (MCIERR_BASE + 67);
  MCIERR_WAVE_OUTPUTUNSPECIFIED =  (MCIERR_BASE + 68);
  MCIERR_WAVE_INPUTUNSPECIFIED  =  (MCIERR_BASE + 69);
  MCIERR_WAVE_OUTPUTSUNSUITABLE =  (MCIERR_BASE + 70);
  MCIERR_WAVE_SETOUTPUTUNSUITABLE = (MCIERR_BASE + 71);
  MCIERR_WAVE_INPUTSUNSUITABLE  =  (MCIERR_BASE + 72);
  MCIERR_WAVE_SETINPUTUNSUITABLE =  (MCIERR_BASE + 73);

  MCIERR_SEQ_DIV_INCOMPATIBLE   =  (MCIERR_BASE + 80);
  MCIERR_SEQ_PORT_INUSE         =  (MCIERR_BASE + 81);
  MCIERR_SEQ_PORT_NONEXISTENT   =  (MCIERR_BASE + 82);
  MCIERR_SEQ_PORT_MAPNODEVICE   =  (MCIERR_BASE + 83);
  MCIERR_SEQ_PORT_MISCERROR     =  (MCIERR_BASE + 84);
  MCIERR_SEQ_TIMER              =  (MCIERR_BASE + 85);
  MCIERR_SEQ_PORTUNSPECIFIED    =  (MCIERR_BASE + 86);

  MCIERR_NO_WINDOW              =  (MCIERR_BASE + 90);
  MCIERR_CREATEWINDOW           =  (MCIERR_BASE + 91);
  MCIERR_FILE_READ              =  (MCIERR_BASE + 92);
  MCIERR_FILE_WRITE             =  (MCIERR_BASE + 93);
            
{ all custom device driver errors must be >= than this value     }
  MCIERR_CUSTOM_DRIVER_BASE     =  (MCIERR_BASE + 256);

{ MCI command message identifiers              }
  MCI_OPEN                        = $0803;
  MCI_CLOSE                       = $0804;
  MCI_ESCAPE                      = $0805;
  MCI_PLAY                        = $0806;
  MCI_SEEK                        = $0807;
  MCI_STOP                        = $0808;
  MCI_PAUSE                       = $0809;
  MCI_INFO                        = $080A;
  MCI_GETDEVCAPS                  = $080B;
  MCI_SPIN                        = $080C;
  MCI_SET                         = $080D;
  MCI_STEP                        = $080E;
  MCI_RECORD                      = $080F;
  MCI_SYSINFO                     = $0810;
  MCI_BREAK                       = $0811;
  MCI_SOUND                       = $0812;
  MCI_SAVE                        = $0813;
  MCI_STATUS                      = $0814;
  MCI_CUE                         = $0830;
  MCI_REALIZE                     = $0840;
  MCI_WINDOW                      = $0841;
  MCI_PUT                         = $0842;
  MCI_WHERE                       = $0843;
  MCI_FREEZE                      = $0844;
  MCI_UNFREEZE                    = $0845;
  MCI_LOAD                        = $0850;
  MCI_CUT                         = $0851;
  MCI_COPY                        = $0852;
  MCI_PASTE                       = $0853;
  MCI_UPDATE                      = $0854;
  MCI_RESUME                      = $0855;
  MCI_DELETE                      = $0856;
													  
{ all custom MCI command messages must be >= than this value     }
  MCI_USER_MESSAGES            =   ($0400 + DRV_MCI_FIRST);


{ device ID for "all devices"                }
  MCI_ALL_DEVICE_ID               = $FFFF;

{ constants for predefined MCI device types           }
  MCI_DEVTYPE_VCR                = (MCI_STRING_OFFSET + 1);
  MCI_DEVTYPE_VIDEODISC          = (MCI_STRING_OFFSET + 2);
  MCI_DEVTYPE_OVERLAY            = (MCI_STRING_OFFSET + 3);
  MCI_DEVTYPE_CD_AUDIO           = (MCI_STRING_OFFSET + 4);
  MCI_DEVTYPE_DAT                = (MCI_STRING_OFFSET + 5);
  MCI_DEVTYPE_SCANNER            = (MCI_STRING_OFFSET + 6);
  MCI_DEVTYPE_ANIMATION          = (MCI_STRING_OFFSET + 7);
  MCI_DEVTYPE_DIGITAL_VIDEO      = (MCI_STRING_OFFSET + 8);
  MCI_DEVTYPE_OTHER              = (MCI_STRING_OFFSET + 9);
  MCI_DEVTYPE_WAVEFORM_AUDIO     = (MCI_STRING_OFFSET + 10);
  MCI_DEVTYPE_SEQUENCER          = (MCI_STRING_OFFSET + 11);
           																  
  MCI_DEVTYPE_FIRST              = MCI_DEVTYPE_VCR;
  MCI_DEVTYPE_LAST               = MCI_DEVTYPE_SEQUENCER;

{ return values for 'status mode' command            }
  MCI_MODE_NOT_READY             = (MCI_STRING_OFFSET + 12);
  MCI_MODE_STOP                  = (MCI_STRING_OFFSET + 13);
  MCI_MODE_PLAY                  = (MCI_STRING_OFFSET + 14);
  MCI_MODE_RECORD                = (MCI_STRING_OFFSET + 15);
  MCI_MODE_SEEK                  = (MCI_STRING_OFFSET + 16);
  MCI_MODE_PAUSE                 = (MCI_STRING_OFFSET + 17);
  MCI_MODE_OPEN                  = (MCI_STRING_OFFSET + 18);
           																  
{ constants used in 'set time format' and 'status time format' commands}
  MCI_FORMAT_MILLISECONDS        = 0;
  MCI_FORMAT_HMS                 = 1;
  MCI_FORMAT_MSF                 = 2;
  MCI_FORMAT_FRAMES              = 3;
  MCI_FORMAT_SMPTE_24            = 4;
  MCI_FORMAT_SMPTE_25            = 5;
  MCI_FORMAT_SMPTE_30            = 6;
  MCI_FORMAT_SMPTE_30DROP        = 7;
  MCI_FORMAT_BYTES               = 8;
  MCI_FORMAT_SAMPLES             = 9;
  MCI_FORMAT_TMSF                = 10;
           
{ flags for wParam of MM_MCINOTIFY message           }
  MCI_NOTIFY_SUCCESSFUL           = $0001;
  MCI_NOTIFY_SUPERSEDED           = $0002;
  MCI_NOTIFY_ABORTED              = $0004;
  MCI_NOTIFY_FAILURE              = $0008;
													  

{ common flags for dwFlags parameter of MCI command messages     }
  MCI_NOTIFY                      = $00000001;
  MCI_WAIT                        = $00000002;
  MCI_FROM                        = $00000004;
  MCI_TO                          = $00000008;
  MCI_TRACK                       = $00000010;

{ flags for dwFlags parameter of MCI_OPEN command message      }
  MCI_OPEN_SHAREABLE              = $00000100;
  MCI_OPEN_ELEMENT                = $00000200;
  MCI_OPEN_ALIAS                  = $00000400;
  MCI_OPEN_ELEMENT_ID             = $00000800;
  MCI_OPEN_TYPE_ID                = $00001000;
  MCI_OPEN_TYPE                   = $00002000;

{ flags for dwFlags parameter of MCI_SEEK command message      }
  MCI_SEEK_TO_START               = $00000100;
  MCI_SEEK_TO_END                 = $00000200;

{ flags for dwFlags parameter of MCI_STATUS command message      }
  MCI_STATUS_ITEM                 = $00000100;
  MCI_STATUS_START                = $00000200;

{ flags for dwItem field of the MCI_STATUS_PARMS parameter block    }
  MCI_STATUS_LENGTH               = $00000001;
  MCI_STATUS_POSITION             = $00000002;
  MCI_STATUS_NUMBER_OF_TRACKS     = $00000003;
  MCI_STATUS_MODE                 = $00000004;
  MCI_STATUS_MEDIA_PRESENT        = $00000005;
  MCI_STATUS_TIME_FORMAT          = $00000006;
  MCI_STATUS_READY                = $00000007;
  MCI_STATUS_CURRENT_TRACK        = $00000008;
															
{ flags for dwFlags parameter of MCI_INFO command message      }
  MCI_INFO_PRODUCT                = $00000100;
  MCI_INFO_FILE                   = $00000200;

{ flags for dwFlags parameter of MCI_GETDEVCAPS command message    }
  MCI_GETDEVCAPS_ITEM             = $00000100;

{ flags for dwItem field of the MCI_GETDEVCAPS_PARMS parameter block   }
  MCI_GETDEVCAPS_CAN_RECORD       = $00000001;
  MCI_GETDEVCAPS_HAS_AUDIO        = $00000002;
  MCI_GETDEVCAPS_HAS_VIDEO        = $00000003;
  MCI_GETDEVCAPS_DEVICE_TYPE      = $00000004;
  MCI_GETDEVCAPS_USES_FILES       = $00000005;
  MCI_GETDEVCAPS_COMPOUND_DEVICE  = $00000006;
  MCI_GETDEVCAPS_CAN_EJECT        = $00000007;
  MCI_GETDEVCAPS_CAN_PLAY         = $00000008;
  MCI_GETDEVCAPS_CAN_SAVE         = $00000009;

{ flags for dwFlags parameter of MCI_SYSINFO command message     }
  MCI_SYSINFO_QUANTITY            = $00000100;
  MCI_SYSINFO_OPEN                = $00000200;
  MCI_SYSINFO_NAME                = $00000400;
  MCI_SYSINFO_INSTALLNAME         = $00000800;

{ flags for dwFlags parameter of MCI_SET command message       }
  MCI_SET_DOOR_OPEN               = $00000100;
  MCI_SET_DOOR_CLOSED             = $00000200;
  MCI_SET_TIME_FORMAT             = $00000400;
  MCI_SET_AUDIO                   = $00000800;
  MCI_SET_VIDEO                   = $00001000;
  MCI_SET_ON                      = $00002000;
  MCI_SET_OFF                     = $00004000;
															
{ flags for dwAudio field of MCI_SET_PARMS or MCI_SEQ_SET_PARMS    }
  MCI_SET_AUDIO_ALL               = $00000000;
  MCI_SET_AUDIO_LEFT              = $00000001;
  MCI_SET_AUDIO_RIGHT             = $00000002;
															
{ flags for dwFlags parameter of MCI_BREAK command message      }
  MCI_BREAK_KEY                   = $00000100;
  MCI_BREAK_HWND                  = $00000200;
  MCI_BREAK_OFF                   = $00000400;

{ flags for dwFlags parameter of MCI_RECORD command message      }
  MCI_RECORD_INSERT               = $00000100;
  MCI_RECORD_OVERWRITE            = $00000200;

{ flags for dwFlags parameter of MCI_SOUND command message      }
  MCI_SOUND_NAME                  = $00000100;

{ flags for dwFlags parameter of MCI_SAVE command message      }
  MCI_SAVE_FILE                   = $00000100;
               
{ flags for dwFlags parameter of MCI_LOAD command message      }
  MCI_LOAD_FILE                   = $00000100;

{ flag for dwReturn field of MCI_STATUS_PARMS          }
{ MCI_STATUS command, (dwItem == MCI_STATUS_MODE)         }
  MCI_VD_MODE_PARK             =   (MCI_VD_OFFSET + 1);

{ flag for dwReturn field of MCI_STATUS_PARMS          }
{ MCI_STATUS command, (dwItem == MCI_VD_STATUS_MEDIA_TYPE)      }
  MCI_VD_MEDIA_CLV             =   (MCI_VD_OFFSET + 2);
  MCI_VD_MEDIA_CAV             =   (MCI_VD_OFFSET + 3);
  MCI_VD_MEDIA_OTHER           =   (MCI_VD_OFFSET + 4);
           
  MCI_VD_FORMAT_TRACK             = $4001;

{ flags for dwFlags parameter of MCI_PLAY command message      }
  MCI_VD_PLAY_REVERSE             = $00010000;
  MCI_VD_PLAY_FAST                = $00020000;
  MCI_VD_PLAY_SPEED               = $00040000;
  MCI_VD_PLAY_SCAN                = $00080000;
  MCI_VD_PLAY_SLOW                = $00100000;

{ flag for dwFlags parameter of MCI_SEEK command message       }
  MCI_VD_SEEK_REVERSE             = $00010000;

{ flags for dwItem field of MCI_STATUS_PARMS parameter block     }
  MCI_VD_STATUS_SPEED             = $00004002;
  MCI_VD_STATUS_FORWARD           = $00004003;
  MCI_VD_STATUS_MEDIA_TYPE        = $00004004;
  MCI_VD_STATUS_SIDE              = $00004005;
  MCI_VD_STATUS_DISC_SIZE         = $00004006;
               
{ flags for dwFlags parameter of MCI_GETDEVCAPS command message    }
  MCI_VD_GETDEVCAPS_CLV           = $00010000;
  MCI_VD_GETDEVCAPS_CAV           = $00020000;

  MCI_VD_SPIN_UP                  = $00010000;
  MCI_VD_SPIN_DOWN                = $00020000;

{ flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block    }
  MCI_VD_GETDEVCAPS_CAN_REVERSE   = $00004002;
  MCI_VD_GETDEVCAPS_FAST_RATE     = $00004003;
  MCI_VD_GETDEVCAPS_SLOW_RATE     = $00004004;
  MCI_VD_GETDEVCAPS_NORMAL_RATE   = $00004005;
               
{ flags for the dwFlags parameter of MCI_STEP command message     }
  MCI_VD_STEP_FRAMES              = $00010000;
  MCI_VD_STEP_REVERSE             = $00020000;
               
{ flag for the MCI_ESCAPE command message            }
  MCI_VD_ESCAPE_STRING            = $00000100;

{ flags for the dwFlags parameter of MCI_OPEN command message     }
  MCI_WAVE_OPEN_BUFFER            = $00010000;

{ flags for the dwFlags parameter of MCI_SET command message     }
  MCI_WAVE_SET_FORMATTAG          = $00010000;
  MCI_WAVE_SET_CHANNELS           = $00020000;
  MCI_WAVE_SET_SAMPLESPERSEC      = $00040000;
  MCI_WAVE_SET_AVGBYTESPERSEC     = $00080000;
  MCI_WAVE_SET_BLOCKALIGN         = $00100000;
  MCI_WAVE_SET_BITSPERSAMPLE      = $00200000;
															
{ flags for the dwFlags parameter of MCI_STATUS, MCI_SET command messages}
  MCI_WAVE_INPUT                  = $00400000;
  MCI_WAVE_OUTPUT                 = $00800000;

{ flags for the dwItem field of MCI_STATUS_PARMS parameter block    }
  MCI_WAVE_STATUS_FORMATTAG       = $00004001;
  MCI_WAVE_STATUS_CHANNELS        = $00004002;
  MCI_WAVE_STATUS_SAMPLESPERSEC   = $00004003;
  MCI_WAVE_STATUS_AVGBYTESPERSEC  = $00004004;
  MCI_WAVE_STATUS_BLOCKALIGN      = $00004005;
  MCI_WAVE_STATUS_BITSPERSAMPLE   = $00004006;
  MCI_WAVE_STATUS_LEVEL           = $00004007;

{ flags for the dwFlags parameter of MCI_SET command message     }
  MCI_WAVE_SET_ANYINPUT           = $04000000;
  MCI_WAVE_SET_ANYOUTPUT          = $08000000;
															
{ flags for the dwFlags parameter of MCI_GETDEVCAPS command message   }
  MCI_WAVE_GETDEVCAPS_INPUTS      = $00004001;
  MCI_WAVE_GETDEVCAPS_OUTPUTS     = $00004002;

{                         }
{ MCI extensions for MIDI sequencer devices           }
{                         }

{ flags for the dwReturn field of MCI_STATUS_PARMS parameter block   }
{ MCI_STATUS command, (dwItem == MCI_SEQ_STATUS_DIVTYPE)       }
      MCI_SEQ_DIV_PPQN           = (0 + MCI_SEQ_OFFSET);
      MCI_SEQ_DIV_SMPTE_24       = (1 + MCI_SEQ_OFFSET);
      MCI_SEQ_DIV_SMPTE_25       = (2 + MCI_SEQ_OFFSET);
      MCI_SEQ_DIV_SMPTE_30DROP   = (3 + MCI_SEQ_OFFSET);
      MCI_SEQ_DIV_SMPTE_30       = (4 + MCI_SEQ_OFFSET);

{ flags for the dwMaster field of MCI_SEQ_SET_PARMS parameter block   }
{ MCI_SET command, (dwFlags == MCI_SEQ_SET_MASTER)         }
      MCI_SEQ_FORMAT_SONGPTR      = $4001;
      MCI_SEQ_FILE                = $4002;
      MCI_SEQ_MIDI                = $4003;
      MCI_SEQ_SMPTE               = $4004;
      MCI_SEQ_NONE               = 65533;

{ flags for the dwItem field of MCI_STATUS_PARMS parameter block    }
  MCI_SEQ_STATUS_TEMPO            = $00004002;
  MCI_SEQ_STATUS_PORT             = $00004000;
  MCI_SEQ_STATUS_SLAVE            = $00004007;
  MCI_SEQ_STATUS_MASTER           = $00004008;
  MCI_SEQ_STATUS_OFFSET           = $00004009;
  MCI_SEQ_STATUS_DIVTYPE          = $0000400A;
               
{ flags for the dwFlags parameter of MCI_SET command message     }
  MCI_SEQ_SET_TEMPO               = $00010000;
  MCI_SEQ_SET_PORT                = $00020000;
  MCI_SEQ_SET_SLAVE               = $00040000;
  MCI_SEQ_SET_MASTER              = $00080000;
  MCI_SEQ_SET_OFFSET              = $01000000;

{                         }
{ MCI extensions for animation devices             }
{                         }

{ flags for dwFlags parameter of MCI_OPEN command message      }
  MCI_ANIM_OPEN_WS                = $00010000;
  MCI_ANIM_OPEN_PARENT            = $00020000;
  MCI_ANIM_OPEN_NOSTATIC          = $00040000;
															
{ flags for dwFlags parameter of MCI_PLAY command message      }
  MCI_ANIM_PLAY_SPEED             = $00010000;
  MCI_ANIM_PLAY_REVERSE           = $00020000;
  MCI_ANIM_PLAY_FAST              = $00040000;
  MCI_ANIM_PLAY_SLOW              = $00080000;
  MCI_ANIM_PLAY_SCAN              = $00100000;

{ flags for dwFlags parameter of MCI_STEP command message      }
  MCI_ANIM_STEP_REVERSE           = $00010000;
  MCI_ANIM_STEP_FRAMES            = $00020000;

{ flags for dwItem field of MCI_STATUS_PARMS parameter block     }
  MCI_ANIM_STATUS_SPEED           = $00004001;
  MCI_ANIM_STATUS_FORWARD         = $00004002;
  MCI_ANIM_STATUS_HWND            = $00004003;
  MCI_ANIM_STATUS_HPAL            = $00004004;
  MCI_ANIM_STATUS_STRETCH         = $00004005;

{ flags for the dwFlags parameter of MCI_INFO command message     }
  MCI_ANIM_INFO_TEXT              = $00010000;

{ flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block    }
  MCI_ANIM_GETDEVCAPS_CAN_REVERSE = $00004001;
  MCI_ANIM_GETDEVCAPS_FAST_RATE   = $00004002;
  MCI_ANIM_GETDEVCAPS_SLOW_RATE   = $00004003;
  MCI_ANIM_GETDEVCAPS_NORMAL_RATE = $00004004;
  MCI_ANIM_GETDEVCAPS_PALETTES    = $00004006;
  MCI_ANIM_GETDEVCAPS_CAN_STRETCH = $00004007;
  MCI_ANIM_GETDEVCAPS_MAX_WINDOWS = $00004008;
															
{ flags for the MCI_REALIZE command message           }
  MCI_ANIM_REALIZE_NORM           = $00010000;
  MCI_ANIM_REALIZE_BKGD           = $00020000;

{ flags for dwFlags parameter of MCI_WINDOW command message      }
  MCI_ANIM_WINDOW_HWND            = $00010000;
  MCI_ANIM_WINDOW_STATE           = $00040000;
  MCI_ANIM_WINDOW_TEXT            = $00080000;
  MCI_ANIM_WINDOW_ENABLE_STRETCH  = $00100000;
  MCI_ANIM_WINDOW_DISABLE_STRETCH = $00200000;

{ flags for hWnd field of MCI_ANIM_WINDOW_PARMS parameter block    }
{ MCI_WINDOW command message, (dwFlags == MCI_ANIM_WINDOW_HWND)    }
  MCI_ANIM_WINDOW_DEFAULT         = $00000000;

{ flags for dwFlags parameter of MCI_PUT command message       }
  MCI_ANIM_RECT                   = $00010000;
  MCI_ANIM_PUT_SOURCE             = $00020000;
  MCI_ANIM_PUT_DESTINATION        = $00040000;

{ flags for dwFlags parameter of MCI_WHERE command message      }
  MCI_ANIM_WHERE_SOURCE           = $00020000;
  MCI_ANIM_WHERE_DESTINATION      = $00040000;

{ flags for dwFlags parameter of MCI_UPDATE command message      }
  MCI_ANIM_UPDATE_HDC             = $00020000;

{                         }
{ MCI extensions for video overlay devices           }
{                         }

{ flags for dwFlags parameter of MCI_OPEN command message      }
  MCI_OVLY_OPEN_WS                = $00010000;
  MCI_OVLY_OPEN_PARENT            = $00020000;

{ flags for dwFlags parameter of MCI_STATUS command message      }
  MCI_OVLY_STATUS_HWND            = $00004001;
  MCI_OVLY_STATUS_STRETCH         = $00004002;

{ flags for dwFlags parameter of MCI_INFO command message      }
  MCI_OVLY_INFO_TEXT              = $00010000; 

{ flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block    }
  MCI_OVLY_GETDEVCAPS_CAN_STRETCH = $00004001;
  MCI_OVLY_GETDEVCAPS_CAN_FREEZE  = $00004002;
  MCI_OVLY_GETDEVCAPS_MAX_WINDOWS = $00004003;

{ flags for dwFlags parameter of MCI_WINDOW command message      }
  MCI_OVLY_WINDOW_HWND            = $00010000;
  MCI_OVLY_WINDOW_STATE           = $00040000;
  MCI_OVLY_WINDOW_TEXT            = $00080000;
  MCI_OVLY_WINDOW_ENABLE_STRETCH  = $00100000;
  MCI_OVLY_WINDOW_DISABLE_STRETCH = $00200000;

{ flags for hWnd parameter of MCI_OVLY_WINDOW_PARMS parameter block   }
  MCI_OVLY_WINDOW_DEFAULT         = $00000000;

{ flags for dwFlags parameter of MCI_PUT command message       }
  MCI_OVLY_RECT                   = $00010000;
  MCI_OVLY_PUT_SOURCE             = $00020000;
  MCI_OVLY_PUT_DESTINATION        = $00040000;
  MCI_OVLY_PUT_FRAME              = $00080000;
  MCI_OVLY_PUT_VIDEO              = $00100000;

{ flags for dwFlags parameter of MCI_WHERE command message      }
  MCI_OVLY_WHERE_SOURCE           = $00020000;
  MCI_OVLY_WHERE_DESTINATION      = $00040000;
  MCI_OVLY_WHERE_FRAME            = $00080000;
  MCI_OVLY_WHERE_VIDEO            = $00100000;

TYPE
  LP_Longint = 		^Longint;
  LP_WORD =		^WORD;
  FOURCC =		LONGINT;
  H_PSTR =		PChar;
  VERSION =		WORD;

  LP_WAVEOUTCAPS = 	^WAVEOUTCAPS;
  WAVEOUTCAPS = record
    wMid : WORD;
    wPid : WORD;
    vDriverVersion : VERSION;
    szPname : PChar;
    dwFormats : longint;
    wChannels : WORD;
    dwSupport : longint;
  end;

  H_WAVEOUT =		THandle;
  LPH_WAVEOUT =		^H_WAVEOUT;

  LP_WAVEFORMAT =	^WAVEFORMAT;
  WAVEFORMAT = record
    wFormatTag : WORD;
    nChannels : WORD;
    nSamplesPerSec : LONGINT;
    nAvgBytesPerSec : LONGINT;
    nBlockAlign : WORD;
  end;

  LP_WAVEHDR =		^WAVEHDR;
  WAVEHDR = record
    lpData : pointer;
    dwBufferLength : longint;
    dwBytesRecorded : Longint;
    dwUser : longint;
    dwFlags : longint;
    dwLoops : longint;
    lpNext : pointer;
    reserved : longint;
  end;

  { MMTIME SUB RECORDS }
  smpte_rec = record
    hour, min, sec, frame, fps, dummy : BYTE;
  end;

  midi_rec = record
    songptrpos : pointer;
  end;

  u_rec = record
    ms : longint;               { milliseconds}
    sample : longint;           { samples}
    cb : longint;               { byte count}
    SMPTE : smpte_rec;
    midi : midi_rec;
  end;

  LP_MMTIME =		^MMTIME;
  MMTIME = record
    wType : WORD;              { indicates the contents of the union}
    u : u_rec;
  end;

  LP_WAVEINCAPS =	^WAVEINCAPS;
  WAVEINCAPS = record
    wMid : WORD;
    wPid : WORD;
    vDriverVersion : VERSION;
    szPname : PChar;
    dwFormats : LONGINT;
    wChannels : WORD;
  end;

  LPH_WAVEIN =		^H_WAVEIN;
  H_WAVEIN =		THandle;

  LP_MIDIOUTCAPS =	^MIDIOUTCAPS;
  MIDIOUTCAPS = record
    wMid : WORD;
    wPid : WORD;
    vDriverVersion : VERSION;
    szPname : PChar;
    wTechnology : WORD;
    wVoices : WORD;
    wNotes : WORD;
    wChannelMask : WORD;
    dwSupport : LONGINT;
  end;

  LP_HMIDIOUT =		^H_MIDIOUT;
  H_MIDIOUT =		THandle;

  LP_MIDIHDR =		^MIDIHDR;
  MIDIHDR = record
    lpData : pointer;
    dwBufferLength : longint;
    dwBytesRecorded : longint;
    dwUser : longint;
    dwFlags : longint;
    lpNext : pointer;
    reserved : longint;
  end;

  LP_MIDIINCAPS =	^MIDIINCAPS;
  MIDIINCAPS = record
    wMid : WORD;
    wPid : WORD;
    vDriverVersion : VERSION;
    szPname : PChar;
  end;

  LPH_MIDIIN =		^H_MIDIIN;
  H_MIDIIN =		THandle;

  LP_AUXCAPS =		^AUXCAPS;
  AUXCAPS = record
    wMid : WORD;
    wPid : WORD;
    vDriverVersion : VERSION;
    szPname : PChar;
    wTechnology : WORD;
    dwSupport : longint;
  end;

  LP_TIMECALLBACK =	TFarProc;
  { pointer to a function with the following syntax:

    function TimerCallBack(
        idTimer : WORD;			 	// Timer ID
        msg : WORD;			 	// not used
        dwUser : LONGINT;		        // User-instance data
        dw1, dw2 : LONGINT) : WORD; EXPORT; 	// not used

    return is not utilized.
  }


  LP_TIMECAPS =		^TIMECAPS;
  TIMECAPS = record
    wPeriodMin : WORD;
    wPeriodMax : WORD;
  end;

  LP_JOYCAPS =		^JOYCAPS;
  JOYCAPS = record
    wMid : WORD;
    wPid : WORD;
    szPname : PChar;
    wXmin : WORD;
    wXmax : WORD;
    wYmin : WORD;
    wYmax : WORD;
    wZmin : WORD;
    wZmax : WORD;
    wNumButtons : WORD;
    wPeriodMin : WORD;
    wPeriodMax : WORD;
  end;

  LP_JOYINFO =		^JOYINFO;
  JOYINFO = record
    wXpos : WORD;
    wYpos : WORD;
    wZpos : WORD;
    wButtons : WORD;
  end;

  LP_MMIOPROC =		TFarProc;

  H_MMIO =		THandle;

  LP_MMIOINFO =		^MMIOINFO;
  MMIOINFO = record
    { general fields  }
    dwFlags : longint;        { general status flags                 }
    fccIOProc : FOURCC;      { pointer to I/O procedure              }
    pIOProc : LP_MMIOPROC;        { pointer to I/O procedure         }
    wErrorRet : WORD;      { place for error to be returned          }
    wReserved : WORD;      { for structure alignment                 }

    { fields maintained by MMIO functions during buffered I/O}
    cchBuffer : LONGINT;      { size of I/O buffer (or 0L)           }
    pchBuffer : H_PSTR;      { start of I/O buffer (or NULL)          }
    pchNext : H_PSTR;        { pointer to next byte to read/write     }
    pchEndRead : H_PSTR;     { pointer to last valid byte to read     }
    pchEndWrite : H_PSTR;    { pointer to last byte to write          }
    lBufOffset : longint;     { disk offset of start of buffer       }

    { fields maintained by I/O procedure}
    lDiskOffset : longint;    { disk offset of next read or write             }
    adwInfo : array [1..3] of longint;     { data specific to type of MMIOPROC}

    { other fields maintained by MMIO}
    dwReserved1 : longint;    { reserved for MMIO use            }
    dwReserved2 : longint;    { reserved for MMIO use            }
    hmmio : H_MMIO;          { handle to open file               }
  end;

  LP_MMCKINFO =		^MMCKINFO;
  MMCKINFO = record
    ckid :		FOURCC;
    cksize : 		longint;
    fcctype :		FOURCC;
    dwDataOffset :	LONGINT;
    dwFlags :		LONGINT;
  end;

  YIELDPROC =		TFarProc;

{ generic parameter block for MCI command messages with no special parameters}
LP_MCI_GENERIC_PARMS = ^MCI_GENERIC_PARMS;
MCI_GENERIC_PARMS = record
	dwCallBack : LONGINT;
end;

{ parameter block for MCI_OPEN command message}
MCI_OPEN_PARMS = record
    dwCallback : LONGINT;
    wDeviceID : WORD;
    wReserved0 : WORD;
    lpstrDeviceType : POINTER;
    lpstrElementName : POINTER;
    lpstrAlias : POINTER;
end;
LP_MCI_OPEN_PARMS = ^MCI_OPEN_PARMS;

{ parameter block for MCI_PLAY command message}
MCI_PLAY_PARMS = record
    dwCallback : LONGINT;
    dwFrom : LONGINT;
    dwTo : LONGINT;
end;
LP_MCI_PLAY_PARMS = ^MCI_PLAY_PARMS;

{ parameter block for MCI_SEEK command message}
MCI_SEEK_PARMS = record
    dwCallback : LONGINT;
    dwTo : LONGINT;
end;
LP_MCI_SEEK_PARMS = ^MCI_SEEK_PARMS;

{ parameter block for MCI_STATUS command message}
MCI_STATUS_PARMS = record
    dwCallback : LONGINT;
    dwReturn : LONGINT;
    dwItem : LONGINT;
    dwTrack : LONGINT;
end;
LP_MCI_STATUS_PARMS = ^MCI_STATUS_PARMS;

{ parameter block for MCI_INFO command message}
MCI_INFO_PARMS = record
    dwCallback : LONGINT;
    lpstrReturn : POINTER;
    dwRetSize : LONGINT;
end;
LP_MCI_INFO_PARMS = ^MCI_INFO_PARMS;

{ parameter block for MCI_GETDEVCAPS command message}
MCI_GETDEVCAPS_PARMS = record
    dwCallback : LONGINT;
    dwReturn : LONGINT;
    dwItem : LONGINT;
end;
LP_MCI_GETDEVCAPS_PARMS = ^MCI_GETDEVCAPS_PARMS;

{ parameter block for MCI_SYSINFO command message}
MCI_SYSINFO_PARMS = record
    dwCallback : LONGINT;
    lpstrReturn : POINTER;
    dwRetSize : LONGINT;
    dwNumber : LONGINT;
    wDeviceType : WORD;
    wReserved0 : WORD;
end;
LP_MCI_SYSINFO_PARMS = ^MCI_SYSINFO_PARMS;

{ parameter block for MCI_SET command message}
MCI_SET_PARMS = record
    dwCallback : LONGINT;
    dwTimeFormat : LONGINT;
    dwAudio : LONGINT;
end;
LP_MCI_SET_PARMS = ^MCI_SET_PARMS;

{ parameter block for MCI_BREAK command message}
MCI_BREAK_PARMS = record
    dwCallback : LONGINT;
    nVirtKey : INTEGER ;
    wReserved0 : WORD;
    hwndBreak : HWND;
    wReserved1 : WORD;
end;
LP_MCI_BREAK_PARMS = ^MCI_BREAK_PARMS;

{ parameter block for MCI_SOUND command message}
MCI_SOUND_PARMS = record
    dwCallback : LONGINT;
    lpstrSoundName : POINTER;
end;
LP_MCI_SOUND_PARMS = ^MCI_SOUND_PARMS;

{ parameter block for MCI_SAVE command message}
MCI_SAVE_PARMS = record
    dwCallback : LONGINT;
    lpfilename : POINTER;
end;
LP_MCI_SAVE_PARMS = ^MCI_SAVE_PARMS;

{ parameter block for MCI_LOAD command message}
MCI_LOAD_PARMS = record
    dwCallback : LONGINT;
    lpfilename : POINTER;
end;
LP_MCI_LOAD_PARMS = ^MCI_LOAD_PARMS;

{ parameter block for MCI_RECORD command message}
MCI_RECORD_PARMS = record
    dwCallback : LONGINT;
    dwFrom : LONGINT;
    dwTo : LONGINT;
end;
LP_MCI_RECORD_PARMS = ^MCI_RECORD_PARMS;

{}
{ MCI extensions for videodisc devices}
{}

{ parameter block for MCI_PLAY command message}
MCI_VD_PLAY_PARMS = record
    dwCallback : LONGINT;
    dwFrom : LONGINT;
    dwTo : LONGINT;
    dwSpeed : LONGINT;
end;
LP_MCI_VD_PLAY_PARMS = ^MCI_VD_PLAY_PARMS;

{ parameter block for MCI_STEP command message}
MCI_VD_STEP_PARMS = record
    dwCallback : LONGINT;
    dwFrames : LONGINT;
end;
LP_MCI_VD_STEP_PARMS = ^MCI_VD_STEP_PARMS;

{ parameter block for MCI_ESCAPE command message}
MCI_VD_ESCAPE_PARMS = record
    dwCallback : LONGINT;
    lpstrCommand : POINTER;
end;
LP_MCI_VD_ESCAPE_PARMS = ^MCI_VD_ESCAPE_PARMS;


{}
{ MCI extensions for waveform audio devices}
{}

{ parameter block for MCI_OPEN command message}
MCI_WAVE_OPEN_PARMS = record
    dwCallback : LONGINT;
    wDeviceID : WORD;
    wReserved0 : WORD;
    lpstrDeviceType : POINTER;
    lpstrElementName : POINTER;
    lpstrAlias : POINTER;
    dwBufferSeconds : LONGINT;
end;
LP_MCI_WAVE_OPEN_PARMS = ^MCI_WAVE_OPEN_PARMS;

{ parameter block for MCI_DELETE command message}
MCI_WAVE_DELETE_PARMS = record
    dwCallback : LONGINT;
    dwFrom : LONGINT;
    dwTo : LONGINT;
end;
LP_MCI_WAVE_DELETE_PARMS = ^MCI_WAVE_DELETE_PARMS;

{ parameter block for MCI_SET command message}
MCI_WAVE_SET_PARMS = record
    dwCallback : LONGINT;
    dwTimeFormat : LONGINT;
    dwAudio : LONGINT;
    wInput : WORD;
    wReserved0 : WORD;
    wOutput : WORD;
    wReserved1 : WORD;
    wFormatTag : WORD;
    wReserved2 : WORD;
    nChannels : WORD;
    wReserved3 : WORD;
    nSamplesPerSec : LONGINT;
    nAvgBytesPerSec : LONGINT;
    nBlockAlign : WORD;
    wReserved4 : WORD;
    wBitsPerSample : WORD;
    wReserved5 : WORD;
end;
LP_MCI_WAVE_SET_PARMS = ^MCI_WAVE_SET_PARMS;


{}
{ MCI extensions for MIDI sequencer devices}
{}

{ parameter block for MCI_SET command message}
MCI_SEQ_SET_PARMS = record
    dwCallback : LONGINT;
    dwTimeFormat : LONGINT;
    dwAudio : LONGINT;
    dwTempo : LONGINT;
    dwPort : LONGINT;
    dwSlave : LONGINT;
    dwMaster : LONGINT;
    dwOffset : LONGINT;
end;
LP_MCI_SEQ_SET_PARMS = ^MCI_SEQ_SET_PARMS;


{}
{ MCI extensions for animation devices}
{}

{ parameter block for MCI_OPEN command message}
MCI_ANIM_OPEN_PARMS = record
    dwCallback : LONGINT;
    wDeviceID : WORD;
    wReserved0 : WORD;
    lpstrDeviceType : POINTER;
    lpstrElementName : POINTER;
    lpstrAlias : POINTER;
    dwStyle : LONGINT;
    hWndParent : WORD;
    wReserved1 : WORD;
end;
LP_MCI_ANIM_OPEN_PARMS = ^MCI_ANIM_OPEN_PARMS;

{ parameter block for MCI_PLAY command message}
MCI_ANIM_PLAY_PARMS = record
    dwCallback : LONGINT;
    dwFrom : LONGINT;
    dwTo : LONGINT;
    dwSpeed : LONGINT;
end;
LP_MCI_ANIM_PLAY_PARMS = ^MCI_ANIM_PLAY_PARMS;

{ parameter block for MCI_STEP command message}
MCI_ANIM_STEP_PARMS = record
    dwCallback : LONGINT;
    dwFrames : LONGINT;
end;
LP_MCI_ANIM_STEP_PARMS = ^MCI_ANIM_STEP_PARMS;

{ parameter block for MCI_WINDOW command message}
MCI_ANIM_WINDOW_PARMS = record
    dwCallback : LONGINT;
    hWnd : WORD;
    wReserved1 : WORD;
    nCmdShow : WORD;
    wReserved2 : WORD;
    lpstrText : POINTER;
end;
LP_MCI_ANIM_WINDOW_PARMS = ^MCI_ANIM_WINDOW_PARMS;

{ parameter block for MCI_PUT, MCI_UPDATE, MCI_WHERE command messages}
MCI_ANIM_RECT_PARMS = record
    dwCallback : LONGINT;
    ptOffset : TPoint;
    ptExtent : TPoint;
    rc : TRect;
end;
LP_MCI_ANIM_RECT_PARMS = ^MCI_ANIM_RECT_PARMS;

{ parameter block for MCI_UPDATE PARMS}
MCI_ANIM_UPDATE_PARMS = record
    dwCallback : LONGINT;
    rc : TRect;
    theDC : HDC ;
end;
LP_MCI_ANIM_UPDATE_PARMS = ^MCI_ANIM_UPDATE_PARMS;


{}
{ MCI extensions for video overlay devices}
{}

{ parameter block for MCI_OPEN command message}
MCI_OVLY_OPEN_PARMS = record
    dwCallback : LONGINT;
    wDeviceID : WORD;
    wReserved0 : WORD;
    lpstrDeviceType : POINTER;
    lpstrElementName : POINTER;
    lpstrAlias : POINTER;
    dwStyle : LONGINT;
    hWndParent : WORD;
    wReserved1 : WORD;
end;
LP_MCI_OVLY_OPEN_PARMS = ^MCI_OVLY_OPEN_PARMS;

{ parameter block for MCI_WINDOW command message}
MCI_OVLY_WINDOW_PARMS = record
    dwCallback : LONGINT;
    hWnd : WORD;
    wReserved1 : WORD;
    nCmdShow : WORD;
    wReserved2 : WORD;
    lpstrText : POINTER;
end;
LP_MCI_OVLY_WINDOW_PARMS = ^MCI_OVLY_WINDOW_PARMS;

{ parameter block for MCI_PUT, MCI_UPDATE, and MCI_WHERE command messages}
MCI_OVLY_RECT_PARMS = record
    dwCallback : LONGINT;
    ptOffset : TPoint;
    ptExtent : TPoint;
    rc : TRect;
end;
LP_MCI_OVLY_RECT_PARMS = ^MCI_OVLY_RECT_PARMS;

{ parameter block for MCI_SAVE command message}
MCI_OVLY_SAVE_PARMS = record
    dwCallback : LONGINT;
    lpfilename : POINTER;
    rc : TRect;
end;
LP_MCI_OVLY_SAVE_PARMS = ^MCI_OVLY_SAVE_PARMS;

{ parameter block for MCI_LOAD command message}
MCI_OVLY_LOAD_PARMS = record
    dwCallback : LONGINT;
    lpfilename : POINTER;
    rc : TRect;
end;
LP_MCI_OVLY_LOAD_PARMS = ^MCI_OVLY_LOAD_PARMS;

IMPLEMENTATION

BEGIN
END.
