/*****************************************************************************

					Visualib Header File
					Copyright (c) 1993
					Visual Technology International, Co.
					P.O.Box 901-413
					Kansas City, MO 64190

*****************************************************************************/

/*****************************************************************************

					Constants, types, and Macros

*****************************************************************************/

typedef double	real;

#define VOIDED  void far pascal
#define DOUBLE  double far pascal
#define FLOAT   float far pascal
#define SHORT   short far pascal
#define REAL    real far pascal
#define BINARY  BOOL far pascal

typedef float huge	*hpfloat;
typedef double far  *lpdouble;
typedef float far   *lpfloat;
typedef real far    *lpreal;
typedef real		COORD;
typedef COORD		COORD2[2];
typedef COORD		COORD3[3];
typedef COORD		COORD4[4];
typedef COORD far	*LPCOORD;
typedef COORD2 far	*LPCOORD2;
typedef COORD3 far	*LPCOORD3;
typedef COORD4 far	*LPCOORD4;

typedef real far    *VECTOR;
typedef real far    *MATRIX;

typedef real    VECTOR2[2];
typedef real    VECTOR3[3];
typedef real    VECTOR4[4];
typedef real    MATRIX2D[9];
typedef real    MATRIX3D[16];
typedef VECTOR2	far	*LPVECT2;
typedef VECTOR3	far	*LPVECT3;
typedef	VECTOR4 far	*LPVECT4;
typedef VECTOR far *LPVECTOR;

typedef struct _tagPOINT2D {    /* 2D point coordinates */
    real    x, y;
} POINT2D, far *LPPOINT2D;

typedef struct _tagPOINT2H {    /* 2D homogeneous point coordinates */
    real    x, y, w;
} POINT2H, far *LPPOINT2H;

typedef struct _tagPOINT3D {    /* 3D point coordinates */
    real    x, y, z;
} POINT3D, far *LPPOINT3D;

typedef struct _tagPOINT3H {    /* 3D homogeneous point coordinates */
    real    x, y, z, w;
} POINT3H, far *LPPOINT3H;

typedef struct _tagBOX2D {
    real    xmin, xmax, ymin, ymax;
} BOX2D, far *LPBOX2D;

typedef struct _tagBOX3D {
    real    xmin, xmax, ymin, ymax, zmin, zmax;
} BOX3D, far *LPBOX3D;

typedef MATRIX3D far	*LPMTRX3D;
typedef MATRIX2D far	*LPMTRX2D;

#define EPSILON (real) 1e-5
#define QUTRPI  (real) 0.78539816
#define HALFPI  (real) 1.57079633
#define PI      (real) 3.14159265
#define TWOPI   (real) 6.2831853
#define DTOR    (real) 0.0174532
#define ATOR    (real) 1.7453293e-3
#define RTOD    (real) 57.295779
#define	SQRT2	(real)1.414214
#define	SQRT3	(real)1.732051

/* coordinate type */
#define	VL_2D	0x1000
#define	VL_3D	0x2000
#define	VL_2H	0x0400
#define	VL_3H	0x0800

/* viewer status flag */
#define	VL_TWOD			8
#define	VL_THREED		16
#define	VL_CURRENT		128

/* light coordinate mode */
#define	VL_WORLDLIGHT		0x0001
#define	VL_CAMERALIGHT		0x0002
#define	VL_OBJECTLIGHT		0x0004

/* light type */
#define	VL_POINTLIGHT			0x0100
#define	VL_DISTLIGHT			0x0200
#define	VL_SPOTLIGHT			0x0400
#define VL_AREALIGHT			0x0800

/* color type */
#define	VL_MATERIALAMBIENT	0x0001
#define	VL_MATERIALDIFFUSE	0x0002
#define	VL_MATERIALSPECULAR	0x0003
#define	VL_MATERIALEMISSION	0x0004
#define	VL_AMBIENTREFLECT	0x0005
#define	VL_DIFFUSEREFLECT	0x0006
#define	VL_SPECULARREFLECT	0x0007
#define	VL_EMISSIONSTRENGTH	0x0008
#define	VL_SHININESS		0x0009

#define	VL_LIGHTCOLOR		0x0010
#define	VL_AMBIENTCONTRIB	0x0020
#define	VL_LIGHTLOCATION	0x0030
#define	VL_LIGHTDIRECTION	0x0040
#define	VL_LIGHTINTENSITY	0x0050
#define	VL_SPOTLIGHTANGLE	0x0060
#define	VL_SPOTLIGHTSPREAD	0x0070

#define	VL_ATTENUATION		0x0100
#define	VL_GLOBALAMBIENT	0x0200
#define	VL_BACKGROUNDCOLOR	0x0300
#define	VL_SHADINGMETHOD	0x0400
#define	VL_SHADINGMODEL		0x0500
#define	VL_LOCALVIEWER		0x0600
#define	VL_COUNTCLOCKWISE	0x0700
#define	VL_TWOSIDESHADE		0x0800
#define	VL_DEPTHBUFFER		0x0900
#define	VL_BACKFACEREMOVAL	0x0A00
#define	VL_PERTURBMATERIAL	0x0B00
#define VL_PERTURBNORMAL	0x0C00
#define	VL_PERTURBPIXEL		0x0D00
#define VL_PERTURBFACET		0x0E00
#define	VL_ENVIRONMENT		0x0F00

#define VL_INQUIRE        	-1

/* projection mode */
#define VL_PROJECTIONMODE  0x03
#define VL_PERSPECTIVE     0x01
#define VL_ORTHOGONAL      0x02

/* Viewport Mapping Mode */
/*
#define	VL_HORIZONTALFIT	1
#define	VL_VERTICALFIT		2
#define	VL_AUTOFIT			3
#define	VL_VIEWPORTFIT		4
*/
/* standard pen and brush color */
#define	VL_NONE			 0
#define VL_RED           1
#define VL_GREEN         2
#define VL_BLUE          3
#define VL_BROWN         4
#define VL_MAGENTA       5
#define VL_CYAN          6
#define VL_WHITE         7
#define VL_GRAY          8
#define VL_LIGHTRED      9
#define VL_LIGHTGREEN    10
#define VL_LIGHTBLUE     11
#define VL_YELLOW        12
#define VL_LIGHTMAGENTA  13
#define VL_LIGHTCYAN     14
#define VL_LIGHTGRAY     15
#define VL_BLACK         16

/* shading method */
#define	VL_WIREFRAME			0x0001
#define	VL_SOLIDFILL			0x0002
#define	VL_CONTOURSHADE			0x0004
#define	VL_GOURAUDSHADE			0x0008
#define	VL_PHONGSHADE			0x0010
#define	VL_FLATSHADE			0x0020

/* shading model */
#define	VL_PHONGMODEL			0x0100
#define	VL_SPECULARMODEL		0x0200

/* mark type */
#define	VL_NULLMARK			0x0000
#define	VL_CIRCLEMARK		0x0001
#define	VL_CROSSMARK		0x0002
#define	VL_XMARK			0x0004
#define	VL_TRIANGLEMARK		0x0008
#define	VL_BOXMARK			0x0010
#define	VL_DIAMONDMARK		0x0020
#define	VL_HEXAGONMARK		0x0040
#define	VL_OCTAGONMARK		0x0080

/* arrow head type */
#define	VL_NULLARROW		0x0000
#define	VL_OPENARROW		0X0100
#define	VL_CLOSEDARROW		0X0200

/* position mark type */
#define	VL_CROSSHAIR	1
#define	VL_ORIGIN		2

/* solid texture flag */
#define	VL_MARBLE		0x0001
#define	VL_WOODGRAIN	0x0002
#define	VL_GRANITE		0x0004

/* Useful Macros */
#define ABS(x)      (((x)>0)?(x):-(x))
#define TRUNC(x)	((int) (x))
//#define ROUND(x)	(int)((x)+0.5f)
#define	FLOOR(x)	(((x)>0) ? (int)(x) : -(int)(-(x)+1))
#define	CEILING(x)	((x)==(int)(x)?(x):(((x)>0)?1+(int)(x):-(1+(int)(-(x)))))
#define	ROUND(x)	((x)>0 ? (int)(x+0.5f) : -(int)(0.5f-x))
#define SQR(x)          ((x)*(x))
#define SQR2(x,y)       ((real)(SQR(x)+SQR(y)))
#define SQR3(x,y,z)     ((real)(SQR(x)+SQR(y)+SQR(z)))

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define	SWAP(a,b)	{ a^=b; b^=a; a^=b; }
#define MIDVAL(a,b)     (((a)+(b))*0.5f)
#define	LERP(a,l,h)	((l)+(((h)-(l))*(a)))
#define	CLAMP(v,l,h)	((v)<(l) ? (l) : (v)>(h) ? (h) : (v))
#define	STEP(v,s)	((v)<(s) ? 0 : 1)
#define	SIGN(x)		(((x)<0) ? -1 : (x)>0 ? 1 : 0)

#define	NEWLIST(type,n)	(type far *)_fmalloc (sizeof (type) * (n))
#define	NEWITEM(type)	(type far *)_fmalloc (sizeof (type))

#define DIST2(x,y)      ((real)sqrt(SQR2(x,y)))
#define DIST3(x,y,z)    ((real)sqrt(SQR3(x,y,z)))
#define DETERM2(a,b,c,d)    ((a)*(d)-(b)*(c))
#define DETERM3(a,b,c,d,e,f,g,h,i) ((a)*DETERM2(e,f,h,i)+(b)*DETERM2(f,d,i,g)+(c)*DETERM2(d,e,g,h))

#define VSET2(v,x,y)		((v)[0]=(real)(x),(v)[1]=(real)(y))
#define VSET3(v,x,y,z)		((v)[0]=(real)(x),(v)[1]=(real)(y),(v)[2]=(real)(z))
#define VSET4(v,x,y,z,w)	((v)[0]=(real)(x),(v)[1]=(real)(y),(v)[2]=(real)(z),(v)[3]=(real)(w))
#define	VGET2(v,x,y)		(x=(v)[0],y=(v)[1])
#define	VGET3(v,x,y,z)		(x=(v)[0],y=(v)[1],z=(v)[2])
#define	VGET4(v,x,y,z,w)	(x=(v)[0],y=(v)[1],z=(v)[2],w=(v)[3])

/*****************************************************************************

					Function Prototypes

*****************************************************************************/

/*****************************************************************************

					Basic Functions

*****************************************************************************/

BINARY	InitializeVisualib (void);
VOIDED  ExitVisualib (void);
VOIDED	AboutVisualib (void);
VOIDED	LicenseInfo (void);

/* utility functions */
BINARY  MessageOn (int flag);
VOIDED  ErrorMessage (LPSTR msg);
VOIDED	Message (LPSTR msg);
COLORREF WINAPI	SelectColor (COLORREF color);

SHORT   NumViewer (void);
VOIDED  SetPoint2D (LPPOINT2D point, real x, real y);
VOIDED  SetPoint3D (LPPOINT3D point, real x, real y, real z);
VOIDED  SetPoint2H (LPPOINT2H point, real x, real y, real w);
VOIDED  SetPoint3H (LPPOINT3H point, real x, real y, real z, real w);
VOIDED  SetBox2D (LPBOX2D box, real xmin, real xmax, real ymin, real ymax);
VOIDED  SetBox3D (LPBOX3D box, real xmin, real xmax, real ymin, real ymax, real zmin, real zmax);

VOIDED	PenColor (HDC hdc, int color_index);
VOIDED	BrushColor (HDC hdc, int color_index);
VOIDED	TextColor (HDC hdc, int tcolor, int bcolor, int mode);
VOIDED	PaintColor (HDC hdc, int pen, int brush, int mode);

SHORT	CreateViewer (LPSTR name, RECT port, BYTE type, BYTE mode);
BINARY	DeleteViewer (int vid);

SHORT	ViewerMappingMode (int vid, int mode);
BINARY	CopyViewer (int vid1, int vid2);
BINARY	ResetViewer (int vid);
SHORT	SelectViewer (int vid);
BINARY	SetViewerName (int vid, LPSTR name);
BINARY	GetViewerName (int vid, LPSTR name);
BINARY	SetViewport (int vid, RECT port);
BINARY	GetViewport (int vid, LPRECT port);

BINARY	ClearViewer (HDC hdc, int vid, int color);
BINARY	DisplayViewerFrame (HDC hdc, int vid);
BINARY	DisplayViewerName (HDC hdc, int vid, int top);

BINARY	BeginDoubleBuffer (HDC far *hdc, int viewid);
BINARY	EndDoubleBuffer (HDC far *hdc, int viewid);
BINARY	UpdateDoubleBuffer (HDC hdc, int viewid);

/*****************************************************************************

						2D Functions

*****************************************************************************/

VOIDED  Translate2D (real x, real y);
VOIDED	TranslateTo2D (real x, real y);
VOIDED  Scale2D (real x, real y);
VOIDED	PointScale2D (real x, real y, real sx, real sy);
VOIDED	TranScale2D (real x, real y, real sx, real sy);
VOIDED	Shear2D (real x, real y, real a, real u, real v);
VOIDED	Stretch2D (real x, real y, real a, real f);
VOIDED	Mirror2D (real x, real y, real a);
VOIDED  Rotate2D (real angle);
VOIDED	PointRotate2D (real x, real y, real a);
BINARY	ViewerField2D (int vid,
			lpreal left, lpreal bottom, lpreal right, lpreal top);

BINARY	PushTransformation2D (MATRIX m);
BINARY	PopTransformation2D (MATRIX m);
VOIDED	ConcatTransformation2D (MATRIX m, BOOL post);
VOIDED	LoadTransformation2D (MATRIX m);

BINARY	SetProjection2D (int vid,
			real left, real bottom, real right, real top);
BINARY	SetView2D (int vid, real x, real y, real a);
BINARY	SetWindow2D (int vid, real left, real bottom, real right, real top);

BINARY	MoveViewer2D (int vid, real horizontal, real vertical, BOOL local);
BINARY	RotateViewer2D (int vid, real angle, BOOL local);
BINARY	ZoomViewer2D (int vid, real zoom);

VOIDED  MoveTo2D (HDC hdc, real x, real y);
VOIDED  RMoveTo2D (HDC hdc, real x, real y);
VOIDED  LineTo2D (HDC hdc, real x, real y);
VOIDED  RLineTo2D (HDC hdc, real x, real y);
VOIDED  Line2D (HDC hdc, real x1, real y1, real x2, real y2);
VOIDED  RLine2D (HDC hdc, real x, real y, real dx, real dy);
VOIDED	Label2D (HDC hdc, real x, real y, LPSTR label);
VOIDED	MoveTo2H (HDC hdc, real x, real y, real w);
VOIDED	LineTo2H (HDC hdc, real x, real y, real w);
VOIDED	Line2H (HDC hdc, real x1, real y1, real w1,
			real x2, real y2, real w2);

VOIDED  Polygon2D (HDC hdc, int type, LPCOORD vertex, int count);
VOIDED  PolyPolygon2D (HDC hdc, int type, LPCOORD vertex,
			LPINT polycount, int count);
VOIDED  Polyline2D (HDC hdc, int type, LPCOORD point, int count);
VOIDED  ClosedPolyline2D (HDC hdc, int type, LPCOORD point, int count);
VOIDED	Mark2D (HDC hdc, real x, real y, int hsize, int vsize, int head);
VOIDED	PolyMark2D (HDC hdc, int type, LPCOORD point, int n,
			int hsize, int vsize, int head);
VOIDED	Pointer2D (HDC hdc, real x1, real y1, real x2, real y2,
			real l, real w, int type);
VOIDED	Arrow2D (HDC hdc, real x, real y, real u, real v, real r, real l, 
			real w, int type);
VOIDED	Net2D (HDC hdc, int type, LPCOORD point, int m, int n);
VOIDED	MarkPosition2D (HDC hdc, real x, real y, real size, int type);

/*****************************************************************************

						3D Functions

*****************************************************************************/

SHORT	ProjectionMode (int vid, int mode);

VOIDED  Translate3D (real x, real y, real z);
VOIDED  TranslateTo3D (real x, real y, real z);
VOIDED  Scale3D (real sx, real sy, real sz);
VOIDED	PointScale3D (real x, real y, real z, real sx, real sy, real sz);
VOIDED  Rotate3D (real angle, char axis);
VOIDED	AxleRotate3D (VECTOR ref, VECTOR dir, real a);
VOIDED	Stretch3D (VECTOR ref, VECTOR dir, real f);
VOIDED	Shear3D (VECTOR ref, VECTOR dir, real u, real v);
VOIDED	Mirror3D (VECTOR ref, VECTOR dir);

BINARY	PushTransformation3D (MATRIX m);
BINARY	PopTransformation3D (MATRIX m);
VOIDED	ConcatTransformation3D (MATRIX m, BOOL post);
VOIDED	LoadTransformation3D (MATRIX m);

BINARY	ResetProjection3D (int vid);
BINARY	SetProjection3D (int vid, real left, real bottom, real right,
			real top, real front, real back, BYTE mode);
BINARY	SetPerspective (int vid, real fovy, real aspect,
			real zmin, real zmax);
BINARY	SetView3D (int vid, real ex, real ey, real ez,
			real ax, real ay, real az, real twist);
BINARY	SetPolarView (int vid, real ax, real ay, real az,
			real dist, real azim, real inc, real twist);

BINARY	ViewerLocation (int vid, lpreal x, lpreal y, lpreal z);
BINARY	ViewerDirection (int vid, lpreal x, lpreal y, lpreal z);
BINARY	ViewerField3D (int vid, lpreal left, lpreal bottom,
			lpreal right, lpreal top, lpreal front, lpreal back);

BINARY	MoveViewer3D (int vid, real horizontal, real vertical, real backforth,
			BOOL local);
BINARY	RotateViewer3D (int vid, real angle, char axis, BOOL local);
BINARY	ZoomViewer3D (int vid, real zoom);

VOIDED  MoveTo3D (HDC hdc, real x, real y, real z);
VOIDED  LineTo3D (HDC hdc, real x, real y, real z);
VOIDED  RMoveTo3D (HDC hdc, real x, real y, real z);
VOIDED  RLineTo3D (HDC hdc, real x, real y, real z);
VOIDED  MoveTo3H (HDC hdc, real x, real y, real z, real w);
VOIDED  LineTo3H (HDC hdc, real x, real y, real z, real w);

VOIDED  Line3D (HDC hdc, real x1, real y1, real z1,
			real x2, real y2, real z2);
VOIDED  RLine3D (HDC hdc, real x, real y, real z, real dx, real dy, real dz);

VOIDED	PolyArrow3D (HDC hdc, int type, LPCOORD poly, LPVECT3 dir, int n,
			real r, real l, real w, int htype);
VOIDED	Label3D (HDC hdc, real x, real y, real z, LPSTR label);
BINARY	Mark3D (HDC hdc, real x, real y, real z,
			int hsize, int vsize, int type);
VOIDED 	PolyMark3D (HDC hdc, int type, LPCOORD point, int n,
			int hsize, int vsize, int htype);


VOIDED	Polygon3D (HDC hdc, int type, LPCOORD vertex, int count);
VOIDED	PolyPolygon3D (HDC hdc, int type, LPCOORD vertex,
			LPINT polycount, int count);
VOIDED	Polyline3D (HDC hdc, int type, LPCOORD point, int count);
VOIDED  ClosedPolyline3D (HDC hdc, int type, LPCOORD point, int count);
VOIDED	MarkPosition3D (HDC hdc, real x, real y, real z, real size, int type);
VOIDED	Pointer3D (HDC hdc, real x1, real y1, real z1, real x2, real y2,
			real z2, real l, real w, int type);
VOIDED	Arrow3D (HDC hdc, real x, real y, real z, real u, real v, real w,
			real r, real l, real t, int type);
VOIDED	Net3D (HDC hdc, int type, LPCOORD point, int m, int n);

/*****************************************************************************

						Shading Functions

*****************************************************************************/

VOIDED	ResetShader (void);

/* depth buffer functions */
BINARY	SetDepthBuffer (int hview);
BINARY	SelectDepthBuffer (int hview);
BINARY	FreeDepthBuffer (int hview);
VOIDED	ClearDepthBuffer (WORD val);

/* light functions */
BINARY	CopyLight (int lid1, int lid2);
BINARY	ResetLight (int lid);
SHORT	CreateLight (LPSTR name, int type);
VOIDED	DeleteLight (int lid);
SHORT	SelectLight (int lid);
BINARY	CopyLModel (int lmid1, int lmid2);
SHORT	CreateLModel (LPSTR name);
VOIDED	DeleteLModel (int lmid);
SHORT	SelectLModel (int lmid);
SHORT	GetLightType (int lid);
BINARY	SwitchLight (int lid, int status);
BINARY	SetLightCoordinateType (int lid, int type);

/* material functions */
SHORT	CreateMaterial (LPSTR name);
VOIDED	DeleteMaterial (int mid);
SHORT	SelectMaterial (int mid);
BINARY	CopyMaterial (int mid1, int mid2);
BINARY	ResetMaterial (int mid);

/* shading parameter functions */
SHORT	ShadingOption (int id, int opt, int status);
COLORREF WINAPI	_ShadingColor (int id, int type, COLORREF color);
#define	ShadingColor(id,type,color)	_ShadingColor (id, type, (COLORREF) color)
REAL	ShadingFactor (int id, int type, real f);
BINARY	ShadingParameter (int id, int type, BOOL inquire, VECTOR param);

HPALETTE WINAPI	SetRGBPalette (void);

/* shading primitive functions */
BINARY	_ShadeFacet (HDC hdc, VECTOR normal, int type, LPCOORD vertex, int count, LPVECT3 param);
#define	ShadeFacet(hdc, normal, type, vertex, count, param)	\
_ShadeFacet (hdc, normal, type, (LPCOORD) vertex, count, param)
BINARY	_ShadePolygon (HDC hdc, VECTOR normal, int type, LPCOORD point, int count);
#define	ShadePolygon(hdc, normal, type, point, count)	\
_ShadePolygon(hdc, normal, type, (LPCOORD) point, count)
BINARY	_ShadePolyPolygon (HDC hdc, VECTOR normal, int type, LPCOORD vertex, LPINT pcount, int count);
#define	ShadePolyPolygon(hdc, normal, type, vertex, pcount, count)	\
_ShadePolyPolygon (hdc, normal, type, (LPCOORD) vertex, pcount, count)

BINARY	ShadingPreview (HDC hdc, LPRECT rect, real r, real d);

/* programmable shader functions */
VOIDED	GetPixelPosition (LPINT x, LPINT y);
VOIDED	GetPixelViewNormal (VECTOR normal);
VOIDED	GetPixelWorldNormal (VECTOR normal);
VOIDED	GetPixelObjectNormal (VECTOR normal);
VOIDED	GetPixelViewCoordinate (VECTOR coord);
VOIDED	GetPixelWorldCoordinate (VECTOR coord);
VOIDED	GetPixelObjectCoordinate (VECTOR coord);
VOIDED	GetPixelViewCameraAxis (VECTOR vaxis);
VOIDED	GetPixelWorldCameraAxis (VECTOR vaxis);
VOIDED	GetPixelObjectCameraAxis (VECTOR vaxis);

VOIDED	SetPerturbation (int type, FARPROC proc);
BINARY	SolidTexture (int type);

/*****************************************************************************

				Image Mapping and Printing Functions

*****************************************************************************/

typedef int (WINAPI *DRAWPROC)(HDC);

#define	VL_FLUSHTOP		0x0001
#define	VL_FLUSHBOTTOM	0x0002
#define	VL_FLUSHLEFT	0x0004
#define	VL_FLUSHRIGHT	0x0008

#define	VL_HORZFIT		0x0010
#define	VL_VERTFIT		0x0020
#define	VL_ALLFIT		0x0030
#define	VL_HORZCENTER	0x0040
#define	VL_VERTCENTER	0x0080

#define	VL_HORZSCALED	0x0100
#define	VL_VERTSCALED	0x0200
#define	VL_BESTFIT		0x0400
#define	VL_USE31APIS	0x0800

#define	VL_MILLIMETER	0x1000
#define	VL_CENTIMETER	0x2000
#define	VL_MARKCORNER	0x4000
#define	VL_MARKPAGE		0x8000

BINARY	ReadDIBFile (LPSTR fname, LPHANDLE hdib);
HANDLE	WINAPI	ScreenToDIB (LPRECT rect);
BINARY	WriteDIBFile (LPSTR fname, HANDLE hdib);
BINARY	SetPrintRect (HDC hdc, LPRECT rect, int mode, double x, double y,
			double w, double h, int bw, int bh);
VOIDED	GetScreenRect (HWND hwnd, BOOL withframe, LPRECT rect);
BINARY	PrintImage (HANDLE hdib, WORD mode, real x, real y, real w, real h);
BINARY	PrintDrawing (DRAWPROC draw, WORD mode,
			real x, real y, real w, real h);
BINARY	ImageMap2D (HDC hdc, HGLOBAL hdib, int type, LPCOORD vertex);
BINARY	ImageMap3D (HDC hdc, HGLOBAL hdib, int type, LPCOORD vertex);


/* text parameter */
#define	VL_TEXT_HEIGHT			0x0001
#define	VL_TEXT_ASPECT			0x0002
#define	VL_TEXT_THICKNESS		0x0004

REAL	TextParameter (int type, real param);
BINARY	SelectFont (void);
BINARY	SetFont (const LPLOGFONT lplf);
BINARY	Text2D (HDC hdc, real x, real y, real a, LPSTR text);
BINARY	Text3D (HDC hdc, real x, real y, real a, LPSTR text);
BINARY	SolidText (HDC hdc, LPSTR text);

/*****************************************************************************

					2D Curve Functions

*****************************************************************************/

VOIDED  QBezierCurve2D (HDC hdc, int type, LPCOORD poly);
VOIDED  QBSplineCurve2D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  QNURBSCurve2D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);

VOIDED  BezierCurve2D (HDC hdc, int type, LPCOORD poly);
VOIDED  HermitCurve2D (HDC hdc, int type, LPCOORD poly);
VOIDED  BSplineCurve2D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurve2D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);
VOIDED  SplineInterp2D (HDC hdc, int type, LPCOORD poly, int n);

VOIDED  BSplineCurveClosed2D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurveClosed2D (HDC hdc, int type, LPCOORD poly,
			int n, VECTOR knot);

VOIDED	CatmullRomSpline2D (HDC hdc, int type, LPCOORD poly, int n);


/*****************************************************************************

					3D Curve Functions

*****************************************************************************/

VOIDED  QBezierCurve3D (HDC hdc, int type, LPCOORD poly);
VOIDED  QBSplineCurve3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  QNURBSCurve3D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);
VOIDED  BezierCurve3D (HDC hdc, int type, LPCOORD poly);
VOIDED	HermitCurve3D (HDC hdc, int type, LPCOORD poly);
VOIDED  BSplineCurve3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurve3D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);
VOIDED  SplineInterp3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  BSplineCurveClosed3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurveClosed3D (HDC hdc, int type, LPCOORD poly,
			int n, VECTOR knot);
VOIDED	CatmullRomSpline3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED	Spring (HDC hdc, int n, real radius, real height);

/*****************************************************************************

						Vertex Functions

*****************************************************************************/

SHORT   CircleSide (short side);
VOIDED	TransfVertex (int type, real x, real y, real a,
			real sx, real sy, lpreal vertex, int n);
SHORT	RectangleVertex (int type, real x1, real y1, real x2, real y2,
			lpreal vertex);
SHORT	BoxVertex (int type, real x, real y, real t, real sx, real sy,
			lpreal vertex);
SHORT   NgonVertex (int type, real x, real y, real t, real rx, real ry,
			int n, lpreal vertex);
SHORT	FlowerVertex (int type, real x, real y, real t, real rx, real ry,
			int n, real r, lpreal vertex);
SHORT	StarVertex (int type, real x, real y, real t, real rx, real ry,
			int n, lpreal vertex);
SHORT	ArcVertex (int type, real x, real y, real t, real rx, real ry,
			int n, real a, real b, lpreal vertex);
SHORT	WedgeVertex (int type, real x, real y, real t, real rx, real ry,
			int n, real a, real b, lpreal vertex);
SHORT	RingVertex (int type, real x, real y, real t, real rx, real ry,
			int n, real a, real b, real w, lpreal vertex);
SHORT	RoseVertex (int type, real x, real y, real a, real r, int m,
			int n, lpreal vertex);

/*****************************************************************************

				2D Primitive Functions

*****************************************************************************/

VOIDED  Rectangle2D (HDC hdc, real x1, real y1, real x2, real y2);
VOIDED	Box2D (HDC hdc, real x, real y, real t, real w, real h);
VOIDED  Disk2D (HDC hdc, real x, real y, real t, real rx, real ry);
VOIDED  Wedge2D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b);
VOIDED  Ring2D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b, real w);
VOIDED	Bow2D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b);
VOIDED  Ngon2D (HDC hdc, real x, real y, real t, real rx, real ry, int n);
VOIDED  Flower2D (HDC hdc, real x, real y, real t,
			real rx, real ry, int n, real ratio);
VOIDED  Star2D (HDC hdc, real x, real y, real t, real rx, real ry, int n);
VOIDED  Arc2D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b);
VOIDED	Rose2D (HDC hdc, real x, real y, real t, real r, int m, int n);

VOIDED	Spiral2D (HDC hdc, real x, real y, real a, real b, real r, real dr);


/*****************************************************************************

				3D Primitive Functions

*****************************************************************************/

VOIDED  Rectangle3D (HDC hdc, real x1, real y1, real x2, real y2);
VOIDED  Box3D (HDC hdc, real x, real y, real t, real sx, real sy);
VOIDED	Ring3D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b, real w);
VOIDED  Disk3D (HDC hdc, real x, real y, real t, real rx, real ry);
VOIDED  Wedge3D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b);
VOIDED  Bow3D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b);
VOIDED  Ngon3D (HDC hdc, real x, real y, real t, real rx, real ry, int n);
VOIDED  Flower3D (HDC hdc, real x, real y, real t,
			real rx, real ry, int n, real r);
VOIDED  Star3D (HDC hdc, real x, real y, real t, real rx, real ry, int n);

VOIDED  Arc3D (HDC hdc, real x, real y, real t,
			real rx, real ry, real a, real b);
VOIDED	Rose3D (HDC hdc, real x, real y, real t, real r, int m, int n);

VOIDED  Spiral3D (HDC hdc, real a, real b, real r, real dr, real h);
VOIDED	Spring3D (HDC hdc, real a, real b, real r, real h);


/*****************************************************************************

				3D Surface Functions

*****************************************************************************/

BINARY	BezierSurface (HDC hdc, int type, LPCOORD poly, int ns, int nt);
BINARY	HermitSurface (HDC hdc, int type, LPCOORD poly, int ns, int nt);
BINARY	BSplineSurface (HDC hdc, int type, LPCOORD poly,
			int Sc, int Tc, int ns, int nt);
BINARY	NURBSSurface (HDC hdc, int type, LPCOORD poly,
			int Sc, int Tc, VECTOR Skn, VECTOR Tkn, int ns, int nt);

BINARY	CoonsPatch (HDC hdc, int type, LPCOORD point, int nu, int nv);

/*****************************************************************************

							Solid Primitive Functions

*****************************************************************************/

BINARY	Cube (HDC hdc, real w, real l, real h);
BINARY	Cylinder (HDC hDC, real rx, real ry, real h);
BINARY	Cone (HDC hDC, real rx, real ry, real h);
BINARY	Ellipsoid (HDC hdc, real a, real b, real c);
BINARY	Sphere (HDC hdc, real r);
BINARY	HemiSphere (HDC hdc, real r, real h);
BINARY	SolidStar (HDC hdc, int n, real rx, real ry, real h);
BINARY	SolidFlower (HDC hdc, int n, real r, real rx, real ry, real h);
BINARY	Wedge (HDC hdc, real rx, real ry, real h, real a, real b);
BINARY	Frustum (HDC hdc, real bw, real bl, real tw, real tl, real h);
BINARY	Ridge (HDC hdc, real w, real l, real h, real r);
BINARY	Prism (HDC hdc, int type, LPCOORD base, int n, real h);
BINARY	Pyramid (HDC hdc, LPPOINT3D base, int n, LPPOINT3D tip);
BINARY	WedgedCone (HDC hdc, real rx, real ry, real h, real a, real b);
BINARY	WedgedCylinder (HDC hdc, real rx, real ry, real h,
			real tr, real a, real b);
BINARY	WedgedSphere (HDC hdc, real rx, real ry, real rz,
			real a1, real a2, real b1, real b2);
BINARY	WedgedTorus (HDC hdc, real r1, real r2,
			real a1, real a2, real b1, real b2);

BINARY	Torus (HDC hdc, real r1, real r2);

BINARY	Ring (HDC hdc, real rtop, real rbot, real t, real h, real a, real b, real ratio);
BINARY	Tube (HDC hdc, real rtop, real rbot, real t, real h);
BINARY	Tetrahedron (HDC hdc, real r);
BINARY	Octahedron (HDC hdc, real r);
BINARY	Dodecahedron (HDC hdc, real r);
BINARY  Icosahedron (HDC hdc, real r);

/*****************************************************************************

							Object Array Functions

*****************************************************************************/

typedef	BOOL (WINAPI *RectArrayProc)(HDC hdc, int row, int col);
typedef BOOL (WINAPI *CubicArrayProc)(HDC hdc, int row, int col, int lev);
typedef	BOOL (WINAPI *PolarArrayProc)(HDC hdc, int row, int col);
typedef	BOOL (WINAPI *CylindricArrayProc)(HDC hdc, int row, int col, int lev);
typedef BOOL (WINAPI *SphericArrayProc)(HDC hdc, int row, int col, int lev);

BINARY	RectangularArray2D (HDC hdc, int m, int n,
			real xinc, real yinc, RectArrayProc fp);
BINARY	RectangularArray3D (HDC hdc, int m, int n,
			real xinc, real yinc, RectArrayProc fp);
BINARY	PolarArray2D (HDC hdc, int m, int n,
			real roff, real ainc, real rinc, PolarArrayProc);
BINARY	PolarArray3D (HDC hdc, int m, int n,
			real roff, real ainc, real rinc, PolarArrayProc);
BINARY	CubicArray (HDC hdc, int m, int n, int l,
			real xinc, real yinc, real zinc, CubicArrayProc fp);
BINARY	CylindricArray (HDC hdc, int m, int n, int l,
			real roff, real ainc, real rinc, real zinc,
			CylindricArrayProc fp);
BINARY	SphericArray (HDC hdc, int m, int n, int l,
			real roff, real toff, real ainc, real rinc, real tinc,
			SphericArrayProc fp);

