/*
 * $Id: WINEXIT.H 1.0 1993/07/19 15:26:48 nino Exp $
 *
 * winexit.h file - define constants for winexit.c
 */


/* constants */
#define DEBUG           1
#define NODEBUG		0
#define EW_QUICK 	1
#define EW_SLOW		2


/* dialog, menu, accelerators */
#define AboutDialog		1
#define ExitDialog		2
#define ExitWindowsMenu		3
#define ExitAccelerators        4


/* radio buttons and about button */
#define IDD_ABOUT	10
#define IDD_EXIT	11
#define IDD_REST	12
#define IDD_BOOT	13
#define IDD_BMPEXIT	14

/* menus */
/* system menu */
#define IDM_ALWAYSONTOP 20
#define IDM_QUICKEXIT   21
#define IDM_ICONEXIT    22

/* application menu */
#define IDM_EXIT        31
#define IDM_REST        32
#define IDM_BOOT        33
#define IDM_ABOUT       34

/* about dlg bitmap (+1000) */
#define IDB_ABOUT_EXIT                   IDD_BMPEXIT+1000     // About box

/* About button bitmaps */
#define IDB_BUTT_UNPRESSED_UNFOCUSED     IDD_ABOUT + 1000     // About button
#define IDB_BUTT_PRESSED_FOCUSED         IDD_ABOUT + 3000     // About button
#define IDB_BUTT_UNPRESSED_FOCUSED       IDD_ABOUT + 5000     // About button

/*icons */
#define IDI_EXIT1       30
#define IDI_EXIT2       31

/* stringtable */
#define IDS_BADVERSION          0
#define IDS_BADOLDWINDOW	1
#define IDS_BADOLDICON          2
#define IDS_BADWINDOWTOP	3
#define IDS_BADLOADLIBRARY	4
#define IDS_EXITMESSAGE		16
#define IDS_DEBUGMESSAGE	17


/* private message for dialog initialisation */
#define WM_INIWINEXIT		( WM_USER + 1 )


/* ini file setings */
char		szIniFile[]	  = "winexit.ini";
char		szSection[]	  = "Options";
char            szQuickExit[]	  = "QuickExit";
char		szAlwaysOnTop[]	  = "AlwaysOnTop";
char		szIconExit[]	  = "ExitMode";

/* globals */
int 		iQuickExitValue;
int             iDebugValue	  = NODEBUG;
int             iBootAction       = IDD_EXIT;
char		szAppName []	  = "ExitWindows";
char    	szClassName[]     = "bordlgWindowsExit";
HINSTANCE	hInst;
HINSTANCE	hBWCCDLL;
HWND		hExitWnd	  = NULL;
HACCEL		hAccel;
LONG		lAction []	  = { 0L, EW_RESTARTWINDOWS, EW_REBOOTSYSTEM };

// local proto.
LRESULT FAR PASCAL _export ExitWndProc (HWND hDlg, UINT iMessage, UINT wParam, LONG lParam);

