#include "bag.h"
#include "assocint.h"
#include "integer.h"

#define THIS    Bag
#define BASE    Collection
//DEFINE_CLASS(THIS, BASE);
DEFINE_CLASS(Bag,Collection);

Bag::Bag(unsigned size) : contents(size)
{
    count = 0;
}

Bag::Bag(const Bag& b) : contents(b.contents)
{
    count = b.count;
}

void Bag::operator=(const Bag& b)
{
    contents = b.contents;
    count = b.count;
}
    
void Bag::reSize(unsigned newSize)
{
    contents.reSize(newSize);
}

Object* Bag::addWithOccurrences(const Object& ob, unsigned n)
{
    AssocInt* a = (AssocInt*)&contents.assocAt(ob);
    Object* o = (Object*)&ob;
    if (a==nil) contents.add(*new AssocInt(ob,n));
    else {
        Integer& i = *((Integer*)(a->value()));
        o = a->key();
        i.value(i.value()+n);
    }
    count += n;
    return o;
}

Object* Bag::add(const Object& ob)
{
    return addWithOccurrences(ob,1);
}

Object*& Bag::at(int i) const { return contents.at(i); }

unsigned Bag::capacity() const   { return contents.capacity(); }

Collection& Bag::addContentsTo(Collection& cltn) const
{
    DO(*this,Object*,ob) cltn.add(*ob); DONE
    return cltn;
}

void Bag::deepenShallowCopy()
{
    BASE::deepenShallowCopy();
    contents.deepenShallowCopy();
}

Object* Bag::doNext(Iterator& pos) const
{
    AssocInt* a;
    while (YES) {
        if (pos.num == 0) {
            a = (AssocInt*)contents.doNext(pos);
            if (a == NULL) return NULL;
        }
        else a = (AssocInt*)contents.at(pos.index-1);
        if (pos.num++ < ((Integer*)a->value())->value())
            return a->key();
        pos.num = 0;
    }
#if (0 MSC(+1))         // Microsoft C++  -gmv 5/4/93 
    return NULL;        // MSC70 generates an error without this line
#endif                  // BC++  generates a warning with it
}

Object* Bag::remove(const Object& ob)
{
    register AssocInt* a = (AssocInt*)&contents.assocAt(ob);
    Object* rob = (Object*)&ob;
    if (a==nil)
        //DTerror("OOPS_REMOVEERR,DEFAULT,this,className(),ob.className(),&ob",className());
        DTerror("Tried to remove object not in collection: ",className());
    register Integer* i = (Integer*)(a->value());
    register unsigned n = i->value();
    if (--n == 0) {
        rob = a->key();
        delete contents.remove(*a);
    }
    else i->value(n);
    --count;
    return rob;
}

bool Bag::operator==(const Bag& b) const
{
    return count==b.count && contents==b.contents;
}

unsigned Bag::hash() const    { return count^contents.hash(); }

bool Bag::isEqual(const Object& p) const
{
    return p.isSpecies(class_Bag) && *this==*(Bag*)&p;
}

const Class* Bag::species() const { return &class_Bag; }

unsigned Bag::occurrencesOf(const Object& ob) const
{
    register AssocInt* a = (AssocInt*)&contents.assocAt(ob);
    if (a==nil) return 0;
    else return ((Integer*)a->value())->value();
}

void Bag::printOn(ostream& strm) const
{
    unsigned n=0;
    strm << className() << "[\n";
    DO(contents,Object*,o)
        if (n>0) strm << "\n";
        o->printOn(strm);
        n++;
    DONE
    strm << "]\n";
}

unsigned Bag::size() const   { return count; }

Bag Collection::asBag() const
{
    Bag cltn(MAX(size(),CLTN_DEFAULT_CAPACITY));
    addContentsTo(cltn);
    return cltn;
}
