#include <stream.h>
#include "display.h"
#include <conio.h>
#include <ctype.h>

void printInt(unsigned int i)
{
    cout << "hex: " << hex(i) << "\n";
}

void printChat(Chat aChat)
{
    printInt(aChat);  // test cast with operator unsigned()
    cout << "aChat.ch()" << aChat.ch() << "\n";
    cout << "(int)aChat.at()" << aChat.at() << "\n";
    if ( isprint(aChat.ch()) )
        cout << form("implicit cast to %%c: %c\n", aChat);
}

main()
{
    cout <<  "hello, world\n";
    Chat noinit;
    Chat A(65);
    Chat a('a');
    Chat b('b', (YELLOW+(BLUE<<4)));
    Chat chatArray[5];

    cout << "sizeof(Chat): " << sizeof(Chat) << "\n";
    cout << "sizeof(a): " << sizeof(a) << "\n";
    cout << "sizeof(chatArray): " << sizeof(chatArray) << "\n";

    cout << "=====printChat(noinit)=====\n";
    printChat(noinit);

    cout << "=====printChat(A)=====\n";
    printChat(A);

    cout << "=====printChat(a)=====\n";
    printChat(a);

    cout << "=====printChat(b)=====\n";
    printChat(b);

#if 1
    noinit=b; // test assignment
    cout << "=====printChat(noinit) noinit=b; =====\n";
    printChat(noinit);

    noinit=0xabcd; // test assignment
    cout << "=====printChat(noinit) noinit=0xabcd; =====\n";
    printChat(noinit);
#endif

    cout << "=====print chatArray 1=====\n";
    int lim = sizeof(chatArray) / sizeof(Chat);
    for (int i=0; i<lim; i++)
    {
        chatArray[i]=i+(i<<8);
    }
    for (i=0; i<lim; i++)
    {
        cout << i << ": ";
        printChat(chatArray[i]);
    }

    cout << "=====print chatArray 2=====\n";
    for (i=0; i<lim; i++)
    {
        chatArray[i]=Chat('a'+i,7+i);
    }
    for (i=0; i<lim; i++)
    {
        cout << i << ": ";
        printChat(chatArray[i]);
    }

    cout << "=====print chatArray 3=====\n";
    for (i=0; i<lim; i++)
    {
        chatArray[i].ch('A'+i);
    }
    for (i=0; i<lim; i++)
    {
        cout << i << ": ";
        printChat(chatArray[i]);
    }

    cout << "=====print chatArray 4=====\n";
    for (i=0; i<lim; i++)
    {
        chatArray[i].at(0xff);
    }
    for (i=0; i<lim; i++)
    {
        cout << i << ": ";
        printChat(chatArray[i]);
    }

    Chat far * pChat = chatArray;
    cout << form("pChat: %lx\n", pChat);
    cout << form("pChat+1: %lx\n", pChat+1);

    cout <<  "goodbye, world\n";
}

