/*
    ut16.c  a 16 bit UT DLL

    UT16.DLL loaded during 32 bit UT initialization
    UTProc is function that services 32 -> 16 bit thunk
    16 -> 32 bit UT address is saved in CBInit

    built with QC/Win 1.0 Windows DLL, small memory model
    linked with w32sut16.lib (included in NT SDK)
    and calcw16.lib (16 bit test DLL library)
*/

#define W32SUT_16

#include <windows.h>
#include "w32sut.h"
#include "calcw16.h"
#include "ut16.h"

UT16CBPROC  pfnCBProc;
static long Ret;

#define CALC_SRV_ADDTWO         0
#define CALC_SRV_SUBTWO         1
#define CALC_SRV_MULTTWO        2
#define CALC_SRV_DIVTWO         3
#define SUM_ARRAY               4

int far pascal LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
	return(TRUE);
}

DWORD far pascal UTProc(long far *lpBuf, DWORD dwFunc)
{

    switch (dwFunc) {

	case CALC_SRV_ADDTWO:
			return(AddTwo(lpBuf));

	case CALC_SRV_SUBTWO:
			return(SubTwo(lpBuf));

		case CALC_SRV_MULTTWO:
			return(MultTwo(lpBuf));

		case CALC_SRV_DIVTWO:
			return(DivTwo(lpBuf));
	};
	return(0);
}


DWORD CALLBACK CBInit(UT16CBPROC pfunction, long far *lpbuf)
{
	pfnCBProc=pfunction;
	return(TRUE);
}


long far pascal AddTwo32(long far *Arrayn)
{
    Ret= (long)(* pfnCBProc)(Arrayn,CALC_SRV_ADDTWO, NULL);
	return(1);
}

long far pascal SubTwo32(long far *Arrayn)
{
	Ret= (long) (* pfnCBProc)(Arrayn,CALC_SRV_SUBTWO, NULL);
	return(1);
}

long far pascal MultTwo32(long far *Arrayn)
{
	Ret= (long) (* pfnCBProc)(Arrayn,CALC_SRV_MULTTWO, NULL);
	return(1);
}

long far pascal DivTwo32(long far *Arrayn)
{
	Ret= (long) (* pfnCBProc)(Arrayn,CALC_SRV_DIVTWO, NULL);
	return(1);
}

long far pascal SumArray32(long far *Arrayn)
{
	Ret= (long) (* pfnCBProc)(Arrayn, SUM_ARRAY, NULL);
	return(1);
}

long far pascal VBPTRtoLong(long far *Arrayn)
{
	Ret= (long)(Arrayn);
	return(Ret);
}

int far pascal VBLowWord(DWORD Handle)
{       int LowWord;

	LowWord=LOWORD(Handle);
	return(LowWord);
}
