// MsgShow

#define  STRICT
#include <windows.h>
#include <stdlib.h>
#include "msgshow.h"

//--------------------------------------------------------------

BOOL CALLBACK _export MainDlgProc (HWND     hDlg,
                                   UINT     message,
                                   WPARAM   wParam,
                                   LPARAM   lParam)
{
  switch (message)
  {
    case WM_COMMAND:
      switch (wParam)
      {
        case IDCANCEL :
          EndDialog (hDlg, 0);
          return TRUE ;

        case IDD_ASTERISK :
          MessageBeep(MB_ICONASTERISK);
          MessageBox(hDlg,"Asterisk Message Box","Asterisk",
          MB_OK | MB_ICONASTERISK);
          return TRUE ;

        case IDD_QUESTION :
          MessageBeep(MB_ICONQUESTION);
          MessageBox(hDlg,"Question Message Box","Question",
          MB_OK | MB_ICONQUESTION);
          return TRUE ;

        case IDD_EXCLAMATION :
          MessageBeep(MB_ICONEXCLAMATION);
          MessageBox(hDlg,"Exclamation Message Box","Exclamation",
          MB_OK | MB_ICONEXCLAMATION);
          return TRUE ;

        case IDD_STOP :
          MessageBeep(MB_ICONSTOP);
          MessageBox(hDlg,"Stop Message Box","Stop",
          MB_OK | MB_ICONSTOP);
          return TRUE ;
      };
  };

  return FALSE ;
};


//-------------------------------------------------------------------
// WinMain
//-------------------------------------------------------------------
  
int PASCAL WinMain( HINSTANCE hInstance,
                    HINSTANCE hPrevInstance, 
                    LPSTR     lpszCmdLine,
                    int       nCmdShow )
{

    DLGPROC lpfnDlgProc;

    lpfnDlgProc =
      (DLGPROC) MakeProcInstance ((FARPROC) MainDlgProc, hInstance);
    DialogBox (hInstance, "MAIN_DIALOG", NULL, lpfnDlgProc) ;
    FreeProcInstance((FARPROC)lpfnDlgProc);

    return 0;
};

