This utility will allow you to scan through an .EXE or .DLL file and view
all bitmaps present.  By using the right arrow button, the next bitmap will be
displayed and by using the left arrow button the previous bitmap can
be brought back and displayed.

When the Open button is pressed, a list of files with the .EXE extension
will be presented in one listbox and a list of alternate drives/directories
will be presented in another.  Using these two lists a file can be
selected.  Files with the .DLL extension, and even the .DRV extension
can also be read by the BitMan program.  To see a list of files with either
of these extensions merely click the mouse in the edit control at the top
of the file selection dialog and replace the .EXE text with .DLL, .DRV,
or whatever text is desired.  There are other files with non-standard
extensions that are readable by BitMan.  Basically the technical explanation
is that any file that contains Windows resources appended by the Windows
Resource Compiler can be read by BitMan, if they contain bitmaps.

Key information on each bitmap will be displayed as it is viewed.  This
information includes the following:

    Name of bitmap in the resource file
    Dimension of bitmap (in pixels)
    Number of colors in bitmaps color palatte
    Type of bitmap (Windows, OS2, Other)

It is unlikely that "Other" will ever appear as a bitmap type as the program
would most likely terminate before reaching such a point.

In addition to using the right and left arrows to scan through bitmaps,
the right and left arrow keys of the keyboard can be used as well.  Or
the Tab key can be pressed until a dotted rectangle is visible around the
desired direction buttons arrow and the space bar can be pressed.  If a
bitmap is larger than the display area, scroll bars will appear that will
allow you to scroll the bitmap.  If only a vertical or only a horizontal
scroll bar appear, then the bitmap was able to fit in the window in one
direction, but unable to fit in another.  Bitmaps that are smaller than
the window will be centered within the window.

If the Save button is pressed, a filename may be entered and the currently
visible bitmap will be saved into a file with the .BMP format.  You will be
presented with a dialog box containing the name of the currently visible
bitmap followed by the .BMP extension.  Any file and path can be entered
in this edit control and the bitmap will be saved to the file with that
name.  The bitmap will be saved in the format that is displayed on the
BitMan screen (e.g Windows or OS2).

If the Replace button is pressed, you will be presented with a dialog box
containing a list of all files with the .BMP extension in your current
directory, and a list of directories and drives to which you can also look.
After selecting a .BMP file from this list the cursor will turn to an
hourglass and there will be some disk activity.  If there are many bitmaps
and other resources in the file being viewed, and the bitmap selected for
replacement is a different size than the bitmap selected to replace it
this might take a few seconds.  If the bitmaps are the same size then
this will be a fairly quick process.  If a bitmap with the OS2 format is
replaced with a bitmap with the Windows format, the program will probably
still work.  Windows supports display of bitmaps of either format and I
have successfully replaced bitmaps of the OS2 type in Solitaire with
bitmaps of the Windows type as a test case.

NOTE: This program does NOT create a backup of the file being viewed.  If
      you choose to replace a bitmap in a program, I highly suggest that
      you create a backup of that program.  I've only found one case where
      BitMan has corrupted the file to the point where it could not be used,
      but that file was VGA.DRV and I'm not sure how a device driver
      accesses its resources.

Known Bugs:  For some reason my program will die in the middle of a Windows
             function in some rare cases.  Examples of these cases are viewing
             the "SETUP.EXE" program in enhanced mode (386), or viewing the
             "WINHELP.EXE" program in standard mode (286).  However, when
             running in standard mode I can view all bitmaps in "SETUP.EXE"
             and when running in enhanced mode I can view all bitmaps in
             "WINHELP.EXE".  All programs, to date, can be read in real
             mode with no difficulties.  So, if you have trouble reading
             a particular file, use one of the following to switch modes
             in Windows:

                   /r - Real Mode
                   /s - Standard Mode
                   /e - Enhanced Mode

             I've also not tested this program with bitmaps larger than
             64K as it's unlikely to find such a bitmap as a resource.  It
             will probably work, but I make no guarantees.

This program was created as a quick way to view and maintain bitmaps in some of
programs and libraries (DLL's) available since the available tools (e.g. The
Whitewater and Edensoft Resource Toolkits) require somewhat more time to
perform minor functions such as this.  This should offer an easy way to
quickly extract only the bitmaps that one wants and/or needs.  For more
advanced manipulation or for the editing of icons, I would suggest purchasing
one of the two tools mentioned previously.  The Paint program that comes with
Windows 3.0 will edit any file extracted by BitMan (at least it has for
me).  Bitmaps that are smaller than 72 x 72 pixels can also be edited by the
SDKPaint program that comes with the Windows Software Developers Toolkit.

NOTE: Due to radically different formats, Windows Version 2.1 bitmaps can not
      be read by this utility.  Some programs may run under both Windows 2.1 and
      Windows 3.0.  An example of this is WinWord.  Resources in such programs
      are stored in Windows 2.1 format, and thus can not be read.

If you find this program interesting and would like to hear about future
enhancements and/or tools please send $20 to:

   Patrick Deupree
   4500 Sojourn, #2606
   Addison, TX 75248

Please mail any comments you might have to the above address or send me
e-mail on CompuServe at user ID 76427,442.

Authors Note:

I've not put an "automatic" about box or timed registration reminder in this
program, the reason being I've always found such things annoying, most
people ignore them, and it's a waste of time to write the code that does
so.

I would also like to mention that I've created this program using a set of
tools that I would also consider selling (compiled library only, no
code).  The two code sets I've used are:

    listman: This is a data set manager that will allow variable length
             data items to be stored in a list and retrieved.  This data
             set manager does not create a new memory handle for each
             item it adds in the list and does not require Windows to be
             in standard or enhanced mode to use it.  At this time item
             deletion does not free associated memory, however there is
             a function to free all memory allocated to the list.

    resinfo: This currently contains five major functions.  One will read
             an exe file and contain a data set of all resources of a
             particular type (that type being fed in as an argument).
             Another will save a single bitmap as a .BMP file, given its
             DIB data.  In the reverse, there is a function to read a .BMP
             file and return its DIB data and bitmap file header.  The final
             function will write a resource to a .EXE file, using information
             contained within the data set returned from the first function.

    bitview: This currently contains a window class that provides a bitmap
             view window.  A bitmap is attached to this window through
             a single Windows message call and, after that, the window
             will do all the rest (scrolling, repainting, etc).  This
             window will support bitmaps in bitmap, icon, or cursor
             format.

In addition to these tool sets, I've created a DOS program that will extract
Icon, Bitmap, and Cursor resources from an executable or resource file and
will also display information on Dialog, Menu, and String entries (such
as name, and info on menu items and controls such as item width, item ID, and
item name).

The reason I mention these is that I would be interested in finding out how
many people would like these tools.  I make no promises as to the
availability of these tools as how much work I put into them depends on
how much interest there is.
