;MailRun v2.11:  Header File
;1992-1993 Gerald P. Sully, all rights reserved.

#comment
**************************************************************************
**************************************************************************
* 
* This header file contains routines that are used in various
* places throughout the MailRun source files.  It also contains
* global variable definitions and macros.
* 
* #ifdef commands have been used to exclude procedures and global
* variables from being compiled in any script module where they
* are not needed.  In theory, it should not be necessary to do
* this:  Datastorm's documentation says that any procedure or
* variable that isn't used is ignored.  In practice, however, the
* compiler will use up its limited memory resources allocating
* space to variables and procedures that never make their way into
* the compiled script.
* 
* The following procedures/functions are found in this file
* (roughly in order of appearance):
* 
* makefullname(), makemrn(), makebbslist(), maketasklist(), 
* makemailrunlist(), makedesc(), loadsettings(), loadbbsinfo(), 
* loadprompts(), loadmaildoor(), writesettings(), writebbsinfo(), 
* writeprompts(), writemaildoor(), readbbs(), readitem(), 
* writebbs(), writeitem(), getfirstitem(), getlastitem(), 
* gettaskstring(), updatecount(), copymrn(), fverify(), inlist(), 
* openfile(), cleardir(), clearfiledesc(), insertitem(), 
* insertbbs(), changemailrun(), checkpending(), checkchild(), 
* checkrunning(), checkchanged(), checkfile(), checktask(), 
* checknew(), menudim(), sortidx(), fieldcompare(), findstring(), 
* interfaceon(), interfaceoff(), parsedialog(), swapbbs(), 
* swapitem(), changestatus(), taskfilefwd(), taskfileend(), 
* parsemenu(), parseobject(), filenewmrun(), filesave(), filesaveas(), 
* filereset(), filedelmrun(), fileautorun(), fileexit(), editcut(), 
* editcopy(), editpaste(), editdelete(), cfgmrun(), cfgbbs(), 
* cfgprompts(), cfgmaildoor(), configbbs(), configmrun(), 
* configprompts(), configmaildoor(), defaultsmailrun(), defaultsbbs(), 
* defaultsprompts(), defaultsdoor(), addnewbbs(), addgetsend(), 
* addupload(), adddownload(), addsendcmd(), addscript(), 
* executemailrun(), executeqwkreader(), executearchiver(), 
* executelogviewer(), helpcontents(), helpcontext(), helpabout(),
* callscript()
* 
**************************************************************************
**************************************************************************
#endcomment

;Open file indexes

#define IniFile 0
#define MailRunFile 1
#define BBSFile 0
#define TaskFile 1
#define OldTaskFile 2
#define TempTaskFile 3
#define BBSidxFile 0
#define BBSdbfFile 1
#define NewFilesFile 2
#define MRUnarcFile 3
#define OldidxFile 4
#define OlddbfFile 5
#define ScriptFile 0
#define QueueListFile 5
#define OldUBFFile 0
#define OldUDXFile 1
#define MRunUBFFile 2
#define MRunUDXFile 3
#define FileDescFile 4
#define SourceFile 5

;Flags

#define ALLFLAGS 255				; 2^8 - 1
#define RUNNING 1					; 2^0
#define CHANGED 2					; 2^1
#define NEW 4						; 2^2
#define AGM 8						; 2^3
#define CMD 16						; 2^4
#define SCR 32						; 2^5
#define ABT 64						; 2^6
#define USR 8						; 2^3
#define PRMPT 16					; 2^4
#define QMD 32						; 2^5
#define DEFAULTS 128				; 2^7
#define IDLE (ALLFLAGS - RUNNING)
#define UNCHANGED (ALLFLAGS - CHANGED)
#define OLD (ALLFLAGS - NEW)
#define CLEARCMD (ALLFLAGS - AGM - CMD - SCR - ABT)

;System global variables

#define FLAGS i9
#define IdleTimeout i8
#define LogRun i7
#define AppendLog i6
#define AnsiInLog i5
#define NewfileFilter i4
#define GraphicsOn i3
#define HelpPage i2
#define PostRun i1
#define IdleTimer i0

#define TaskItem s9
#define MailRun s8
#define MailRunIni s7
#define TempDir s6
#define MailRunDir s5
#define TaskList s4
#define BBS s3
#define Item s2
#define Conf s1
#define CurrentConf s0

;Macros

#define EscapeFail 0
#define ErrorFail 1
#define ALPHA 0
#define NUMERIC 1
#define MMDDYY 2
#define _READWRITE 0
#define _CREATE 1
#define _TEXT 0
#define _NORMAL 1

;Miscellaneous global variables

string 	MailRunTrunc

#ifndef MRUN211G
#ifndef MRUN211B
string	BBSList
#endif
#ifndef MRUN211F
string	BBSType
#endif
#ifndef MRUN211AB
#ifndef MRUN211C
integer PermRadio
#endif
#endif
#endif

#ifdef MRUN211AB
string MailRunList
#endif

#ifdef MRUN211DE
string 	FileName,		FileDesc,		FileChoice
#endif

;Global variables containing values displayed in the main dialogbox

#ifdef MRUN211AG
string 	BBSTotal, 		BBSComplete, 	BBSRemaining,	AttemptNum
string 	ItemTotal, 		ItemComplete,	ItemError, 		ItemRemaining
integer 	BBST, BBSC, BBSR, ItemT, ItemC, ItemE, ItemR
#endif


;Global variables containing values from [MailRun] section of *.MRN

#ifdef MRUN211AB
string 	MailDir,			ReplyDir,		DownloadDir,	UploadDir
string	DialAttempts,	DialTimeout,	DialPause
string	SavePackets,	IdleTime,		ExecTime
string	Archiver,		QWKReader,		LogViewer
integer  GoWait
#endif


#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G

;Global variables containing general BBS info from *.MRN

string	BBSName,			UserName,		PWord,		XferProt
string	CallingFrom,	UserResp1,		UserResp2
string 	Number_1,		Number_2,		Number_3
string	LangNumber,		MailDoorType

;Global variables containing BBS prompts from MAILRUN.INI

string 	LangPrompt,		GraphicsPrompt,	NamePrompt,			UserPrompt1
string	PWordPrompt,	ViewPrompt,			FilePrompt,			UserPrompt2
string	ScanPrompt,		MorePrompt,			ContinuePrompt,	CommandPrompt
string	DLPrompt,		DLUnavPrompt,		ULPrompt,			ULDescPrompt

;Global variables containing Mail Door prompts from MAILRUN.INI

string	MailPrompt,		ReceiveQWKPrompt,	MailDLPrompt,  MsgMenuPrompt
string 	MailXferProt,	MailULPrompt, 		QWKArchiver,	MailDoor

#endif
#endif
#endif


#comment
*********************************************************************
* 
* MAKEFULLNAME()
* 
* Called by all modules, various procedures
* 
* Appends a filename to a directory name.
* 
*********************************************************************
#endcomment

func makefullname : string
strparm Directory, FileNamen
string FullName
	FullName = Directory
	addfilename FullName FileNamen
	return FullName
endfunc


#comment
*********************************************************************
* 
* MAKEMRN()
* 
* Calls loadsettings(), loadbbsinfo(), loadprompts(), loadmaildoor(),
* writesettings(), writebbsinfo(), writeprompts(), writemaildoor(),
* makefullname(), filesave()
* 
* Called by:
* 	MRUN211A:  initialize()
* 	MRUN211B:  newmailrun()
* 
* Create the file MAILRUN.MRN and initialize it.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AB
proc makemrn
string DLPurgeLimit
#ifndef MRUN211A
string RingInterrupt
#endif
	;load the defaults 
	loadsettings(MailRunIni)
	loadbbsinfo(MailRunIni, "DEFAULT")
	loadprompts(MailRunIni, "DEFAULT")
	loadmaildoor(MailRunIni, "DEFAULT")
	profilerd MailRunIni "MailRun" "DLPurgeLimit" DLPurgeLimit
	profilerd MailRunIni "MailRun" "ExecTime" ExecTime
	profilerd MailRunIni "MailRun" "GoWait" GoWait
	profilerd MailRunIni "MailRun" "PostRun" PostRun
	profilerd MailRunIni "MailRun" "RingInterrupt" RingInterrupt
	;write the defaults to the new mailrun
	MailRun = makefullname(TempDir, MailRunTrunc)
	writesettings(MailRun)
	writebbsinfo(MailRun, "DEFAULT")
	writeprompts(MailRun, "DEFAULT")
	writemaildoor(MailRun, "DEFAULT")
	profilewr MailRun "MailRun" "DLPurgeLimit" DLPurgeLimit
	profilewr MailRun "MailRun" "ExecTime" ExecTime
	profilewr MailRun "MailRun" "GoWait" GoWait
	profilewr MailRun "MailRun" "PostRun" PostRun
	profilewr MailRun "MailRun" "RingInterrupt" RingInterrupt
	;write the new mailrun to disk
	filesave()
endproc
#endif


#comment
*********************************************************************
* 
* MAKEBBSLIST()
* 
* Calls readbbs()
* 
* Called by:
* 	MRUN211H:  editdelete(), editpaste(), callscript()
* 	MRUN211C:  changeuserinfo(), changeprompts(), changemaildoor()
* 	MRUN211D:  main()
* 	MRUN211E:  main()
* 	MRUN211F:  addgetmail(), addsendcommand(), adddoscript()
* 
* Creates a list of BBSs for display the BBS combobox of
* various dialog boxes.
* 
*********************************************************************
#endcomment

#ifndef MRUN211G
#ifndef MRUN211B
proc makebbslist
string BBSid
integer i
	BBSList = ""
	i = 1
	BBSid = readbbs(i)
	while not NULLSTR BBSid
		strlwr BBSid
		strfmt BBSList "%s,%s" BBSList BBSid
		i++
		BBSid = readbbs(i)
	endwhile
	if i > 1
		strdelete BBSList 0 1
	endif
endproc
#endif
#endif


#comment
*********************************************************************
* 
* MAKETASKLIST()
* 
* Calls openfile(), gettaskstring(), readbbs(), readitem(),
* makefullname(), updatecount()
* 
* Called by:
* 	MRUN211H:  parsedialog(), changestatus(), filereset(),
* 				  filedelmrun(), editpaste(), editdelete(),
*             callscript()
* 	MRUN211A:  main(), executor()
* 	MRUN211G:  main(), dobbs()
* 
* 
* Creates the Task List displayed in the main MailRun
* dialog box.  Each item of each BBS is read from the *.MRN
* file and a "TaskString" is produced to describe its contents.
* The BBS and Item coordinates are appended to the TaskString
* as an index back into the *.MRN file.  Tabstops are used to
* push these indexes beyond the right edge of the Task List
* flistbox so that they are not visible.  TaskStrings for BBS
* names have an item coordinate of zero.
* 
* Also calculates the values of variables displayed in the
* statistics section of the main dialog box.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc maketasklist
string TaskString, Tasks, Pending
string BBSid, Itemj
integer i, j
	;set all values displayed in main dialog box to 0
	BBST = 0
	BBSC = 0
	BBSR = 0
	ItemT = 0
	ItemC = 0
	ItemE = 0
	Tasks = makefullname(TempDir, "TASKLIST.TMP")
	;Save the values for the current BBS and Item
	openfile(TaskFile, Tasks, _CREATE, _TEXT)
	i = 1
	BBSid = readbbs(i)
	while not NULLSTR BBSid
		;Loop through each BBS in the MailRun
		ItemR = 0
		j = 0
		TaskString = gettaskstring(BBSid, 0)
		fputs TaskFile TaskString
		j++
		Itemj = readitem(BBSid, j)
		while not NULLSTR Itemj
			;Loop through each Item
			strextract Pending Itemj "," 0
			if strcmpi Pending "0"
				ItemC++
			elseif strcmpi Pending "1"
				ItemR++
			else
				ItemE++
			endif
			TaskString = gettaskstring(BBSid, j)
			fputs TaskFile TaskString
			ItemT++
			j++
			Itemj = readitem(BBSid, j)
		endwhile
		BBST++
		if ItemR == 0
			BBSC++
		endif
		i++
		BBSid = readbbs(i)
	endwhile
	fclose TaskFile
	;prepare statistics variables for display in the main box
	BBSR = BBST - BBSC
	ItemR = ItemT - ItemC - ItemE
	updatecount()
endproc
#endif


#comment
*********************************************************************
* 
* MAKEMAILRUNLIST()
* 
* Calls makefullname()
* 
* Called by:
* 	MRUN211H:  filesaveas(), filedelmrun(), callscript()
* 	MRUN211A:  main()
* 	MRUN211B:  main(), newmailrun()
* 
* Creates a list of MailRuns for display in the main
* MailRun and MailRun Settings dialog boxes.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AB
proc makemailrunlist
string FileTrunc, MRNFile
	MailRunList = ""
	MRNFile = makefullname(MailRunDir, "*.MRN")
	findfirst MRNFile
	;Loop through all files in the directory
	while FOUND
		FileTrunc = $FILENAME
		strlwr FileTrunc
		strfmt MailRunList "%s,%s" MailRunList FileTrunc
		findnext
	endwhile
	if not NULLSTR MailRunList
		strdelete MailRunList 0 1
	endif
endproc
#endif


#comment
*********************************************************************
* 
* MAKEDESC()
* 
* Calls openfile()
* 
* Called by:
* 	MRUN211D:  main(), deldlfile()
* 	MRUN211E:  getnewdesc()
* 
* Creates the file description for display in the upload
* and download dialog boxes.
* 
*********************************************************************
#endcomment

#ifdef MRUN211DE
proc makedesc
strparm DescSource
string DB, DL
integer char
long DescBegin, DescLength, counter
	strextract DB FileChoice "`t" 4
	atol DB DescBegin
	strextract DL FileChoice "`t" 5
	atol DL DescLength
	if DescLength != 0
		;if there is a description in the database, retrieve it
		openfile(FileDescFile, FileDesc, _CREATE, _NORMAL)
		openfile(SourceFile, DescSource, _READWRITE, _NORMAL)
		fseek SourceFile DescBegin 0
		for counter = 1 upto DescLength
			fgetc SourceFile char
			fputc FileDescFile char
		endfor
		fclose FileDescFile
		fclose SourceFile
	else
		;otherwise, just delete the previous description
		openfile(FileDescFile, FileDesc, _CREATE, _NORMAL)
		fclose FileDescFile
	endif
endproc
#endif


#comment
*********************************************************************
* 
* LOADSETTINGS()
* 
* Called by:
* 	MRUN211H:  makemrn(), changemailrun()
* 	MRUN211B:  main()
* 
* Initializes MailRun settings.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AB
proc loadsettings
strparm _MailRun
	profilerd _MailRun "MailRun" "MailDir" MailDir
	profilerd _MailRun "MailRun" "ReplyDir" ReplyDir
	profilerd _MailRun "MailRun" "DownloadDir" DownloadDir
	profilerd _MailRun "MailRun" "UploadDir" UploadDir
	profilerd _MailRun "MailRun" "SavePackets" SavePackets
	profilerd _MailRun "MailRun" "DialAttempts" DialAttempts
	profilerd _MailRun "MailRun" "DialTimeout" DialTimeout
	profilerd _MailRun "MailRun" "DialPause" DialPause
	profilerd _MailRun "MailRun" "IdleTimeout" IdleTime
	profilerd _MailRun "MailRun" "LogRun" LogRun
	profilerd _MailRun "MailRun" "AppendLog" AppendLog
	profilerd _MailRun "MailRun" "AnsiInLog" AnsiInLog
	profilerd _MailRun "MailRun" "NewfileFilter" NewfileFilter
	profilerd _MailRun "MailRun" "Archiver" Archiver
	profilerd _MailRun "MailRun" "QWKReader" QWKReader
	profilerd _MailRun "MailRun" "LogViewer" LogViewer
endproc
#endif


#comment
*********************************************************************
* 
* WRITESETTINGS()
* 
* Called by:  
* 	MRUN211H:  makemrn()
* 	MRUN211B:  main()
* 
* Writes MailRun settings to the *.MRN file.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AB
proc writesettings
strparm _MailRun
	profilewr _MailRun "MailRun" "MailDir" MailDir
	profilewr _MailRun "MailRun" "ReplyDir" ReplyDir
	profilewr _MailRun "MailRun" "DownloadDir" DownloadDir
	profilewr _MailRun "MailRun" "UploadDir" UploadDir
	profilewr _MailRun "MailRun" "DialAttempts" DialAttempts
	profilewr _MailRun "MailRun" "DialTimeout" DialTimeout
	profilewr _MailRun "MailRun" "DialPause" DialPause
	profilewr _MailRun "MailRun" "IdleTimeout" IdleTime
	profilewr _MailRun "MailRun" "SavePackets" SavePackets
	profilewr _MailRun "MailRun" "LogRun" LogRun
	profilewr _MailRun "MailRun" "AppendLog" AppendLog
	profilewr _MailRun "MailRun" "AnsiInLog" AnsiInLog
	profilewr _MailRun "MailRun" "NewfileFilter" NewfileFilter
	profilewr _MailRun "MailRun" "Archiver" Archiver
	profilewr _MailRun "MailRun" "QWKReader" QWKReader
	profilewr _MailRun "MailRun" "LogViewer" LogViewer
endproc
#endif


#comment
*********************************************************************
* 
* LOADBBSINFO()
* 
* Called by:
* 	MRUN211H:  makemrn(), editcopy(), editpaste()
* 	MRUN211C:  changeuserinfo(), addbbs()
* 
* Initializes BBS information.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc loadbbsinfo
strparm _MailRun, _BBS
	profilerd _MailRun _BBS "BBSName" BBSName
	profilerd _MailRun _BBS "UserName" UserName
	profilerd _MailRun _BBS "PWord" Pword
	profilerd _MailRun _BBS "XferProt" XferProt
	profilerd _MailRun _BBS "MailXferProt" MailXferProt
	profilerd _MailRun _BBS "QWKArchiver" QWKArchiver
	profilerd _MailRun _BBS "Number_1" Number_1
	profilerd _MailRun _BBS "Number_2" Number_2
	profilerd _MailRun _BBS "Number_3" Number_3
	profilerd _MailRun _BBS "BBSType" BBSType
	profilerd _MailRun _BBS "MailDoorType" MailDoorType
endproc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* WRITEBBSINFO()
* 
* Called by:
* 	MRUN211H:  makemrn(), editcopy(), editpaste()
* 	MRUN211C:  changeuserinfo()
* 
* Writes information for current BBS to the *.MRN file.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc writebbsinfo
strparm _MailRun, _BBS
	profilewr _MailRun _BBS "BBSName" BBSName
	profilewr _MailRun _BBS "UserName" UserName
	profilewr _MailRun _BBS "PWord" PWord
	profilewr _MailRun _BBS "XferProt" XferProt
	profilewr _MailRun _BBS "MailXferProt" MailXferProt
	profilewr _MailRun _BBS "QWKArchiver" QWKArchiver
	profilewr _MailRun _BBS "Number_1" Number_1
	profilewr _MailRun _BBS "Number_2" Number_2
	profilewr _MailRun _BBS "Number_3" Number_3
	profilewr _MailRun _BBS "BBSType" BBSType
	profilewr _MailRun _BBS "MailDoorType" MailDoorType
endproc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* LOADPROMPTS()
* 
* Called by:
* 	MRUN211H:  makemrn(), editcopy(), editpaste()
* 	MRUN211C:  changeuserinfo(), changeprompts(), addbbs()
* 
* Initializes BBS prompts.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc loadprompts
strparm _MailRun, _BBS
	profilerd _MailRun _BBS "CallingFrom" CallingFrom
	profilerd _MailRun _BBS "UserResp1" UserResp1
	profilerd _MailRun _BBS "UserResp2" UserResp2
	profilerd _MailRun _BBS "LangNumber" LangNumber
	profilerd _MailRun _BBS "GraphicsOn" GraphicsOn
	profilerd _MailRun _BBS "LangPrompt" LangPrompt
	profilerd _MailRun _BBS "GraphicsPrompt" GraphicsPrompt
	profilerd _MailRun _BBS "NamePrompt" NamePrompt
	profilerd _MailRun _BBS "PWordPrompt" PWordPrompt
	profilerd _MailRun _BBS "UserPrompt1" UserPrompt1
	profilerd _MailRun _BBS "UserPrompt2" UserPrompt2
	profilerd _MailRun _BBS "ViewPrompt" ViewPrompt
	profilerd _MailRun _BBS "ScanPrompt" ScanPrompt
	profilerd _MailRun _BBS "FilePrompt" FilePrompt
	profilerd _MailRun _BBS "MorePrompt" MorePrompt
	profilerd _MailRun _BBS "ContinuePrompt" ContinuePrompt
	profilerd _MailRun _BBS "CommandPrompt" CommandPrompt
	profilerd _MailRun _BBS "DLPrompt" DLPrompt
	profilerd _MailRun _BBS "DLUnavPrompt" DLUnavPrompt
	profilerd _MailRun _BBS "ULPrompt" ULPrompt
	profilerd _MailRun _BBS "ULDescPrompt" ULDescPrompt
endproc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* WRITEPROMPTS()
* 
* Called by:
* 	MRUN211H:  makemrn(), editcopy(), editpaste()
* 	MRUN211C:  changeuserinfo(), changeprompts(), exportprompts()
* 
* Writes prompts for current BBS to the *.MRN file.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc writeprompts
strparm _MailRun, _BBS
	profilewr _MailRun _BBS "CallingFrom" CallingFrom
	profilewr _MailRun _BBS "UserResp1" UserResp1
	profilewr _MailRun _BBS "UserResp2" UserResp2
	profilewr _MailRun _BBS "LangNumber" LangNumber
	profilewr _MailRun _BBS "GraphicsOn" GraphicsOn
	profilewr _MailRun _BBS "LangPrompt" LangPrompt
	profilewr _MailRun _BBS "GraphicsPrompt" GraphicsPrompt
	profilewr _MailRun _BBS "NamePrompt" NamePrompt
	profilewr _MailRun _BBS "PWordPrompt" PWordPrompt
	profilewr _MailRun _BBS "UserPrompt1" UserPrompt1
	profilewr _MailRun _BBS "UserPrompt2" UserPrompt2
	profilewr _MailRun _BBS "ViewPrompt" ViewPrompt
	profilewr _MailRun _BBS "ScanPrompt" ScanPrompt
	profilewr _MailRun _BBS "FilePrompt" FilePrompt
	profilewr _MailRun _BBS "MorePrompt" MorePrompt
	profilewr _MailRun _BBS "ContinuePrompt" ContinuePrompt
	profilewr _MailRun _BBS "CommandPrompt" CommandPrompt
	profilewr _MailRun _BBS "DLPrompt" DLPrompt
	profilewr _MailRun _BBS "DLUnavPrompt" DLUnavPrompt
	profilewr _MailRun _BBS "ULPrompt" ULPrompt
	profilewr _MailRun _BBS "ULDescPrompt" ULDescPrompt
endproc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* LOADMAILDOOR()
* 
* Called by:
* 	MRUN211H:  makemrn(), editcopy(), editpaste()
* 	MRUN211C:  changeuserinfo(), changemaildoor(), addbbs()
* 
* Initializes mail door prompts.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc loadmaildoor
strparm _MailRun, _BBS
	profilerd _MailRun _BBS "MailDoor" MailDoor
	profilerd _MailRun _BBS "MailPrompt" MailPrompt
	profilerd _MailRun _BBS "ReceiveQWKPrompt" ReceiveQWKPrompt
	profilerd _MailRun _BBS "MailDLPrompt" MailDLPrompt
	profilerd _MailRun _BBS "MailULPrompt" MailULPrompt
	profilerd _MailRun _BBS "MsgMenuPrompt" MsgMenuPrompt
endproc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* WRITEMAILDOOR()
* 
* Called by:
* 	MRUN211H:  makemrn(), editcopy(), editpaste()
* 	MRUN211C:  changeuserinfo(), changemaildoor(), 
* 				  exportmaildoor()
* 
* Writes mail door prompts for the current BBS to the .MRN
* file.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc writemaildoor
strparm _MailRun, _BBS
	profilewr _MailRun _BBS "MailDoor" MailDoor
	profilewr _MailRun _BBS "MailPrompt" MailPrompt
	profilewr _MailRun _BBS "ReceiveQWKPrompt" ReceiveQWKPrompt
	profilewr _MailRun _BBS "MailDLPrompt" MailDLPrompt
	profilewr _MailRun _BBS "MailULPrompt" MailULPrompt
	profilewr _MailRun _BBS "MsgMenuPrompt" MsgMenuPrompt
endproc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* READBBS()
* 
* Called by:
* 	MRUN211H:  makebbslist(), maketasklist(), getbbscoord(), 
* 				  insertbbs(), swapbbs(), filereset(), editdelete()
* 	MRUN211G:  main(), makequeue()
* 
* Reads the BBS associated with a BBS coordinate in the
* current mailrun.
* 
*********************************************************************
#endcomment

func readbbs : string
intparm i
string BBS_X, BBSid
	strfmt BBS_X "BBS_%d" i
	profilerd MailRun "MailRun" BBS_X BBSid
	return BBSid
endfunc


#comment
*********************************************************************
* 
* READITEM()
* 
* Called by:
* 	MRUN211H:  maketasklist(), getlastitem(), insertitem(), 
* 				  checkpending(), swapitem(), filereset(), 
* 				  changestatus(), editcopy(), editdelete()
* 	MRUN211G:  dobbs()
* 
* Reads the Item associated with a BBS coordinate in the
* current mailrun.
* 
*********************************************************************
#endcomment

func readitem : string
strparm BBSid
intparm i
string Item_X, Itemi
	strfmt Item_X "Item_%d" i
	profilerd MailRun BBSid Item_X Itemi
	return Itemi
endfunc


#comment
*********************************************************************
* 
* WRITEBBS()
* 
* Called by:
* 	MRUN211H:  insertbbs(), swapbbs(), editdelete()
* 	MRUN211C:  changeusersettings()
* 
* Writes a BBS ID to the given coordinate in the current
* mailrun.
* 
*********************************************************************
#endcomment

proc writebbs
intparm i
strparm BBSid
string BBS_X
	strfmt BBS_X "BBS_%d" i
	profilewr MailRun "MailRun" BBS_X BBSid
endproc


#comment
*********************************************************************
* 
* WRITEITEM()
* 
* Called by:
* 	MRUN211H:  swapitem(), insertitem(), editdelete(), filereset(),
* 				  changestatus()
* 	MRUN211G:  dobbs()
* 
* Writes an Item to the given Item coordinate for the
* current BBS and MailRun.
* 
*********************************************************************
#endcomment

proc writeitem
strparm BBSid
intparm i
strparm Itemi
string Item_X
	strfmt Item_X "Item_%d" i
	profilewr MailRun BBSid Item_X Itemi
endproc


#comment
*********************************************************************
* 
* GETBBSCOORD()
* 
* Calls readbbs()
* 
* Called by:
* 	MRUN210H:  parsedialog(), editdelete()
* 
* Gets the BBS coordinate for a given BBS ID.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
func getbbscoord : integer
strparm BBSid
integer i
string BBSi
	i = 1
	BBSi = readbbs(i)
	while not strcmpi BBSid BBSi
		i++
		BBSi = readbbs(i)
	endwhile
	return i
endfunc
#endif


#comment
*********************************************************************
* 
* GETFIRSTITEM()
*
* Calls gettaskstring()
* 
* Called by:
* 	MRUN211H:  parsedialog(), filereset(), filedelmrun(),
*             callscript()
* 	MRUN211A:  main()
*  MRUN211B:  main()
* 
* Highlights the first item in the task list.
* 
*********************************************************************
#endcomment

proc getfirstitem
string BBSid
	profilerd MailRun "MailRun" "BBS_1" BBSid
	if not NULLSTR BBSid
		TaskItem = gettaskstring(BBSid, 0)
	else
		TaskItem = ""
	endif
endproc


#comment
*********************************************************************
* 
* GETLASTITEM()
* 
* Calls readitem()
* 
* Called by:
* 	MRUN211D:  main()
* 	MRUN211E:  main()
* 	MRUN211F:  addgetmail(), addsendcommand(), adddoscript()
* 
* Gets the Item coordinate for a given Item in the current
* BBS.
* 
*********************************************************************
#endcomment

func getlastitem : integer
strparm BBSid
string Itemi
integer i
	i = 1
	Itemi = readitem(BBSid, i)
	while not NULLSTR Itemi
		i++
		Itemi = readitem(BBSid, i)
	endwhile
	i--
	return i
endfunc


#comment
*********************************************************************
* 
* GETTASKSTRING()
* 
* Called by:
* 	MRUN211H:  maketasklist(), parsedialog(), swapbbs(), swapitem(), 
*             editdelete(), changestatus(), editpaste()
* 	MRUN211C:  changeuserinfo(), changeprompts(), changemaildoor()
* 	MRUN211D:  main()
* 	MRUN211E:  main()
* 	MRUN211F:  addgetmail(), addsendmail(), adddoscript()
* 	MRUN211G:  dobbs()
* 
* Produces a TaskString from the current *.MRN Item.
* Items are strings with the format:
* 
* 		"Pending,Perm,TaskType,FileName,Conf"
* 
* Pending = 0 if item is completed, 1 if pending, 2 if an
* 		error occurred in previous attempt to execute it.
* Perm = 1 if the item is permanent; Perm = 2 if temporary.
* TaskType may be SendMail, GetMail, SendFile, GetFile,
* 		SendCommand or SendScript.
* FileName is the name of the file to be transferred, used
* 		by SendFile and GetFile items.
* Conf is the number of the conference to be joined, used
* 		by SendFile and GetFile items.
* 
*********************************************************************
#endcomment

func gettaskstring : string
strparm BBSid
intparm j
string Pending, Perm, TaskType, TaskString, KeyString, BBSNamen
string char, Item_X, Itemi, Confi
	if j == 0
		;if this is for a BBS name
		profilerd MailRun BBSid "BBSName" BBSNamen
		strfmt TaskString "%s`t`t`t%s`t%d" BBSNamen BBSid j
	else
		;if this is for an item
		strfmt Item_X "Item_%d" j
		profilerd MailRun BBSid Item_X Itemi
		strextract Pending Itemi "," 0
		strextract Perm Itemi "," 1
		strextract TaskType Itemi "," 2
		if strcmpi Pending "1"
			If strcmpi Perm "1"
				char = "#"
			else
				char = ""
			endif
		elseif strcmpi Pending "0"
			char = "@"
		else
			char = " !"
		endif
		switch TaskType
			case "SendMail"
				TaskString = "Send REP Packet"
			endcase
			case "GetMail"
				TaskString = "Get QWK Packet"
			endcase
			case "SendFile"
				strextract KeyString Itemi "," 3
				strextract Confi Itemi "," 4
				strfmt TaskString "Upload %s to File Area %s" KeyString Confi
			endcase
			case "GetFile"
				strextract keystring Itemi "," 3
				strextract Confi Itemi "," 4
				strfmt TaskString "Download %s from File Area %s" KeyString Confi
			endcase
			case "SendCommand"
				strextract KeyString Itemi "," 3
				strfmt TaskString "Send Command:  %s" KeyString
			endcase
			case "SendScript"
				strextract KeyString Itemi "," 3
				strfmt TaskString "Execute Script:  %s" KeyString
			endcase
		endswitch
		strfmt TaskString "`t%s`t%s`t%s`t%d" char TaskString BBSid j
	endif
	return TaskString
endfunc


#comment
*********************************************************************
* 
* UPDATECOUNT()
* 
* Called by:
* 	MRUN211H:  maketasklist(), changestatus()
* 	MRUN211G:  dobbs()
* 
* Updates the statistics section of the main MailRun dialog box.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc updatecount
	itoa BBST BBSTotal
	itoa BBSC BBSComplete
	itoa BBSR BBSRemaining
	itoa ItemT ItemTotal
	itoa ItemC ItemComplete
	itoa ItemE ItemError
	itoa ItemR ItemRemaining
endproc
#endif


#comment
*********************************************************************
* 
* COPYMRN()
* 
* Calls makefullname()
* 
* Called by:
* 	MRUN211H:  changemailrun(), filesaveas(), filedelmrun()
* 
* Copies a mailrun from MailRunDir to TempDir.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AB
proc copymrn
string LastRun
	delfile MailRun
	LastRun = makefullname(MailRunDir, MailRunTrunc)
	MailRun = makefullname(TempDir, MailRunTrunc)
	copyfile LastRun MailRun
endproc
#endif


#comment
*********************************************************************
* 
* FVERIFY()
* 
* Called by:
* 	MRUN211H:  filesaveas()
* 	MRUN211B:  newmailrun()
* 	MRUN211C:  addbbs()
* 
* Checks for a valid DOS filename (sans extension).
* Returns 1 if valid, 0 if invalid.
* 
*********************************************************************
#endcomment

#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
func fverify : integer
strparm LookString
string DOSChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&()-_{}"
string char
integer i, j
	strlen LookString i
	if (i > 8) || (i == 0)
		return 0
	else
		i = 0
		strpeek LookString i j
		while j != 0
			strfmt char "%c" j
			if not strfind DOSChars char
				return 0
			endif
			i++
			strpeek LookString i j
		endwhile
		return 1
	endif
endfunc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* INLIST()
* 
* Called by:
*  MRUN211H: editpaste()
*	MRUN211C: addbbs(), exportprompts(), exportmaildoor()
* 
* Returns 1 if the first string parameter is contained in
* the second string, which must be a comma delimited list;
* otherwise returns 0.
* 
*********************************************************************
#endcomment

#ifndef MRUN211B
#ifndef MRUN211DE
#ifndef MRUN211F
func inlist: integer
strparm LookString, ListString
string Element
integer i = 0
	strextract Element ListString "," i
	while not NULLSTR Element
		if strcmpi Element LookString
			return 1
		endif
		i++
		strextract Element ListString "," i
	endwhile
	return 0 
endfunc
#endif
#endif
#endif


#comment
*********************************************************************
* 
* OPENFILE()
* 
* Calls fileexit()
* 
* Called by:
* 	MRUN211H:  maketasklist(), makedesc(), clearfiledesc(),
* 				  sortidx(), swapbbs(), taskfilefwd(), fileautorun()
* 	MRUN211D:  main(), purgeoldfiles(), getnewfiles(),
* 				  import(), deldlfile()
* 	MRUN211E:  insertulfile(), killfile(), getulfiles(),
* 				  updateudx()
* 	MRUN211F:  makescriptlist()
* 	MRUN211G:  makequeue(), getdialstring(), senddesc(), putdesc()
* 
* Opens a file in the manner specified.  If the file could
* not be opened successfully, displays an error message and
* terminates the script.
* 
*********************************************************************
#endcomment

proc openfile
intparm FileIndex
strparm FileNamen
intparm OpenMethod, OpenType
	switch OpenMethod
		case _CREATE
			switch OpenType
				case _TEXT
					fopen FileIndex FileNamen CREATE TEXT
				endcase
				case _NORMAL
					fopen FileIndex FileNamen CREATE
				endcase
			endswitch
		endcase
		case _READWRITE
			switch OpenType
				case _TEXT
					fopen FileIndex FileNamen READWRITE TEXT
				endcase
				case _NORMAL
					fopen FileIndex FileNamen READWRITE
				endcase
			endswitch
		endcase
	endswitch
	if FAILURE
		errormsg "Unable to open file %s;`r`nscript aborted...." FileNamen
		fileexit()
	endif
endproc


#comment
*********************************************************************
* 
* CLEARDIR()
* 
* Calls makefullname()
* 
* Called by:
* 	MRUN211H:  fileexit()
* 	MRUN211A:  initialize()
* 	MRUN211G:  getmail()
* 
* Deletes the contents of a directory.
* 
*********************************************************************
#endcomment

proc cleardir
strparm DirName
string DeadFile, DirFiles
	DirFiles = makefullname(DirName, "*.*")
	findfirst DirFiles
	while FOUND
		DeadFile = makefullname(DirName, $FILENAME)
		delfile DeadFile
		findnext
	endwhile
endproc


#comment
*********************************************************************
* 
* CLEARFILEDESC()
* 
* Calls openfile()
* 
* Called by:
* 	MRUN211D:  main(), deldlfile()
* 	MRUN211E:  main(), insertulfile(), killfile()
* 
* Clears the current file description box by creating a
* new file.
* 
*********************************************************************
#endcomment

#ifdef MRUN211DE
proc clearfiledesc
	openfile(FileDescFile, FileDesc, _CREATE, _NORMAL)
	fclose FileDescFile
endproc
#endif


#comment
*********************************************************************
* 
* INSERTITEM()
* 
* Calls readitem(), writeitem()
* 
* Called by:
* 	MRUN211H:  editpaste()
* 	MRUN211D:  main()
* 	MRUN211E:  insertulfile()
* 	MRUN211F:  addgetmail(), addsendcommand(), adddoscript()
* 
* Inserts a new item into the *.MRN file.
* 
*********************************************************************
#endcomment

proc insertitem
strparm BBSid
intparm i
strparm NovumItem
string Itemi
integer j, k
	j = i - 1
	Itemi = readitem(BBSid, i)
	while not NULLSTR Itemi
		i++
		Itemi = readitem(BBSid, i)
	endwhile
	k = i - 1
	while k > j
		Itemi = readitem(BBSid, k)
		writeitem(BBSid, i, Itemi)
		i--
		k--
	endwhile
	writeitem(BBSid, i, NovumItem)
endproc


#comment
*********************************************************************
* 
* INSERTBBS()
* 
* Calls readbbs(), writebbs()
* 
* Called by:
* 	MRUN211H:  editpaste()
* 	MRUN211C:  changeuserinfo()
* 
* Inserts a new BBS into the *.MRN file.
* 
*********************************************************************
#endcomment

#ifndef MRUN211B
#ifndef MRUN211DE
#ifndef MRUN211F
#ifndef MRUN211G
proc insertbbs
strparm BBSid, NewBBS
string BBSi
integer j, k
	j =  1
	BBSi = readbbs(j)
	;Go to the last BBS
	while not NULLSTR BBSi
		j++
		BBSi = readbbs(j)
	endwhile
	k = j - 1
	;Count back down, renumbering on the way
	while not strcmp BBSi BBSid
		BBSi = readbbs(k)
		writebbs(j, BBSi)
		j--
		k--
	endwhile
	writebbs(j, NewBBS)
endproc
#endif
#endif
#endif
#endif


#comment
*********************************************************************
* 
* CHANGEMAILRUN()
* 
* Calls filesave(), copymrn(), loadsettings()
* 
* Called by: 
* 	MRUN211H:  parsedialog()
* 	MRUN211B:  main()
* 
* Saves the last mailrun and loads a new one.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AB
proc changemailrun
	;Update the last mailrun
	filesave()
	;Get the next mailrun and copy it to the temp directory
	copymrn()
	loadsettings(MailRun)
endproc
#endif


#comment
*********************************************************************
* 
* CHECKPENDING()
* 
* Calls readitem()
* 
* Called by:
* 	MRUN211H:  changestatus()
* 	MRUN211G:  makequeue()
* 
* Checks a BBS for currently pending items.  Returns "1" if
* items are pending, "0" if none are pending.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
func checkpending : integer
strparm BBSid
string Pending, Itemi
integer i
	i = 1
	Itemi = readitem(BBSid, i)
	while not NULLSTR Itemi
		strextract Pending Itemi "," 0
		if strcmpi Pending "1"
			return 1
		endif
		i++
		Itemi = readitem(BBSid, i)
	endwhile
	return 0
endfunc
#endif


#comment
*********************************************************************
* 
* CHECKCHILD()
* 
* Called by:
* 	MRUN211A-G:  main()
* 
* Halts the script if the current script has not been
* called by another script.
* 
*********************************************************************
#endcomment

proc checkchild
	if not ($CHILD || $CHAINED)
		errormsg "This script can only be run from MRUN211.WAX."
		halt
	endif
endproc


#comment
*********************************************************************
* 
* CHECKRUNNING()
* 
* Called by:
* 	MRUN211H:  filenewmrun()
* 
* Checks whether a mailrun is executing.  Returns 0 and
* generates a message if running, returns 1 if not.
* 
*********************************************************************
#endcomment

#ifndef MRUN211G
func checkrunning : integer
	if FLAGS & RUNNING
		usermsg "You cannot create a new mailrun while a mailrun is executing."
		return 0
	else
		return 1
	endif
endfunc
#endif


#comment
*********************************************************************
* 
* CHECKCHANGED()
* 
* Called by:
* 	MRUN211H:  filenewmrun(), cfgmrun(), cfgbbs(), cfgprompts(),
* 				  cfgmaildoor(), defaultsmailrun(), defaultsbbs(),
* 				  defaultsprompts(), defaultsdoor(), addnewbbs(),
* 				  addgetsend(), adddownload(), addupload(), 
* 				  addsendcmd(), addscript(), helpabout()
* 	MRUN211B:  main()
* 	MRUN211C:  changebbsinfo(), changeprompts(), changemaildoor()
* 	MRUN211E:  main()
* 
* Checks whether the contents of the current dialog box
* have changed and generates a warning.  Returns 1 if
* user elects to proceed or if there has been no change,
* 0 if user cancels.
* 
*********************************************************************
#endcomment

func checkchanged : integer
integer Response
	if FLAGS & CHANGED
		sdlgmsgbox "MailRun Message" "Discard Changes?" QUESTION YESNO \
			Response 2
		switch Response
			case 6
				FLAGS &= UNCHANGED
				return 1
			endcase
			case 7
				return 0
			endcase
		endswitch
	else
		return 1
	endif
endfunc


#comment
*********************************************************************
* 
* CHECKFILE()
* 
* Called by:
* 	MRUN211A:  initialize()
* 	MRUN211D:  purgeoldfiles(), getnewfiles(), import()
* 	MRUN211E:  main(), getulfiles()
* 	MRUN211G:  senddesc(), putdesc()
* 
* Checks for a file's existence.  Returns 1 if the file is
* found, 0 if not found.
* 
*********************************************************************
#endcomment

#ifndef MRUN211BC
#ifndef MRUN211F
func checkfile : integer
strparm FileNom
	if isfile FileNom
		return 1
	else
		return 0
	endif
endfunc
#endif
#endif


#comment
*********************************************************************
* 
* CHECKTASK()
* 
* Called by:
* 	MRUN211H:  executearchiver(), executeqwkreader(),
* 				  executelogviewer()
* 
* Returns 1 if the specified application is already running;
* otherwise returns 0.
* 
*********************************************************************
#endcomment

func checktask : integer
strparm Called
string AppName
integer i
	firsttask i
	while i
		taskname i AppName
		if strfind Called AppName
			return i
		endif
		nexttask i
	endwhile
	return 0
endfunc


#comment
*********************************************************************
* 
* CHECKNEW()
* 
* Called by:
* 	MRUN211H:  cfgbbs(), cfgprompts(), cfgmaildoor(), 
* 				  addgetsend(), adddlfile(), addulfile(),
* 				  addsendcmd(), addscript()
* 
* Returns 0 if the current mailrun is empty; else returns 1.
* 
*********************************************************************
#endcomment

func checknew : integer
	if NULLSTR TaskItem
		usermsg "You must add a BBS before selecting this function!"
		return 0
	else
		return 1
	endif
endfunc


#comment
*********************************************************************
* 
* MENUDIM()
* 
* Called by:
* 	MRUN211H:  callscript()
* 	MRUN211B-G:  main()
* 
* Enables all menu controls, then disables those which
* cannot be used in the current module.
* 
*********************************************************************
#endcomment

proc menudim
	enable MENU 1 32
#ifndef MRUN211AG
	disable MENU 3 5
	disable MENU 8 11
#endif
#ifdef MRUN211G
	disable MENU 1
	disable MENU 3
	disable MENU 5 6
#endif
endproc


#comment
*********************************************************************
* 
* SORTIDX()
* 
* Calls fieldcompare(), makefullname(), openfile(),
* interfaceoff(), interfaceon()
* 
* Called by:
* 	MRUN211D:  main(), getnewfiles()
* 	MRUN211E:  main(), getulfiles(), updateudx()
* 
* Sorts an index file for display in the upload or download
* dialog box.  This routine uses two temp files to sort the
* contents of the referenced file.  It is used to sort an
* index file that has not been previously sorted.  The
* method used is too slow when only a couple of new items
* need to be sorted in the file.
* 
*********************************************************************
#endcomment

#ifdef MRUN211DE
proc sortidx
strparm idxName
intparm SortField
string temp1, temp2, Line1, Line2, LastLine
integer Unsorted, Readidx, Writeidx, i, counter
	SortField -=2
	if SortField < 0
		return
	endif
	interfaceoff()
	counter = 0
	temp1 = makefullname(TempDir, "temp1.tmp")
	temp2 = makefullname(TempDir, "temp2.tmp")
	Unsorted = 0
	Readidx = 1
	Writeidx = 2
	openfile(Unsorted, idxName, _READWRITE, _TEXT)
	fgets Unsorted Line1
	statmsg "Sorting...     %d" counter
	if feof Unsorted
		;if the index is empty, return
		fclose Unsorted
		interfaceon()
		return
	else
		;otherwise, open temp files and sort
		openfile(Readidx, temp1, _CREATE, _TEXT)
		openfile(Writeidx, temp2, _CREATE, _TEXT)
		;put the first line into the read file
		fputs Readidx Line1
		rewind Readidx
		;get the next line of the unsorted file
		fgets Unsorted Line1
		counter++
		statmsg "Sorting...     %d" counter
		fgets Readidx Line2
		if feof Unsorted
			;prevents a single file from being deleted
			fputs Writeidx Line2
		endif
		while not feof Unsorted
			while not feof Readidx
				if fieldcompare(Line1, Line2, SortField)
					exitwhile
				endif
				fputs Writeidx Line2
				fgets Readidx Line2
			endwhile
			fputs Writeidx Line1
			LastLine = Line1
			fgets Unsorted Line1
			counter++
			statmsg "Sorting...     %d" counter
			if feof Unsorted
				while not feof Readidx
					fputs Writeidx Line2
					fgets Readidx Line2
				endwhile
				exitwhile
			elseif !(fieldcompare(Line1, LastLine, SortField))
				loopwhile
			endif
			while not feof Readidx
				fputs Writeidx Line2
				fgets Readidx Line2
			endwhile
			rewind Readidx
			rewind Writeidx
			i = Readidx
			Readidx = Writeidx
			Writeidx = i
			fgets Readidx Line2
		endwhile
		fclose Unsorted
		fclose Readidx
		fclose Writeidx
		delfile idxName
		if Writeidx == 1
			copyfile temp1 idxName
		else
			copyfile temp2 idxName
		endif
		delfile temp1
		delfile temp2
	endif
	statmsg ""
	interfaceon()
endproc
#endif


#comment
*********************************************************************
* 
* FIELDCOMPARE()
* 
* Called by:
* 	MRUN211H:  sortidx()
* 
* Compares two fields.  Returns 0 if Field1 > Field2,
* 1 if Field1 <= Field2.
* 
*********************************************************************
#endcomment

#ifdef MRUN211DE
func fieldcompare : integer
strparm Line1, Line2
intparm FieldType
string Field1, Field2
long number1, number2, Date1, Date2
	strextract Field1 Line1 "`t" FieldType
	strextract Field2 Line2 "`t" FieldType
	switch FieldType
		case ALPHA
			strcmpi Field1 Field2
			if $STRCMP >= 0
				return 0
			else
				return 1
			endif
		endcase
		case NUMERIC
			atol Field1 number1
			atol Field2 number2
			if number1 >= number2
				return 0
			else
				return 1
			endif
		endcase
		case MMDDYY
			strsltime Field1 "00:00:00" Date1
			strsltime Field2 "00:00:00" Date2
			if Date1 >= Date2
				return 0
			else
				return 1
			endif
		endcase
	endswitch
endfunc
#endif


#comment
*********************************************************************
* 
* FINDSTRING()
* 
* Called by:
* 	MRUN211B:  main()
* 	MRUN211C:  exportprompts()
* 	MRUN211D:  getnewfiles(), import()
* 	MRUN211E:  shortdesc()
* 	MRUN211G:  main(), checkcommandprompt(), getconfprompt(),
* 				  checkmailprompt(), checkdescprompt(), 
* 				  checkbaseset(), getotherprompt(), sendmail(),
* 				  getmail(), checkmail(), ulfile(), checkverifyprompt(),
* 				  senddesc(), dlfile(), sendcommand(), sendscript()
* 
* Returns a value of 1 if the second string is contained
* in the first string; otherwise returns 0.
* 
*********************************************************************
#endcomment

#ifndef MRUN211A
#ifndef MRUN211F
func findstring : integer
strparm String1, String2
	if not NULLSTR String2
		if strfind String1 String2
			return 1
		endif
	endif
	return 0
endfunc
#endif
#endif


#comment
**************************************************************************
**************************************************************************
* 
* The following routines comprise the user interface of MailRun.
* parsedialog controls the behavior of the main mailrun dialog box,
* parsemenu() controls the menu and parseobject() controls the
* toolbar.  The menus and toolbar are defined in MRUN211A in the
* procedures mrunmenu(), which creates the main menu system, 
* runmenu(), which creates the alternate menu used when a mailrun
* is executing, and mrunwin(), which creates the toolbar.
* 
**************************************************************************
**************************************************************************
#comment


#comment
*********************************************************************
* 
* INTERFACEON()
* 
* Calls parsemenu(), parseobject()
* 
* Called by:
* 	MRUN211H:  sortidx(), taskfileend()
* 	MRUN211A:  main()
* 	MRUN211B:  main()
* 	MRUN211C:  changeuserinfo(), changeprompts(), changemaildoor()
* 	MRUN211D:  main(), purgeoldfiles(), getnewfiles(), deldlfile()
* 	MRUN211E:  main(), insertulfile(), getulfiles(), updateudx(),
* 	MRUN211F:  addgetmail(), addsendcommand(), adddoscript()
* 	MRUN211G:  makequeue(), getdialstring(), senddesc(), putdesc()
* 
* Activate and deactivate the menu and iconbar.
* 
*********************************************************************
#endcomment

proc interfaceon
	when menu call parsemenu
	when object call parseobject
endproc


#comment
*********************************************************************
* 
* INTERFACEOFF()
* 
* Called by:
* 	MRUN211H:  sortidx(), taskfilefwd()
* 	MRUN211D:  main(), purgeoldfiles(), getnewfiles(), deldlfile()
* 	MRUN211E:  insertulfile(), geulfiles(), updateudx()
* 	MRUN211G:  makequeue(), getdialstring(), senddesc(), putdesc()
* 
* Activate and deactivate the menu and iconbar.
* 
*********************************************************************
#endcomment

#ifndef MRUN211BC
#ifndef MRUN211F
proc interfaceoff
	clearwhen menu
	clearwhen object
endproc
#endif
#endif


#comment
*********************************************************************
* 
* PARSEDIALOG()
* 
* Calls changestatus(), changemailrun(), maketasklist(),
* getfirstitem(), gettaskstring(), swapbbs(), swapitem(),
* getbbscoord(), makequeue()
* 
* Called by
*  MRUN211A:  main(), executor()
*  MRUN211G:  main()
* 
* Checks for dialog box selection and dispatches the
* appropriate task.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc parsedialog
string BBSid, char
integer dialogstatus, i, j
	dialogstatus = $DIALOG
	switch dialogstatus
		case 10
			;User double clicked on an item
			changestatus()
			updatedlg 80
		endcase
		case 11
			;User selected Alt-U to move an item up
			strextract BBSid TaskItem "`t" 3
			i = getbbscoord(BBSid)
			strextract char TaskItem "`t" 4
			atoi char j
			if j == 0
				;if the selected TaskItem is a BBS
				i--
				swapbbs(i)
			else
				;if the selected TaskItem is an Item
				j--
				if swapitem(BBSid, j)
					TaskItem = gettaskstring(BBSid, j)
				endif
			endif
			updatedlg 80
		endcase
		case 12
			;User selected Alt-I to move an item down
			strextract BBSid TaskItem "`t" 3
			i = getbbscoord(BBSid)
			strextract char TaskItem "`t" 4
			atoi char j
			if j == 0
				;If the selected TaskItem is a BBS
				swapbbs(i)
			else
				;If the selected TaskItem is an Item
				if swapitem(BBSid, j)
					j++
					TaskItem = gettaskstring(BBSid, j)
				endif
			endif
			updatedlg 80
		endcase
#ifdef MRUN211A
		case 170
			;User changed mailruns with combobox
			changemailrun()
			maketasklist()
			getfirstitem()
			updatedlg 80
		endcase
#endif
	endswitch
#ifdef MRUN211G
	makequeue()
#endif
endproc
#endif


#comment
*********************************************************************
* 
* SWAPBBS()
* 
* Calls readbbs(), writebbs(), openfile(), gettaskstring(),
* taskfilefwd(), taskfileend()
* 
* Called by:
*  MRUN211H: parsedialog()
* 
* Swaps two BBSs in the task list.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc swapbbs
intparm i
string FirstBBS, SecondBBS, BBSid, TempTasks, TaskString, temp
integer j
	j = i + 1
	FirstBBS = readbbs(i)
	SecondBBS = readbbs(j)
	if NULLSTR FirstBBS
		return
	endif
	if NULLSTR SecondBBS
		return
	endif
	;Unless this is the last (or first) BBS, swap with the next BBS
	TaskString = gettaskstring(FirstBBS, 0)
	taskfilefwd(TaskString)
	TempTasks = makefullname(TempDir, "tmptasks.tmp")
	openfile(TempTaskFile, TempTasks, _CREATE, _TEXT)
	BBSid = FirstBBS
	while strcmp FirstBBS BBSid
		fputs TempTaskFile TaskString
		fgets OldTaskFile TaskString
		strextract BBSid TaskString "`t" 3
	endwhile
	while strcmp SecondBBS BBSid
		fputs TaskFile TaskString
		fgets OldTaskFile TaskString
		strextract BBSid TaskString "`t" 3
	endwhile
	temp = TaskString
	rewind TempTaskFile
	fgets TempTaskFile TaskString
	while not feof TempTaskFile
		fputs TaskFile TaskString
		fgets TempTaskFile TaskString
	endwhile
	fputs TaskFile temp
	taskfileend()
	fclose TempTaskFile
	delfile TempTasks
	writebbs(i, SecondBBS)
	writebbs(j, FirstBBS)
endproc
#endif


#comment
*********************************************************************
* 
* SWAPITEM()
* 
* Calls readitem(), writeitem(), gettaskstring(), taskfilefwd(),
* taskfileend()
* 
* Called by:
*  MRUN211H: parsedialog()
* 
* Swaps two Items in the task list.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
func swapitem : integer
strparm BBSid
intparm j
string Itemj, Iteml, TaskString
integer l
	if j == 0
		return 0
	endif
	l = j + 1
	Itemj = readitem(BBSid, j)
	Iteml = readitem(BBSid, l)
	if not NULLSTR Iteml
		;Unless this is the last Item, swap with the next Item
		TaskString = gettaskstring(BBSid, j)
		taskfilefwd(TaskString)
		writeitem(BBSid, j, Iteml)
		writeitem(BBSid, l, Itemj)
		TaskString = gettaskstring(BBSid, j)
		fputs TaskFile TaskString
		TaskString = gettaskstring(BBSid, l)
		fputs TaskFile TaskString
		fgets OldTaskFile TaskString
		taskfileend()
		return 1
	else
		return 0
	endif
endfunc
#endif


#comment
*********************************************************************
* 
* CHANGESTATUS()
* 
* Calls readitem(), writeitem(), maketasklist(), gettaskstring(), 
* checkpending(), taskfilefwd(), taskfileend(), updatecount()
* 
* Called by:
* 	MRUN211H:  parsedialog()
* 
* Changes the pending/complete permanent/temporary status
* of the selected item on the task list.  Responds to user
* double-clicking on the item.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc changestatus
string Pending, Perm, BBSid, Itemi, char
integer j
	strextract BBSid TaskItem "`t" 3
	strextract char TaskItem "`t" 4
	atoi char j
	if j == 0
		;If the item is a BBS
		;Check for pending items
		if checkpending(BBSid)
			;If at least one item is pending, set all to completed status
			Pending = "0"
		else
			;If no items are pending, set all to pending status
			Pending = "1"
		endif
		j = 1
		Itemi = readitem(BBSid, j)
		;Update all items
		while not NULLSTR Itemi
			strupdt Itemi Pending 0 1
			writeitem(BBSid, j, Itemi)
			j++
			Itemi = readitem(BBSid, j)
		endwhile
		maketasklist()
		TaskItem = gettaskstring(BBSid, 0)
	else
		;If it is not a BBS
		Itemi = readitem(BBSid, j)
		strextract Pending Itemi "," 0
		strextract Perm Itemi "," 1
		if not strcmpi Pending "1"
			if strcmpi Pending "0"
				ItemC--
			else
				ItemE--
			endif
			ItemR++
			Pending = "1"
			Perm = "0"
		else
			if strcmpi Perm "0"
				Perm = "1"
			else
				Pending = "0"
				ItemC++
				ItemR--
			endif
		endif
		updatecount()
		strupdt Itemi Pending 0 1
		strupdt Itemi Perm 2 1
		taskfilefwd(TaskItem)
		writeitem(BBSid, j, Itemi)
		TaskItem = gettaskstring(BBSid, j)
		fputs TaskFile TaskItem
		taskfileend()
	endif
endproc
#endif


#comment
*********************************************************************
*
* TASKFILEFWD()
*
* Calls makefullname(), openfile(), interfaceoff()
*
* Called by:
*  MRUN211H:  swapbbs(), swapitem(), changestatus()
*
* Opens the Task List file and moves forward to the designated
* coordinates.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc taskfilefwd
strparm OldTaskString
string OldTasks, TaskString
	interfaceoff()
	OldTasks = makefullname(TempDir, "oldtasks.tmp")
	copyfile TaskList OldTasks
	openfile(OldTaskFile, OldTasks, _READWRITE, _TEXT)
	openfile(TaskFile, TaskList, _CREATE, _TEXT)
	fgets OldTaskFile TaskString
	while not strcmpi OldTaskString TaskString
		fputs TaskFile TaskString
		fgets OldTaskFile TaskString
	endwhile
endproc
#endif


#comment
*********************************************************************
*
* TASKFILEEND()
*
* Calls makefullname(), interfaceon()
*
* Called by:
*  MRUN211H:  swapbbs(), swapitem(), changestatus()
*
* Reads to the end of the Task List file and closes it.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc taskfileend
string TaskString, OldTasks
	fgets OldTaskFile TaskString
	while not feof OldTaskFile
		fputs TaskFile TaskString
		fgets OldTaskFile TaskString
	endwhile
	fclose OldTaskFile
	fclose TaskFile
	OldTasks = makefullname(TempDir, "oldtasks.tmp")
	delfile OldTasks
	interfaceon()
endproc
#endif


#comment
*********************************************************************
* 
* PARSEMENU()
* 
* Calls filenewmrun(), filesave(), filesaveas(), filereset(),
* filedelmrun(), fileautorun(), fileexit(), editcut(), editcopy(), 
* editpaste(), editdelete(), cfgmrun(), cfgbbs(), cfgprompts(), 
* cfgmaildoor(), defaultsmailrun(), defaultsbbs(), defaultsprompts(),
* defaultsdoor(), addnewbbs(), addgetsend(), addupload(),
* adddownload(), addsendcmd(), addscript(), executemailrun(),
* executeqwkreader(), executearchiver(), executelogviewer(),
* helpcontents(), helpcontext(), helpabout()
* 
* Called by:
* 	MRUN211H:  interfaceon()
* 
* Parses a selection from the MailRun menu.
* 
*********************************************************************
#endcomment

proc parsemenu
integer menustatus
	menustatus = $MENU
	switch menustatus
#ifndef MRUN211G
		case 1
			;User selected file.new
			filenewmrun()
		endcase
#endif
		case 2
			;User selected file.save
			filesave()
		endcase
#ifdef MRUN211A
		case 3
			;User selected file.save_as
			filesaveas()
		endcase
#endif
#ifdef MRUN211AG
		case 4
			;User selected file.reset
			filereset()
		endcase
#endif
#ifdef MRUN211A
		case 5
			;User selected file.delete_mailrun
			filedelmrun()
		endcase
#endif
#ifndef MRUN211G
		case 6
			;User selected file.create_autorun
			fileautorun()
		endcase
#endif
		case 7
			;User selected file.exit
			fileexit()
		endcase
#ifdef MRUN211AG
		case 8
			;User selected edit.cut
			editcut()
		endcase
		case 9
			;User selected edit.copy
			editcopy()
		endcase
		case 10
			;User selected edit.paste
			editpaste()
		endcase
		case 11
			;User selected delete_item
			editdelete()
		endcase
#endif
		case 12
			;User selected configure.mailrun_settings
			cfgmrun()
		endcase
		case 13
			;User selected configure.bbs_settings
			cfgbbs()
		endcase
		case 14
			;User selected configure.bbs_prompts
			cfgprompts()
		endcase
		case 15
			;User selected configure.bbs_mail_door
			cfgmaildoor()
		endcase
		case 16
			;User selected configure.defaults.mailrun
			defaultsmailrun()
		endcase
		case 17
			;User selected configure.defaults.bbs
			defaultsbbs()
		endcase
		case 18
			;User selected configure.defaults.prompts
			defaultsprompts()
		endcase
		case 19
			;User selected configure.defaults.maildoor
			defaultsdoor()
		endcase
		case 20
			;User selected add.new_bbs
			addnewbbs()
		endcase
		case 21
			;User selected add.get/send_mail
			addgetsend()
		endcase
		case 22
			;User selected add.upload_file
			addupload()
		endcase
		case 23
			;User selected add.download_file
			adddownload()
		endcase
		case 24
			;User selected add.send_command
			addsendcmd()
		endcase
		case 25
			;User selected add.execute_script
			addscript()
		endcase
		case 26
			;User selected execute.mailrun
			executemailrun()
		endcase
		case 27
			;User selected execute.qwk_reader
			executeqwkreader()
		endcase
		case 28
			;User selected execute.archiver
			executearchiver()
		endcase
		case 29
			;User selected execute.view_log_file
			executelogviewer()
		endcase
		case 30
			;User selected help.contents
			helpcontents()
		endcase
		case 31
			;User selected help.current_window
			helpcontext()
		endcase
		case 32
			;User selected help.about
			helpabout()
		endcase
	endswitch
endproc


#comment
*********************************************************************
* 
* PARSEOBJECT()
* 
* Calls executemailrun(), filereset(), filenewmrun(), 
* cfgbbs(), addnewbbs(), addgetsend(), addupload(),
* adddownload(), addsendcmd(), addscript(), editdelete(),
* executelogviewer(), executeqwkreader(), executearchiver(), 
* fileexit(), helpabout()
* 
* Called by:
* 	MRUN211H:  interfaceon()
* 
* Parses a selection from the MailRun icon bar.
* 
*********************************************************************
#endcomment

proc parseobject
integer objectstatus
	objectstatus = $OBJECT
	switch objectstatus
		case 1
			;User selected icon for execute.mailrun
			executemailrun()
		endcase
#ifdef MRUN211AG
		case 2
			;User selected icon for file.reset
			filereset()
		endcase
#endif
#ifndef MRUN211G
		case 3
			;User selected icon for file.new
			filenewmrun()
		endcase
#endif
		case 4
			;User selected icon for configure.bbs
			cfgbbs()
		endcase
		case 5
			;User selected icon for add.new_bbs
			addnewbbs()
		endcase
		case 6
			;User selected icon for add.get/send_mail
			addgetsend()
		endcase
		case 7
			;User selected icon for add.upload_file
			addupload()
		endcase
		case 8
			;User selected icon for add.download_file
			adddownload()
		endcase
		case 9
			;User selected icon for add.send_command
			addsendcmd()
		endcase
		case 10
			;User selected icon for add.execute_script
			addscript()
		endcase
#ifdef MRUN211AG
		case 11
			;User selected icon for file.delete_item
			editdelete()
		endcase
#endif
		case 12
			;User selected icon for execute.view_log_file
			executelogviewer()
		endcase
		case 13
			;User selected icon for execute.qwk_reader
			executeqwkreader()
		endcase
		case 14
			;User selected icon for execute.archiver
			executearchiver()
		endcase
		case 15
			;User selected icon for file.exit
			fileexit()
		endcase
		case 16
			;User selected icon for context sensitive help
			helpcontext()
		endcase
	endswitch
endproc


#comment
**************************************************************************
**************************************************************************
* 
* The following procedures correspond to menu selections
* and are called from parsemenu() and parseobject().
* 
**************************************************************************
**************************************************************************
#endcomment


#comment
*********************************************************************
* 
* FILENEWMRUN()
* 
* Calls checkrunning(), checkchanged(), makefullname(),
* callscript(), MRUN211B\main()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	
* Corresponds to File.New_MailRun menu selection.  Creates a 
* new mailrun.
* 	
*********************************************************************
#endcomment

#ifndef MRUN211G
proc filenewmrun
#ifndef MRUN211B
string changesettings
#endif
	if checkrunning() && checkchanged()
		FLAGS = NEW
#ifndef MRUN211B
		changesettings = makefullname(MailRunDir, "MRUN211B")
		callscript(changesettings)
#else
		main()
#endif
	endif
endproc
#endif


#comment
*********************************************************************
* 
* FILESAVE()
* 
* Calls makefullname()
* 
* Called by:
* 	MRUN211H:  parsemenu(), makemrn(), changemailrun(), fileexit()
* 	MRUN211B:  newmailrun()
* 
* Corresponds to the File.Save menu selection.  Saves the 
* current mailrun.
* 	
*********************************************************************
#endcomment

proc filesave
string LastRun
	if !(FLAGS & DEFAULTS)
		findfirst MailRun
		LastRun = makefullname(MailRunDir, $FILENAME)
		if not NULLSTR $FILENAME
			delfile LastRun
		endif
		copyfile MailRun LastRun
		profilewr MailRunIni "MailRun" "MailRun" $FILENAME
	endif
endproc


#comment
*********************************************************************
* 
* FILESAVEAS()
* 
* Calls fverify(), makefullname(), copymrn(), makemailrunlist()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the File.Save_AS menu selection.  Saves the
* current mailrun under a new name and makes the new mailrun
* current.
* 
*********************************************************************
#endcomment

#ifdef MRUN211A
proc filesaveas
string NewRun, temp
integer Response
	;Make sure the entered MailRun ID is the correct length
	;and that it doesn't already exist
	while 1
		NewRun = ""
		sdlginput "New MailRun" \
			"Save the current mailrun as:" NewRun
		if FAILURE
			exit
		endif
		strlwr NewRun
		if not fverify(NewRun)
			usermsg \
			"A mailrun ID must be a valid DOS file name without the extension."
			loopwhile
		endif
		strfmt temp "%s.mrn" NewRun
		NewRun = makefullname(MailRunDir, temp)
		if isfile NewRun
			sdlgmsgbox "MailRun Message" \
				"%s already exists!`r`n`r`nReplace it?" QUESTION YESNO Response 2
			if Response == 7
				;if user selected "No"
				NewRun = ""
				loopwhile
			endif
		endif
		exitwhile
	endwhile
	delfile NewRun
	MailRunTrunc = temp
	copyfile MailRun NewRun
	copymrn()
	makemailrunlist()
	updatedlg 512
endproc
#endif


#comment
*********************************************************************
* 
* FILERESET()
* 
* Calls maketasklist(), getfirstitem(), readbbs(), readitem(),
* writeitem()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject(), filereset()
* 
* Corresponds to the File.Reset_MailRun menu selection.
* Resets completed permenant items to pending.  Deletes
* completed temporary items.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc filereset
string Pending, Perm, BBSid, Itemi
integer p1, p2, i, j, k
	i = 1
	BBSid = readbbs(i)
	;Loop through each BBS
	while not NULLSTR BBSid
		j = 1
		k = 1
		Itemi = readitem(BBSid, j)
		;Loop through each Item
		while not NULLSTR Itemi
			;Clear the old item
			writeitem(BBSid, j, "")
			strextract pending Itemi "," 0
			strextract perm Itemi "," 1
			atoi pending p1
			atoi perm p2

			;Items that are completed and temporary will not be updated
			;The second counter "k" is required to avoid gaps where items
			;are deleted.

			if (p1 != 0) || (p2 != 0)
				strupdt Itemi "1" 0 1
				writeitem(BBSid, k, Itemi)
				k++
			endif
			j++
			Itemi = readitem(BBSid, j)
		endwhile
		i++
		BBSid = readbbs(i)
	endwhile
	maketasklist()
	getfirstitem()
	updatedlg 80
endproc
#endif


#comment
*********************************************************************
* 
* FILEDELMRUN()
* 
* Calls makefullname(), copymrn(), makemailrunlist(),
* maketasklist(), getfirstitem()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the File.Delete_MailRun menu selection.
* Deletes the current mailrun and makes the next available
* mailrun current.
* 
*********************************************************************
#endcomment

#ifdef MRUN211A
proc filedelmrun
string LastMRun
	findfirst MailRun
	LastMRun = makefullname(MailRunDir, $FILENAME)
	delfile LastMRun
	LastMRun = makefullname(MailRunDir, "*.MRN")
	findfirst LastMRun
	MailRunTrunc = $FILENAME
	copymrn()
	makemailrunlist()
	maketasklist()
	getfirstitem()
	updatedlg -1
endproc
#endif


#comment
*********************************************************************
* 
* FILEAUTORUN()
* 
* Calls makefullname(), openfile()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the File.Create_AutoRun menu selection.
* Creates an AutoRun script file.
* 
*********************************************************************
#endcomment

#ifndef MRUN211G
proc fileautorun
string AutoRunFile
	findfirst MailRun
	AutoRunFile = makefullname(MailRunDir, $FNAME)
	strcat AutoRunFile ".WAS"
	openfile(0, AutoRunFile, _CREATE, _TEXT)
	fstrfmt 0 ";MailRun autostart script for %s`r`n`r`n" MailRunTrunc
	fputs 0 "proc main"
	fputs 0 "string MailRunIni"
	fputs 0 "`tMailRunIni = $WINPATH"
	fputs 0 "`taddfilename MailRunIni `"MAILRUN.INI`""
	fputs 0 "`tprofilewr MailRunIni `"MailRun`" `"AutoRun`" 1"
	fstrfmt 0 "`tprofilewr MailRunIni `"MailRun`" `"MailRun`" `"%s`"`r`n" \
		MailRunTrunc
	fputs 0 "`tchain `"MRUN211`""
	fputs 0 "endproc"
	fclose 0
endproc
#endif


#comment
*********************************************************************
* 
* FILEEXIT()
* 
* Calls filesave(), cleardir(), makefullname()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	MRUN211A:  executor()
* 	MRUN211B:  changemrundir()
* 	MRUN211G:  dobbs()
* 
* Corresponds to the File.Exit menu selection.  Restores
* system settings, deletes temporary files, and halts script.
* 
*********************************************************************
#endcomment

proc fileexit
string StateCapPath, StateCapFile, StateDnldPath, StateUpldPath
string CleanupFile
integer StateAutoDL, StateActionBar, StateMetaKeys

	;Update the last mailrun
	filesave()

	;Retrieve the previous system state from the cleanup file
	cleanupfile = makefullname(TempDir, "CLEANUP.TMP")
	profilerd CleanupFile "Cleanup" "StateAutoDL" StateAutoDL
	profilerd CleanupFile "Cleanup" "StateCapPath" StateCapPath
	profilerd CleanupFile "Cleanup" "StateCapFile" StateCapFile
	profilerd CleanupFile "Cleanup" "StateDnldPath" StateDnldPath
	profilerd CleanupFile "Cleanup" "StateUpldPath" StateUpldPath
	profilerd CleanupFile "Cleanup" "StateActionBar" StateActionBar
	profilerd CleanupFile "Cleanup" "StateMetaKeys" StateMetaKeys

	;Restore the settings
	capture OFF
	set capture path StateCapPath
	set capture file StateCapFile
	set dnldpath StateDnldPath
	set upldpath StateUpldPath
	set aspect rangechk ON
	if StateAutoDL != 0
		set autodnld ON
	endif
	if StateActionBar != 0
		actionbar ON
	endif
	if StateMetaKeys != 0
		metakeys ON
	endif

	cleardir(TempDir)
	chdir MailRunDir
	rmdir TempDir
	statmsg ""
	remove USERWIN
#ifdef MRUN211A
	if PostRun == 3
		closepw
	endif
#endif
	halt
endproc


#comment
*********************************************************************
* 
* EDITCUT()
* 
* Calls editcopy(), editdelete()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the Edit.Cut menu selection.  Copies the
* current item in the Task List to the clipboard and deletes
* it from the Task List.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc editcut
	editcopy()
	editdelete()
endproc
#endif


#comment
*********************************************************************
* 
* EDITCOPY()
* 
* Calls makefullname(), loadbbsinfo(), loadprompts(), 
* loadmaildoor(), writebbsinfo(), writeprompts(),
* writemaildoor(), readitem()
* 
* Called by:
* 	MRUN211H:  parsemenu(), editcut()
* 
* Coresponds to the Edit.Copy menu selection.  Copies the 
* currently selected item in the Task List to the clipboard.
* If the item is a BBS, all user info and prompts are copied
* as well.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc editcopy
string BBSid, Itemi, char, temp
integer j
	if NULLSTR TaskItem
		return
	endif
	strextract BBSid TaskItem "`t" 3
	strextract char TaskItem "`t" 4
	atoi char j
	temp = makefullname(TempDir, "TEMP.TMP")
	;If the current TaskItem is a BBS...
	if j == 0
#ifdef MRUN211G
		usermsg "Cannot copy/cut a BBS while a mailrun is executing!"
#else
		loadbbsinfo(MailRun, BBSid)
		loadprompts(MailRun, BBSid)
		loadmaildoor(MailRun, BBSid)
		profilewr temp "MailRun Data" "BBS" BBSid
		writebbsinfo(temp, BBSid)
		writeprompts(temp, BBSid)
		writemaildoor(temp, BBSid)
		filetoclip TEXT temp
#endif
	else
		Itemi = readitem(BBSid, j)
		profilewr temp "MailRun Data" "Item" Itemi
		filetoclip TEXT temp
	endif
	delfile temp
endproc
#endif


#comment
*********************************************************************
* 
* EDITPASTE()
* 
* Calls makefullname(), gettaskstring(), inlist(), 
* insertitem(), makebbslist(), insertbbs(), loadbbsinfo(),
* loadprompts(), loadmaildoor(), writebbsinfo(), writeprompts(),
* writemaildoor(), maketasklist()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the Edit.Paste menu selection.  Pastes an
* item from the clipboard into the current mailrun.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc editpaste
string BBSid, NewBBS, Itemi, char, temp
integer j
	strextract BBSid TaskItem "`t" 3
	strextract char TaskItem "`t" 4
	atoi char j
	temp = makefullname(TempDir, "TEMP.TMP")
	cliptofile TEXT temp
	profilerd temp "MailRun Data" "Item" Itemi
	profilerd temp "MailRun Data" "BBS" NewBBS
	if not NULLSTR Itemi
		;if the clipboard contains an item...
		if NULLSTR TaskItem
			usermsg "You must add a BBS first!"
			return
		endif
		insertitem(BBSid, j, Itemi)
		TaskItem = gettaskstring(BBSid, j)
	elseif not NULLSTR NewBBS
		;if the clipboard contains a BBS...
#ifdef MRUN211G
		usermsg "Cannot paste a BBS while a mailrun is executing!"
#else
		makebbslist()
		if inlist(NewBBS, BBSList) 
			errormsg "That BBS is already in the MailRun!"
			return
		endif
		if not NULLSTR BBSList
			insertbbs(BBSid, NewBBS)
		else
			profilewr MailRun "MailRun" "BBS_1" NewBBS
		endif
		loadbbsinfo(temp, NewBBS)
		loadprompts(temp, NewBBS)
		loadmaildoor(temp, NewBBS)
		writebbsinfo(MailRun, NewBBS)
		writeprompts(MailRun, NewBBS)
		writemaildoor(MailRun, NewBBS)
		TaskItem = gettaskstring(NewBBS, 0)
#endif
	else
		usermsg "Nothing to paste!"
		return
	endif
	maketasklist()
	updatedlg 80
endproc
#endif


#comment
*********************************************************************
* 
* EDITDELETE()
* 
* Calls readbbs(), readitem(), writebbs(), writeitem(), 
* maketasklist(), makebbslist(), gettaskstring(), getbbscoord()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject(), editcut()
* 	MRUN211A:  parsekeystate()
* 
* Corresponds to the Edit.Delete menu selection.  Deletes
* the currently selected item in the Task List.
* 
*********************************************************************
#endcomment

#ifdef MRUN211AG
proc editdelete
string BBSid, char, Itemi
integer i, j, k, l
	strextract BBSid TaskItem "`t" 3
	i = getbbscoord(BBSid)
	strextract char TaskItem "`t" 4
	atoi char j
	if j == 0
		;If the current TaskItem is a BBS...
		l = i
		k = l + 1
		BBSid = readbbs(k)

		;Decrement the BBS coordinate of each BBS after the one selected

		while not NULLSTR BBSid
			writebbs(l, BBSid)
			l++
			k++
			BBSid = readbbs(k)
		endwhile
		writebbs(l, "")
		;Update the task list
		maketasklist()

		;Reset the TaskItem.  If the selected BBS was the last one
		;in the list, set TaskItem to the previous BBS; otherwise,
		;set it to the next BBS

		BBSid = readbbs(i)
		if NULLSTR BBSid
			i--
			BBSid = readbbs(i)
			if NULLSTR BBSid
				TaskItem = ""
			else
				TaskItem = gettaskstring(BBSid, 0)
			endif
		else
			TaskItem = gettaskstring(BBSid, 0)
		endif

	else
		;If the current TaskItem is an Item
		l = j
		k = l + 1

		;Decrement the Item coordinate of each item after the one selected

		Itemi = readitem(BBSid, k)
		while not NULLSTR Itemi
			writeitem(BBSid, l, Itemi)
			l++
			k++
			Itemi = readitem(BBSid, k)
		endwhile
		writeitem(BBSid, l, "")
		;Update the task list
		maketasklist()

		;Reset the TaskItem to the next Item for that BBS.  If the selected
		;Item was the last one for that BBS, set TaskItem to the previous
		;Item.  If it was the only item for that BBS, set it to the BBS name.

		Itemi = readitem(BBSid, j)
		if not NULLSTR Itemi
			;If it wasn't the last item...
			TaskItem = gettaskstring(BBSid, j)
		elseif j == 1
			;If it was the only item...
			TaskItem = gettaskstring(BBSid, 0)
		else
			;If it was the last of multiple items...
			j--
			TaskItem = gettaskstring(BBSid, j)
		endif
	endif
	updatedlg 80
endproc
#endif


#comment
*********************************************************************
* 
* CFGMRUN()
* 
* Calls checkchanged(), configmrun()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the Configure.MailRun_Settings menu selection.
* 
*********************************************************************
#endcomment

proc cfgmrun
	if checkchanged()
		;reset all flags except RUNNING
		FLAGS &= RUNNING
		configmrun()
	endif
endproc


#comment
*********************************************************************
* 
* DEFAULTSMAILRUN()
* 
* Calls checkchanged(), configmrun()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the Configure.Defaults.MailRun menu selection.
* 	
*********************************************************************
#endcomment

proc defaultsmailrun
#ifdef MRUN211B
	if FLAGS & DEFAULTS
		return
	endif
#endif
	if checkchanged()
		;reset all flags but RUNNING and set the DEFAULTS flag
		FLAGS &= RUNNING
		FLAGS |= DEFAULTS
		configmrun()
	endif
endproc


#comment
*********************************************************************
* 
* CONFIGMRUN()
* 
* Calls MRUN211B\main(), makefullname(), callscript()
* 
* Called by:
* 	MRUN211H:  cfgmrun(), defaultsmailrun()
* 
* Calls the changesettings script module.
* 	
*********************************************************************
#endcomment

proc configmrun
#ifdef MRUN211B
		main()
#else
string changesettings
		changesettings = makefullname(MailRunDir, "MRUN211B")
		callscript(changesettings)
#endif
endproc


#comment
*********************************************************************
* 
* CFGBBS()
* 
* Calls checkchanged(), checknew(), configbbs()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	MRUN211C:  changeprompts(), changemaildoor()
* 
* Corresponds to the Configure.BBS_Settings menu selection.
* 
*********************************************************************
#endcomment

proc cfgbbs
	if checkchanged() && checknew()
		FLAGS &= RUNNING
		configbbs()
	endif
endproc


#comment
*********************************************************************
* 
* DEFAULTSBBS()
* 
* Calls checkchanged(), configbbs()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 	MRUN211C:  changeprompts(), changemaildoor()
* 
* Corresponds to the Configure.Defaults.BBS menu selection.
* 
*********************************************************************
#endcomment

proc defaultsbbs
	if checkchanged()
		FLAGS &= RUNNING
		FLAGS |= DEFAULTS
		configbbs()
	endif
endproc


#comment
*********************************************************************
* 
* CONFIGBBS()
* 
* Calls makefullname(), callscript(), changeuserinfo()
* 
* Called by:
* 	MRUN211H:  cfgbbs(), defaultsbbs()
* 
* Calls the changebbs script module for the changeuserinfo()
* procedure.
* 
*********************************************************************
#endcomment

proc configbbs
#ifndef MRUN211C
string changebbs
		FLAGS = (FLAGS & CLEARCMD) | USR
		changebbs = makefullname(MailRunDir, "MRUN211C")
		callscript(changebbs)
#else
		changeuserinfo()
#endif
endproc


#comment
*********************************************************************
* 
* CFGPROMPTS()
* 
* Calls checkchanged(), checknew(), configprompts
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 	MRUN211C:  changeuserinfo(), changemaildoor()
* 
* Corresponds to the Configure.BBS_Prompts menu settings.
* 
*********************************************************************
#endcomment

proc cfgprompts
	if checkchanged() && checknew()
		FLAGS &= RUNNING
		configprompts()
	endif
endproc


#comment
*********************************************************************
* 
* DEFAULTSPROMPTS()
* 
* Calls checkchanged(), configprompts()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 	MRUN211C:  changeuserinfo(), changemaildoor()
* 
* Corresponds to the Configure.Defaults.Prompts menu selection.
* 
*********************************************************************
#endcomment

proc defaultsprompts
	if checkchanged()
		FLAGS &= RUNNING
		FLAGS |= DEFAULTS
		configprompts()
	endif
endproc


#comment
*********************************************************************
* 
* CONFIGPROMPTS()
* 
* Calls makefullname(), callscript(), changeprompts()
* 
* Called by:
* 	MRUN211H:  cfgprompts(), defaultsprompts()
* 
* Calls the changebbs script module for the changeprompts()
* procedure.
* 
*********************************************************************
#endcomment

proc configprompts
#ifndef MRUN211C
string changebbs
	FLAGS = (FLAGS & CLEARCMD) | PRMPT
	changebbs = makefullname(MailRunDir, "MRUN211C")
	callscript(changebbs)
#else
	changeprompts()
#endif
endproc


#comment
*********************************************************************
* 
* CFGMAILDOOR()
* 
* Calls checkchanged(), checknew(), configmaildoor()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 	MRUN211C:  changeuserinfo(), changeprompts()
* 
* Corresponds to the Configure.BBS_Mail_Door menu selection.
* 
*********************************************************************
#endcomment

proc cfgmaildoor
	if checkchanged() && checknew()
		FLAGS &= RUNNING
		configmaildoor()
	endif
endproc


#comment
*********************************************************************
* 
* DEFAULTSDOOR()
* 
* Calls checkchanged(), configmaildoor()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 	MRUN211C:  changeuserinfo(), changeprompts()
* 
* Corresponds to the Configure.Defaults.Mail_Door menu selection.
* 
*********************************************************************
#endcomment

proc defaultsdoor
	if checkchanged()
		FLAGS &= RUNNING
		FLAGS |= DEFAULTS
		configmaildoor()
	endif
endproc


#comment
*********************************************************************
* 
* CONFIGMAILDOOR()
* 
* Calls makefullname(), callscript(), changemaildoor()
* 
* Called by:
* 	MRUN211H:  cfgmaildoor(), defaultsmaildoor()
* 
* Calls the changebbs script module for the changemaildoor()
* procedure.
* 
*********************************************************************
#endcomment

proc configmaildoor
#ifndef MRUN211C
string changebbs
	FLAGS = (FLAGS & CLEARCMD) | QMD
	changebbs = makefullname(MailRunDir, "MRUN211C")
	callscript(changebbs)
#else
	changemaildoor()
#endif
endproc


#comment
*********************************************************************
* 
* ADDNEWBBS()
* 
* Calls checkchanged(), makefullname(), callscript()
* MRUN211C\changeuserinfo()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 
* Corresponds to the Add.New_BBS menu selection.  Calls the
* changebbs module for the changeuserinfo() procedure with 
* the NEW flag set.
* 
*********************************************************************
#endcomment

proc addnewbbs
#ifndef MRUN211C
string changebbs
#endif
	if checkchanged()
		FLAGS &= RUNNING
		FLAGS |= NEW
#ifndef MRUN211C
		FLAGS = (FLAGS & CLEARCMD) | USR
		changebbs = makefullname(MailRunDir, "MRUN211C")
		callscript(changebbs)
#else
		changeuserinfo()
#endif
	endif
endproc


#comment
*********************************************************************
* 
* ADDGETSEND()
* 
* Calls checkchanged(), checknew(), makefullname(), callscript()
* MRUN211F\addgetmail()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 
* Corresponds to the Add.Get/Send_Mail menu selection.  Calls
* the othercmds script module for the addgetmail() procedure.
* 
*********************************************************************
#endcomment

proc addgetsend
#ifndef MRUN211F
string othercmds
#endif
	if checkchanged() && checknew()
		FLAGS &= RUNNING
#ifndef MRUN211F
		FLAGS = (FLAGS & CLEARCMD) | AGM
		othercmds = makefullname(MailRunDir, "MRUN211F")
		callscript(othercmds)
#else
		addgetmail()
#endif
	endif
endproc


#comment
*********************************************************************
* 
* ADDDOWNLOAD()
* 
* Calls checkchanged(), checknew(), makefullname(), callscript()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 
* Corresponds to the Add.Download_File menu selection.  Calls
* the adddlfile script module.
* 
*********************************************************************
#endcomment

proc adddownload
#ifndef MRUN211D
string adddlfile
	if checkchanged() && checknew()
		FLAGS &= RUNNING
		adddlfile = makefullname(MailRunDir, "MRUN211D")
		callscript(adddlfile)
	endif
#endif
endproc


#comment
*********************************************************************
* 
* ADDUPLOAD()
* 
* Calls checkchanged(), checknew(), makefullname(), callscript()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	
* Corresponds to the Add.Upload_File menu selection.  Calls
* the addulfile script module.
* 
*********************************************************************
#endcomment

proc addupload
#ifndef MRUN211E
string addulfile
	if checkchanged() && checknew()
		FLAGS &= RUNNING
		addulfile = makefullname(MailRunDir, "MRUN211E")
		callscript(addulfile)
	endif
#endif
endproc


#comment
*********************************************************************
* 
* ADDSENDCMD()
* 
* Calls checkchanged(), checknew(), makefullname(), callscript(),
* MRUN211F\addsendcommand()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	
* Corresponds to the Add.Send_Command menu selection.  Calls
* the othercmds script module for the addsendcommand() procedure.
* 
*********************************************************************
#endcomment

proc addsendcmd
#ifndef MRUN211F
string othercmds
#endif
	if checkchanged() && checknew()
		FLAGS &= RUNNING
#ifndef MRUN211F
		FLAGS = (FLAGS & CLEARCMD) | CMD
		othercmds = makefullname(MailRunDir, "MRUN211F")
		callscript(othercmds)
#else
		addsendcommand()
#endif
	endif
endproc


#comment
*********************************************************************
* 
* ADDSCRIPT()
* 
* Calls checkchanged(), checknew(), makefullname(), callscript(),
* MRUN211F\adddoscript()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	
* Corresponds to the Add.Execute_Script menu selection.  Calls
* the othercmds script module for the adddoscript() procedure.
* 
*********************************************************************
#endcomment

proc addscript
#ifndef MRUN211F
string othercmds
#endif
	if checkchanged() && checknew()
		FLAGS &= RUNNING
#ifndef MRUN211F
		FLAGS = (FLAGS & CLEARCMD) | SCR
		othercmds = makefullname(MailRunDir, "MRUN211F")
		callscript(othercmds)
#else
		adddoscript()
#endif
	endif
endproc


#comment
*********************************************************************
* 
* EXECUTEMAILRUN()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	
* Corresponds to the Execute.Execute/Terminate_MailRun menu
* selection.
* 
*********************************************************************
#endcomment

proc executemailrun
#ifdef MRUN211G
	hangup
	FLAGS &= IDLE
	capture OFF
	exit
#else
	if FLAGS & RUNNING
		FLAGS &= IDLE
	else
		FLAGS |= RUNNING
	endif
#endif
endproc


#comment
*********************************************************************
* 
* EXECUTEARCHIVER()
* 
* Calls checktask()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 
* Corresponds to the Execute.Archiver menu selection.  Calls
* the archive utility specified in the MailRun Settings
* dialog.
* 
*********************************************************************
#endcomment

proc executearchiver
integer i
#ifndef MRUN211AB
string Archiver
#endif
	profilerd MailRun "MailRun" "Archiver" Archiver
	if not NULLSTR Archiver
		i = checktask(Archiver)
		if i
			activatetask i
		else
			run Archiver
		endif
		if FAILURE
			usermsg "Unable to run Archive Utility %s .`r`n\
The file does not exist or is not in your DOS path." Archiver
		endif
	else
		usermsg "You must specify an Archive Utility in`r`n\
the MailRun Settings dialog box."
	endif
endproc


#comment
*********************************************************************
* 
* EXECUTEQWKREADER()
* 
* Calls checktask()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 
* Corresponds to the Execute.QWK_Reader menu selection.  Calls
* the QWK mail reader specified in the MailRun Settings
* dialog.
* 
*********************************************************************
#endcomment

proc executeqwkreader
integer i
#ifndef MRUN211AB
string QWKReader
#endif
	profilerd MailRun "MailRun" "QWKReader" QWKReader
	if not NULLSTR QWKReader
		i = checktask(QWKReader)
		if i
			activatetask i
		else
			run QWKReader
		endif
		if FAILURE
			usermsg "Unable to run QWK Mail Reader %s.`r`n\
The file does not exist or is not in your DOS path." QWKReader
		endif
	else
		usermsg "You must specify a QWK Mail Reader in`r`n\
the MailRun Settings dialog box."
	endif
endproc


#comment
*********************************************************************
* 
* EXECUTELOGVIEWER()
* 
* Calls checktask(), makefullname()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 	
* Corresponds to the Execute.View_Log_File menu selection.  
* Calls the file viewer specified in the MailRun Settings
* dialog and loads the log file for the current mailrun.
* 
*********************************************************************
#endcomment

proc executelogviewer
string CapFile, RunLine, WinTitle
integer i, j
#ifndef MRUN211AB
string LogViewer
#endif
	profilerd MailRun "MailRun" "LogViewer" LogViewer
	if not NULLSTR LogViewer
		if not NULLSTR MailRunTrunc
			CapFile = makefullname(MailRunDir, MailRunTrunc)
			strlwr CapFile
			strreplace CapFile ".mrn" ".cap"
		else
			CapFile = ""
		endif
		i = checktask(LogViewer)
		if i
			taskwin i j
			getwintext j WinTitle
			if strfind WinTitle CapFile
				activatetask i
				return
			endif
		endif
		strfmt RunLine "%s %s" LogViewer CapFile
		run RunLine
		if FAILURE
			usermsg "Unable to run Log File Viewer %s.`r`n\
The file does not exist or is not in your DOS path." LogViewer
		endif
	else
		usermsg "You must specify a Log File Viewer in`r`n\
the MailRun Settings dialog box."
	endif
endproc


#comment
*********************************************************************
* 
* HELPCONTENTS()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 
* Corresponds to the Help.Contents menu selection.  Calls 
* the help file and displays the contents page.
* 
*********************************************************************
#endcomment

proc helpcontents
	help 1
endproc


#comment
*********************************************************************
* 
* HELPCONTEXT()
* 
* Called by:
* 	MRUN211H:  parsemenu(), parseobject()
* 
* Corresponds to the Help.On_current_window menu selection.
* Calls the help file and displays the page appropriate for
* the current dialog box.  HelpPage is a global variable set
* in each procedure that calls a dialog box.
* 
*********************************************************************
#endcomment

proc helpcontext
	help HelpPage
endproc


#comment
*********************************************************************
* 
* HELPABOUT()
* 
* Calls checkchanged(), makefullname(), callscript(),
* MRUN211F\showabout()
* 
* Called by:
* 	MRUN211H:  parsemenu()
* 	MRUN211A:  main()
* 
* Corresponds to the Help.About_MailRun menu selection.  Calls
* the othercmds script module for the showabout() procedure.
* 
*********************************************************************
#endcomment

proc helpabout
#ifndef MRUN211F
string othercmds
#endif
	if checkchanged()
		FLAGS &= RUNNING
#ifndef MRUN211F
		FLAGS = (FLAGS & CLEARCMD) | ABT
		othercmds = makefullname(MailRunDir, "MRUN211F")
		callscript(othercmds)
#else
		showabout()
#endif
	endif
endproc


#comment
*********************************************************************
* 
* CALLSCRIPT()
* 
* Calls menudim(), makemailrunlist(), makebbslist(),
* maketasklist(), getfirstitem(), MRUN211AG\mailrunbox(),
* MRUN211G\makequeue()
* 
* Called by:
* 	MRUN211H:  filenewmrun(), configmrun(), configbbs(),
* 				  configprompts(), configmaildoor(), addnewbbs(),
* 				  addgetsend(), adddownload(), addupload(),
* 				  addsendcmd(), addscript(), helpabout()
* 
* Executes the specified MailRun script module.
* 
*********************************************************************
#endcomment

proc callscript
strparm ScriptTitle
#ifndef MRUN211AG
	chain ScriptTitle
#else
string LastMRun
	LastMRun = MailRun
	execute ScriptTitle
	menudim()
	FLAGS &= RUNNING
#ifdef MRUN211G
	if !(FLAGS & RUNNING)
		;if the mailrun has been terminated from another script module...
		executemailrun()
	endif
	profilerd MailRun "MailRun" "LogRun" LogRun
	if LogRun
		profilerd MailRun "MailRun" "AnsiInLog" AnsiInLog
		if AnsiInLog
			set capture mode append RAW
		else
			set capture mode append VISUAL
		endif
		capture ON
	else
		capture OFF
	endif
	makequeue()
#else
	findfirst MailRun
	MailRunTrunc = $FILENAME
	makemailrunlist()
	makebbslist()
	if not strcmpi LastMRun MailRun
		getfirstitem()
	endif
#endif
	maketasklist()
	mailrunbox()
	statmsg ""
#endif
endproc



