VERSION 2.00
Begin Form frmmain 
   Caption         =   "Paperboy"
   ClientHeight    =   3804
   ClientLeft      =   864
   ClientTop       =   1932
   ClientWidth     =   7512
   ClipControls    =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   12
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4548
   Icon            =   FRMMAIN.FRX:0000
   Left            =   816
   LinkTopic       =   "Form1"
   ScaleHeight     =   3804
   ScaleWidth      =   7512
   Top             =   1236
   Width           =   7608
   Begin CommonDialog dlgFile 
      CancelError     =   -1  'True
      DialogTitle     =   "Open AREAS file"
      Filter          =   "Areas file|AREAS"
      Left            =   2880
      Top             =   720
   End
   Begin PictureBox pictext 
      ClipControls    =   0   'False
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Book Antiqua"
      FontSize        =   13.8
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2052
      Left            =   0
      ScaleHeight     =   2028
      ScaleWidth      =   7068
      TabIndex        =   3
      Top             =   1752
      Width           =   7092
   End
   Begin VScrollBar vsbtext 
      Height          =   1932
      Left            =   7200
      TabIndex        =   2
      Top             =   1800
      Value           =   1
      Width           =   252
   End
   Begin ListBox lstsubjects 
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   7.8
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1560
      Left            =   3600
      TabIndex        =   1
      Top             =   0
      Width           =   3852
   End
   Begin ListBox lstareas 
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   7.8
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1560
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   2532
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFOPEN 
         Caption         =   "&Open Areas..."
         Shortcut        =   ^O
      End
      Begin Menu mnubar1 
         Caption         =   "-"
      End
      Begin Menu mnusave 
         Caption         =   "&Save/Append Message..."
         Shortcut        =   ^S
      End
      Begin Menu mnuFPrint 
         Caption         =   "&Print Message"
         Shortcut        =   ^P
      End
      Begin Menu mnubar3 
         Caption         =   "-"
      End
      Begin Menu mnuFExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuedit 
      Caption         =   "&Edit"
      Begin Menu mnuECopy 
         Caption         =   "&Copy Message"
         Shortcut        =   ^C
      End
      Begin Menu mnurot13 
         Caption         =   "&Rot 13"
         Shortcut        =   ^X
      End
   End
   Begin Menu menumessage 
      Caption         =   "&Message"
      Begin Menu mnunewmail 
         Caption         =   "Send &New Mail..."
         Shortcut        =   ^N
      End
      Begin Menu mnureplymail 
         Caption         =   "Reply by &Mail..."
         Shortcut        =   ^R
      End
      Begin Menu mnubar4 
         Caption         =   "-"
      End
      Begin Menu mnuPostMsg 
         Caption         =   "Post New Message..."
         Shortcut        =   ^U
      End
      Begin Menu mnuFollowUp 
         Caption         =   "Post Follow&up..."
         Shortcut        =   ^F
      End
   End
   Begin Menu mnudisplay 
      Caption         =   "&Display"
      Begin Menu mnufonts 
         Caption         =   "&Fonts"
         Begin Menu mnugroups 
            Caption         =   "&Groups..."
         End
         Begin Menu mnusubjects 
            Caption         =   "&Subjects..."
         End
         Begin Menu mnumessage 
            Caption         =   "&Message Text..."
         End
         Begin Menu mnuprinter 
            Caption         =   "&Printer Text..."
         End
      End
      Begin Menu mnuration 
         Caption         =   "Screen &Ratio..."
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "&Help"
      Begin Menu mnuughbug 
         Caption         =   "Send &Bug Report..."
      End
      Begin Menu mnubar2 
         Caption         =   "-"
      End
      Begin Menu mnuHAbout 
         Caption         =   "&About..."
      End
   End
End
Option Explicit

Sub DisableMsgMenus ()
mnuFPrint.Enabled = False
mnuECopy.Enabled = False
mnureplymail.Enabled = False
mnurot13.Enabled = False
mnuFollowUp.Enabled = False
mnuPostMsg.Enabled = False
mnusave.Enabled = False
'mnu.Enabled = False

End Sub

Sub EnableMsgMenus ()
mnuFPrint.Enabled = True
mnuECopy.Enabled = True
mnureplymail.Enabled = True
mnurot13.Enabled = True
mnusave.Enabled = True
If Mid$(fixstr(GetAreaEncoding(group)), 3, 1) = "n" Then
    mnuFollowUp.Enabled = True
    mnuPostMsg.Enabled = True
End If
'mnu.Enabled = True

End Sub

Sub Form_Load ()
    DisableMsgMenus
    Form_resize
End Sub

Sub Form_resize ()
' Whenever form is resized, we need to scale all
' controls appropriately so they fill the new window
Dim horizpercent As Single, vertpercent As Single

    horizpercent = GetPrivateProfileInt("Window", "HPercent", 40, "paperboy.ini")
    vertpercent = GetPrivateProfileInt("Window", "VPercent", 30, "paperboy.ini")
    horizpercent = horizpercent / 100
    vertpercent = vertpercent / 100

    lstareas.Top = 0
    lstareas.Left = 0
    lstareas.Width = frmmain.ScaleWidth * horizpercent
    lstareas.Height = frmmain.ScaleHeight * vertpercent
    lstsubjects.Top = 0
    lstsubjects.Left = lstareas.Width
    lstsubjects.Height = lstareas.Height
    lstsubjects.Width = frmmain.ScaleWidth - lstareas.Width
    pictext.Left = 0
    pictext.Top = lstsubjects.Height
    pictext.Width = frmmain.ScaleWidth - vsbtext.Width
    pictext.Height = frmmain.ScaleHeight - lstsubjects.Height
    vsbtext.Left = pictext.Width
    vsbtext.Top = pictext.Top
    vsbtext.Height = pictext.Height
End Sub

Sub lstareas_Click ()
Dim which, result As Integer

    Screen.MousePointer = HourGlass
    lstsubjects.Clear
    lstsubjects.Enabled = False
    message = 0
    pictext.Cls
    pictext.Enabled = False
    vsbtext.Enabled = False
    group = lstareas.ListIndex + 1
    DisableMsgMenus
    If Mid$(fixstr(GetAreaEncoding(group)), 3, 1) = "n" Then
        mnuPostMsg.Enabled = True
        result = ThreadMsgs(group)
    End If
    For which = 1 To GetNumMsgs(group)
        lstsubjects.AddItem fixstr(GetSubject(group, which))

    Next which
    lstsubjects.Enabled = True
    Screen.MousePointer = NORMAL
    
End Sub

Sub lstsubjects_Click ()
Dim linesperscreen As Integer
Dim numremlines As Integer

    message = lstsubjects.ListIndex + 1
    GetMsg group, message
    pictext.Enabled = True
    pictext.Cls
    vsbtext.Enabled = True
    firstline = 1

    If GetNumLines() > 0 Then
        linesperscreen = pictext.Height \ pictext.TextHeight("This space for rent")
        vsbtext.LargeChange = linesperscreen
    
        While firstline < GetNumLines() And Len(fixstr(GetLine(firstline))) > 0
            firstline = firstline + 1
        Wend
        While firstline < GetNumLines() And Len(fixstr(GetLine(firstline))) = 0
            firstline = firstline + 1 'Skip the gap
        Wend
        
        numremlines = GetNumLines() - firstline + 3
        If numremlines <= linesperscreen Then
            vsbtext.Max = 0
            vsbtext_change
            'vsbtext.Enabled = False
        Else
            vsbtext.Max = numremlines - linesperscreen + 1
            If vsbtext.Value = 0 Then vsbtext_change Else vsbtext.Value = 0
        End If
        vsbtext.SetFocus
    Else
        vsbtext.Cls
    End If
    
EnableMsgMenus
If fixstr(GetHeader("Followup-To")) = "poster" Then mnuFollowUp.Enabled = False
If fixstr(GetHeader("Followup-To")) = "/dev/null" Then mnuFollowUp.Enabled = False
End Sub

Sub mnuECopy_Click ()
Dim lineno As Integer
Dim hold As String

    If message > 0 Then
        Screen.MousePointer = HourGlass
        clipboard.Clear
        hold = ""
        GetMsg group, message
        For lineno = 1 To GetNumLines()
            hold = hold + fixstr(GetLine(lineno)) + Chr(13) + Chr(10)
        Next lineno
        clipboard.SetText hold
        Screen.MousePointer = Default
    End If
End Sub

Sub mnuFExit_Click ()
    Dim result As Integer
    If windowstate = NORMAL Then
        ' Update size/position in INI file
        result = WritePrivateProfileString("Window", "Maximized", "N", "paperboy.ini")
        result = WritePrivateProfileString("Window", "Top", Str(Int(Top)), "paperboy.ini")
        result = WritePrivateProfileString("Window", "Left", Str(Int(Left)), "paperboy.ini")
        result = WritePrivateProfileString("Window", "Height", Str(Int(Height)), "paperboy.ini")
        result = WritePrivateProfileString("Window", "Width", Str(Int(Width)), "paperboy.ini")
    Else If windowstate = MAXIMIZED Then result = WritePrivateProfileString("Window", "Maximized", "Y", "paperboy.ini")
    End If

    result = WritePrivateProfileString("Fonts", "GroupsName", lstareas.FontName, "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "GroupsSize", Str(lstareas.FontSize), "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "SubjName", lstsubjects.FontName, "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "SubjSize", Str(lstsubjects.FontSize), "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "TextName", pictext.FontName, "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "TextSize", Str(pictext.FontSize), "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "PrinterName", PrinterFontName, "paperboy.ini")
    result = WritePrivateProfileString("Fonts", "PrinterSize", Str(PrinterFontSize), "paperboy.ini")

    frmmain.Hide     ' This should end sub main
End Sub

Sub mnuFollowUp_Click ()
Dim subj As String
    
    If fixstr(GetHeader("Followup-To")) <> "" Then
        mailsendto = fixstr(GetHeader("Followup-To"))
    Else
        mailsendto = fixstr(GetHeader("Newsgroups"))
    End If
    mailreferences = fixstr(GetHeader("Message-ID")) + " " + fixstr(GetHeader("References"))
    subj = fixstr(GetHeader("Subject"))
    If Left$(subj, 4) <> "Re: " Then subj = "Re: " & subj
    mailsubject = subj
    replytype = 2
    frmmail.Show 1
End Sub

Sub mnuFOPEN_Click ()
Dim Filename As String
Dim result As Integer

    Filename = Space(100)
    result = GetPrivateProfileString("Files", "AREAS", "AREAS.", Filename, 100, "PAPERBOY.INI")
    On Error Resume Next
    ChDir stripfilename(Filename)
    Err = 0
    dlgfile.Flags = OFN_FILEMUSTEXIST
    dlgfile.Filename = Filename
    dlgfile.DialogTitle = "Open AREAS File"
    dlgfile.Action = DLG_FILE_OPEN
    If Err = 0 Then 'Didn't press cancel
        Filename = dlgfile.Filename
        result = WritePrivateProfileString("Files", "AREAS", Filename, "PAPERBOY.INI")
        OpenAreas (Filename)
    End If
End Sub

Sub mnuFPrint_Click ()
Dim lineno As Integer
Dim hold As String
Dim author As String
Dim subject As String

    If message > 0 Then
        Screen.MousePointer = HourGlass

        printer.FontName = PrinterFontName
        printer.FontSize = PrinterFontSize
        
        subject = fixstr(GetSubject(group, message))
        author = fixstr(GetAuthor(group, message))
        author = extractusername(author) + " "
        printer.FontBold = True
        printer.CurrentX = (printer.ScaleWidth - printer.TextWidth(subject)) / 2
        printer.Print subject
        printer.FontBold = False
        printer.CurrentX = printer.ScaleWidth - printer.TextWidth(author)
        printer.Print author
        printer.Line -Step(printer.ScaleWidth, 0)
        printer.CurrentX = 0
        
        GetMsg group, message
        
        ' Print message text
        For lineno = firstline To GetNumLines()
            printer.Print Spc(1); fixstr(GetLine(lineno))
        Next lineno
        
        printer.CurrentX = 0
        printer.Line -Step(printer.ScaleWidth, 0)
        printer.CurrentX = 0
        printer.Print

        ' Print the headers small
        printer.FontSize = printer.FontSize - 4
        For lineno = 1 To firstline - 1
            printer.Print Spc(1); fixstr(GetLine(lineno))
        Next lineno
        
        printer.EndDoc
        Screen.MousePointer = Default
    End If

End Sub

Sub mnugroups_Click ()
    dlgfile.FontName = lstareas.FontName
    dlgfile.FontSize = lstareas.FontSize
    dlgfile.DialogTitle = "Group Font"
    dlgfile.Flags = CF_SCREENFONTS
    On Error Resume Next
    dlgfile.Action = DLG_FONT
    If Err = 0 Then
        lstareas.FontName = dlgfile.FontName
        lstareas.FontSize = dlgfile.FontSize
    End If
End Sub

Sub mnuHAbout_Click ()
    frmabout.Show 1
End Sub

Sub mnumessage_Click ()
    dlgfile.FontName = pictext.FontName
    dlgfile.FontSize = pictext.FontSize
    dlgfile.DialogTitle = "Message Text Font"
    dlgfile.Flags = CF_SCREENFONTS
    On Error Resume Next
    dlgfile.Action = DLG_FONT
    If Err = 0 Then
        pictext.FontName = dlgfile.FontName
        pictext.FontSize = dlgfile.FontSize
        pictext_paint
    End If
End Sub

Sub mnunewmail_Click ()
    mailreferences = ""
    mailsendto = ""
    mailsubject = ""
    replytype = 1
    frmmail.Show 1
End Sub

Sub mnuPostMsg_Click ()
    mailsubject = ""
    mailreferences = ""
    mailsendto = fixstr(GetAreaName(group))
    replytype = 2
    frmmail.Show 1
End Sub

Sub mnuprinter_Click ()
    dlgfile.FontName = PrinterFontName
    dlgfile.FontSize = PrinterFontSize
    dlgfile.DialogTitle = "Printer Font"
    dlgfile.Flags = CF_PRINTERFONTS
    On Error Resume Next
    dlgfile.Action = DLG_FONT
    If Err = 0 Then
        PrinterFontName = dlgfile.FontName
        PrinterFontSize = dlgfile.FontSize
    End If
End Sub

Sub mnuration_Click ()
    frmratio.Show 1
    Form_resize
End Sub

Sub mnureplymail_Click ()
Dim subj As String
    If Len(fixstr(GetHeader("Reply-To"))) > 2 Then
        mailsendto = fixstr(GetHeader("Reply-To"))
    Else
        mailsendto = fixstr(GetHeader("From"))
    End If
    subj = fixstr(GetHeader("Subject"))
    If Left$(subj, 4) <> "Re: " Then subj = "Re: " & subj
    mailsubject = subj
    mailreferences = fixstr(GetHeader("Message-ID")) + " " + fixstr(GetHeader("References"))
    replytype = 1
    frmmail.Show 1
End Sub

Sub mnurot13_Click ()
    Rot13Msg
    vsbtext_change
End Sub

Sub mnusave_Click ()
Static Filename As String   'Remember the filename
Dim fileno, lineno As Integer

    Filename = InputBox$("Enter Filename", "Save/Append message to file", Filename)
    If Filename <> "" Then
        Screen.MousePointer = HourGlass
        fileno = FreeFile
        Open Filename For Append As fileno
        GetMsg group, message
        For lineno = 1 To GetNumLines()
            Print #fileno, fixstr(GetLine(lineno))
        Next lineno
        Close fileno
        Screen.MousePointer = Default
    End If
End Sub

Sub mnusubjects_Click ()
    dlgfile.FontName = lstsubjects.FontName
    dlgfile.FontSize = lstsubjects.FontSize
    dlgfile.DialogTitle = "Subjects Font"
    dlgfile.Flags = CF_SCREENFONTS
    On Error Resume Next
    dlgfile.Action = DLG_FONT
    If Err = 0 Then
        lstsubjects.FontName = dlgfile.FontName
        lstsubjects.FontSize = dlgfile.FontSize
    End If
End Sub

Sub mnuughbug_Click ()
    mailreferences = ""
    mailsendto = "vart@eniac.seas.upenn.edu"
    mailsubject = "Paperboy 1.90 Bug Report"
    replytype = 1
    frmmail.Show 1
End Sub

Sub pictext_paint ()
    If message > 0 Then vsbtext_change Else Call ShowSplash
End Sub

Sub ShowSplash ()
Dim fonthold As Single
Dim fontcolor As Long

    pictext.Cls
    fonthold = pictext.FontSize
    fontcolor = pictext.ForeColor
    pictext.FontSize = pictext.FontSize * 5
    pictext.CurrentY = (pictext.ScaleHeight - pictext.TextHeight("Paperboy")) / 2
    pictext.CurrentX = (pictext.ScaleWidth - pictext.TextWidth("Paperboy")) / 2
    pictext.ForeColor = BUTTON_SHADOW
    pictext.Print "Paperboy"
    pictext.CurrentX = (pictext.ScaleWidth - pictext.TextWidth("Paperboy")) / 2
    pictext.CurrentY = (pictext.ScaleHeight - pictext.TextHeight("Paperboy")) / 2
    pictext.CurrentX = pictext.CurrentX - pictext.TextWidth("Paperboy") / 200
    pictext.CurrentY = pictext.CurrentY - pictext.TextWidth("Paperboy") / 200
    pictext.ForeColor = BUTTON_FACE
    pictext.Print "Paperboy"
    pictext.FontSize = fonthold
    pictext.CurrentX = (pictext.ScaleWidth - pictext.TextWidth("Version 1.90")) / 2
    pictext.Print "Version 1.90"
    pictext.ForeColor = fontcolor
End Sub

Sub vsbtext_change ()
Dim lineno As Integer
Dim Max As Integer
Dim previousy As Single
Dim blankline As String
Dim subject As String
Dim author As String

    pictext.Cls
    Max = intmin(GetNumLines() - firstline + 3, vsbtext.Value + vsbtext.LargeChange)

    For lineno = vsbtext.Value To Max
        If lineno > 2 Then
            pictext.Print Spc(1); fixstr(GetLine(lineno + firstline - 3))
        ElseIf lineno = 0 Then
            subject = fixstr(GetSubject(group, message))
            pictext.FontBold = True
            pictext.CurrentX = (pictext.Width - pictext.TextWidth(subject)) / 2
            pictext.Print subject
            pictext.FontBold = False
        ElseIf lineno = 1 Then
            author = fixstr(GetAuthor(group, message))
            author = extractusername(author) + " "
            pictext.CurrentX = pictext.Width - pictext.TextWidth(author)
            pictext.Print author
        ElseIf lineno = 2 Then
            pictext.Line -Step(pictext.Width, 0)
            pictext.CurrentX = 0
            'pictext.Print
        End If
    Next lineno
End Sub

Sub vsbtext_KeyPress (keyascii As Integer)
    If message > 0 Then
        If keyascii = 32 Then
            'space pressed
            If vsbtext.Value >= vsbtext.Max Then
                If lstsubjects.ListIndex >= (lstsubjects.ListCount - 1) Then
                    'Next group
                    If lstareas.ListIndex < (lstareas.ListCount - 1) Then
                            lstareas.ListIndex = lstareas.ListIndex + 1
                            If lstsubjects.ListCount > 0 Then lstsubjects.ListIndex = 0
                    Else
                            'Do nothing (end of groups)
                            lstareas.ListIndex = lstareas.ListIndex
                    End If
                Else
                    'Next message
                    lstsubjects.ListIndex = lstsubjects.ListIndex + 1
                End If
            Else
                ' Page down
                If vsbtext.Value + vsbtext.LargeChange >= vsbtext.Max Then vsbtext.Value = vsbtext.Max Else vsbtext.Value = vsbtext.Value + vsbtext.LargeChange
            End If
        End If 'space

        If keyascii = Asc("n") Or keyascii = Asc("N") Then
            ' Next message
            If lstsubjects.ListIndex >= (lstsubjects.ListCount - 1) Then
                'Next group
                If lstareas.ListIndex < (lstareas.ListCount - 1) Then
                        lstareas.ListIndex = lstareas.ListIndex + 1
                        If lstsubjects.ListCount > 0 Then lstsubjects.ListIndex = 0
                Else
                        'Do nothing (end of groups)
                        lstareas.ListIndex = lstareas.ListIndex
                End If
            Else
                'Next message
                lstsubjects.ListIndex = lstsubjects.ListIndex + 1
            End If
        End If ' N or n
    End If ' message > 0

End Sub

Sub vsbtext_Scroll ()
    vsbtext_change
End Sub

