Option Explicit
' Global variables
Global group As Integer
Global message As Integer
Global firstline As Integer
Global PrinterFontName As String
Global PrinterFontSize As Integer
Global mailsendto As String
Global mailsubject As String
Global mailreferences As String
Global replytype As Integer '1=mail, 2=news

' Windows API used by program
Declare Function GetWinFlags Lib "Kernel" () As Long
Global Const WF_CPU286 = &H2
Declare Function GetProfileInt% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%)
Declare Function GetProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%)
Declare Function WriteProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpString$)
Declare Function GetPrivateProfileInt% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$)
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpreturned$, ByVal nSize%, ByVal lpFileName$)
Declare Function WritePrivateProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpString$, ByVal lpFileName$)
Declare Function lstrcpy Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long

' Paperboy/SOUP support DLL API
Global Const ERRMEM = 10
Global Const ERRIO = 20
Global Const ERRPARSE = 30

Declare Function MajorVersion% Lib "PBOYSOUP.DLL" ()
Declare Function MinorVersion% Lib "PBOYSOUP.DLL" ()
Declare Function VersionDesc Lib "PBOYSOUP.DLL" () As Long
Declare Function LoadAreas Lib "PBOYSOUP.DLL" (ByVal fname As String) As Integer
Declare Function GetNumAreas Lib "PBOYSOUP.DLL" () As Integer
Declare Function GetAreaName Lib "PBOYSOUP.DLL" (ByVal index As Integer) As Long
Declare Function GetAreaEncoding Lib "PBOYSOUP.DLL" (ByVal index As Integer) As Long
Declare Function GetAreaDesc Lib "PBOYSOUP.DLL" (ByVal index As Integer) As Long
Declare Function GetNumMsgs Lib "PBOYSOUP.DLL" (ByVal index As Integer) As Integer
Declare Function ThreadMsgs Lib "PBOYSOUP.DLL" (ByVal index As Integer) As Integer
Declare Function GetSubject Lib "PBOYSOUP.DLL" (ByVal index As Integer, ByVal index2 As Integer) As Long
Declare Function GetAuthor Lib "PBOYSOUP.DLL" (ByVal index As Integer, ByVal index2 As Integer) As Long
Declare Function GetNumLines Lib "PBOYSOUP.DLL" () As Integer
Declare Function GetLine Lib "PBOYSOUP.DLL" (ByVal lineno As Integer) As Long
Declare Function GetInfo Lib "PBOYSOUP.DLL" () As Integer
Declare Function Post Lib "PBOYSOUP.DLL" (ByVal fname As String, ByVal sendtype As Integer) As Integer
Declare Function GetHeader Lib "PBOYSOUP.DLL" (ByVal header As String) As Long
Declare Function GetGMTime Lib "PBOYSOUP.DLL" () As Long
Declare Sub GetMsg Lib "PBOYSOUP.DLL" (ByVal index1 As Integer, ByVal index2 As Integer)
Declare Sub Rot13Msg Lib "PBOYSOUP.DLL" ()

Function extractusername (from As String) As String
Dim username As String
Dim pos As Integer

    username = Trim(from) 'Remove leading and trailing spaces

' First type is of foo@bad.edu (john q. public)
    If InStr(username, "(") > 0 Then
        pos = InStr(username, "(")
        ' Remove everything before (, up to )
        username = Mid$(username, pos + 1)
        username = Left$(username, InStr(username, ")") - 1)
    ElseIf InStr(username, Chr(34)) > 0 Then
    ' foo@bad.edu "john q. public"
        pos = InStr(username, Chr(34))
        username = Mid$(username, pos)
        ' Truncate past second quote
        username = Left$(username, InStr(username, Chr(34)) - 1)
    ElseIf InStr(username, "<") > 0 Then
    ' John Q. Public <foo@bad.edu>
        pos = InStr(username, "<")
        username = Left$(username, pos - 1)
    ElseIf InStr(username, "@") > 0 Then
    ' worst-case, john@bad.edu
        pos = InStr(username, "@")
        username = Left$(username, pos - 1)
    End If
    
    ' If parsing gave us nothing, punt
    username = Trim(username)
    If Len(username) = 0 Then username = from
    extractusername = username
End Function

Function fixstr (ByVal az As Long) As String
Dim tempstr As String
Dim z As Integer

If az <> 0 Then
    tempstr = Space$(250)
    az = lstrcpy(tempstr, az)
    z = InStr(tempstr, Chr(0)) 'Chop off null-terminator
    If z > 0 Then tempstr = Left$(tempstr, z - 1)
    fixstr = tempstr
Else fixstr = ""
End If
End Function

Function intmax (ByVal a As Integer, ByVal b As Integer) As Integer
    If a >= b Then intmax = a Else intmax = b
End Function

Function intmin (ByVal a As Integer, ByVal b As Integer) As Integer
    If a <= b Then intmin = a Else intmin = b
End Function

Sub Main ()
    Dim cputype As Long
    Dim lpstr As Long
    Dim result As Integer
    Dim hold As String * 100

    ' Check for CPU > 286
    cputype = GetWinFlags()
    If cputype And WF_CPU286 Then
        ' Paperboy DLL will probably use 386 instructions in the near future, warn user now
        MsgBox "Your computer is not be powerful enough for Paperboy", MB_OK + MB_ICONSTOP, "Warning!"
    End If
    
    result = GetPrivateProfileString("Window", "Maximized", "N", hold, 3, "PAPERBOY.INI")
    If Left$(hold, 1) = "N" Then
        frmmain.WindowState = NORMAL
    Else
        frmmain.WindowState = MAXIMIZED
    End If

    ' Load in INI file settings
    frmmain.Height = GetPrivateProfileInt("Window", "Height", screen.Height * .9, "paperboy.ini")
    frmmain.Width = GetPrivateProfileInt("Window", "Width", screen.Width * .9, "paperboy.ini")
    frmmain.Left = GetPrivateProfileInt("Window", "Left", (screen.Width - frmmain.Width) \ 2, "paperboy.ini")
    frmmain.Top = GetPrivateProfileInt("Window", "Top", (screen.Height - frmmain.Height) \ 2, "paperboy.ini")
    
    result = GetPrivateProfileString("Fonts", "GroupsName", "Arial", hold, 80, "PAPERBOY.INI")
    frmmain!lstareas.FontName = hold
    result = GetPrivateProfileString("Fonts", "GroupsSize", "10", hold, 80, "PAPERBOY.INI")
    frmmain!lstareas.FontSize = Val(hold)
    result = GetPrivateProfileString("Fonts", "SubjName", "Arial", hold, 80, "PAPERBOY.INI")
    frmmain!lstsubjects.FontName = hold
    result = GetPrivateProfileString("Fonts", "SubjSize", "10", hold, 80, "PAPERBOY.INI")
    frmmain!lstsubjects.FontSize = Val(hold)
    result = GetPrivateProfileString("Fonts", "TextName", "Arial", hold, 80, "PAPERBOY.INI")
    frmmain!pictext.FontName = hold
    result = GetPrivateProfileString("Fonts", "TextSize", "12", hold, 80, "PAPERBOY.INI")
    frmmain!pictext.FontSize = Val(hold)
    result = GetPrivateProfileString("Fonts", "PrinterName", "Arial", hold, 80, "PAPERBOY.INI")
    PrinterFontName = hold
    result = GetPrivateProfileString("Fonts", "PrinterSize", "12", hold, 80, "PAPERBOY.INI")
    PrinterFontSize = Val(hold)

    ' If command-line, assume it's the AREAS filename
    If Len(Command$) > 1 Then
        OpenAreas (Command$)
    End If

    frmmain.Show Modal
    ' frmmain has quit, shut down
    End
End Sub

Sub OpenAreas (filename As String)
Dim result, count As Integer
Dim group As String

    frmmain.lstareas.Clear
    frmmain.lstareas.Enabled = False
    screen.MousePointer = HourGlass
    ' We expect LoadAreas to chdir into the packet's directory as well
    result = LoadAreas(filename)
    screen.MousePointer = Default
    
    'Remove BMP
    frmmain!pictext.Picture = LoadPicture()

    If result = ERRMEM Then
        MsgBox "Out of Memory", MB_OK + MB_ICONSTOP, "Error"
    End If
    If result = ERRIO Then
        MsgBox "File problem", MB_OK + MB_ICONSTOP, "Error"
    End If
    If result = ERRPARSE Then
        MsgBox "Incompatible file format", MB_OK + MB_ICONSTOP, "Error"
    End If
    If GetInfo() = 0 Then
        ' We got something urgent to show
        frminfo.Show 1
    End If
    If result = 0 Then
        For count = 1 To GetNumAreas()
            group = fixstr(GetAreaName(count))
            'If Left(fixstr(GetAreaEncoding(count)), 1) = "u" Then frmmain.lstareas.AddItem group
            frmmain.lstareas.AddItem group
        Next count
        frmmain.lstareas.Enabled = True
    End If
End Sub

Function stripfilename (filename As String) As String
Dim lastbackslash, p As Integer

    For p = 1 To Len(filename)
        If Mid$(filename, p, 1) = "\" Then lastbackslash = p
    Next p
    
    If lastbackslash > 1 Then
        stripfilename = Left$(filename, lastbackslash - 1)
    Else
        stripfilename = "\"
    End If
End Function

