/*      post.c -- mechanisms for posting mail/news
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@eniac.seas.upenn.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <ctype.h>
#include <direct.h>
#include <sys\types.h>
#include <sys\timeb.h>
#include "soup.h"
#include "error.h"
#include "areas.h"

extern char * packetpath;	/* base directory for files */

static char datebuf[128];

char *  DLLFUNC UnixDate (void)
{
    time_t ltime;
    struct tm *gmt;

    /* Get UNIX-style time and display as number and string. */
    time( &ltime );
    
    gmt = gmtime( &ltime );
    
    
    /* strftime (datebuf, 128, "%a, %d %b %y %H:%M:%D GMT", gmt); */
    
    return datebuf;
}

int		DLLFUNC Post (char * fname,  int type)
/* fname should be FNAME.MSG */
{
	FILE * fin, * fout;
	int result;
	unsigned long length;
	unsigned char c;
	char * p;

	/* Rename fname to TMPFILE, recopy onto fname sans CR */

	assert (packetpath!=NULL);
	assert (fname!=NULL);
	assert (type==POSTMAIL || type==POSTNEWS);

	if (packetpath!=NULL)
		_chdir(packetpath);	/* If a path is available, use it, otherwise do current directory */

	result=rename(fname,TMPFILE);
	if (result!=0) return ERRIO;

	fin=fopen(TMPFILE,"rb");
	if (fin==NULL) return ERRIO;

	fout=fopen(fname,"wb");	
	if (fout==NULL) return ERRIO;

	fputc(00,fout);	/* Temporary write 0x00000000 as length */
	fputc(00,fout);
	fputc(00,fout);
	fputc(00,fout);

	/* Recopy file, stripping Carriage-return characters for Unix */
	while (!feof(fin))
	{
		result=getc(fin);
		if (result!=CRCHAR && result!=EOF) putc(result,fout);
	}

	fclose(fin);
	remove(TMPFILE);		/* Nuke the temporary file */
	length=ftell(fout)-4;	/* Correct for four length bytes at beginning */

	/* Write new length */
	rewind(fout);
	c=(unsigned char)length  / (256L*256L*256L);
	fputc(c,fout);
	c=(unsigned char)length / (256L*256L);
	fputc(c,fout);
	c=(unsigned char)length / 256;
	fputc(c,fout);
	c=(unsigned char)length;
	fputc(c,fout);

	fclose(fout);

	/* Append to REPLIES */
	fout=fopen(REPLYFILE,"a");

	p=strchr(fname,'.');	/* Strip off .MSG to make a prefix */
	assert (p!=NULL);
	*p='\0';

	fprintf(fout,"%s\t",fname);
	if (type==POSTMAIL)
		fprintf(fout,"mail\tBn");
	if (type==POSTNEWS)
		fprintf(fout,"news\tbn");
	fputc(LFCHAR,fout);

	fclose (fout);
}

char * DLLFUNC GetGMTime (void)
{
static char timebuf[40];
struct tm * now;
time_t zulu;
	
	time(&zulu);
	now=gmtime(&zulu);
	
	wsprintf (timebuf,"%s, %d %s %d %d:%d:%d GMT",
		dayofweek[now->tm_wday], now->tm_mday, months[now->tm_mon], now->tm_year, 
		now->tm_hour, now->tm_min, now->tm_sec);
		
	return timebuf;
}