/*      structs.h -- Basic data structures
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@eniac.seas.upenn.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Basic data structures for Paperboy SOUP DLL */

#ifndef HSTRUCTS
#define HSTRUCTS

#include <time.h>

#define MSGMAGIC	0xDEDEDEDEL
#define AREAMAGIC	0xBABABABAL

struct lltext
{
	struct lltext * next;	/* Pointer to next element in linked-list */
	char * text;			/* Line of text */
};



struct llmsg
{
	long magic;				/* Sanity check magic number */
	struct llmsg * next;	/* Pointer to next element in linked-list */
	long start;				/* Position in file of start */
	long length;			/* Length of message */
	char * subject;			/* Subject of message */
	char * author;			/* Author of message */
	char * date;			/* Date message was posted */
	time_t idate;			/* Date in machine form */
};

struct llareas
{
	long magic;				/* Sanity check magic number */
	struct llareas * next;	/* Pointer to next element in linked-list */
	char * name;			/* Name of area */
	char * prefix;			/* Name of .MSG file containing messages */
	char encoding[4];		/* Encoding of message area */
	char * desc;			/* Description of message areas */
	struct llmsg * head;		/* Top of messages list for this area */
};
#endif
