/*      thread.c -- Threads messages for easier perusal
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@eniac.seas.upenn.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "error.h"
#include "soup.h"
#include "structs.h"
#include "msgs.h"
#include "areas.h"
#include "thread.h"

struct llmsg ** hold;

static int comparemsg (const void * m1, const void * m2)
{
	struct llmsg * msg1, * msg2;
	struct llmsg ** p;
	char * subj1, * subj2;
	int comp;

	p=NULL;
	msg1=NULL;
	msg2=NULL;
	subj1=NULL;
	subj2=NULL;
	
	assert(m1!=NULL);
	assert(m2!=NULL);
	p=(struct llmsg **)m1;
	msg1=(struct llmsg *)*p;
	p=(struct llmsg **)m2;
	msg2=(struct llmsg *)*p;
	
	/* I've had loads of trouble debugging this routine, can't you tell ? */
	assert(msg1->magic==MSGMAGIC);	
	assert(msg2->magic==MSGMAGIC);
	assert(msg1!=NULL);
	assert(msg2!=NULL);
	subj1=msg1->subject;
	subj2=msg2->subject;
	assert(subj1!=NULL);
	assert(subj2!=NULL);
	assert(strlen(subj1)>0);
	assert(strlen(subj2)>0);

    if (subj1==subj2) return 0; /* They're the same subject alright! */
	
	/* Remove leading RE: to get down to a basic subject */
	while (_strnicmp(subj1,REPLYSTR,strlen(REPLYSTR)) ==0) 
	{
		subj1+=strlen(REPLYSTR);
	}

	while (_strnicmp(subj2,REPLYSTR,strlen(REPLYSTR)) ==0) 
	{
		subj2+=strlen(REPLYSTR);
	}
	
	comp=strcmp(subj1,subj2);
		
	if (comp==0)    /* base subjects are same, sort by date */
	{
		if (msg1->idate < msg2->idate) return -1;
		if (msg1->idate > msg2->idate) return 1;
	}

	return comp;
}

int DLLFUNC ThreadMsgs (int index)
{
	struct llareas * area;
	struct llmsg * msghead;
	int nummsg;
	int pt;
 
	assert(index>0);
	assert(index<=GetNumAreas());
	area=findarea(index);
	
	assert(area!=NULL);

	nummsg=GetNumMsgs(index);
	
	assert(nummsg!=0);

	/* We create an array large enough to hold pointers to all messages */
	hold=(struct llmsg **)malloc(sizeof(struct llmsg *) * nummsg);
	if (hold==NULL) return ERRMEM;
	memset(hold, 0, sizeof(struct llmsg *) * nummsg );

	/* Now stuff pointers to each element into the array */
	msghead=area->head;
	assert(msghead!=NULL);
	
	for (pt=0; pt<nummsg; pt++)
	{   
		assert(msghead!=NULL);                     
		assert(msghead->magic==MSGMAGIC);
		hold[pt]=msghead;
		msghead=msghead->next;
	}
    
	assert(pt==nummsg);

	/* Sort the array */
	qsort(hold, nummsg, sizeof(struct llmsg *), comparemsg);

	/* Reassemble the linked list */
	area->head=hold[0];

	for (pt=0; pt<nummsg-1; pt++)
		hold[pt]->next=hold[pt+1];

	hold[pt]->next=NULL;    /* End of list */

	free(hold);
	return 0;
}
