//===========================================================
// THINDISK.H -- Header File 
// Copyright (c) 1994 Douglas Boling
//===========================================================
// Equates used by program
#define MAXCOUNT          32767
//#define MAXCOUNT          16384
#define MAXFNAMELEN       256
#define SORTTYPES         4
#define FUNCTYPES         3
#define MAXINCSPECS       8

#define DOSERROFFSET      16
#define ERR_CANCELED      -1
#define ERR_OUTOFMEM      -2
#define ERR_TOOMANYFILES  -3
#define ERR_TOODEEP       -4
#define ERR_DISKFULL      -5
#define ERR_NAMETOOLONG   -6
#define ERR_BADNAME       -7 
#define ERR_BADSIZE       -8 
#define ERR_BADDATE       -9 

#define SHOW_SIZE         1
#define SHOW_DATE         2
#define SHOW_ATTRIB       4
#define SHOW_PATH         8

#define SCRN_BAE          0x0003
#define SCRN_SIZEB        0x0004
#define SCRN_NAME         0x0008
#define SCRN_SIZE         0x0010
#define SCRN_DATE         0x0020
#define SCRN_ATTRS        0x0040
#define SCRN_INCEMPTYDIRS 0x0080
#define SCRN_INCDIRS      0x0100

#define DLG_FIND          0x2000
#define DLG_INCLUDE       0x4000
#define DLG_INCLUDEEDIT   0x8000

#define ATTR_SELECTED     0x40
#define ATTR_DELETED      0x80
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#define WIN16     TRUE
//#define WIN31

#define INT       int
#define UINT      WORD
#define APIENTRY  PASCAL
#define WNDPROC   FARPROC


struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
LONG CALLBACK LBoxSCProc(HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyWritePrivateProfileInt (char *, char *, int, int, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
INT MyCopyFile (char *, char *);
//
// Data types needed for program
//
typedef struct {
	UINT selNext;
	UINT usEnd;
	UINT usSize;
} BUFFHDR;
typedef BUFFHDR far *LPBUFFHDR;

typedef struct {
	LPVOID lpParent;
	BYTE ucAttrib;                           // The remainder of this structure
	UINT usTime;                             // must match the C file search 
	UINT usDate;                             // structure.
	LONG lSize;
	char szName[13];
} MYDIRENTRY;	   
typedef MYDIRENTRY far * LPMYDIRENTRY;
typedef LPMYDIRENTRY huge * LPLPMYDIRENTRY;

typedef DWORD huge *HPDWORD;

typedef struct {
	char szSpecName[SPECNAMELEN];
	char szFileSpec[15];
	UINT usIncFlags;
	UINT usIncDate;
	LONG lIncSize;
	UINT fScrnFlags;
} INCSPEC;
typedef INCSPEC * PINCSPEC;
typedef INCSPEC far * LPINCSPEC;
typedef INT (*SORTFUNC) (LPVOID, LPVOID);
typedef SORTFUNC *PSORTFUNC;
typedef INT (*FILEFUNC) (LPMYDIRENTRY, char *, char *, char *);

typedef struct find_t FIND_T;
typedef struct DOSERROR DOSERR;
//
// Program specific prototypes
//
// Dialog functions
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK RefreshDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK MoveCopyDelDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK IncFilesDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK IncludeDelDlgProc (HWND, UINT, UINT, LONG);
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoInitMenuMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoSetFocusMain (HWND, UINT, UINT, LONG);
LONG DoDrawItemMain (HWND, UINT, UINT, LONG);
LONG DoMeasureItemMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainMenuRefresh (HWND, UINT, HWND, UINT);
LONG DoMainMenuMCD (HWND, UINT, HWND, UINT);
LONG DoMainMenuExit (HWND, UINT, HWND, UINT);
LONG DoMainMenuFind (HWND, UINT, HWND, UINT);
LONG DoMainMenuInvert (HWND, UINT, HWND, UINT);
LONG DoMainMenuShow (HWND, UINT, HWND, UINT);
LONG DoMainMenuSort (HWND, UINT, HWND, UINT);
LONG DoMainMenuInclude (HWND, UINT, HWND, UINT);
LONG DoMainMenuIncludeEdit (HWND, UINT, HWND, UINT);
LONG DoMainMenuIncludeDel (HWND, UINT, HWND, UINT);
LONG DoMainMenuIncludeSet (HWND, UINT, HWND, UINT);
LONG DoMainMenuAbout (HWND, UINT, HWND, UINT);
// Utility function prototypes
INT AddIncSet (HWND, PINCSPEC);
void Date2asc (UINT, UINT, char *);
void Attr2asc (BYTE, char *);
void CreatePath (LPMYDIRENTRY, char *, int *);
void DisplayCurrStatus (HWND);
INT GetIncludedFiles (HWND);
HGLOBAL GetIncludedSet (LPMYDIRENTRY, INT *);
BOOL ScreenFile (LPMYDIRENTRY, LPINCSPEC);
INT MyQSort (LPVOID, UINT, PSORTFUNC);
BOOL MyYield (void);
void InvertIndex (HPDWORD, UINT);
INT SortName (LPVOID, LPVOID);
INT SortExt (LPVOID, LPVOID);
INT SortSize (LPVOID, LPVOID);
INT SortDate (LPVOID, LPVOID);
INT SortPath (LPVOID, LPVOID);
INT ScanDisk (HWND, LPMYDIRENTRY, INT);
INT ScanMachine (HWND, INT, INT *);
INT CopyFile (LPMYDIRENTRY, char *, char *, char *);
INT DeleteFile (LPMYDIRENTRY, char *, char *, char *);
INT MoveFile (LPMYDIRENTRY, char *, char *, char *);
void FillLB (HWND, INT);
void PrintError (HWND, INT);
//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"
#define     PRO_XSIZE     "WinSizeX"
#define     PRO_YSIZE     "WinSizeY"

#define     PRO_INCCNT    "IncCount"
#define     PRO_SPECNAME  "SpecName"
#define     PRO_FILESPEC  "FileSpec"
#define     PRO_INCSIZE   "IncSize"
#define     PRO_INCDATE   "IncDate"
#define     PRO_INCFLAGS  "IncFlags"
#define     PRO_SCRNFLAGS "ScrnFlags"
//
// Resource Identifiers
//
#define     MENU_VIEW        2
#define     MENU_INCLUDE     3

#define     IDD_FLIST        100
#define     IDD_FSCROLL      101

#define     IDM_REFRESH      200
#define     IDM_OPEN	     201
#define     IDM_COPY	     202           //Keep copy move and delete in order
#define     IDM_MOVE	     203
#define     IDM_DELETE	     204
#define     IDM_EXIT	     205

#define     IDM_FIND         210
#define     IDM_FINDNEXT     211
#define     IDM_FINDPREV     212

#define     IDM_SORTUPDN     221
#define     IDM_SORTNAME     222           //Keep sort and show IDs in this order
#define     IDM_SORTEXT      223
#define     IDM_SORTSIZE     224
#define     IDM_SORTDATE     225
#define     IDM_SORTPATH     226
#define     IDM_SHOWSIZE     227
#define     IDM_SHOWDATE     228
#define     IDM_SHOWATTRIB   229
#define     IDM_SHOWPATH     230

#define     IDM_INCLUDE      240
#define     IDM_INCLUDEDEL   241
#define     IDM_INCLUDEEDIT  242
#define     IDM_INCLUDEALL   243           //Leave 7 numbers above this ID free

#define     IDM_ABOUT	     260

#define     IDD_SPECNAME     300
#define     IDD_CHKFSPEC     301
#define     IDD_FSPEC	     302
#define     IDD_CHKFSIZE     303
#define     IDD_FSIZE	     304
#define     IDD_FSIZEUP	     305
#define     IDD_FSIZEDN	     306
#define     IDD_CHKFDATE     307
#define     IDD_FDATE	     308
#define     IDD_FDATEB	     309
#define     IDD_FDATEA	     310
#define     IDD_FDATEO	     311
#define     IDD_CHKFATTRS    312
#define     IDD_CHKFARDONLY  313
#define     IDD_CHKFAARCH    314
#define     IDD_CHKFAHIDDEN  315
#define     IDD_CHKFASYSTEM  316
#define     IDD_INCDIRS      317
#define     IDD_INCEMPTYDIRS 318
#define     IDD_SAVEAS       319

#define     IDD_REFRESHTEXT  400
#define     IDD_DRVLIST      401
#define     IDD_REFRESH      402

#define     IDD_COPYTEXT     500
#define     IDD_FILELIST     501
#define     IDD_DESTPATH     502

#define     IDD_INCLIST      530

#define     IDD_PROGSTR      600



