/*

Written By:	Earl W. Hartsell

Date:		8 - 16 - 92

Name:		WINDERS

Version:    	2.2

Use:		WINDERS allows the user to choose to automatically run
		Windows or exit to DOS upon startup or reboot.
		It allows the user to specify a length of time to
		countdown before Windows 3.X is loaded.
		Windows may be loaded before the countdown
 		is complete by pressing one of the modifier keys
		([SHIFT], [ALT], or [CTRL]), the user may also
		exit to DOS pressing any other key.

The syntax for the command is as follows:

d:\<path>\WINDERS [num] [/A <args>] [/B] [/D <d:>] [/I] [/P] [/N <filename>] [/W]
d:\<path>\WINDERS /H
d:\<path>\WINDERS /V
d:\<path>\WINDERS /?

d:\<path>\ 	is drive and directory path where WINDERS executable is
		located.

num 		is length of pause before loading windows.  It must be
		first argument and may be range of 1 to 32767 in seconds.
		The default pause is 5 seconds.  0 seconds defaults to 5.

/A <args>	are the arguments to be passed to windows. The arguments are
		not optional and will generate an error if not found after
		the /a. There also must be a space between the /a and the
		<args> and multiple arguments must be placed inside
		quotes.  If you have problems getting this to work
                try using full path names on the executables.

/B		beep on countdown, default no beep.


/D <d:>         is to specify drive in where WINDOWS is located.
		The default is C:.

/P <path>       If executable file to start WINDOWS is not in \WINDOWS\ use
		this option to specify the path.
		Examples:

		\DIR1\DIR2\...\DIRn\WINDOWS\
		\WIN\  If WINDOWS is in a directory called WIN.

		NOTE: The final back-slash on the path is required.

/N <filename>   Used to specify the name of the file to be executed
		if it is not WIN.COM.
		Example:
		   Use /N WINDERS.BAT  if you want to execute a batch file
		   before entering windows.
		   This would be an easy way to disable a DOS screen saver
		   before starting Windows.
		   (See WINDERS.BAT)
		Note: If you change the name a new shell will 
		and the batch file will run from that shell which is
		not as efficient memory efficient as running 
		WIN.COM directly.

/I 		suppress loading Windows into screen. Default show intro screen.

/H or /?	help screen.

/V		prints out version information.

/W		supress display of WINDERS countdown banner.


Copyright (c)1992 By Earl W. Hartsell
This is a Freeware program.

Windows is a registered trademark of Microsoft Corporation.

*/


#include "winders.h"

struct text_info ti;

int main(argc, argv)
int argc;
char *argv[];
{
  int  i = 0, k = 0, j = 0;             /* counters */
  int  pause = 5;		        /* default pause */

  char w_banner = 1;                    /* print banner flag */
  char beep = 0;		        /* set default beep off */
  char buffer[100]; 		        /* buffer for sprintf */
  char show_intro = 1;			/* turn intro screen off */
  char name_changed = 0;

  char drive[3], path[256], name[16], args[256];

  time_t start, new;			/* long int */


  fflush(stdin); 			/* clear the kbd buffer */

  NIL(args);                            /* clear out arguments to WINDOWS */

  strcpy(drive,"C:");     		/* default drive C: */
  strcpy(path,"\\WINDOWS\\");           /* default directory */
  strcpy(name,"WIN.COM");               /* default executable */

  if (atoi(argv[1]) > 0)  		/* take first argument as number */
  {
    j = 2; 
    pause = atoi(argv[1]);
  }
  else
  {
   j = 1;
    pause = 5;         			/* set default pause to 5 seconds. */
  }
  for (; j < argc; j++)
  {
    switch (argv[j][1])
    { 

     /* arguments */
      case 'a': case 'A':
	if ( argv[j+1] == NULL || argv[j+1][0] == '/' )
	{
	  argerror(argv[0], "A" , 0);
	  /* Error no argument found */
	}
	else
	{
	  strcpy(args, argv[++j]); /* pass arguments */
	}
      break;
      /* arguments */

      /* beep */
      case 'b': case 'B':
	beep = 1;  /* set beep on */
      break;
      /* beep */

      /* drive */
      case 'd': case 'D':
	if ( argv[j+1] == NULL || argv[j+1][0] == '/' )
	{
	  argerror(argv[0], "D" , 0);
	  /* error no argument found */
	}
	else
	{
	  strcpy(drive, argv[++j]); /* pass arguments */
	}
      break;
      /* drive */

      /* help screen */
      case 'h': case 'H': case '?':
	highvideo();
	printf("\n");
	center("WINDERS HELP  VERSION 2.2\r\n\r\n");
	lowvideo();
	center("Copyright (c)1992 By Earl W. Hartsell\r\n");
	center("This is a Freeware program.\r\n");
	printf("%s [num] [/A <args>] [/B] [/D <d:>] [/P <path>] [/N] [/I] [/W]\n",argv[0]);
	printf("%s /V or /H or /?\n",argv[0]);
	printf("num is duration of countdown, default is 5 seconds.\n");
	printf("Num must be the first argument to WINDERS.\n");
	printf("/A  is the argument(s) to be passed to Windows.\n");
	printf("/B  causes beeping during countdown.\n");
	printf("/D  drive where windows is located, C: is the default.\n");
	printf("/P  path to Windows, default \\WINDOWS\\ \n");
	printf("/N  used to specify the filename of Windows executable, default WIN.COM\n");
	printf("/I  suppresses showing Windows intro screen.\n");
	printf("/H  or /? to print out this screen.\n");
	printf("/V  display WINDERS version and copyright information.\n");
	printf("/W  used to turn off WINDERS countdown banner.\n");
	printf("Pressing [SHIFT], or [ALT], or [CTRL] during the countdown\n");
	printf("will cause Windows to load without continuing the countdown.\n");
	printf("Pressing any other key will cause WINDERS to exit to DOS.\n");
	printf("\n");
	printf("Windows is a registered trademark of Microsoft Corporation.\n");
	exit(HLP);
      break;
      /* help screen */

      /* intro screen */
      case 'i': case 'I':
	show_intro = 0;  /* turn on intro screen */
      break;
      /* intro screen */

      /* path */
      case 'p' : case 'P':
	if ( argv[j+1] == NULL || argv[j+1][0] == '/' )
	{
	  argerror(argv[0], "P", 0);
	  /* Error no argument found */
	}
	else
	{
	  strcpy(path, argv[++j]); /* pass arguments */
	}
      break;

      /* name */
      case 'n': case 'N':
	if ( argv[j+1] == NULL || argv[j+1][0] == '/' )
	{
	  argerror(argv[0], "N", 0);
	  /* error no argument found to pass to windows */
	}
	else
	{
          name_changed = 1;
	  strcpy(name, argv[++j]); /* pass arguments */
	}
      break;

      /* version screen */
      case 'v': case 'V':
        clrscr();
        fprintf(stderr,"\n");
	highvideo();
	center("WINDERS VERSION 2.2\r\n");
	lowvideo();
	center("Copyright (c) 1992 By Earl W. Hartsell\r\n");
	center("This is a Freeware program.\r\n");
	printf("\n");
	printf("\n");
	center("Windows is a registered trademark of Microsoft Corporation.\r\n");
	exit(VER);
      break;
      /* version screen */

      /* WINDERS banner */
      case 'w': case 'W':
	w_banner = 0; /* don't print WINDERS countdown banner */
      break;
      /* WINDERS banner */

      /* ERROR in arguments */
      default:
	fprintf(stderr,"\n%s: Error: Unrecognized Switch %s Will Be Ignored.",argv[0],argv[j]);
	DELAY_SECONDS(2);
      break;
      /* ERROR in arguments */
    }
  }

  k = keyhit(); 	/* check and see if key has already been selected */

  if (k == 1) Winf(drive,path,name,args,show_intro, name_changed);
  if (k == 2) Dosf(); 	/* exit to dos if key is pressed */

  clrscr(); /* clear screen */
  if (w_banner)
  {
  highvideo();
  textattr(WHITE + (BLUE << 4));
  center("ͻ");
  cprintf("\r\n");
  center("      Winders Countdown    ");
  textattr(DARKGRAY);
  cprintf("\r\n");
  textattr(WHITE + (BLUE << 4));
  center("ͼ");
  textattr(DARKGRAY);
  cprintf("\r\n");
  printf("\t\t\t   ");
  textattr(DARKGRAY);
  cprintf("\r\n");
  cprintf("\r\n");
  lowvideo();
  }
  textattr(LIGHTGRAY);
  sprintf(buffer, "Loading Windows in %d seconds.\r\n",pause);
  center(buffer);
  center("Press [SHIFT], or [ALT], or [CTRL] to load Windows now.\r\n");
  center("Press any other key to exit to DOS.\r\n");
  center("Counting");
  start = time(NULL); /* get initial time in seconds */
  for (i=1 ;(i <= pause && !k);i++)
  {
    new = time(NULL); 		/* get new time */
    while(new - start == 0) 	/* start time = new time second not elapsed */
    {
      new = time(NULL); 	/* get new time again */
      k = keyhit();  if (k) break;
    }
    if (k == 1) Winf(drive,path,name,args,show_intro, name_changed);
    if (k == 2) Dosf(); 	/* exit to dos if key is pressed */
    if (new - start != 0)
    {
      if (beep)
	printf("\a.");
      else
	printf(".");
    }
    start = new;
  }
  Winf(drive, path, name, args, show_intro, name_changed);
  return (0); /* keeping the compiler happy */
}


/* 
    keyhit- function returns 0,1, or 2 depending on the key pressed
	0 - if no key has been pressed
	1 - if SHIFT, CTRL, or ALT has been pressed
	2 - if a key other than the ones above has been pressed
*/
int keyhit(void)
{
  int modifiers;

  modifiers = bioskey(2);
  if (modifiers)
  {
    if (modifiers & RIGHT) return(1);
    if (modifiers & LEFT)  return(1);
    if (modifiers & CTRL)  return(1);
    if (modifiers & ALT)   return(1);
  }
  if (bioskey(1)) return(2);
  return(0);
}


/* Dosf - return to DOS and clear screen */

void Dosf()
{
    fflush(stdout);
    clrscr();
    exit(DOS);
}


/* Winf - execute win.com and pass arguments to it.

   args - argumentents to be passed to windows

   drive - drive where Windows resides.

   path -  directory path where windows resides.

   name -  filename of executable that will run Windows.

   intro - 0 will by pass Windows intro using command win :
	   1 (default) Will show intro screen

   changed - 0 name of executable has not been changed.
	     1 name has changed.

   Note: execl was used in the hope that the progam would be
         cleared from memory and not take up any space in Windows.
*/
 
void Winf(drive, path, name, args, intro, changed)
char *drive, *path, *name, *args;
char intro, changed;
{
  highvideo();
  center("Loading Windows...\r\n");
  lowvideo();

  strcat(drive,path);
  strcat(drive,name);

  if (changed)
  {
    if(!(intro))
      strcat(drive," :");
    system(drive);
    if (errno)
    {
      printf("%s",sys_errlist[errno]);
    }
    exit(errno);
   }
  else
  {
    if (intro) /* to show into or not to show intro */
      execl(drive, name, args, NULL); /* to show */
    else
      execl(drive, name, ":", args, NULL);  /* not to show */
  }
  printf("%s",sys_errlist[errno]);
  exit(errno);
}

int argerror(argv, option, Dlay)
char *argv;
char option[5];
int Dlay;
{
  if (Dlay == 0)
    Dlay = 2;
  fprintf(stderr,"\n%s: Error: Argument Missing Option /%s Ignored, Default Will Be Used.\n",argv,option);
  DELAY_SECONDS(Dlay);
  return(0);
}

/* center text on screen using CPRINTF */
/* input string of characters to be centered */

int center (string)
char *string;
{
  int length, posx = 0;

  gettextinfo(&ti);
  length = strlen(string);
  if (length > ti.screenwidth) return(-1);
  posx = (ti.screenwidth /2) - (length /2);
  gotoxy(posx,wherey());
  cprintf("%s", string);
  return(0);
}