/*
 * Smart terminal module header file
 * 
 * Copyright (c) 1990, 1991 by
 * William S. Hall
 * 3665 Benton Street  #66
 * Santa Clara, CA 95051
 *
 */

#define MAXROWS		30
#define MAXCOLUMNS	132
#define MAXTEXTBUFFERS	5

typedef struct _SMT {
    HWND hWnd;			/* smart term window handle */
    HWND hMain;
    HWND hStatic;
    HBRUSH hbr;
    HFONT hFont;
    DWORD TextColor;
    DWORD BGColor;
    short MaxCols;
    short MaxLines;
    int MaxTextLines;
    short CharWidth;
    short CharHeight;
    int BufSize;
    WORD *lines[MAXTEXTBUFFERS * MAXROWS];
    short TopScroll;
    short BottomScroll;
    short TopOrgLine, BottomOrgLine;
    int scrollback;
    int MaxScrollBack;
    int scrollforward;
    BOOL OriginMode;
    short CurLine, CurLineOffset;
    short CurSaveX, CurSaveY;
    short SaveAttrib;
    WORD *pVidBuffer;
    POINT Pos;			/* caret position */
    WORD Attrib;
    BOOL SmoothScroll;
    short ScrollUnits;
    BOOL HaveToWrap;
    BOOL Wrap;
    BOOL ICToggle;
    BOOL MarginBell;
    RECT rect;		/* terminal window rectangle */
    RECT vrect;		/* visible rectangle (static window) */
    RECT srect;		/* scrolling rectangle */
    char TabStops[MAXCOLUMNS];
    LOGFONT lfnt;
    int NFontWidth, NFontHeight;
    int SFontWidth, SFontHeight;
    BOOL NBold;
    BOOL SBold;
    BOOL Bold;
    BOOL NSymbol;
    BOOL SSymbol;
    BOOL Symbol;
} SMT;
typedef SMT *PSMT;

typedef struct _SETFONT {
    int nwidth;
    int nheight;
    int swidth;
    int sheight;
    char FaceName[LF_FACESIZE];

} SETFONT;

/* function declarations */
long FAR PASCAL SmartTermWndProc(HWND, unsigned, WORD, LONG);
BOOL NEAR RegisterTermWindow(HANDLE hInstance);
HWND NEAR MakeAndShowTermWindow(HANDLE hInstance,HANDLE hPrevInstance,
				HWND hPar,
				PSMT pSmt, DWORD tcolor, DWORD bgcolor,
				short x,short y,short rows,short cols,
				BOOL Wrap,
				char *fontface,
				short nwidth, short nheight,
				short swidth, short sheight);
void SmartTermWndCreate(HWND hWnd, LONG lParam);
HFONT FAR SetFontData(PSMT pSmt);

#define VA_NORMAL	0
#define VA_BOLD		1
#define VA_UNDERLINE	2
#define VA_BLINK	4
#define VA_REVERSE	8
#define VA_DIM		16
#define VA_SELECT	32
#define VA_MARK		64
#define VA_SPECIAL	128

#define SMT_CARETFUNCTION	WM_USER
#define SM_CREATECARET		1
#define SM_DESTROYCARET		2
#define SM_HIDECARET		3
#define SM_SHOWCARET		4
#define SM_GETCARETPOS		5

#define SMT_STRINGINPUT		WM_USER + 1
#define SMT_SIZEPARENT		WM_USER + 2

#define SMT_COMMAND		WM_USER + 3
#define SM_CURSORHOME		1
#define SM_CURSORUP		2
#define SM_CURSORDOWN		3
#define SM_CURSORRIGHT		4
#define SM_CURSORLEFT		5
#define SM_CLRTOENDOFLINE	6
#define SM_CLRTOENDOFPAGE	7
#define SM_POSITIONCURSOR	8
#define SM_REVERSEINDEX		9
#define SM_INDEX		10
#define SM_NEXTLINE		11
#define SM_ALIGNSCREEN		12
#define SM_SAVECURSOR		13
#define SM_CLEARSCREEN		14
#define SM_CLEARTOTOPOFPAGE	15
#define SM_CLEARTOLINESTART	16
#define SM_CLEARLINE		17
#define SM_DELETECHAR		18
#define SM_INSERTLINE		19
#define SM_DELETELINE		20
#define SM_SETTAB		21
#define SM_VIDEOATTRIB		22
#define SM_SCROLLREGION		23
#define SM_FILLSCREEN		24
#define SM_HSCROLL		25
#define SM_SETCOLS		26
#define SM_LEFTMARGIN		27
#define SM_TAB			28
#define SM_BKSP			29
#define SM_SETCHARSET		30
#define SM_ORIGINMODE		31
#define SM_SETFONT		32
#define SM_SCROLLBACK		33
#define SM_PAGEBACK		34
#define SM_HOMEEND		35

#define SMT_SHOWWINDOW		WM_USER + 4

#define SMT_SETATTRIBUTE	WM_USER + 5
#define SMT_GETATTRIBUTE	WM_USER + 6
#define SM_COLORCHANGE		1
#define SM_AUTOWRAP		2
#define SM_INSERT		3
#define SM_MARGINBELL		4
#define SM_SMOOTHSCROLL		5
#define SM_SCREENSIZE		6
#define SM_FONTFACE		7
#define SM_NORMALFONT		8
#define SM_SMALLFONT		9
#define SM_SCROLLUNITS		10

#define SMT_COPYLINES		WM_USER + 7
#define SMT_INVERT		WM_USER + 8

