%{
#define NOKANJI
#define NOATOM
#define NOMINMAX
#define NOSOUND
#include <windows.h>
#ifdef COLUMBIA
#include "wktsmt.h"
#include "wkt100.h"
#else
#include "smterm.h"
#include "win600.h"
#endif
#ifdef WIN600
#include "grterm.h"
#endif

#undef YYLEX
#define YYLEX vt100

#undef YYLMAX
#define YYLMAX (BUFSIZE + 1)

#define YY_PRESERVE

#undef YY_INTERACTIVE
#define YY_INTERACTIVE	0

#undef output
#define output(c)

#undef yygetc
#define yygetc mygetc

#undef YY_FATAL
#define YY_FATAL(msg) {HWND hError = GetTopWindow(MWnd.hWnd); \
		       if (!hError) hError = MWnd.hWnd; \
		       MessageBox(hError,msg,szAppName, \
				  MB_OK | MB_ICONEXCLAMATION); \
		       PostMessage(MWnd.hWnd, WM_SYSCOMMAND, SC_CLOSE, 0L);}

static int accum;
static int list[MAXPROTOLEN];
static int lptr, hptr;
static int *pn;
static int * NEAR getnextelement(BOOL corr);
static int NEAR mygetc(void);
static void NEAR doesc(register BYTE c);
static void NEAR dosharp(register BYTE c);
static void NEAR doscsl(register BYTE c);
static void NEAR doscsr(register BYTE c);
static void NEAR docsi(register BYTE c);
static int NEAR doendnum(register BYTE c);
static BOOL NEAR doquesendnum(register BYTE c);
static int oldstate;

%}

ENQ	[\005]
BEL	[\007]
BS	[\010]
HT	[\011]
LF	[\012]
VT	[\013]
FF	[\014]
CR	[\015]
SO	[\016]
SI	[\017]
CAN	[\030]
EM	[\031]
SUB	[\032]
ESC	[\033]
FS	[\034]
GS	[\035]
RS	[\036]
US	[\037]
SPC	[\040]
DEL	[\177]
IND	[\204]
NEL	[\205]
HTS	[\210]
RI	[\215]
SS2	[\216]
SS3	[\217]
DCS	[\220]
CSI	[\233]
ST	[\234]
ANSI	[\040-\176\221-\222\240-\377]
CTRL	[\000-\037\177\200-\220\223-\237]

%p	3000

%s esc csi sharp lpr rpr innum endnum ques quesinnum quesendnum
%x crep
%%

<crep>[\012-\014] {
    SendMessage(hWndText,SMT_STRINGINPUT,yyleng,(LONG)(LPSTR)yytext);
    SendMessage(hWndText, SMT_COMMAND, SM_NEXTLINE, (LONG)yyleng);
}

<crep>[\000-\011\015-\377]+ {
    SendMessage(hWndText,SMT_STRINGINPUT,yyleng,(LONG)(LPSTR)yytext);
}

{ENQ}+ {
    if (MWnd.AutoAnswer) {
	while (yyleng--)
	    ShowAnswerBack();
    }
}

{BEL}+ {
    if (MWnd.WarningBell) {
	while (yyleng--)
	    MessageBeep(0);
    }
}

{BS}+ {
    SendMessage(hWndText, SMT_COMMAND, SM_BKSP, (LONG)yyleng);
}    

{HT}+ {
    SendMessage(hWndText, SMT_COMMAND, SM_TAB, (LONG)yyleng);
}    

[\012-\014]+ {
    SendMessage(hWndText, SMT_COMMAND,
		MWnd.LFCR ? SM_NEXTLINE : SM_INDEX, (LONG)yyleng);
}

{CR}+ {
    SendMessage(hWndText, SMT_COMMAND, SM_LEFTMARGIN, (LONG)yyleng);
}

{SO}+ {
    // select G1 character set into GL
    MWnd.ActiveCharSet = 1;
    SendMessage(hWndText,SMT_COMMAND,SM_SETCHARSET,(LONG)MWnd.CharSet[1]);
}

{SI}+ {
    // select G0 character set into GL
    MWnd.ActiveCharSet = 0;
    SendMessage(hWndText,SMT_COMMAND,SM_SETCHARSET,(LONG)MWnd.CharSet[0]);
}

{CAN}+ {
    BEGIN 0;
}

{SUB}+ {
    SendMessage(hWndText,SMT_STRINGINPUT,yyleng,(LONG)(LPSTR)yytext);
    BEGIN 0;
}

{IND}+ {
    SendMessage(hWndText, SMT_COMMAND, SM_INDEX, (LONG)yyleng);
}

{NEL}+ {
    SendMessage(hWndText, SMT_COMMAND, SM_NEXTLINE, (LONG)yyleng);
}

{HTS} {
    SendMessage(hWndText, SMT_COMMAND, SM_SETTAB, 1L);
}

{RI}+ {
    SendMessage(hWndText, SMT_COMMAND, SM_REVERSEINDEX, (LONG)yyleng);
}

{CSI} {
    memset((char *)list, 0, 2 * MAXPROTOLEN);
    lptr = hptr = -1;
    accum = 0;
    BEGIN csi;
}

{ESC} {
    BEGIN esc;
}

{CTRL} {
    ;
}

<0>{ANSI}+ {
    SendMessage(hWndText,SMT_STRINGINPUT,yyleng,(LONG)(LPSTR)yytext);
}

<esc>[#\(\)78=\>DEHMZ\[c] {
    doesc(*yytext);
}

<sharp>[345678] {
    dosharp(*yytext);
}

<lpr>[012AB\<] {
    doscsl(*yytext);
}

<rpr>[012AB\<] {
    doscsr(*yytext);
}

<csi>[0-9] {
    accum = *yytext - '0';
    BEGIN innum;
}

<csi>[\;\?ABCDHJKLMPcfgmr] {
    docsi(*yytext);
}

<innum>[0-9] {
    accum = 10 * accum + *yytext - '0';
}

<innum>\; {
    if (lptr < (MAXPROTOLEN - 1))
	list[++lptr] = accum;
    accum = 0;
    BEGIN endnum;
}

<innum>{ANSI} {
    unput(*yytext);
    if (lptr < (MAXPROTOLEN - 1))
	list[++lptr] = accum;
    accum = 0;
    BEGIN endnum;
}

<endnum>[0-9] {
    accum = 10 * accum + *yytext - '0';
    BEGIN innum;
}

<endnum>[\;ABCDHfJKLMPcghlmnr] {
    if (doendnum(*yytext))
	return 1;
}

<ques>[0-9] {
    accum = *yytext - '0';
    BEGIN quesinnum;
}

<ques>\; {
    if (lptr < (MAXPROTOLEN - 1))
	list[++lptr] = accum;
    accum = 0;
    BEGIN quesendnum;
}

<quesinnum>[0-9] {
    accum = 10 * accum + *yytext - '0';
}

<quesinnum>\; {
    if (lptr < (MAXPROTOLEN - 1))
	list[++lptr] = accum;
    accum = 0;
    BEGIN quesendnum;
}

<quesinnum>{ANSI} {
    unput(*yytext);
    if (lptr < (MAXPROTOLEN - 1))
	list[++lptr] = accum;
    accum = 0;
    BEGIN quesendnum;
}

<quesendnum>[0-9] {
    accum = 10 * accum + *yytext - '0';
    BEGIN quesinnum;
}

<quesendnum>[\;hl] {
    if (doquesendnum(*yytext))
	return 1;
}

<esc,sharp,lpr,rpr,csi,endnum,ques,quesendnum>{ANSI} {
    BEGIN 0;
}

%%

static BOOL NEAR doquesendnum(register BYTE c)
{
    switch(c) {
	case ';':
            if (lptr < (MAXPROTOLEN - 1))
	        list[++lptr] = accum;
	    accum = 0;
	    BEGIN quesendnum;
	    break;

	case 'h':
	    while ((pn = getnextelement(FALSE)) != NULL) {
		switch(*pn) {
		    case 1:
			MWnd.CurKeyMode = TRUE;
			break;
		    case 3:
			SetCols(132);
			break;
		    case 4:
			SendMessage(hWndText,SMT_SETATTRIBUTE,SM_SMOOTHSCROLL,(LONG)TRUE);
			break;
		    case 5:
		        if (!MWnd.Reverse) {
		  	    MWnd.Reverse = TRUE;
			    InvertScreen(TRUE);
			}
			break;
		    case 6:
			SendMessage(hWndText, SMT_COMMAND, SM_ORIGINMODE, (LONG)TRUE);
			break;
		    case 7:
			SendMessage(hWndText, SMT_SETATTRIBUTE, SM_AUTOWRAP,(LONG)TRUE);
			MWnd.Wrap = TRUE;
			break;
		    case 25:
		        if (!MWnd.Cursor) {
			    MWnd.Cursor = TRUE;
			    SendMessage(hWndText,SMT_CARETFUNCTION,SM_SHOWCARET,0L);
			}
		        break;
		}
	    }
	    BEGIN 0;
	    break;

	case 'l':
	    while ((pn = getnextelement(FALSE)) != NULL) {
		switch(*pn) {
		    case 1:
			MWnd.CurKeyMode = FALSE;
			break;
		    case 2:
		        SendMessage(hWndText,SMT_COMMAND,SM_SETCHARSET,(LONG)0);
		        SetAlphaParams(52);
			if (input() != EOF)
			    pushback();
			return 1;
		    case 3:
			SetCols(80);
			break;
		    case 4:
		        SendMessage(hWndText,SMT_SETATTRIBUTE,SM_SMOOTHSCROLL,(LONG)FALSE);
		        break;
		    case 5:
		        if (MWnd.Reverse) {
		  	    InvertScreen(FALSE);
			    MWnd.Reverse = FALSE;
			}
			break;
		    case 6:
			SendMessage(hWndText,SMT_COMMAND, SM_ORIGINMODE, (LONG)FALSE);
			break;
		    case 7:
			SendMessage(hWndText, SMT_SETATTRIBUTE, SM_AUTOWRAP,(LONG)FALSE);
			MWnd.Wrap = FALSE;
			break;
		    case 25:
		        if (MWnd.Cursor) {
		            MWnd.Cursor = FALSE;
		            SendMessage(hWndText,SMT_CARETFUNCTION,SM_HIDECARET,0L);
		        }
		        break;
		}
	    }
	    BEGIN 0;
	    break;
    }
    return 0;
}


static int NEAR doendnum(register BYTE c)
{
    LONG lparam;

    switch (c) {
	case ';':
	    if (lptr < (MAXPROTOLEN - 1))
	        list[++lptr] = accum;
            accum = 0;
	    break;
	case 'A':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORUP,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;
	case 'B':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORDOWN,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;
	case 'C':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORRIGHT,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;
	case 'D':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORLEFT,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;

	case 'H':
	case 'f':
	    SendMessage(hWndText, SMT_COMMAND, SM_POSITIONCURSOR,
			MAKELONG((list[0] ? list[0] : 1),
		        (list[1] ? list[1] : 1)));
	    BEGIN 0;
	    break;

	case 'J':
	    SendMessage(hWndText, SMT_COMMAND, 
		        list[0] == 0 ? SM_CLRTOENDOFPAGE :
			list[0] == 1 ? SM_CLEARTOTOPOFPAGE :
			list[0] == 2 ? SM_CLEARSCREEN : 0, 0L);
	    BEGIN 0;
	    break;
	case 'K':
	    SendMessage(hWndText, SMT_COMMAND, 
		        list[0] == 0 ? SM_CLRTOENDOFLINE :
			list[0] == 1 ? SM_CLEARTOLINESTART :
			list[0] == 2 ? SM_CLEARLINE : 0, 0L);
	    BEGIN 0;
	    break;

	case 'L':
	    SendMessage(hWndText, SMT_COMMAND, SM_INSERTLINE,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;

	case 'M':
	    SendMessage(hWndText, SMT_COMMAND, SM_DELETELINE,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;

	case 'P':
	    SendMessage(hWndText, SMT_COMMAND, SM_DELETECHAR,
			(LONG)(list[0] ? list[0] : 1));
	    BEGIN 0;
	    break;

	case 'c':
	    if (list[0] == 0)
		IdentifyTerm(100);
	    BEGIN 0;
	    break;

	case 'g':
	    SendMessage(hWndText,SMT_COMMAND,SM_SETTAB,MAKELONG(0, list[0]));
	    BEGIN 0;
	    break;

	case 'h':
	    while ((pn = getnextelement(FALSE)) != NULL) {
		switch(*pn) {
	            case 3:
		        SendMessage(hWndActive, SMT_SETATTRIBUTE, 
				    SM_AUTOWRAP, (LONG)TRUE);
			MWnd.ControlRep = TRUE;
			if (input() != EOF)
			    pushback();
			vt100SetState(-1);
			return 1;
	            case 4:
			SendMessage(hWndText,SMT_SETATTRIBUTE,SM_INSERT,(LONG)TRUE);
			break;
		    case 12:
		        LocalEcho = 0;
		        if (LineState != LOCAL_ON)
		            LineState = LINE_ON + LocalEcho;
		        break;
		    case 20:
		        MWnd.LFCR = TRUE;
		        break;
		}
	    }
	    BEGIN 0;
	    break;

	case 'l':
	    while ((pn = getnextelement(FALSE)) != NULL) {
		switch(*pn) {
		    case 4:
			SendMessage(hWndText,SMT_SETATTRIBUTE,SM_INSERT,(LONG)FALSE);
			break;
		    case 12:
			LocalEcho = TRUE;
			if (LineState != LOCAL_ON)
			    LineState = LINE_ON + LocalEcho;
			break;
		    case 20:
			MWnd.LFCR = FALSE;
			break;
		}
	    }
	    BEGIN 0;
	    break;

	case 'm':
	    while ((pn = getnextelement(FALSE)) != NULL)
		SendMessage(hWndText, SMT_COMMAND, SM_VIDEOATTRIB, (LONG)*pn);
	    BEGIN 0;
	    break;

	case 'n':
	    switch(list[0]) {
		case 5:
		    WriteToComm("\033[0n",4);
		    break;
		case 6:
		    lparam = SendMessage(hWndText, SMT_CARETFUNCTION,
					 SM_GETCARETPOS, 0L);
		    ReportCursorPos(LOWORD(lparam), HIWORD(lparam));
		    break;
	    }
	    BEGIN 0;
	    break;

	case 'r':
	    SendMessage(hWndText, SMT_COMMAND, SM_SCROLLREGION,
			MAKELONG(list[0], list[1]));
	    BEGIN 0;
	    break;
    }
    return 0;
}

static void NEAR docsi(BYTE c)
{
    switch(c) {
	case ';':
	    if (lptr < (MAXPROTOLEN - 1))
		list[++lptr] = accum;
	    accum = 0;
	    BEGIN endnum;
	    break;

	case '?':
	    BEGIN ques;
	    break;

	case 'A':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORUP,1L);
	    BEGIN 0;
	    break;

	case 'B':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORDOWN,1L);
	    BEGIN 0;
	    break;

	case 'C':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORRIGHT,1L);
	    BEGIN 0;
	    break;

	case 'D':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORLEFT,1L);
	    BEGIN 0;
	    break;

	case 'H':
	case 'f':
	    SendMessage(hWndText, SMT_COMMAND, SM_CURSORHOME,0L);
	    BEGIN 0;
	    break;

	case 'J':
	    SendMessage(hWndText, SMT_COMMAND, SM_CLRTOENDOFPAGE,0L);
	    BEGIN 0;
	    break;

	case 'K':
	    SendMessage(hWndText, SMT_COMMAND, SM_CLRTOENDOFLINE, 0L);
	    BEGIN 0;
	    break;

	case 'L':
	    SendMessage(hWndText, SMT_COMMAND, SM_INSERTLINE, 1L);
	    BEGIN 0;
	    break;

	case 'M':
	    SendMessage(hWndText, SMT_COMMAND, SM_DELETELINE, 1L);
	    BEGIN 0;
	    break;

	case 'P':
	    SendMessage(hWndText, SMT_COMMAND, SM_DELETECHAR, 1L);
	    BEGIN 0;
	    break;

	case 'c':
	    IdentifyTerm(100);
	    BEGIN 0;
	    break;

	case 'g':
	    SendMessage(hWndText, SMT_COMMAND, SM_SETTAB,0L);
	    BEGIN 0;
	    break;

	case 'm':	
	    SendMessage(hWndText, SMT_COMMAND, SM_VIDEOATTRIB,0L);
	    BEGIN 0;
	    break;

	case 'r':
	    SendMessage(hWndText, SMT_COMMAND, SM_SCROLLREGION,0L);
	    BEGIN 0;
	    break;
    }
}

static void NEAR doscsr(BYTE c)
{

    switch(c) {
	case 'A':	// Select UK National into G1
	case 'B':	// Select ASCII (default) into G1
	case '1':	// Select Alternate ROM set into G1
	    MWnd.CharSet[1] = 0;
	    if (MWnd.ActiveCharSet == 1)
	    SendMessage(hWndText,SMT_COMMAND,
			SM_SETCHARSET,(LONG)MWnd.CharSet[1]);
	    break;

	case '0':	// Select Dec special graphics into G1
	case '2':	// Select Alternate char ROM special graphics into G0
	    MWnd.CharSet[1] = SYMBOL_CHARSET;
	    if (MWnd.ActiveCharSet == 1)
	    SendMessage(hWndText,SMT_COMMAND,
			SM_SETCHARSET,(LONG)MWnd.CharSet[1]);
	    break;
	case '<':    // Select Dec supplemental into G1
	    break;
    }
    BEGIN 0;
}

static void NEAR doscsl(BYTE c)
{

    switch(c) {
	case 'A':	// Select UK National into G0
	case 'B':	// Select ASCII (default) into G0
	case '1':	// Select Alternate ROM set into G0
	    MWnd.CharSet[0] = 0;
	    if (MWnd.ActiveCharSet == 0)
	    SendMessage(hWndText,SMT_COMMAND,
			SM_SETCHARSET,(LONG)MWnd.CharSet[0]);
	    break;

	case '0':	// Select Dec special graphics into G0
	case '2':	// Select Alternate char ROM special graphics into G0
	    MWnd.CharSet[0] = SYMBOL_CHARSET;
	    if (MWnd.ActiveCharSet == 0)
	    SendMessage(hWndText,SMT_COMMAND,
			SM_SETCHARSET,(LONG)MWnd.CharSet[0]);
	    break;

	case '<':
	    // Select Dec supplemental into G0	    
	    break;

    }
    BEGIN 0;
}

static void NEAR dosharp(BYTE c)
{

    switch(c) {
	case '3':
	    // single high single width
	    break;
	case '4':
	    // single high double width
	    break;
	case '5':
	    // double high double width top line
	    break;
	case '6':
	    // double high double width bottom line
	    break;
	case '7':
	    SendMessage(hWndText, SMT_COMMAND, SM_FILLSCREEN, 0L);
	    break;
	case '8':
	    SendMessage(hWndText, SMT_COMMAND, SM_ALIGNSCREEN, 0L);
	    break;
    }
    BEGIN 0;
}

static void NEAR doesc(BYTE c)
{
    switch(c) {
	case '#':
	    BEGIN sharp;
	    break;
	case '(':
	    BEGIN lpr;
	    break;
	case ')':
	    BEGIN rpr;
	    break;
	case '7':
	    SendMessage(hWndText, SMT_COMMAND, SM_SAVECURSOR, (LONG)TRUE);
	    BEGIN 0;
	    break;
	case '8':
	    SendMessage(hWndText, SMT_COMMAND, SM_SAVECURSOR, (LONG)FALSE);
	    BEGIN 0;
	    break;
	case '=':
	    MWnd.ApplMode = TRUE;
	    BEGIN 0;
	    break;
	case '>':
	    MWnd.ApplMode = FALSE;
	    BEGIN 0;
	    break;
	case 'D':
	    SendMessage(hWndText, SMT_COMMAND, SM_INDEX, 1L);
	    BEGIN 0;
	    break;
	case 'E':
	    SendMessage(hWndText, SMT_COMMAND, SM_NEXTLINE, 1L);
	    BEGIN 0;
	    break;
	case 'H':
	    SendMessage(hWndText, SMT_COMMAND, SM_SETTAB, 1L);
	    BEGIN 0;
	    break;
	case 'M':
	    SendMessage(hWndText, SMT_COMMAND, SM_REVERSEINDEX, 1L);
	    BEGIN 0;
	    break;
	case 'Z':
	    IdentifyTerm(100);
	    BEGIN 0;
	    break;
	case '[':
	    memset((char *)list, 0, 2 * MAXPROTOLEN);
	    lptr = hptr = -1;
	    accum = 0;
	    BEGIN csi;
	    break;
	case 'c':
	    // Hard reset
	    BEGIN 0;
	    break;
    }
}

void FAR vt100SetState(int state)
{
    int temp = yy_start;


    if (state < 0)
	BEGIN crep;
    else
        BEGIN state;
}

static int * NEAR getnextelement(BOOL corr)
{

    if (hptr++ < lptr) {
	if (corr)
	    if (list[hptr] == 0)
		list[hptr] = 1;
	return(&list[hptr]);
    }
    else
	return(NULL);
}

static int NEAR mygetc()
{

    if (pBuf->len > 0) {
	pBuf->len--;
	return (*pBuf->ptr++) & curproto.mask;
    }	
    else
	return EOF;
    
}

void FAR ANSISpecialKeys(int item)
{

    int index;

    static char *ANSIKeys[] = {
        "\033OA","\033[A",
        "\033OB","\033[B",
        "\033OC","\033[C",
        "\033OD","\033[D",
        "\033OH","\033[H",			// 9
	"\033OP","\033OQ","\033OR","\033OS",	// 13
	"\033Op","0",
	"\033Oq","1",
	"\033Or","2",
	"\033Os","3",
	"\033Ot","4",
	"\033Ou","5",
	"\033Ov","6",
	"\033Ow","7",
	"\033Ox","8",
	"\033Oy","9",				// 33
	"\033Ol","+",	// 35
	"\033Om","-",   // 37
	"\033On",".",   // 39
	"\033OM","*",   // 41
    };

    switch(item) {
	case IDM_UP:
	case IDM_S_UP:
	case IDM_C_UP:
	case IDM_CS_UP:
	    index = (MWnd.CurKeyMode ? 0 : 1);
	    break;

	case IDM_DOWN:
	case IDM_S_DOWN:
	case IDM_C_DOWN:
	case IDM_CS_DOWN:
	    index = (MWnd.CurKeyMode ? 2 : 3);
	    break;

	case IDM_RIGHT:
	case IDM_S_RIGHT:
	case IDM_C_RIGHT:
	case IDM_CS_RIGHT:
	    index = (MWnd.CurKeyMode ? 4 : 5);
	    break;

	case IDM_LEFT:
	case IDM_S_LEFT:
	case IDM_C_LEFT:
	case IDM_CS_LEFT:
	    index = (MWnd.CurKeyMode ? 6 : 7);
	    break;

	case IDM_HOME:
	case IDM_S_HOME:
	case IDM_C_HOME:
	case IDM_CS_HOME:
	    index = (MWnd.CurKeyMode ? 8 : 9);
	    break;

	case IDM_F1:
	    index = 10;
	    break;

	case IDM_F2:
	    index = 11;
	    break;

	case IDM_F3:
	    index = 12;
	    break;

	case IDM_F4:
	    index = 13;
	    break;

	case IDM_NUM0:
//	case IDM_S_NUM0:
	case IDM_C_NUM0:
//	case IDM_CS_NUM0:
	    index = (MWnd.ApplMode ? 14 : 15);
	    break;

	case IDM_NUM1:
//	case IDM_S_NUM1:
	case IDM_C_NUM1:
//	case IDM_CS_NUM1:
	    index = (MWnd.ApplMode ? 16 : 17);
	    break;

	case IDM_NUM2:
//	case IDM_S_NUM2:
	case IDM_C_NUM2:
//	case IDM_CS_NUM2:
	    index = (MWnd.ApplMode ? 18 : 19);
	    break;

	case IDM_NUM3:
//	case IDM_S_NUM3:
	case IDM_C_NUM3:
//	case IDM_CS_NUM3:
	    index = (MWnd.ApplMode ? 20 : 21);
	    break;

	case IDM_NUM4:
//	case IDM_S_NUM4:
	case IDM_C_NUM4:
//	case IDM_CS_NUM4:
	    index = (MWnd.ApplMode ? 22 : 23);
	    break;

	case IDM_NUM5:
//	case IDM_S_NUM5:
	case IDM_C_NUM5:
//	case IDM_CS_NUM5:
	    index = (MWnd.ApplMode ? 24 : 25);
	    break;

	case IDM_NUM6:
//	case IDM_S_NUM6:
	case IDM_C_NUM6:
//	case IDM_CS_NUM6:
	    index = (MWnd.ApplMode ? 26 : 27);
	    break;

	case IDM_NUM7:
//	case IDM_S_NUM7:
	case IDM_C_NUM7:
//	case IDM_CS_NUM7:
	    index = (MWnd.ApplMode ? 28 : 29);
	    break;

	case IDM_NUM8:
//	case IDM_S_NUM8:
	case IDM_C_NUM8:
//	case IDM_CS_NUM8:
	    index = (MWnd.ApplMode ? 30 : 31);
	    break;

	case IDM_NUM9:
//	case IDM_S_NUM9:
	case IDM_C_NUM9:
//	case IDM_CS_NUM9:
	    index = (MWnd.ApplMode ? 32 : 33);
	    break;

	case IDM_ADD:
//	case IDM_S_ADD:
	case IDM_C_ADD:
//	case IDM_CS_ADD:
	    index = 
		(MWnd.ApplMode && (GetKeyState(VK_NUMLOCK) & 1) ? 34 : 35);
	    break;

	case IDM_SUBTRACT:
//	case IDM_S_SUBTRACT:
	case IDM_C_SUBTRACT:
//	case IDM_CS_SUBTRACT:
	    index = 
		(MWnd.ApplMode && (GetKeyState(VK_NUMLOCK) & 1) ? 36 : 37);
	    break;

	case IDM_DECIMAL:
//	case IDM_S_DECIMAL:
	case IDM_C_DECIMAL:
//	case IDM_CS_DECIMAL:
	    index = (MWnd.ApplMode ? 38 : 39);
	    break;

	case IDM_MULTIPLY:
//	case IDM_S_MULTIPLY:
	case IDM_C_MULTIPLY:
//	case IDM_CS_MULTIPLY:
	    index = 
		(MWnd.ApplMode && (GetKeyState(VK_NUMLOCK) & 1) ? 40 : 41);
	    break;

	default:
	    return;
    }
    WriteToComm(ANSIKeys[index], strlen(ANSIKeys[index]));
}
