/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is Winsock Chess specific.
  
  C source for GNU CHESS

  Revision: 1990-09-30
  Modified by Daryl Baker for use in MS WINDOWS environment

  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM              
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOKANJI

#define STRICT 
#include <windows.h>         
#include <windowsx.h> 
#include <ddeml.h>

#include "winsock.h"
#include "gnuchess.h"
#include "defs.h"    
#include "chess.h"
#include "resource.h"

extern WORD wComType;
extern BOOL (*Initialise)(void);
extern BOOL (*ConnectHost)(void);
extern BOOL (*ConnectClient)(void);
extern void (*GetOpponentsMove)(WORD);
extern void (*SendMove)(WORD);         
extern BOOL (*IsCommand)(LPSTR);
extern void (*LoadGame)(void);
extern void (*StartGame)(void);
extern void (*SetTime)(int);
extern MoveInfo moveinfo;
extern BOOL bConnected,bHost,bWaiting;
extern HWND hwndHostDlg,hwndMain;               
extern DWORD idDdeServInst,idDdeClntInst;
extern HCONV hconvHost,hconvClient;
extern HSZ hszServName,hszTopic,hszServNameCl,hszTopicCl,hszGet;
extern int User_Move;    
extern char szSockDesc[45];
extern SOCKET socketListen,socketServer,socketClient;
extern HINSTANCE hInst; 

void DestroySocket(SOCKET);
void DecodeGame (HWND,LPSTR);
void WaitForSocket(void);
void SaveHosts(HWND, char *);
void GetHosts(HWND);
int BlockReceive(SOCKET,LPSTR,WORD);
int BlockSend(SOCKET ,LPSTR, WORD);
void EnableMenuItems(void);

BOOL CALLBACK ProtocolDlg(HWND hDlg, UINT message, WPARAM wParam, 
                          LPARAM lParam)
//---------------------------------------------------------------                          
{ WORD wOldComType;

  switch (message) 
   { case WM_INITDIALOG:      
       wOldComType = wComType;
       CheckRadioButton(hDlg,IDC_SOCKETS,IDC_MODEM,wComType);
       return TRUE;

     case WM_COMMAND:     
        switch (wParam)
         { case IDOK : 
              EndDialog(hDlg, NULL);
              return TRUE;
           
           case IDCANCEL :
              wComType = wOldComType;
              EndDialog(hDlg, NULL);
              return TRUE;
                 
           case IDC_SOCKETS : 
              GetOpponentsMove = GetOpponentsMoveWS;
              SendMove         = SendMoveWS;
              LoadGame         = GetGameWS;
              IsCommand        = IsCommandWS;
              StartGame        = NewGameWS;
              SetTime          = SetTimeWS;
              wComType = IDC_SOCKETS;
              return TRUE;
              
           case IDC_DDE :
              GetOpponentsMove = GetOpponentsMoveDDE;
              SendMove         = SendMoveDDE;
              LoadGame         = GetGameDDE;
              IsCommand        = IsCommandDDE;
              StartGame        = NewGameDDE;
              SetTime          = SetTimeDDE;
              wComType = IDC_DDE;
              return TRUE;
              
           case IDC_MODEM :
              wComType = IDC_MODEM;
              return TRUE;                 
         }
    }

    return (FALSE); 
}

BOOL IsCommandDDE(LPSTR lpszCommand)
//-----------------=----------------
{ HDDEDATA hddedata;
  LPSTR lpszGetBuf;
  DWORD dwBuflen;
  char str[10];
  short opp;

  if (lstrcmpi(lpszCommand,"COMG") == 0)
    { hddedata = DdeClientTransaction(NULL,0,hconvClient,hszGet,CF_TEXT,
                                  XTYP_REQUEST, 2000, NULL);
      NewGame(hwndMain);                            
      lpszGetBuf = (LPSTR)DdeAccessData(hddedata,&dwBuflen);
      DecodeGame(hwndMain,lpszGetBuf);
      flag.reverse = !flag.reverse;   
      DdeUnaccessData(hddedata);
      bWaiting=FALSE;
      User_Move = FALSE;
      UpdateDisplay (hwndMain, 0, 0, 1, 0);
      return TRUE;
    }       
    
  if (lstrcmpi(lpszCommand,"COMN") == 0)
    { opp = opponent;
      NewGame(hwndMain);
      if (opp == black)
        { computer = white;
          opponent = black;
          User_Move = TRUE;          
        }
      else
        { computer = black;
          opponent = white;
          User_Move = FALSE;
          flag.reverse = !flag.reverse;          
        }  
      UpdateDisplay(hwndMain,0,0,1,0);
      flag.force = false;
      Sdepth = 0; 
      bWaiting = FALSE; 
      return TRUE;
    }  
  if (lstrcmpi(lpszCommand,"COMT") == 0)
    { sscanf(moveinfo.szMove,"%4s%3d%3d",str,&TCmoves,&TCminutes);
      if (TCflag)
         SetTimeControl ();
      bWaiting=FALSE;
      return TRUE;
    }  
  return FALSE;      
}

BOOL CALLBACK LdRequestDlg(HWND hDlg, UINT message, WPARAM wParam,
                           LPARAM lParam)
//----------------------------------------------------------------
{ char *szPrompt;

  switch (message) 
   { case WM_INITDIALOG : 
       szPrompt = (char *) LOWORD((DWORD)lParam);
       SetDlgItemText(hDlg,IDS_PROMPT,szPrompt);
       return TRUE;
   
     case WM_COMMAND:     
        switch (wParam)
         { case IDB_AGREE : 
              EndDialog(hDlg,TRUE);
              return TRUE;   
           case ID_NO :
              EndDialog(hDlg,FALSE);
              return TRUE;
         }
   }
  return (FALSE); 
}


BOOL IsCommandWS(LPSTR lpszCommand)
//-----------------=----------------
{ LPSTR lpszGetBuf;
  SOCKET socket;
  unsigned long ulArgp;
  char szPrompt[80]; 
  short opp;

  if (lstrcmpi(lpszCommand,"COMG") == 0)
    { if (bHost)
        socket = socketServer;
      else
        socket = socketClient; 
      lstrcpy(szPrompt,"Opponent wants to load a saved game");  
      if (DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_REQUEST),hwndMain,
                    LdRequestDlg,MAKELPARAM(szPrompt,0)))
        { WSAAsyncSelect(socket,hwndMain,0,0L);
          ulArgp = 0;  
          ioctlsocket(socket,FIONBIO,&ulArgp);
          lpszGetBuf = (LPSTR)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,
                                             4096);
          if (lpszGetBuf == NULL)
            { MsgBox( NULL,
                      MB_ICONSTOP | MB_OK,
                     "Out of global memory");
              BlockSend(socket,"NO",3);
            }
          else  
            { BlockSend(socket,"OK",3); 
              BlockReceive(socket,lpszGetBuf,4095); 
              NewGame(hwndMain);                            
              DecodeGame(hwndMain,lpszGetBuf);
              flag.reverse = !flag.reverse;   
              GlobalFreePtr(lpszGetBuf);
            }  
        } 
      else
        BlockSend(socket,"NO",3);
      bWaiting=FALSE;
      User_Move = FALSE;
      Sdepth = 0;
      UpdateDisplay (hwndMain, 0, 0, 1, 0);
      ulArgp = 1;  
      ioctlsocket(socket,FIONBIO,&ulArgp);
      WSAAsyncSelect(socket,hwndMain,WM_SOCKET,
                         FD_READ | FD_CLOSE);      
      return TRUE;
    }                      
    
  if (lstrcmpi(lpszCommand,"COMN") == 0)
    { if (bHost)
        socket = socketServer;
      else
        socket = socketClient; 
      lstrcpy(szPrompt,"Opponent wants to start a new game");  
      if (DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_REQUEST),hwndMain,
                    LdRequestDlg,MAKELPARAM(szPrompt,0)))
        { WaitForSocket();
          WSAAsyncSelect(socket,hwndMain,0,0L);
          ulArgp = 0;  
          ioctlsocket(socket,FIONBIO,&ulArgp);          
          BlockSend(socket,"OK",3); 
          opp = opponent;
          NewGame(hwndMain);
          if (opp == black)
           { computer = white;  // they get swapped on return ie reverse logic
             opponent = black;
             User_Move = TRUE;          
           }
          else
           { computer = black;
             opponent = white;
             User_Move = FALSE;
             flag.reverse = !flag.reverse;          
           }  
          UpdateDisplay(hwndMain,0,0,1,0);
          flag.force = false;
          Sdepth = 0; 
        }  
      else
        BlockSend(socket,"NO",3);        
      bWaiting=FALSE;    
      ulArgp = 1;  
      ioctlsocket(socket,FIONBIO,&ulArgp);
      WSAAsyncSelect(socket,hwndMain,WM_SOCKET,
                         FD_READ | FD_CLOSE);          
      return TRUE;                   
    }    
    
    if (lstrcmpi(lpszCommand,"COMT") == 0)
    { if (bHost)
        socket = socketServer;
      else
        socket = socketClient; 
      lstrcpy(szPrompt,"Opponent wants to change time settings");  
      if (DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_REQUEST),hwndMain,
                    LdRequestDlg,MAKELPARAM(szPrompt,0)))
        { WaitForSocket();
          WSAAsyncSelect(socket,hwndMain,0,0L);
          ulArgp = 0;  
          ioctlsocket(socket,FIONBIO,&ulArgp);          
          BlockSend(socket,"OK",3); 
          BlockReceive(socket,szPrompt,7);
          sscanf(szPrompt,"%3d%3d",&TCmoves,&TCminutes);
          SetTimeControl ();
        }  
      else
        BlockSend(socket,"NO",3);        
      bWaiting=FALSE;  
      ulArgp = 1;  
      ioctlsocket(socket,FIONBIO,&ulArgp);
      WSAAsyncSelect(socket,hwndMain,WM_SOCKET,
                         FD_READ | FD_CLOSE);          
      return TRUE;
    }  
  
  return FALSE;      
}     

BOOL CALLBACK HostDlgDDE(HWND hDlg, UINT message, WPARAM wParam, 
                          LPARAM lParam)
//-----------------------------------------------------------
{ HSZ hszServer;

  switch (message) 
   { case WM_INITDIALOG:       
       hwndHostDlg = hDlg;
       bHost = TRUE;  
       if (!InitialiseDDE())
         { MessageBox(hDlg,"Error initializing DDE Link",
                      (LPSTR)NULL, MB_OK | MB_ICONSTOP);
           hwndHostDlg = NULL;           
           bHost = FALSE;
           EndDialog(hDlg, NULL);
           return TRUE;
         }       
       SetWindowText(hwndMain,"Winsock Chess (Waiting for Connection)");  
       return TRUE;

     case WM_CONNECTED :       
       hwndHostDlg = NULL;
       hszServer = DdeCreateStringHandle(idDdeClntInst,"WSCHESSC",NULL);
       hconvClient = DdeConnect(idDdeClntInst,hszServer,hszTopicCl,NULL);
       if (hconvClient == NULL)
         MessageBox(hDlg,"Could not open duplex link on DDE connect",
                    (LPSTR)NULL, MB_OK | MB_ICONSTOP);
       else
         bConnected = TRUE;
       EnableMenuItems();  
       SetWindowText(hwndMain,"Winsock Chess (Connected)");    
       EndDialog(hDlg, NULL);       
       return TRUE;   

     case WM_COMMAND:     
        switch (wParam)
         { case IDC_ABORT : 
              hwndHostDlg = NULL; 
              bHost = FALSE; 
              EndDialog(hDlg, NULL);
              return TRUE;   
              
         }
    }

    return (FALSE); 
}

BOOL CALLBACK ConnDdeDlg(HWND hDlg, UINT message, WPARAM wParam, 
                          LPARAM lParam)
//--------------------------------------------------------------
{ HSZ hszServer;

  switch (message) 
   { case WM_INITDIALOG:      
       if (!InitialiseDDE())
         { MessageBox(hDlg,"Error initializing DDEML",
                      (LPSTR)NULL, MB_OK | MB_ICONSTOP);
           EndDialog(hDlg, NULL);
           return TRUE;
         }
       hszServer   = DdeCreateStringHandle(idDdeClntInst,"WSCHESSH",NULL);
       hconvClient = DdeConnect(idDdeClntInst,hszServer,hszTopicCl,NULL);
       if (hconvClient == NULL)
         { SetWindowText(GetDlgItem(hDlg,IDC_CMESS),"Connection refused");
           SetWindowText(hwndMain,"Winsock Chess (Not Connected)");
         }  
       else
         { SetWindowText(GetDlgItem(hDlg,IDC_CMESS),"Connected");
           SetWindowText(hwndMain,"Winsock Chess (Connected)");  
         }  
       return TRUE;

     case WM_COMMAND:     
        switch (wParam)
         { case IDOK : 
             if (hconvClient != NULL)
               { computer = white;
                 opponent = black;
                 User_Move = FALSE;
                 bConnected = TRUE;
                 flag.reverse = !flag.reverse;
                 UpdateDisplay(hwndMain,0,0,1,0);
                 flag.force = false;
                 Sdepth = 0;
                 PostMessage ( hwndMain, MSG_COMPUTER_MOVE, NULL,NULL);  
               }
             else
               bConnected = FALSE;    
             EnableMenuItems();  
             EndDialog(hDlg, NULL);
             return TRUE;
         }     
    }

    return (FALSE); 
}

BOOL CALLBACK HostDlgWS(HWND hDlg, UINT message, WPARAM wParam, 
                          LPARAM lParam)
//-----------------------------------------------------------
{ switch (message) 
   { case WM_INITDIALOG:       
       hwndHostDlg = hDlg;
       bHost = TRUE;  
       if (!InitialiseWS())
         { hwndHostDlg = NULL;           
           bHost = FALSE;
           EndDialog(hDlg, NULL);
           return TRUE;
         }       
       SetDlgItemText(hDlg,IDS_WSMESS,szSockDesc);
       if (! ServerStartWS())
         { hwndHostDlg = NULL;           
           bHost = bConnected = FALSE;
           EndDialog(hDlg, NULL);
           return TRUE;
         }       
       SetWindowText(hwndMain,"Winsock Chess (Waiting for Connection)");    
       return TRUE;

     case WM_CONNECTED :       
//       SetWindowText(hwndMain,"Winsock Chess (Connected)");  
       hwndHostDlg = NULL;
       if (wParam == 0)
         bConnected = TRUE;
       else
         bConnected = bHost = FALSE;  
       EnableMenuItems();  
       EndDialog(hDlg, NULL);       
       return TRUE;   

     case WM_COMMAND:     
        switch (wParam)
         { case IDC_ABORT : 
              hwndHostDlg = NULL; 
              bHost = FALSE;
              DestroySocket(socketListen); 
              DestroySocket(socketServer); 
              WSACleanup();
              EndDialog(hDlg, NULL);
              return TRUE;   
              
         }
    }

    return (FALSE); 
}

BOOL CALLBACK ConnWSDlg(HWND hDlg, UINT message, WPARAM wParam, 
                          LPARAM lParam)
//--------------------------------------------------------------
{ char szIpAddr[50],szWinText[80];
    
  switch (message) 
   { case WM_INITDIALOG:      
       if (!InitialiseWS())
         { EndDialog(hDlg, NULL);
           return TRUE;
         } 
       GetHosts(hDlg);  
       return TRUE;

     case WM_COMMAND:     
        switch (wParam)
         { case IDOK :             
             SendDlgItemMessage(hDlg,IDC_COMBO1,WM_GETTEXT,(WPARAM)49,
                         (LPARAM)((LPSTR)szIpAddr));
             
             SaveHosts(hDlg,szIpAddr); 
             ShowWindow(GetDlgItem(hDlg,IDOK),SW_HIDE);
             ShowWindow(GetDlgItem(hDlg,IDCANCEL),SW_HIDE);
             SetWindowText(GetDlgItem(hDlg,IDS_WAIT),
                           "Attempting connection - Please Wait");
             if (ClientStartWS(szIpAddr))
               { computer = white;
                 opponent = black;
                 User_Move = FALSE;
                 bConnected = TRUE;
                 flag.reverse = !flag.reverse;
                 wsprintf(szWinText,"Winsock Chess (Connected to %s)",
                          (LPSTR)szIpAddr);
                 SetWindowText(hwndMain,szWinText);  
                 UpdateDisplay(hwndMain,0,0,1,0);
                 flag.force = false;
                 Sdepth = 0;
                 PostMessage ( hwndMain, MSG_COMPUTER_MOVE, NULL,NULL);  
               }  
             else
               bConnected = FALSE;  
             SetWindowText(GetDlgItem(hDlg,IDS_WAIT)," ");  
             ShowWindow(GetDlgItem(hDlg,IDOK),SW_SHOW);  
             ShowWindow(GetDlgItem(hDlg,IDCANCEL),SW_SHOW);  
             EnableMenuItems();  
             EndDialog(hDlg, NULL);
             return TRUE;
           
           case IDCANCEL:
             EndDialog(hDlg, NULL);
             return TRUE;  
         }     
    }

    return (FALSE); 
}

