/* Dialogs.H - WSMTPSRV's Resource IDs include file */
/*             Also includes some CASE IDs.         */

/* Range       Description
   100         Main Dialog (dialogs.dlg)
   101-110     Main Dialog control IDs
   200         About Dialog (dialogs.dlg)
   300-309     SMTP Reply Message IDs
   400-442     Windows Sockets Resource string IDs
   500-513     SMTP Control Tokens/Resource string IDs
   600-609     User messages
*/
#ifndef DIALOGS_H
#define DIALOGS_H

         /* Dialog control IDs */
#define dlgWSMTPSRV                 "DLGWSMTPSRV"
#define IDL_LOG                     101
#define IDE_PATH                    102
#define IDB_PATH                    103
#define IDI_ICON                    104
#define IDI_ICONEMPTY               105
#define IDI_ICONFULL                106
#define IDE_HOSTNAME                107
#define IDR_NORMAL                  108
#define IDR_DEBUG                   109
#define IDM_ABOUT                   120

        /* SMTP Reply Message IDs */
#define MSG_BASE                    300
#define MSG_WHOAREYOU_S_S_S         MSG_BASE+0
#define MSG_WHOAREYOU_S_S           MSG_BASE+1
#define MSG_HWOAREYOU_S_S_S         MSG_BASE+2
#define MSG_HWOAREYOU_S_S           MSG_BASE+3
#define MSG_HELLO_S_S               MSG_BASE+4
#define MSG_TOOBUSY_S               MSG_BASE+5
#define MSG_ALREADYSENDER           MSG_BASE+6
#define MSG_SENDEROK_S              MSG_BASE+7
#define MSG_RECIPIENTOK_S           MSG_BASE+8
#define MSG_NEEDMAIL                MSG_BASE+9
#define MSG_NOTEMP                  MSG_BASE+10
#define MSG_RESET                   MSG_BASE+11
#define MSG_IDONTDOTHATYET          MSG_BASE+12
#define MSG_SYNTAXERROR             MSG_BASE+13
#define MSG_OK                      MSG_BASE+14
#define MSG_GOODBYE_S               MSG_BASE+15
#define MSG_VERBOSEMODE             MSG_BASE+16
#define MSG_ONETRANSACTION          MSG_BASE+17
#define MSG_SHOWQ                   MSG_BASE+18
#define MSG_DEBUGSET                MSG_BASE+19
#define MSG_UNKNOWN                 MSG_BASE+20
#define MSG_I_AM_S_S                MSG_BASE+21
#define MSG_END_HELP_S              MSG_BASE+22
#define MSG_TEMPOPEN                MSG_BASE+23
#define MSG_MAILOPEN                MSG_BASE+24
#define MSG_SEEKERROR               MSG_BASE+25
#define MSG_SENDDATA                MSG_BASE+26
#define MSG_SEND8BITMIME            MSG_BASE+27
#define MSG_EHLLO_S_S               MSG_BASE+28
#define MSG_SENDEROK_8BITMIME_S     MSG_BASE+29
#define MSG_WIN3OK                  MSG_BASE+30

        /* Error Resource IDs */
#define ERROR_WSABASE               400
#define ERROR_WSANOTINITIALISED     ERROR_WSABASE
#define ERROR_WSAENETDOWN           ERROR_WSABASE+1
#define ERROR_WSAENETUNREACH        ERROR_WSABASE+2
#define ERROR_WSAENETRESET          ERROR_WSABASE+3
#define ERROR_WSAECONNABORTED       ERROR_WSABASE+4
#define ERROR_WSAECONNRESET         ERROR_WSABASE+5
#define ERROR_WSAEACCES             ERROR_WSABASE+6
#define ERROR_WSAEADDRNOTAVAIL      ERROR_WSABASE+7
#define ERROR_WSAEADDRINUSE         ERROR_WSABASE+8
#define ERROR_WSAEALREADY           ERROR_WSABASE+9
#define ERROR_WSAEDESTADDRREQ       ERROR_WSABASE+10
#define ERROR_WSAEMSGSIZE           ERROR_WSABASE+11
#define ERROR_WSAEBADF              ERROR_WSABASE+12
#define ERROR_WSAEFAULT             ERROR_WSABASE+13
#define ERROR_WSAEINTR              ERROR_WSABASE+14
#define ERROR_WSAEINPROGRESS        ERROR_WSABASE+15
#define ERROR_WSAEAFNOSUPPORT       ERROR_WSABASE+16
#define ERROR_WSAEINVAL             ERROR_WSABASE+17
#define ERROR_WSAEMFILE             ERROR_WSABASE+18
#define ERROR_WSAENOBUFS            ERROR_WSABASE+19
#define ERROR_WSAEISCONN            ERROR_WSABASE+20
#define ERROR_WSAENOTCONN           ERROR_WSABASE+21
#define ERROR_WSAESHUTDOWN          ERROR_WSABASE+22
#define ERROR_WSAETOOMANYREFS       ERROR_WSABASE+23
#define ERROR_WSAETIMEDOUT          ERROR_WSABASE+24
#define ERROR_WSAECONNREFUSED       ERROR_WSABASE+25
#define ERROR_WSAELOOP              ERROR_WSABASE+26
#define ERROR_WSAENAMETOOLONG       ERROR_WSABASE+27
#define ERROR_WSAEHOSTDOWN          ERROR_WSABASE+28
#define ERROR_WSAEHOSTUNREACH       ERROR_WSABASE+29
#define ERROR_WSASYSNOTREADY        ERROR_WSABASE+30
#define ERROR_WSAVERNOTSUPPORTED    ERROR_WSABASE+31
#define ERROR_WSAHOST_NOT_FOUND     ERROR_WSABASE+32
#define ERROR_WSATRY_AGAIN          ERROR_WSABASE+33
#define ERROR_WSANO_RECOVERY        ERROR_WSABASE+34
#define ERROR_WSANO_DATA            ERROR_WSABASE+35
#define ERROR_WSAENOTSOCK           ERROR_WSABASE+36
#define ERROR_WSAEPROTOTYPE         ERROR_WSABASE+37
#define ERROR_WSAENOPROTOOPT        ERROR_WSABASE+38
#define ERROR_WSAEPROTONOSUPPORT    ERROR_WSABASE+39
#define ERROR_WSAEOPNOTSUPP         ERROR_WSABASE+40
#define ERROR_WSAEPFNOSUPPORT       ERROR_WSABASE+41
#define ERROR_WSAEWOULDBLOCK        ERROR_WSABASE+42
#define ERROR_UNKNOWN               ERROR_WSABASE+43

        /* The Command tokens that double
            as string resource IDs */
#define CMDBASE                     500
#define CMDHELO                     CMDBASE
#define CMDVERB                     CMDBASE+1
#define CMDONEX                     CMDBASE+2
#define CMDMULT                     CMDBASE+3
#define CMDMAIL                     CMDBASE+4
#define CMDRCPT                     CMDBASE+5
#define CMDDATA                     CMDBASE+6
#define CMDRSET                     CMDBASE+7
#define CMDVRFY                     CMDBASE+8
#define CMDNOOP                     CMDBASE+9
#define CMDQUIT                     CMDBASE+10
#define CMDTICK                     CMDBASE+11
#define CMDTURN                     CMDBASE+12
#define CMDSEND                     CMDBASE+13
#define CMDSAML                     CMDBASE+14
#define CMDSOML                     CMDBASE+15
#define CMDDBGQSHOW                 CMDBASE+16
#define CMDDBGDEBUG                 CMDBASE+17
#define CMDERROR                    CMDBASE+18
#define CMDHELP                     CMDBASE+19
#define CMDEHLO                     CMDBASE+20
#define CMDXWIN3                    CMDBASE+21

#endif /* DIALOGS_H */

       /* User Message Resource IDs */
#define IDS_BASE                    600
#define IDS_FILTER                  IDS_BASE
#define IDS_PREV_INSTANCE           IDS_BASE+1
#define IDS_NO_WINSOCK              IDS_BASE+2
#define IDS_BAD_VERSION             IDS_BASE+3
#define IDS_SMTP_INIT               IDS_BASE+4
#define IDS_LOSTINPUT_S_S           IDS_BASE+5
#define IDS_CONFIGERROR             IDS_BASE+6
#define IDS_COULDNTOPEN_S           IDS_BASE+7
#define IDS_FILEERROR_S             IDS_BASE+8
#define LOG_CONNECT_S               IDS_BASE+9
#define LOG_DISCONNECT_S            IDS_BASE+10
#define LOG_RECEIVED_S              IDS_BASE+11
#define LOG_SENT_S                  IDS_BASE+12


