#include "animator.h"

//////////////////////////////////////////////////////////////////////////
// SettingsDlg - Dialog box window proc for getting the timer interval
// between icon changes from the user.
//////////////////////////////////////////////////////////////////////////

static HWND hwndEdit;
static HWND hwndLink;
static HWND hwndAuto;
static HWND hwndOK;
static HWND hwndMDI;
static short sChild;
static BOOL bAutoAnimate;

BOOL NEAR PASCAL Settings_OnInitDialog (HWND, HWND, LPARAM);
BOOL NEAR PASCAL Settings_OnCommand (HWND, UINT, HWND, UINT);


BOOL _export CALLBACK SettingsDlg(DLGPROC_PARAMS)
{
    switch (uMsg) 
    {
        case WM_INITDIALOG:
            return (BOOL)HANDLE_WM_INITDIALOG (hDlg, wParam, lParam,
                Settings_OnInitDialog);
        case WM_COMMAND:
            return (BOOL)HANDLE_WM_COMMAND (hDlg, wParam, lParam, 
                Settings_OnCommand);
    }
    return FALSE;
}


BOOL NEAR PASCAL Settings_OnInitDialog (HWND hwndDlg, HWND hwndFocus, 
    LPARAM lParam)
{
    hwndMDI  = MDI_GetActive (_hwndClient);

    if (IsWindow(hwndMDI)) 
    {
        sChild = WINDOWNUM(hwndMDI);
    }

    hwndEdit = GetDlgItem (hwndDlg, IDD_EDIT);
    hwndLink = GetDlgItem (hwndDlg, IDD_LINKFILENAME);
    hwndAuto = GetDlgItem (hwndDlg, IDD_AUTOANIMATE);
    hwndOK   = GetDlgItem (hwndDlg, IDOK);
    
    if(TIMEINT(sChild))
    {
        SetDlgItemInt (hwndDlg, IDD_EDIT, TIMEINT(sChild), FALSE);
    }

    if (SZEXELINK(sChild)[0] != '\0')
    {
        SetDlgItemText (hwndDlg, IDD_LINKFILENAME, (LPSTR)SZEXELINK(sChild));
    }

    // gray OK if bogus time interval
    EnableWindow (hwndOK, TIMEINT(sChild));       

    // gray OK if no file linked
    EnableWindow (hwndOK, (BOOL)(SZEXELINK(sChild)[0]!='\0'));

    CheckDlgButton (hwndDlg, IDD_AUTOANIMATE, 
                            bAutoAnimate = (BOOL)AUTOANIMATE(sChild));
    return (TRUE);
}



BOOL NEAR PASCAL Settings_OnCommand (HWND hwndDlg, UINT uMsg, HWND hwndCtl,
    UINT uNotify)
{
    switch (uMsg)
    {
        case IDD_EDIT:
        {
            if (uNotify == EN_CHANGE)
            {
                EnableWindow (hwndOK, Edit_GetTextLength(hwndCtl));
                EnableWindow (hwndOK, (BOOL)(SZEXELINK(sChild)[0]!='\0'));
            }
            return TRUE;
        }
        case IDOK:
        {
            BOOL fSuccess;
            short sNumber = GetDlgItemInt (hwndDlg, IDD_EDIT,
                        (BOOL FAR *)&fSuccess, FALSE);

            if (fSuccess && sNumber >= MINTIME && sNumber < MAXTIME)
            {
                HWND hwndTarget = (HWND) GetWindowLong(hwndDlg, DWL_USER);
                
                sNumber -= (sNumber % MINTIME);
                SET_TIMEINT (sChild, sNumber);
                
                GetDlgItemText (hwndDlg, IDD_LINKFILENAME,
                    (LPSTR)SZEXELINK(sChild), MAX_FILE_SIZE);
                SET_HWNDTARGET (sChild, hwndTarget);
                SET_EXELOADED (sChild, (BOOL)(hwndTarget!=NULL));
                SET_HPREVICON (sChild, GetClassWord (hwndTarget, GCW_HICON));
                SET_AUTOANIMATE (sChild, bAutoAnimate);

                EndDialog (hwndDlg, TRUE);
            }
            else
            {
                MESSAGE (IDS_TimeDlgRange);
            }
            break ;
        }
        case IDCANCEL:
        {
            EndDialog (hwndDlg, FALSE) ;
            break ;
        }
        case IDD_RUNNING:
        {
            FARPROC lpfnShowTask = 
                        MakeProcInstance ((FARPROC)ShowTaskDlg, _hInst);
            HWND hwndTarget = DialogBox (_hInst, SHOWTASKS, hwndDlg, 
                        lpfnShowTask);

            if (hwndTarget != NULL)
            {
                char szModuleFile[MAX_FILE_SIZE];

                SetWindowLong (hwndDlg, DWL_USER, (DWORD)hwndTarget);

                GetModuleFileName (GetWindowInstance(hwndTarget),
                    (LPSTR)szModuleFile, MAX_FILE_SIZE);

                SetDlgItemText (hwndDlg, IDD_LINKFILENAME, (LPSTR)szModuleFile);
            }

            FreeProcInstance (lpfnShowTask);
            
            // gray OK if no file linked
            EnableWindow (hwndOK, (BOOL)(SZEXELINK(sChild)[0]!='\0'));

            break;
        }
        case IDD_NOTRUNNING:
        {
            HWND hwndTarget = NULL;
            char szExe[MAX_FILE_SIZE];

            lstrcpy ((LPSTR)szExe, (LPSTR)SZEXELINK(sChild));

            if (LinkToExecutable((LPSTR)szExe))
            {
                hwndTarget = GetAppTaskWindow (szExe);

                SetWindowLong (hwndDlg, DWL_USER, (DWORD)hwndTarget);

                SetDlgItemText (hwndDlg, IDD_LINKFILENAME, (LPSTR)szExe);
            }

            // gray OK if no file linked
            EnableWindow (hwndOK, (BOOL)szExe[0]);
            
            break;
        }
        case IDD_AUTOANIMATE:
        {
            bAutoAnimate = !bAutoAnimate;
            break;
        }
        default:
            return FALSE ;
    }

    return TRUE;
}



HWND WINAPI GetAppTaskWindow (char * szFileName)
{
    HWND hwndNext;
    char szModFileName[MAX_FILE_SIZE];

    for (hwndNext = GetWindow (_hwndFrame,GW_HWNDFIRST) ;
         hwndNext ; 
         hwndNext = GetWindow (hwndNext,GW_HWNDNEXT))
    {
        GetModuleFileName (GetWindowInstance(hwndNext), 
            (LPSTR)szModFileName,sizeof (szModFileName));

        if (lstrcmp((LPSTR)szFileName,(LPSTR)szModFileName) == 0)
        {
            return hwndNext;
        }
    }

    return NULL;
}


