/*
 * These routines decode Windows 3.0 and OS/2 Device Independent Bitmap
 * files. The usual extensions are "bmp", "dib" and "rle". The initial
 * version of the BMP reading code was written by Maurice Castro and
 * Russell Lang.
 *
 * Adapted by Hippocrates Sendoukas, Los Angeles, September 1993
 */
#include "common1.c"
/*  <- read_huge_block */

static int PASCAL NEAR
read_huge_block(FILE *f,Uns8 *dibbits,unsigned long n)
{
  unsigned	delta;
  char huge	*p;

  p = (char huge *) dibbits;
  while (n)
    {
      delta = (n>16384LU) ? 16384 : (unsigned)n;
      if (fread((void *)p,1,delta,f)!=delta) return IE_BAD_FILE_DATA;
      p += delta;
      n -= delta;
    }
  return IE_OK;
}

/*  -> read_huge_block */
/*  <- make_compr_meta */

static int PASCAL NEAR
make_compr_meta(FILE *f,unsigned nx,unsigned ny,BITMAPINFO *bi,
                HPALETTE hpal,HANDLE *hmf)
{
  HDC		hdc;
  unsigned	retcode;
  unsigned long temp;
  Uns8		*dibbits;

  temp = bi->bmiHeader.biSizeImage;
  if ( (dibbits=malloc(temp)) == NULL ) return IE_MEM_FULL;
  if ( (hdc=CreateMetaFile(NULL)) == 0 )
    {
      free(dibbits);
      return IE_MEM_FULL;
    }
  SetWindowOrg(hdc,0,0);
  SetWindowExt(hdc,nx,ny);
  if (hpal)
    {
      SelectPalette(hdc,hpal,0);
      RealizePalette(hdc);
    }
  retcode = read_huge_block(f,dibbits,temp);
  if (retcode==IE_OK)
    if (!StretchDIBits(hdc,0,0,nx,ny,0,0,nx,ny,(LPSTR)dibbits,bi,
                       DIB_RGB_COLORS,SRCCOPY))
      retcode = IE_MEM_FULL;
  free(dibbits);
  *hmf = CloseMetaFile(hdc);
  if (*hmf && retcode!=IE_OK)
    {
      DeleteMetaFile(*hmf);
      *hmf = 0;
    }
  return retcode;
}

/*  -> make_compr_meta */
/*  <- get_chunk */

static int PASCAL NEAR
get_chunk(FILE *f,Uns8 *dibbits,unsigned bpl,unsigned ny)
{
  for (   ;  ny>0;  ny--)
    {
      fread(dibbits,1,bpl,f);
      dibbits += bpl;
    }
  return feof(f) ? IE_BAD_FILE_DATA : IE_OK;
}

/*  -> get_chunk */
/*  <- make_normal_meta */

static int PASCAL NEAR
make_normal_meta(FILE *f,unsigned nx,unsigned ny,BITMAPINFO *bi,
                 HPALETTE hpal,HANDLE *hmf)
{
  HDC		hdc;
  unsigned	wpl,y1,y2,dy,maxdy,retcode;
  unsigned long temp;
  Uns8		*dibbits;

  temp = (unsigned long) nx * (unsigned long) bi->bmiHeader.biBitCount;
  temp += 31;
  temp /= 32;
  temp *= 2;
  wpl = (unsigned) temp;
  maxdy = 16384u/wpl;                           /* 32K chunks */
  if (maxdy==0) return IE_TOO_BIG;
  if (maxdy>1) maxdy--;
  if (maxdy>ny) maxdy = ny;
  if ( (dibbits=malloc(2*wpl*maxdy)) == NULL )  return IE_MEM_FULL;

  if ( (hdc=CreateMetaFile(NULL)) == 0 )
    {
      free(dibbits);
      return IE_MEM_FULL;
    }
  SetWindowOrg(hdc,0,0);
  SetWindowExt(hdc,nx,ny);
  if (hpal)
    {
      SelectPalette(hdc,hpal,0);
      RealizePalette(hdc);
    }
  for (y1=0,y2=ny;  y1<y2;  )
    {
      dy = min(y2-y1,maxdy);
      bi->bmiHeader.biHeight = dy;
      bi->bmiHeader.biSizeImage = 2*wpl*dy;
      retcode = get_chunk(f,dibbits,2*wpl,dy);
      if (retcode!=IE_OK) break;
      if (!StretchDIBits(hdc,0,ny-dy-y1,nx,dy,0,0,nx,dy,(LPSTR)dibbits,bi,
                        DIB_RGB_COLORS,SRCCOPY))
        {
          retcode = IE_MEM_FULL;
          break;
        }
      y1 += dy;
    }
  free(dibbits);
  *hmf = CloseMetaFile(hdc);
  if (*hmf && retcode!=IE_OK)
    {
      DeleteMetaFile(*hmf);
      *hmf = 0;
    }
  bi->bmiHeader.biHeight = ny;
  bi->bmiHeader.biSizeImage = 0;
  return retcode;
}

/*  -> make_normal_meta */
/*  <- bmp_read_hdr */

static int PASCAL NEAR
bmp_read_hdr(FILE *f,BITMAPINFO *bi,unsigned *colors)
{
  unsigned		n,is_os2_bmp;
  RGBQUAD		*pal;
  BITMAPINFOHEADER	*bih;
  char buf[16];

  fread(buf,1,14,f);
  if (feof(f) || memcmp(buf,"BM",2)) return 0;
  bih = &(bi->bmiHeader);
  bih->biSize = readUns32(f);
  if (bih->biSize == 12)
    {
      is_os2_bmp		= 1;
      bih->biSize		= 40;		/* Placate windows */
      bih->biWidth		= readUns16(f);
      bih->biHeight		= readUns16(f);
      bih->biPlanes		= readUns16(f);
      bih->biBitCount		= readUns16(f);
      bih->biCompression	= BI_RGB;
      bih->biSizeImage		= 0;
      bih->biXPelsPerMeter	= 0;
      bih->biYPelsPerMeter	= 0;
      bih->biClrUsed		= 0;
      bih->biClrImportant	= 0;
    }
  else
    {
      is_os2_bmp		= 0;
      bih->biWidth		= readUns32(f);
      bih->biHeight		= readUns32(f);
      bih->biPlanes		= readUns16(f);
      bih->biBitCount		= readUns16(f);
      bih->biCompression	= readUns32(f);
      bih->biSizeImage		= readUns32(f);
      bih->biXPelsPerMeter	= readUns32(f);
      bih->biYPelsPerMeter	= readUns32(f);
      bih->biClrUsed		= readUns32(f);
      bih->biClrImportant	= readUns32(f);
    }
  if ( feof(f) || bih->biPlanes!=1 || bih->biWidth==0 || bih->biHeight==0 ||
       bih->biClrUsed>256 )
    return 0;

  n = bih->biBitCount;
  if (n!=1 && n!=4 && n!=8 && n!=24) return 0;
  if (bih->biSizeImage==0 && bih->biCompression!=BI_RGB) return 0;

  n = (unsigned) bih->biClrUsed;
  if (n==0 && bih->biBitCount!=24)   n = 1 << bih->biBitCount;
  *colors = n;
  for (pal=bi->bmiColors;  n>0;  pal++,n--)
    {
      pal->rgbBlue	= readUns8(f);
      pal->rgbGreen	= readUns8(f);
      pal->rgbRed	= readUns8(f);
      pal->rgbReserved	= (is_os2_bmp) ? 0 : readUns8(f);
    }
  return !feof(f);
}

/*  -> bmp_read_hdr */
/*  <- bmpgraph */

static int PASCAL NEAR
bmp_graph(char *fname,HANDLE *hmf,int *nx,int *ny)
{
  unsigned		width,height,colors,retcode;
  HPALETTE		hpal;
  FILE			*f;
  BITMAPINFO		*bi;

  if ( (f=fopen(fname,"r")) == NULL ) return IE_NO_FILE;
  if ((bi=malloc(sizeof(BITMAPINFOHEADER)+256*sizeof(RGBQUAD)))==NULL)
    {
      fclose(f);
      return IE_MEM_FULL;
    }
  if (!bmp_read_hdr(f,bi,&colors))
    {
      free(bi);
      fclose(f);
      return IE_BAD_FILE_DATA;
    }
  hpal = 0;
  if (colors) hpal = make_palette(colors,&(bi->bmiColors[0]));
  width		= (unsigned) bi->bmiHeader.biWidth;
  height	= (unsigned) bi->bmiHeader.biHeight;
  retcode	= (bi->bmiHeader.biCompression == BI_RGB) ?
                      make_normal_meta(f,width,height,bi,hpal,hmf) :
                      make_compr_meta (f,width,height,bi,hpal,hmf) ;
  if (hpal)	DeleteObject(hpal);
  free(bi);
  fclose(f);
  *nx = width;
  *ny = height;
  return retcode;
}

/*  -> bmpgraph */
#define read_graphic(fname,hmf,x,y)	bmp_graph(fname,hmf,x,y)
#include "common2.c"
