/*
 * All filters can use the routines below. Just make sure that
 * read_graphics() is defined as a macro for a function with
 * the following prototype:
 *    int read_graphics(LPSTR filename,LPHANDLE hmf,int *nx,int *ny)
 *
 * Written by Hippocrates Sendoukas, Los Angeles, September 1993
 */
/*  <- GetFilterInfo */

#pragma argsused
WORD FAR PASCAL
GetFilterInfo(WORD version,LPSTR iniinfo,LPHANDLE hmem,LPHANDLE ftypes)
{
  return 2;
}

/*  -> GetFilterInfo */
/*  <- GetFilterPref */

#pragma argsused
void FAR PASCAL
GetFilterPref(HANDLE hinst,HWND hwnd,HANDLE hmem,WORD flags)
{
}

/*  -> GetFilterPref */
/*  <- ImportGR */

#pragma argsused
WORD FAR PASCAL
ImportGR(HDC hdc,LPFILESPEC fs,LPPICTINFO pi,HANDLE hmem)
{
  HANDLE hmf;
  int nx,ny,retcode;

  memset(pi,0,sizeof(PICTINFO));
  hmf = 0;
  retcode = read_graphic(fs->fullname,&hmf,&nx,&ny);
  if (retcode!=IE_OK) return retcode;
  pi->hmf = hmf;
  pi->bbox.left = pi->bbox.top = 0;
  pi->bbox.right = nx;
  pi->bbox.bottom = ny;
  if (hdc)
    pi->inch = GetDeviceCaps(hdc,LOGPIXELSX);
  else
    {
      hdc = GetDC(0);
      pi->inch = GetDeviceCaps(hdc,LOGPIXELSX);
      ReleaseDC(0,hdc);
    }
  return IE_OK;
}

/*  -> ImportGR */
/*  <- LibMain */

#pragma argsused
int FAR PASCAL
LibMain(HANDLE hinst,WORD dataseg,WORD heapsize,LPSTR cmdline)
{
  if (heapsize>0) UnlockData(0);
  return 1;
}

/*  -> LibMain */
