#ifndef __FILTER_H__
#define __FILTER_H__

#ifndef __GRAPHIO_H__
#include "graphio.h"
#endif

typedef struct	{
  WORD		flags;
  DWORD		ftype;
  WORD		handle;
  char		fullname[124];
  DWORD		filepos;
  } FILESPEC, FAR *LPFILESPEC;
/*
 * Version 1.0 filter functions
 */
typedef WORD (FAR PASCAL *PFN_INFO)	(WORD,LPSTR,LPHANDLE,LPHANDLE);
typedef void (FAR PASCAL *PFN_PREF)	(HANDLE,HWND,HANDLE,WORD);
typedef WORD (FAR PASCAL *PFN_IMPORT)	(HDC,LPFILESPEC,LPPICTINFO,HANDLE);
/*
 * Version 2.0 filter functions
 */
typedef WORD (FAR PASCAL *PFN_VER)	(DWORD,BOOL FAR *,LPWORD,LPWORD);
typedef WORD (FAR PASCAL *PFN_ISMY)	(LPFILESPEC);
typedef WORD (FAR PASCAL *PFN_PREF2)	(HANDLE,HANDLE,LPHANDLE,DWORD,FARPROC,LPFILESPEC);
typedef WORD (FAR PASCAL *PFN_OUTPUT)	(HDC,HDC,LPFILESPEC,LPSTR,LPPICTINFO,HANDLE,FARPROC,BOOL);

WORD FAR PASCAL GetFilterInfo(WORD version,LPSTR iniinfo,LPHANDLE hmem,
			LPHANDLE ftypes);
void FAR PASCAL GetFilterPref(HANDLE hinst,HWND hwnd,HANDLE hmem,WORD flags);
WORD FAR PASCAL ImportGR(HDC hdc,LPFILESPEC fs,LPPICTINFO pi,HANDLE hmem);


/*
 * Import Error Codes
 */
#define	IE_OK			0
#define IE_BASE			5300		/* base value for IE_ error codes */
#define IE_NOT_MY_FILE		(IE_BASE+1)	/* generic "not my file" error */
#define IE_TOO_BIG		(IE_BASE+2)	/* bitmap or pict too big error */
#define IE_DUMB_BITMAP		(IE_BASE+3)	/* bitmap all white */
#define IE_UNKNOWN_TYPE		(IE_BASE+7)	/* unknown file type */
#define IE_BAD_FILE_DATA 	(IE_BASE+9)  	/* current file data is bad */
#define IE_IMPORT_ABORT 	(IE_BASE+10)	/* import abort alert */
#define IE_MEM_FULL		(IE_BASE+11)	/* ran out of memory during import */
#define IE_METAFILE_TOO_BIG	(IE_BASE+13)	/* metafile too big */
#define IE_INVALID_LOTUS_PIC	(IE_BASE+14)	/* bad lotus .pic */
#define IE_MEM_FAIL		(IE_BASE+15)	/* couldn't lock memory during import */
#define IE_PAINT_BASE		(IE_BASE+40)
#define IE_UNSUPP_COMPR		(IE_PAINT_BASE+1) /* unsupp'd compress. style */
#define IE_UNSUPP_VERSION	(IE_PAINT_BASE+2) /* unsupp'd file version */
#define IE_UNSUPP_COLOR		(IE_PAINT_BASE+3) /* can't handle this color style */
#define	IE_NO_FILE		(-1)		/* cannot open file */

#endif
