/* cordine.c ... freeware button accordion dialog example
 * jack j. woehr p.o. box 51, golden co 80402-0051
 * jax@well.sf.ca.us JAX on GEnie 72203.1320@compuserve.com
 * SYSOP, RealTime Control & Forth Board [RCFB] (303) 278-0364
 */

#include <windows.h>
#include "cordine.h"

HINSTANCE hInst;

char szAppName[] = "Cordine";

int APIENTRY WinMain(
	HINSTANCE hInstance,
        HINSTANCE hPrevInstance,
	LPSTR lpCmdLine,
	int nCmdShow)
{

	MSG msg;
//	HANDLE hAccelTable;

	if (!hPrevInstance) {
			if (!InitApplication(hInstance)) {
			return (FALSE);
		}
	}

	if (!InitInstance(hInstance, nCmdShow)) {
		return (FALSE);
	}

	while (GetMessage(&msg, NULL, 0, 0))  
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (msg.wParam);
	lpCmdLine;
}

BOOL InitApplication(HINSTANCE hInstance)
{
	WNDCLASS  wc;
	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = (WNDPROC)WndProc; 
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hInstance     = hInstance; 
	wc.hIcon         = LoadIcon(hInstance,"Cordine");
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = szAppName;

	return (RegisterClass(&wc));
}

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow)
{
	HWND            hWnd; 
	hInst = hInstance;

	hWnd = CreateWindow(
		szAppName,
		szAppName,
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
		NULL,
		NULL,
		hInstance,
		NULL
	);

	if (!hWnd) {
		return (FALSE);
	}

	ShowWindow(hWnd, SW_MINIMIZE);
	UpdateWindow(hWnd);
	return (TRUE);
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT message, WPARAM uParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_SYSCOMMAND:
			switch (0xfff0 & uParam)
			{
				case SC_MAXIMIZE:
				DialogBox(hInst, MAKEINTRESOURCE (100), hWnd, (DLGPROC)CordineProc);
				return (0);

				case SC_RESTORE:
				DialogBox(hInst, MAKEINTRESOURCE (100), hWnd, (DLGPROC)CordineProc);
				return (0);
			}

		default:
			return (DefWindowProc(hWnd, message, uParam, lParam));
	}
	return (0);
}

LRESULT CALLBACK CordineProc ( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	HWND idCntrl;
	HMENU sysMenu;

	switch (message)
	{
		case WM_INITDIALOG:
			if (idCntrl = GetDlgItem (hDlg, IDM_DURATION))
			{
			SetScrollRange (idCntrl, SB_CTL, 50, 500, FALSE) ;
			// We allow a tone duration of 50 mS to 500 ms
			SetScrollPos (idCntrl, SB_CTL, duration, TRUE) ;
			}
			sysMenu = GetSystemMenu (hDlg, FALSE);
			AppendMenu (sysMenu, MF_STRING|MF_ENABLED, IDMSC_HELP, "&Help");
			AppendMenu (sysMenu, MF_STRING|MF_ENABLED, IDMSC_ABOUT, "&About");
			return FALSE;

		case WM_COMMAND:
			switch (wParam)
			{
				case IDM_LO_C:
					Beep ((DWORD) TONE_LO_C, (DWORD) duration);
					return FALSE;

				case IDM_LO_G:
					Beep ((DWORD) TONE_LO_G, (DWORD) duration);
					return FALSE;

				case IDM_C:
					Beep ((DWORD) TONE_C, (DWORD) duration);
					return FALSE;

				case IDM_G:
					Beep ((DWORD) TONE_G, (DWORD) duration);
					return FALSE;

				case IDM_LO_D:
					Beep ((DWORD) TONE_LO_D, (DWORD) duration);
					return FALSE;

				case IDM_LO_A:
					Beep ((DWORD) TONE_LO_A, (DWORD) duration);
					return FALSE;

				case IDM_D:
					Beep ((DWORD) TONE_D, (DWORD) duration);
					return FALSE;

				case IDM_A:
					Beep ((DWORD) TONE_A, (DWORD) duration);
					return FALSE;

				case IDM_LO_E:
					Beep ((DWORD) TONE_LO_E, (DWORD) duration);
					return FALSE;

				case IDM_LO_BFLAT:
					Beep ((DWORD) TONE_LO_BFLAT, (DWORD) duration);
					return FALSE;

				case IDM_E:
					Beep ((DWORD) TONE_E, (DWORD) duration);
					return FALSE;

				case IDM_BFLAT:
					Beep ((DWORD) TONE_BFLAT, (DWORD) duration);
					return FALSE;

				case IDM_LO_F:
					Beep ((DWORD) TONE_LO_F, (DWORD) duration);
					return FALSE;

				case IDM_LO_B:
					Beep ((DWORD) TONE_LO_B, (DWORD) duration);
					return FALSE;

				case IDM_F:
					Beep ((DWORD) TONE_F, (DWORD) duration);
					return FALSE;

				case IDM_B:
					Beep ((DWORD) TONE_B, (DWORD) duration);
					return FALSE;

				case IDM_HI_C:
					Beep ((DWORD) TONE_HI_C, (DWORD) duration);
					return FALSE;

				case IDM_HI_G:
					Beep ((DWORD) TONE_HI_G, (DWORD) duration);
					return FALSE;

				case IDM_HI_D:
					Beep ((DWORD) TONE_HI_D, (DWORD) duration);
					return FALSE;

				case IDM_HI_A:
					Beep ((DWORD) TONE_HI_A, (DWORD) duration);
					return FALSE;

				case IDM_HI_E:
					Beep ((DWORD) TONE_HI_E, (DWORD) duration);
					return FALSE;

				case IDM_HI_BFLAT:
					Beep ((DWORD) TONE_HI_BFLAT, (DWORD) duration);
					return FALSE;

				case IDM_HI_F:
					Beep ((DWORD) TONE_HI_F, (DWORD) duration);
					return FALSE;

				case IDM_HI_B:
					Beep ((DWORD) TONE_HI_B, (DWORD) duration);
					return FALSE;
				
				default:
					return FALSE;
			}

		case WM_HSCROLL :
			switch (LOWORD (wParam))
			{
				case SB_BOTTOM :	// Scroll to bottom.
					duration = 500 ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_LINEDOWN :	// Scroll one line down.
					duration = min (500, duration + 5) ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_LINEUP :	// Scroll one line up.
					duration = max (50, duration -5) ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_PAGEDOWN :	// Scroll one page down.
					duration = min (500, duration + 50) ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_PAGEUP :	// Scroll one page up. 
 					duration = max (50, duration - 50) ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_THUMBPOSITION :
					duration = HIWORD (wParam) ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_THUMBTRACK :
					duration = HIWORD (wParam) ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				case SB_TOP:	// Scroll to top. 
					duration = 50 ;
					SetScrollPos ( (HWND) (lParam), SB_CTL, duration, TRUE) ;
					return 0 ;

				default:
					return FALSE ;
			}

		case WM_SYSCOMMAND :
			switch (wParam)
			{
				case SC_CLOSE:
					EndDialog (hDlg,TRUE);
					return TRUE;

				case IDMSC_ABOUT:
					DialogBox (hInst, MAKEINTRESOURCE (300), hDlg, (DLGPROC)AboutProc);
					return TRUE;

				case IDMSC_HELP:
					DialogBox (hInst, MAKEINTRESOURCE (500), hDlg, (DLGPROC)HelpProc);
					return TRUE;

				default:
					return FALSE ;
			}
	}
	return (FALSE);

	lParam;
}

LRESULT CALLBACK AboutProc ( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			Beep ( (DWORD) 55, (DWORD) 500);
			return FALSE;

		case WM_COMMAND:
			switch (wParam)
			{
				case ABOUT_OK1:
					EndDialog (hDlg,TRUE);
					return FALSE;

				case ABOUT_OK2:
					EndDialog (hDlg,TRUE);
					return FALSE;

				default:
					return FALSE;
			}

		case WM_SYSCOMMAND :
			switch (wParam)
			{
				case SC_CLOSE:
					EndDialog (hDlg,TRUE);
					return TRUE;

				default:
					return FALSE ;
			}
		default:
			return FALSE;
	}
}

LRESULT CALLBACK HelpProc ( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDMSC_BAYOU:
					EndDialog (hDlg,TRUE);
					return FALSE;

				default:
					return FALSE;
			}

		case WM_SYSCOMMAND :
			switch (wParam)
			{
				case SC_CLOSE:
					EndDialog (hDlg,TRUE);
					return TRUE;

				default:
					return FALSE ;
			}
		default:
			return FALSE;
	}
}
