/*
	DEMOTOOL.C -- program to demonstrate the abilities of
        Tool Bar control implemented in ESTOOLS.DLL
	Copyright (C) Eugene Sokolov 1992-93, (516)632-7892,
	esokolov@sbchm1.chem.sunysb.edu

	You can freely copy, change or redistribute this file as long
	as this notice remains intact.
*/

#define STRICT	

#include <windows.h>
#include "esdefs.h"

LRESULT CALLBACK 	MainWndProc	( HWND, UINT, WPARAM, LPARAM );
extern HWND FAR PASCAL 	CreateToolBar	( HINSTANCE, LPSTR, HWND, POINT );

HINSTANCE hInst;

BOOL InitApplication(HINSTANCE hInstance)
{
   WNDCLASS  wc;

   wc.style 		= CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc 	= (long (FAR PASCAL*)())MainWndProc;
														// windows of this class.
   wc.cbClsExtra 	= 0;	
   wc.cbWndExtra 	= 0;	
   wc.hInstance 	= hInstance;
   wc.hIcon 		= LoadIcon( hInstance, MAKEINTRESOURCE(TBICON) );
   wc.hCursor 		= LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground 	= GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName 	= MAKEINTRESOURCE(TBMENU);
   wc.lpszClassName 	= "ESDemoTools";


   return (RegisterClass(&wc));
}


/************************************************************************/
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd;

	hInst = hInstance;

	hWnd = CreateWindow(
		"ESDemoTools",	// See RegisterClass() call.
		"ES Toolbar Demo",	// Text for window title bar.
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,	// Window style.
		CW_USEDEFAULT,			// Default horizontal position.
		CW_USEDEFAULT,			// Default vertical position.
		CW_USEDEFAULT,			// Default width.
		CW_USEDEFAULT,			// Default height.
		NULL,		
		NULL,		
		hInstance,	
		NULL		
	);

	if (!hWnd)
		return (FALSE);

	ShowWindow(hWnd, nCmdShow);	// Show the window
	UpdateWindow(hWnd);		// Sends WM_PAINT message
	return (TRUE);		// Returns the value from PostQuitMessage

}


LRESULT CALLBACK MainWndProc( HWND hWnd, UINT message,
					 WPARAM wParam, LPARAM lParam )
{
        static HWND hwndTBar;
	switch (message)
	{

	case WM_CREATE:
	{
	   POINT pnt;
           pnt.x=pnt.y=0;
	   hwndTBar=CreateToolBar( hInst, (LPSTR)MAKEINTRESOURCE(TOOLBAR), hWnd, pnt );
	   if( !hwndTBar )
	   {
	      MessageBox( hWnd, "Could not create Tool Bar window", NULL, MB_OK );
	      PostMessage( hWnd, WM_CLOSE, 0, 0L );
	   }
           break;
        }

	case WM_COMMAND:

	/* The following WM_COMMAND message processing was NOT intended to be
	   nicely written and serves as an example only to show the abilities
	   of the Tool Bar control. */
	    
	   switch( wParam )
           {

	      case ID_CMD1:
	      case ID_CMD2:
	      case ID_CMD3:
	      case ID_CMD4:
	      case ID_CMD5:
              {
	   /* This simply prints the wParam of the WM_COMMAND message
	      which is equal to the ID number of the pressed TB button
           */
	         HDC hdc;
                 char buffer[64];
	         hdc = GetDC( hWnd );
		 wsprintf( buffer,"Message WM_COMMAND, wParam=0x%X (%u), button # %d",
		    wParam, wParam, GetButtonNumber( hwndTBar, wParam ) );
	         TextOut( hdc, 10, 20, buffer, lstrlen( buffer ) );
		 ReleaseDC( hWnd, hdc );
		 break;
	      }
	      case 1100:
	      case 1200:
	      case 1300:
	      case 1400:
	      case 1500:
	      /* Toggle disable/enable button */
	      {
		 int button=(wParam-1100)/100;
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
                    MF_UNCHECKED:MF_CHECKED );
		 ES_TB_Toggle_Enable_Disable_Demo( hwndTBar, button );
		 // This function actually calls SendMessage API which sends
		 // a message to hwndTBar window to change the corresponding
		 // style (explanation and source for these functions is sent to registred
		 // users only).
		 // 
		 // Of course you can try to 'Spy' the messages. But I do
		 // not think the effort would be worth $15. Anyway, you are
		 // not allowed to use it in your programs unless you are
		 // registered.
	      }
	      break;

	      case 1101:
	      case 1201:
	      case 1301:
	      case 1401:
	      case 1501:
	      /* Toggle standard/auto 2 state button */
	      {
		 int button=(wParam-1100)/100;
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
                    MF_UNCHECKED:MF_CHECKED );
		 ES_TB_Toggle_Standard_Auto2State_Demo( hwndTBar, button );
		 // you need to register to get the documentation on this
		 // option. Read the explanation above.
	      }
	      break;

	      case 1102:
	      case 1202:
	      case 1302:
	      case 1402:
	      case 1502:
	      /* Toggle standard/2 state button */
	      {
		 int button=(wParam-1100)/100;
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
                    MF_UNCHECKED:MF_CHECKED );
		 ES_TB_Toggle_Standard_2State_Demo( hwndTBar, button );
		 // you need to register to get the documentation on this
		 // option. Look up there 
		 break;
	      }
	      case 2001:
	      case 2002:
	      case 2003:
	      case 2004:
	      case 2005:
	      /*
		 This function calls SendMessage which sends the corresponding
		 message to hwndTBar to set the number of buttons per row.
		 Although you could specify 0 in resource header to get horizontal
		 tool bar, here you have to supply the actual number, 0 does not
		 work - it will be ignored
	      */
		 ES_TB_Set_Number_of_Controls_Demo( hwndTBar, wParam-2000 ); //Register!
		 ShowWindow( hwndTBar, SW_SHOW );
	      /*
		 Calls to this and following functions will hide the TB from
		 the screen. You need to show the window explicitly. I removed
		 this call to ShowWindow from DLL to give a programmer the
		 possibility to move the window after it's style was changed before
		 the window is displayed. Thus you can override the default
                 positions of window and so on.
               */
		 break;
               /*
	      case 2006:
		 I want to point out that there is no example on something
		 like
		 ES_TB_Toggle_Popup_Child_Demo( hwndTBar );
		 It is not because it is undocumented but because it is
		 not implemented. This simply does not work, Windows 3.x
		 cannot convert WS_POPUP to WS_CHILD and back. Or at least I
		 can say I do not know about this possibility. If you want
		 this, you need to destroy the TB with one style and create
                 with another. Or tell me how to make it work.
              */
	      case 2007:
	      {
                 /* Toggles caption/no caption TB */
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
                    MF_UNCHECKED:MF_CHECKED );

		 ES_TB_Toggle_Movable_Fixed_Demo( hwndTBar ); //Register!
		 ShowWindow( hwndTBar, SW_SHOW );
                 break;
	      }
	      case 2008:
	      {
                 /* Toggles border/no border TB styles */
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
                    MF_UNCHECKED:MF_CHECKED );

		 ES_TB_Toggle_BorderStyle_Demo( hwndTBar );   //Register!
		 ShowWindow( hwndTBar, SW_SHOW );
                 break;
	      }

	      default:;
	   }
	   break;
	case WM_CLOSE:
	   DestroyWindow(hWnd);
	   break;

	case WM_QUIT:
	case WM_DESTROY:
	   PostQuitMessage(0);
	   break;

	/*
	   The following two message control the style of TB caption
	   It is intended to be active always when the parent is active.
	   It cannot be done without a cooperation from parent's side.
	   It may have some bugs. Try, if you have problems, contact me.
	*/  
	case WM_NCACTIVATE:
	/* The following is required in order to prevent DefWindowProc
	   from redrawing the caption bar of this window in inactive style
	   when tool bar window is activated. Try to remove this and you
	   will see caption bar flashing when you click in TB window.
	   Whenever TB becomes active it passes the active state to it's
	   parent and becomes inactive, to look active it redraws it's caption
           in the active style.
	*/
	   if( (HWND)LOWORD(lParam)==hwndTBar )
	      return TRUE;

	case WM_ACTIVATEAPP:
	/* This is necessary to draw a title bar of TB in inactive style
	   when the application becomes inactive. TB is never active and cannot
	   process this message by itself. If you remove this part TB will
	   remain looking 'active' even if another application is activated */
	   if( !wParam )
	      SendMessage( hwndTBar, WM_NCACTIVATE, FALSE, 0L );
	   else SendMessage( hwndTBar, WM_NCACTIVATE, TRUE, 0L );
	   //break;  -- DO NOT PUT IT HERE. Documentation states incorrectly that
	   // you can return 0 if you process this message. You cannot, if you
	   // return FALSE you prevent another application from activation.
	   // If you want you may try to return wParam for default processing.
	default:
	   return (DefWindowProc(hWnd, message, wParam, lParam));
   }
   return (NULL);
}

#pragma argsused
/**************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
			 LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;		
	if( !hPrevInstance )	
	   if (!InitApplication(hInstance))
		return (FALSE);	

	if (!InitInstance(hInstance, nCmdShow))
	   return (FALSE);

	while( GetMessage( &msg, NULL, NULL, NULL ) )	
	{
		TranslateMessage(&msg);	
		DispatchMessage(&msg);	
	}
	return (msg.wParam);
}


