/* This file is DPMI.H
** Copyright (c) Rainer Schnitker 10/91
*/
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef struct {
                WORD lim_lo,base_lo;
                BYTE base_mi,access;
                BYTE lim_hi,base_hi;
                } DESCRIPTOR ;
typedef struct {
		WORD limit,lo,hi ;
	       } GDTR ;
typedef struct {
		WORD off_lo;
		WORD sel;
		BYTE count;
		BYTE type;
		WORD off_hi;
		} GATE;
typedef struct { DWORD i1,i2,i3,i4,i5,i6,i7,i8,i9,r1,r2,r3 ;} 
		FREEMEMINFO;

#define DPMI(function)  { _AX = function ; asm int 31h ; }

void real_to_protected(void);
void protected_to_real(void);
WORD AllocLDT(WORD);
int FreeLDT(WORD);
WORD SegtoSel(WORD);
WORD SelInc(void);
int LockSel(WORD);
int UnlockSel(WORD);
DWORD GetBaseAddress(WORD);
int SetBaseAddress(WORD,DWORD);
int SetLimit(WORD sel,DWORD);
int SetAccess(WORD,BYTE,BYTE);
WORD CreatAlias(WORD);
int AllocSpecialLDT(WORD);
int GetDescriptor(WORD,DESCRIPTOR *);
int SetDescriptor(WORD,DESCRIPTOR *);
int GetExceptionVektor(BYTE,WORD *,WORD *);
int SetExceptionVektor(BYTE,WORD,WORD);
int GetPMinterruptVector(BYTE,WORD *,WORD *);
int SetPMinterruptVektor(BYTE,WORD,WORD);
void getfreeinfo(FREEMEMINFO *);
void printfreeinfo(FREEMEMINFO *);
DWORD GlobalAlloc(DWORD,DWORD *);
int GlobalFree(DWORD);
int LockLinRegion(DWORD,DWORD);
int UnlockLinRegion(DWORD,DWORD);
void Yield(void);
DWORD lsl(WORD);
WORD lsl16(WORD);
WORD lar(WORD);
WORD verr(WORD);
WORD verw(WORD);
void sgdt(GDTR *);
void sidt(GDTR *);
WORD sldt(void);
WORD str(void);
void far * incfp(void far *);
void far * decfp(void far *);
void farcopy(void far *, void far *,DWORD);
void printdescriptor(DESCRIPTOR);
void far * morepages(WORD);
void far *extmalloc(DWORD);
void extfree(void far *);
