// winsb.h

#if !defined(WINSB_H)

#include<stdlib.h>

#include"stddefs.h"

const MAXPOSITION = 32767;

/* WinScrollBar

This class creates a scrollbar, either horizontal
or vertical, and contains code to manage them.
*/
class WinScrollBar
    {
        void SetDefaults(void)
            {
            numLineScroll = numPageScroll = 1;
            minPosition = 0;
            maxPosition = MAXPOSITION;
            oldPosition = curPosition = 0;
            redraw = TRUE;
            myWin = NULL;
            barType = SB_VERT;
            created = FALSE;
            }

    protected:
        int numLineScroll;      // number of positions to scroll by line
        int numPageScroll;      // number of positions to scroll by page

        int curPosition;        // current thumb position
        int oldPosition;        // old thumb position
        int minPosition;        // lowest position on the scale
        int maxPosition;        // highest position on the scale

        HWND    myWin;          // window to which SB is attached
        int     barType;        // SB_CTL, SB_HORZ, SB_VERT
        BOOL    redraw;         // TRUE if we should redraw when range changes
        BOOL    created;

    public:
        WinScrollBar(HWND hWnd, int bar)
            {
            SetDefaults();
            SetType(bar);
            SetHandle(hWnd);
            }
        WinScrollBar(void)
            {
            SetDefaults();
            }

        void Init(HWND hWnd, int bar, int minpos, int maxpos)
            {
            SetHandle(hWnd);
            SetType(bar);
            SetRange(minpos,maxpos);
            Show();
            }

        void SetType(int bar)           {   barType = bar;      }
        void SetHandle(HWND hWnd)       {   myWin = hWnd;       }
        void SetRedraw(void)            {   redraw = TRUE;      }
        void SetLineScroll(int lines)   {   numLineScroll = lines;  }
        void SetPageScroll(int pages)   {   numPageScroll = pages;  }
        void ClearRedraw(void)          {   redraw = FALSE;     }

        void SetCurPos(int curpos)
            {
            curPosition = curpos;
            Update();
            }
        void SetMin(int minpos)
            {
            SetRange(minPosition = minpos,maxPosition);
            }
        void SetMax(int maxpos)
            {
            SetRange(minPosition,maxPosition = maxpos);
            }

        int GetCurPos(void)             { return curPosition;   }
        int GetMinPos(void)             { return minPosition;   }
        int GetMaxPos(void)             { return maxPosition;   }

        void Update(void)
            {
            if(!created)
                SetRange(minPosition, maxPosition);
            if(myWin)
                oldPosition = SetScrollPos(myWin,barType,curPosition,redraw);
            }

        void SetRange(int minimum, int maximum)
            {
            if(myWin)
                {
                minPosition = minimum;
                maxPosition = maximum;
                SetScrollRange(myWin,barType,minPosition,maxPosition, redraw);
                }
            created = TRUE;
            }
        void ScrollProc(WORD wParam, LONG lParam);
        void ScrollUpdate(WORD wParam, LONG lParam)
            {
            ScrollProc(wParam, lParam);
            Update();
            }
        void Hide(void)
            {
            ShowScrollBar(myWin,barType,FALSE);
            }
        void Show(void)
            {
            ShowScrollBar(myWin,barType,TRUE);
            }
    };


#define WINSB_H
#endif
