/*

  EDILZSS.DLL - Test program
  Copyright 1991 Robert Salesas, All Rights Reserved.

  See Pascal example for more information.

*/

#include <windows.h>
#include <dos.h>
#include <string.h>


int FAR PASCAL LZSSPackFile(LPSTR SrcFile, LPSTR DstFile);
// Packs SrcFile to DstFile using a LZSS algorithm.

int FAR PASCAL LZSSUnPackFile(LPSTR SrcFile, LPSTR DstFile);
// Unpacks SrcFile to DstFile using a LZSS algorithm.


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow )

{
  int  cmdCode;
  int  errCode;
  char *srcFile;
  char *dstFile;
  char *p;
  char buf[255];

  lstrcpy((LPSTR)buf, lpszCmdLine);
  p = strtok(buf, " ");
  if (p)
    {
      if (stricmp(p, "e") == 0)
	cmdCode = 1;
      else
	cmdCode = 0;

      srcFile = strtok(NULL, " ");
      if (srcFile)
	{
	  dstFile = strtok(NULL, " ");
	  if (dstFile)
	    {
	      if (cmdCode == 1)
		errCode = LZSSPackFile(srcFile, dstFile);
	      else
		errCode = LZSSUnPackFile(srcFile, dstFile);

	      if (errCode)
		MessageBox(0, "ERROR #--, unable to complete operation.",
			   "EDI LZSS TEST", MB_OK | MB_ICONINFORMATION);
	      else
		MessageBox(0, "All done.",
			   "EDI LZSS TEST", MB_OK | MB_ICONEXCLAMATION);

	      return 0;
	    }
	}
    }

  MessageBox(0, "USAGE:  LZSSTEST e|d infile outfile", "EDI LZSS TEST",
	     MB_OK | MB_ICONINFORMATION);
}




