
/*
 * Copyright (c) 1991 Darryl Collins.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Darryl Collins, University of western Australia.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/*
 * This program is intended only as an example of the use of the NetBIOS DLL
 *
 * Please send questions, comments and bug-reports to
 *
 *               darryl@fibula.surgery.uwa.oz.au
 *
 */

#include "windows.h"
#include "talk.h"
#include "netbios.h"

#define LINELENGTH      200
#define HISTORY         30

HANDLE  hInst;
HANDLE  hWnd;
HANDLE  hRecBox;
HANDLE  hSendDlg; 
HANDLE  hSysMenu;

char    cRemoteName[16];
char    cLocalName[16];

LPSTR   lpSendBuffer;
LPSTR   lpReceiveBuffer;

LPSTR   lpLocalName=cLocalName;
LPSTR   lpRemoteName=cRemoteName;

FARPROC lpProcSendBox;

unsigned char           nLsn;
unsigned char           nNum;


SESSIONSTATUS   ssStatBuf;


void ClearBuffer(LPSTR lpBuffer, int nLength);


	
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevious, LPSTR lpCmdLine, int nCmdShow) {

    MSG msgCurrent;
    
	lstrcpy(lpLocalName,lpCmdLine);

    if (!hPrevious) 
	if (!InitApplication(hInstance))
	    return(FALSE);
	    
    if (!InitInstance(hInstance, nCmdShow))
	return(FALSE);
	
    while(GetMessage(&msgCurrent, NULL, NULL, NULL)) {
		if(!hSendDlg || !IsDialogMessage(hSendDlg,&msgCurrent)) {
			TranslateMessage(&msgCurrent);
			DispatchMessage(&msgCurrent);
		}
    }
    
    return(msgCurrent.wParam);
}


BOOL InitApplication(HANDLE hInstance) {

    WNDCLASS    wcDefinition;
    
    wcDefinition.style = NULL;
    wcDefinition.lpfnWndProc = MainWndProc;

    wcDefinition.cbClsExtra = 0;
    wcDefinition.cbWndExtra = 0;
    
    wcDefinition.hInstance = hInstance;
    wcDefinition.hIcon = LoadIcon(hInstance,"Icon");
    wcDefinition.hCursor = LoadCursor(NULL, IDC_ARROW);
    
    wcDefinition.hbrBackground = GetStockObject(WHITE_BRUSH);
    
    wcDefinition.lpszMenuName = NULL;
    wcDefinition.lpszClassName = "TalkClass";
    
    if(!(RegisterClass(&wcDefinition)))
		return(FALSE);

    wcDefinition.style = NULL;
    wcDefinition.lpfnWndProc = TTYProc;

    wcDefinition.cbClsExtra = 0;
    wcDefinition.cbWndExtra = 0;
    
    wcDefinition.hInstance = hInstance;
    wcDefinition.hIcon = LoadIcon(NULL,IDI_APPLICATION);
    wcDefinition.hCursor = LoadCursor(NULL, IDC_ARROW);
    
    wcDefinition.hbrBackground = GetStockObject(WHITE_BRUSH);
    
    wcDefinition.lpszMenuName = NULL;
    wcDefinition.lpszClassName = "TTYClass";
    
    return(RegisterClass(&wcDefinition));
}


BOOL InitInstance(HANDLE hInstance, int nCmdShow) {

	LPNCB   lpNcb;

    hInst = hInstance;

    hWnd = CreateWindow(
	"TalkClass",
	"Talk",
	WS_OVERLAPPED|WS_ICONIC|WS_SYSMENU,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
	NULL,
	NULL,
	hInstance,
	NULL
    );
    
    if(!hWnd)  
	return(FALSE);

	hSysMenu = GetSystemMenu(hWnd,0);
	InsertMenu(hSysMenu,0,MF_SEPARATOR,(WORD)0,(LPSTR)0);
	InsertMenu(hSysMenu,0,MF_STRING|MF_ENABLED,IDC_CALL,(LPSTR)"C&all");

	EnableWindow(hWnd,FALSE);

	ShowWindow(hWnd,nCmdShow|SW_MINIMIZE);
	UpdateWindow(hWnd);

	lpNcb = AddName(hWnd, lpLocalName, NB_NOWAIT);
	if(!lpNcb) {
		MessageBox(hWnd,"Failed to add name", NULL, MB_OK);
		DestroyWindow(hWnd);
		return(FALSE);
	}

	SendMessage(hWnd,WM_SETTEXT,0,(DWORD)(LPSTR)"Wait ...");

    return(TRUE);
}


LONG FAR PASCAL MainWndProc(HWND hWnd, unsigned uMessage, WORD wParam, LONG lParam) {

    FARPROC             lpRemoteProc;

	HDC                             hDC;
	PAINTSTRUCT             ps;

	unsigned char   nRetCode;
	LPNCB                   lpNcb;

	register int    i,j;


    switch(uMessage) {

		case NB_COMMAND:
			
			lpNcb = (LPNCB)lParam;
			nRetCode = lpNcb->NcbRetCode;

			switch(wParam) {

				case NB_ADDNAME:

					EnableWindow(hWnd,TRUE);

					nNum = lpNcb->NcbNum;
					ReleaseNcb(lpNcb);

					if(nRetCode) {
						MessageBox(hWnd,"Failed to Add Name",NULL,MB_OK|MB_ICONSTOP);
						DestroyWindow(hWnd);
						break;
					}

					lpNcb = Listen(hWnd, (LPSTR)"*", lpLocalName, NB_NOWAIT);
					if(!lpNcb) {
						MessageBox(hWnd,"Listen Failed", NULL, MB_OK|MB_ICONSTOP);
						DestroyWindow(hWnd);
						return(FALSE);
					}

					SendMessage(hWnd,WM_SETTEXT,0,(DWORD)(LPSTR)"Talk");

					break;

				case NB_LISTEN:

					nLsn = lpNcb->NcbLsn;
					ReleaseNcb(lpNcb);

					if(nRetCode) {
						MessageBox(hWnd,"Listen Failed",NULL,MB_OK|MB_ICONSTOP);
						DestroyWindow(hWnd);
						break;
					}

					EnableMenuItem(hSysMenu,0,MF_BYPOSITION|MF_DISABLED|MF_GRAYED);
					
					lpNcb = SessionStatus(hWnd, (LPSTR)&ssStatBuf, 364, lpLocalName, NB_WAIT);
					ReleaseNcb(lpNcb);
					for(i=0; i<10; i++)
						if(ssStatBuf.ss[i].ssLsn == nLsn)
							break;

					if(i == 10)
						break;

					lstrcpy(lpRemoteName,&ssStatBuf.ss[i].ssRemoteName[0]);

					lpProcSendBox = MakeProcInstance(SendBoxProc,hInst);

					hSendDlg = CreateDialog(hInst, "SendBox", hWnd, lpProcSendBox);

					break;


				case NB_CALL:

					nLsn = lpNcb->NcbLsn;
					ReleaseNcb(lpNcb);

					if(nRetCode) {
						MessageBox(hWnd,"Call Failed",NULL,MB_OK|MB_ICONSTOP);
						break;
					}

					EnableMenuItem(hSysMenu,0,MF_BYPOSITION|MF_DISABLED|MF_GRAYED);
					
					lpProcSendBox = MakeProcInstance(SendBoxProc,hInst);

					hSendDlg = CreateDialog(hInst, "SendBox", hWnd, lpProcSendBox);

					break;


				default:
					ReleaseNcb(lpNcb);
					break;
			}

			break;


		case WM_SYSCOMMAND:

			switch(wParam&0xfff0) {

				case IDC_CALL:

		    lpRemoteProc = MakeProcInstance(RemoteDlgProc,hInst);
		    
		    if(DialogBox(hInst,"CallBox",hWnd,lpRemoteProc)) {
						lpNcb = Call(hWnd,lpRemoteName,lpLocalName,NB_NOWAIT);
						if(!lpNcb) {
							FreeProcInstance(lpRemoteProc);
							MessageBox(hWnd,"Call Failed",NULL,MB_OK|MB_ICONSTOP);
							break;
						}
					}

					FreeProcInstance(lpRemoteProc);

					break;

				case SC_CLOSE:
					DestroyWindow(hWnd);
					break;

				default:
					return(DefWindowProc(hWnd,uMessage,wParam,lParam));
			}

			break;


		case WM_CLOSE:    
			DestroyWindow(hWnd);
			break;


	case WM_DESTROY:
			if(nLsn) {
				lpNcb = HangUp(hWnd,nLsn,NB_WAIT);
				ReleaseNcb(lpNcb);
			}

			if(nNum) {
				lpNcb = DeleteName(hWnd,lpLocalName,NB_WAIT);
				ReleaseNcb(lpNcb);
			}

			if(lpReceiveBuffer)
				FreeFixedBuffer(lpReceiveBuffer);

	    PostQuitMessage(0);
	    break;
	    
	default:
	    return(DefWindowProc(hWnd, uMessage, wParam, lParam));
    
    }
    
    return(NULL);
}


LONG FAR PASCAL TTYProc(HWND hWnd, unsigned uMessage, WORD wParam, LONG lParam) {

	register int i,j,k;

	HDC                     hDC;
	PAINTSTRUCT     ps;

	static RECT rcClient;
	static int      X,Y;

	static char     cHistory[HISTORY][LINELENGTH];
	static BOOL bHistory[HISTORY];
	static int      nLine=0;

	static int      nScroll;
	static BOOL     bScroll;

	long            lUnits;


    switch(uMessage) {

		case WM_CREATE:
			nLine = 0;

			lUnits = GetDialogBaseUnits();
			X = LOWORD(lUnits);
			Y = HIWORD(lUnits)/2;

			GetClientRect(hWnd,&rcClient);

			nScroll = (rcClient.bottom-rcClient.top)/Y/2;

			break;

		case WM_COMMAND:

			switch(wParam) {
			
				case TTY_ADDLINE:
					lstrcpy((LPSTR)&cHistory[nLine][0],(LPSTR)lParam);
					bHistory[nLine] = ((LPSTR)lParam == lpReceiveBuffer);

					nLine++;
					nLine %= HISTORY;
					if(nLine > nScroll)
						bScroll = TRUE;

					InvalidateRect(hWnd,NULL,TRUE);
					break;
			}

			break;

		case WM_PAINT:
			hDC = BeginPaint(hWnd,&ps);

			if(bScroll) {
				j = nLine-nScroll;
				if(j < 0)
					j += HISTORY;
			} else {
				j = 0;
			}

			for(i=j,k=0; i<nLine; k++, i++, i%=HISTORY) {
				if(bHistory[i])
					SetTextColor(hDC,RGB(0,0,0));
				else
					SetTextColor(hDC,RGB(255,0,0));
				TextOut(hDC,X,Y*k*2,(LPSTR)&cHistory[i][0],lstrlen((LPSTR)&cHistory[i][0]));
			}

			EndPaint(hWnd,&ps);
			break;

			
	default:
	    return(DefWindowProc(hWnd, uMessage, wParam, lParam));
    
    }
    
    return(NULL);
}


BOOL FAR PASCAL SendBoxProc(HWND hDlg, unsigned uMessage, WORD wParam, DWORD lParam) {

	LPNCB                   lpNcb;
	unsigned char   nRetCode;       

	static HANDLE   hRecFrame;
	static HANDLE   hSendBox;

	RECT                    rcClient;

	register int    i,j;

	LPSTR                   p;


	switch(uMessage) {

		case WM_INITDIALOG:

			SendMessage(hDlg,WM_SETTEXT,(WORD)0,(DWORD)lpRemoteName);

			lpReceiveBuffer = AllocFixedBuffer(LINELENGTH);
			if(!lpReceiveBuffer)
				return(TRUE);

			lpNcb = Receive(hDlg,nLsn,lpReceiveBuffer,LINELENGTH,NB_NOWAIT);
			if(!lpNcb)
				return(TRUE);

			hRecFrame = GetDlgItem(hDlg,IDC_RECBOX);
			hSendBox = GetDlgItem(hDlg,IDC_SENDBOX);

			GetClientRect(hRecFrame,&rcClient);

			hRecBox = CreateWindow(
				"TTYClass",
				"RecWindow",
				WS_CHILD|WS_VISIBLE|WS_BORDER,
				0,
				0,
				rcClient.right-rcClient.left,
				rcClient.bottom-rcClient.top,
				hRecFrame,
				NULL,
				hInst,
				NULL
			);

			if(!hRecBox)
				PostMessage(hDlg,WM_COMMAND,IDC_HANGUP,(DWORD)0);

			SetFocus(hSendBox);

			return(FALSE);


		case NB_COMMAND:

			lpNcb = (LPNCB)lParam;
			nRetCode = lpNcb->NcbRetCode;
			
			switch(wParam) {

				case NB_RECEIVE:

					ReleaseNcb(lpNcb);

					if(nRetCode) {
						if(nRetCode == 0x0a) {
							PostMessage(hDlg,WM_COMMAND,IDC_HANGUP,(DWORD)NULL);                                                    
							return(TRUE);
						}
						return(TRUE);
					}

					SendMessage(hRecBox,WM_COMMAND,TTY_ADDLINE,(DWORD)lpReceiveBuffer);

					ClearBuffer(lpReceiveBuffer,LINELENGTH);
					lpNcb = Receive(hDlg,nLsn,lpReceiveBuffer,LINELENGTH,NB_NOWAIT);

					return(TRUE);

				case NB_SEND:

					FreeFixedBuffer(lpNcb->NcbBuffer);

					ReleaseNcb(lpNcb);
					if(nRetCode) {
						if(nRetCode == 0x0a) {
							PostMessage(hDlg,WM_COMMAND,IDC_HANGUP,(DWORD)NULL);
							return(TRUE);
						}
					}

					return(TRUE);


				default:
					ReleaseNcb(lpNcb);
					if(nRetCode) {
						if(nRetCode == 0x0a) {
							PostMessage(hDlg,WM_COMMAND,IDC_HANGUP,(DWORD)NULL);
							return(TRUE);
						}
					}
					return(TRUE);
			}

		case WM_COMMAND:
		
			switch(wParam) {

				case IDC_OK:

					j = SendDlgItemMessage(hDlg,IDC_SENDBOX,EM_GETLINECOUNT,(WORD)0,(DWORD)0);

					for(i=0; i<j; i++) {

						lpSendBuffer = AllocFixedBuffer(LINELENGTH);
						if(!lpSendBuffer)
							return(TRUE);

						lpSendBuffer[0] = LINELENGTH;

						if(SendDlgItemMessage(hDlg,IDC_SENDBOX,EM_GETLINE,(WORD)i,(DWORD)lpSendBuffer)) {

							SendMessage(hRecBox,WM_COMMAND,TTY_ADDLINE,(DWORD)lpSendBuffer);

							lpNcb = Send(hDlg,nLsn,lpSendBuffer,lstrlen(lpSendBuffer),NB_NOWAIT);
							if(!lpNcb)
								return(TRUE);
						}
					}

					SendDlgItemMessage(hDlg,IDC_SENDBOX,WM_SETTEXT,0,(DWORD)(LPSTR)"");

					SetFocus(hSendBox);

					return(TRUE);

				case IDC_CANCEL:

					SendDlgItemMessage(hDlg,IDC_SENDBOX,WM_SETTEXT,(WORD)1,(DWORD)(LPSTR)"");
					return(TRUE);


				case IDC_HANGUP:
					
					if(nLsn) {
						lpNcb = HangUp(hDlg,nLsn,NB_WAIT);
						ReleaseNcb(lpNcb);
					}

					EnableMenuItem(hSysMenu,0,MF_BYPOSITION|MF_ENABLED);

					lpNcb = Listen(hWnd, (LPSTR)"*", lpLocalName, NB_NOWAIT);
					if(!lpNcb) {
						MessageBox(hWnd,"Listen Failed", NULL, MB_OK|MB_ICONSTOP);
						DestroyWindow(hWnd);
						return(FALSE);
					}

					hSendDlg = 0;

					DestroyWindow(hDlg);

					return(TRUE);

			}
			
			break;
	}

	return(FALSE);
}


BOOL FAR PASCAL RemoteDlgProc(HWND hDlg, unsigned uMessage, WORD wParam, DWORD lParam) {

	HANDLE  hEdit;

    switch(uMessage) {
    
	case WM_COMMAND:
	    
	    switch(wParam) {
		case IDC_OK:
					GetDlgItemText(hDlg,IDC_REMOTE,lpRemoteName,16);
					EndDialog(hDlg,TRUE);
					return(TRUE);

		case IDC_CANCEL:
		    EndDialog(hDlg,FALSE);
		    return(TRUE);
	    }
	    
	    break;

	case WM_INITDIALOG:
			
			hEdit = GetDlgItem(hDlg,IDC_REMOTE);
			SetFocus(hEdit);
			
	    return(FALSE);
    }
    
    return(FALSE);
}


void ClearBuffer(LPSTR lpBuffer, int nLength) {

	LPSTR   p = lpBuffer;

	while(p < &lpBuffer[nLength]) 
		*p++ = '\0';
}
