/* ------------------------------ CCINIT.C ---------------------------
 *	DLL Initialisation and Finalization
 * ---------------------------------------------------------------- */

#include <windows.h>
#include "Target_.h"

/* -------------------------- LibMain -------------------------------
 *	Function called when DLL is loaded, from asm entry point
 *		- hinst is DLL's handle
 *		- wDataSeg is DS segment
 *		- cbHeapSize is HEAPSIZE as declared in .DEF file
 *		- lpszCmdLine is command line
 *		Returns		TRUE to accept loading
 *					FALSE to stop it
 * ---------------------------------------------------------------- */

int CALLBACK LibMain (HINSTANCE hinst, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
WNDCLASS		wc;					// Window class structure
LRESULT CALLBACK TargetWndProc (HWND, unsigned, WORD, DWORD);

	hmodDLL = hinst;				// Global variable

// ---- Unlocks the Date segment (if LocalInit had been called)
	UnlockData (0);

// ---- Registers class
	wc.hCursor			= LoadCursor (NULL, IDC_CROSS);
	wc.hIcon			= NULL;
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= TARGET_CLASSNAME;
	wc.hbrBackground	= COLOR_WINDOW+1;
	wc.hInstance		= hinst;
	wc.style			= CS_GLOBALCLASS | CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= TargetWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 8;		// xCur, yCur, fCapture, VBBmp

	return RegisterClass (&wc);		// Stops loading if failure
}
