/* ------------------------------ CCINIT.C ---------------------------
 *	DLL initializations
 * ---------------------------------------------------------------- */

#include <windows.h>
#include <vbapi.h>

#include "Target.h"
#include "VBTarget.h"

// ---------------------- Global Variables -------------------------

HANDLE			hLib;

// ---- Specific Properties
PROPINFO PropertyXPos =
{
	"XPos",
	DT_XPOS | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN (TARGET, XPos),
	0,
	0,
	NULL,
	0
};

PROPINFO PropertyYPos =
{
	"YPos",
	DT_YPOS | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN (TARGET, YPos),
	0,
	0,
	NULL,
	0
};

PROPINFO PropertyType =
{
	"Type",
	DT_ENUM | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN (TARGET, Type),
	0,
	TYPE_CIRCLES,
	"0 - Circles\0" "1 - Plain\0" "2 - Bitmap\0",
	TYPE_MAX
};

PROPINFO PropertyPicture =
{
	"Picture",
	DT_PICTURE | PF_fGetData | PF_fSetData | PF_fSetCheck | PF_fSaveData,
    OFFSETIN (TARGET, hpicPix),
	0,
	0,
	NULL,
	0
};

// ---- Properties Table
static PPROPINFO PropertiesCtrl1[] =
{
	PPROPINFO_STD_CTLNAME,
	PPROPINFO_STD_INDEX,
	PPROPINFO_STD_BACKCOLOR,
	PPROPINFO_STD_LEFT,
	PPROPINFO_STD_TOP,
	PPROPINFO_STD_WIDTH,
	PPROPINFO_STD_HEIGHT,
	PPROPINFO_STD_VISIBLE,
	PPROPINFO_STD_ENABLED,
	PPROPINFO_STD_PARENT,
	PPROPINFO_STD_DRAGMODE,
	PPROPINFO_STD_DRAGICON,
	PPROPINFO_STD_TABINDEX,
	PPROPINFO_STD_TABSTOP,
	PPROPINFO_STD_TAG,
	PPROPINFO_STD_BORDERSTYLEON,
	&PropertyXPos,
	&PropertyYPos,
	&PropertyType,
	&PropertyPicture,
	NULL
};

// ---- Specific Events
EVENTINFO EventChange =
{
	"Change",
	0,
	0,
	NULL,
	NULL
};

// ---- Events Table
static PEVENTINFO EventsCtrl1[] =
{
	&EventChange,
	PEVENTINFO_STD_CLICK,
	PEVENTINFO_STD_DBLCLICK,
	PEVENTINFO_STD_DRAGDROP,
	PEVENTINFO_STD_DRAGOVER,
	PEVENTINFO_STD_GOTFOCUS,
	PEVENTINFO_STD_LOSTFOCUS,
	NULL
};

// ---- Control Model
static MODEL ModelCtrl1 =
{
	VB_VERSION,						// VB Version
	MODEL_fArrows | MODEL_fFocusOk,	// MODEL flags
	(PCTLPROC)TargetCtlProc,		// Control Function
	CS_VREDRAW | CS_HREDRAW,		// Class style
	TGS_VB,							// Default Window style
	sizeof(TARGET),					// Size of TARGET structure
	IDBMP_TARGET,					// First Bitmap for tool box
	"Target",						// Default CtlName
	"VBTarget",						// Visual Basic class name
	"Target",						// Subclassed class name
	PropertiesCtrl1,				// Properties Table
	EventsCtrl1						// Events Table
};

/* -------------------------- VBINITCC ------------------------------
 *	Called by VB when control is loaded
 *		- usVersion is VB version
 *		- fRuntime is TRUE if .EXE, FALSE if VB
 *		Returns:	TRUE to proceed
 *					FALSE to stop loading
 * ---------------------------------------------------------------- */

BOOL FAR PASCAL _export VBINITCC (USHORT usVersion, BOOL fRuntime)
{
BOOL			fOk;

// ---- Registers control
    fOk = VBRegisterModel (hmodDLL, &ModelCtrl1);
	return fOk;
}

/* -------------------------- VBTERMCC ------------------------------
 *	Called when control is beeing unloaded
 * ---------------------------------------------------------------- */

VOID FAR PASCAL _export VBTERMCC ()
{
// ---- Nothing to do
}

/* -------------------------- LibMain -------------------------------
 *	Called first time DLL is loaded
 *		- hmod is DLL's handle
 *		- segDS is DS segment
 *		- cbHeapSize is HEAPSIZE in .DEF file
 *		Returns		TRUE to proceed
 *					FALSE to stop loading
 * ---------------------------------------------------------------- */

int CALLBACK LibMain (HINSTANCE hinst, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
	hmodDLL = hinst;				// Global variable

// ---- Unlocks Data segment (if LocalInit called)
	UnlockData (0);

// ---- Loads DLL
	hLib = LoadLibrary ("Target.dll");

	return hLib;
}

/* -------------------------- WEP -----------------------------------
 *	Function called when DLL is unloaded
 *		- fSystemExit can be	WEP_SYSTEM_EXIT if Windows ends
 *								WEP_FREE_DLL if DLL is beeing unloaded
 * ---------------------------------------------------------------- */

VOID FAR PASCAL _export WEP (BOOL fSystemExit)
{
	FreeLibrary (hLib);
}
