#include "sortcltn.h"

#define THIS    SortedCltn
#define BASE    OrderedCltn
DEFINE_CLASS(SortedCltn,OrderedCltn);

SortedCltn::SortedCltn(unsigned size) : OrderedCltn(size) {}

SortedCltn::SortedCltn(const SortedCltn& s) : OrderedCltn(s) {}

void SortedCltn::operator=(const SortedCltn& s)
{
    this->OrderedCltn::operator=(s);
}

bool SortedCltn::operator==(const SortedCltn& s) const
{
    return this->OrderedCltn::operator==(s);
}
    
Object* SortedCltn::add(const Object& ob)
{
    if (size()==0) {        // add first object to collection 
        this->OrderedCltn::add(ob);
        return (Object*)&ob;
    }
/*
Do a binary search to determine where to insert the object.  This binary
search algorithm was adapted from Knuth, "The Art of Computer
Programming", Vol. 3, Section 6.2.1, Algorithm U.
*/
    register int i =(size()+1)>>1;
    register int m =size()>>1;
    while (YES) {
        if (i>0 && ob.compare(*contents[i-1])<0) {
            if (m==0) {
                this->OrderedCltn::addAtIndex(i-1,ob);
                return (Object*)&ob;
            }
            else i -= (m+1)>>1;
        }
        else {
            if (m==0) {
                this->OrderedCltn::addAtIndex(i,ob);
                return (Object*)&ob;
            }
            else i += (m+1)>>1;
        m >>= 1;
        }
    }
#if (0 MSC(+1))                                 // if Microsoft C++
    // should never be executed
    return (Object*)NULL;                       // avoids Warning message
#endif
}
    
Object* SortedCltn::addAfter(const Object& ob, const Object& /*newob*/)
{
    shouldNotImplement("addAfter"); return (Object*)&ob;
}

Object* SortedCltn::addAllLast(const OrderedCltn&)
{
    shouldNotImplement("addAllLast"); return (Object*)0;
}

Object* SortedCltn::addBefore(const Object& ob, const Object& /*newob*/)
{
    shouldNotImplement("addBefore"); return (Object*)&ob;
}

Object* SortedCltn::addLast(const Object& ob)
{
    shouldNotImplement("addLast"); return (Object*)&ob;

}

void SortedCltn::atAllPut(const Object&)
{
    shouldNotImplement("atAllPut");
}

int SortedCltn::indexOfSubCollection(const SeqCltn& /*cltn*/,
                                     int /*start*/) const
{
    shouldNotImplement("indexOfSubCollection"); return 0;
}

//SeqCltn SortedCltn::operator&(const SeqCltn& cltn) const
SeqCltn SortedCltn::operator&(/*const*/ SeqCltn& cltn) const //-gmv 5/2/90
{
    shouldNotImplement("operator&"); return cltn;
}

void SortedCltn::replaceFrom(int /*start*/,
                             int /*stop*/,
                             const SeqCltn& /*replacement*/,
                             int /*startAt*/)
{
    shouldNotImplement("replaceFrom");
}

void SortedCltn::sort()
{
    shouldNotImplement("sort");
}
 
SortedCltn Collection::asSortedCltn() const
{
    SortedCltn cltn(MAX(size(),CLTN_DEFAULT_CAPACITY));
    addContentsTo(cltn);
    return cltn;
}
