#include "point.h"
#include "sortcltn.h"
#include "set.h"

#define TestDate
#ifdef TestDate
#include "date.h" //-gmv
#include "timecls.h"
#endif

main()
{
    cout << "\nTest class Time\n";
#ifdef TestDate
    //-gmv
    cout << "dates\n";
    Date d1(1,"Jan",85);
    Date d2(1,"Jan",86);
    Date d3(1,"Jan",87);

    Date d4(2,"Jan",87);
    Date d5(2,"Jan",86);
    Date d6(2,"Jan",85);

    Date d7(31,"Dec",87);
    Date d8(31,"Dec",86);
    Date d9(31,"Dec",85);

    Date d10(1,"Jan",93);
    Date d11(1,"Jan",94);
    Date d12(1,"Jan",95);

    SortedCltn u(8);
    u.add(d1);
    u.add(d2);
    u.add(d3);

    u.add(d4);
    u.add(d5);
    u.add(d6);

    u.add(d7);
    u.add(d8);
    u.add(d9);

    u.add(d10);
    u.add(d11);
    u.add(d12);

    u.add(*new Date(31,"Dec",93));
    u.add(*new Date( 1,"Apr",93));
    u.add(*new Date( 1,"May",93));
    u.add(*new Date( 27,"Apr",93));


    cout << "u = " << u << "\n";
    Date aDate(27, "Apr", 93);
    cout << aDate
         << " Day of Week is "
         << aDate.weekDay()
         << " ("
         << nameOfDay(aDate.weekDay())
         << ")"
         << "\n";
#endif
                
    Time t1(Date(1,"Jan",93), 12, 30, 15);
    cout << "aTime==>"
         << t1
         << "\n";
    SortedCltn timeCollection(8);
    timeCollection.add(t1);             // add main time
    timeCollection.add(t1);             // duplicate entry
    timeCollection.add(t1+1);           // one second later
    timeCollection.add(t1-1);           // one second earlier

    timeCollection.add(t1+60);          // one minute later
    timeCollection.add(t1-60);          // one minute earlier

    timeCollection.add(t1+60*60);       // one hour later
    timeCollection.add(t1-60*60);       // one hour earlier 

    timeCollection.add(t1+60*60*10L);   // ten hours later
                                        // implicit cast to long is necessary
                                        // if number added to Time is greater
                                        // than 32768 (2^15)

    timeCollection.add(t1+60*60*24L);   // one day later
    timeCollection.add(t1-60*60*24L);   // one day earlier 

    timeCollection.add(t1+60*60*6L);   // six hours later
    timeCollection.add(t1-60*60*6L);   // six hours earlier

    timeCollection.add(t1+60*60*12L);   // twelve hours later
    timeCollection.add(t1-60*60*12L);   // twelve hours earlier
    cout << "timeCollection = " << timeCollection << "\n";
    return 0;
}

