/* Net.H - Include file for NET.C */
#ifndef NET_H
#define NET_H

#include "WsmtpSrv.h"

/* Messages sent by WSA calls to NetProc */
#define NET_BASE     1
#define NET_ACTIVITY NET_BASE
#define NET_NAME     NET_BASE+1

#define SMTP_NAME       "smtp"          /* try a database lookup first! */
#define SMTP_PORT       IPPORT_SMTP     /* 25 - The one and only SMTP port */


// Structure to hold the WSA error and its Resource String ID
typedef struct
{
 int iError;
 int iResourceID;
} NETERROR;

// Structure that holds help topic Resource string
typedef struct
{
 PSTR pTopic;
 int  iResourceID;
} HELPTOPIC;


#ifdef NET_C

// Globals for Net.C only

static SOCKET sSocketMain;          // Main Accepting socket
static char szNetworkClass[40];     // Network window class name
static char szMainBuffer[MAXSNDBUFF];  // Temporary string buffer

    // Day/Month strings
static LPSTR lpDaysOfTheWeek[] =
{
 "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
 "Today"
};

static LPSTR lpMonthsOfTheYear[] =
{
 "Jan", "Feb", "Mar", "Apr", "May", "June",
 "July","Aug", "Sep", "Oct", "Nov", "Dec",
 "This-Month"
};

// Equivalence table for all net errors
// Bad form, should have used the error number as the
// actual resource ID... but I'm too lazy to go back
// and change it.
NETERROR netErrorTable[] =
{
 {WSANOTINITIALISED,     ERROR_WSANOTINITIALISED    },
 {WSAENETDOWN,           ERROR_WSAENETDOWN          },
 {WSAENETUNREACH,        ERROR_WSAENETUNREACH       },
 {WSAENETRESET,          ERROR_WSAENETRESET         },
 {WSAECONNABORTED,       ERROR_WSAECONNABORTED      },
 {WSAECONNRESET,         ERROR_WSAECONNRESET        },
 {WSAEACCES,             ERROR_WSAEACCES            },
 {WSAEADDRINUSE,         ERROR_WSAEADDRINUSE        },
 {WSAEADDRNOTAVAIL,      ERROR_WSAEADDRNOTAVAIL     },
 {WSAEALREADY,           ERROR_WSAEALREADY          },
 {WSAEDESTADDRREQ,       ERROR_WSAEDESTADDRREQ      },
 {WSAEMSGSIZE,           ERROR_WSAEMSGSIZE          },
 {WSAEBADF,              ERROR_WSAEBADF             },
 {WSAEFAULT,             ERROR_WSAEFAULT            },
 {WSAEINTR,              ERROR_WSAEINTR             },
 {WSAEINPROGRESS,        ERROR_WSAEINPROGRESS       },
 {WSAEAFNOSUPPORT,       ERROR_WSAEAFNOSUPPORT      },
 {WSAEINVAL,             ERROR_WSAEINVAL            },
 {WSAEMFILE,             ERROR_WSAEMFILE            },
 {WSAENOBUFS,            ERROR_WSAENOBUFS           },
 {WSAEISCONN,            ERROR_WSAEISCONN           },
 {WSAENOTCONN,           ERROR_WSAENOTCONN          },
 {WSAESHUTDOWN,          ERROR_WSAESHUTDOWN         },
 {WSAETOOMANYREFS,       ERROR_WSAETOOMANYREFS      },
 {WSAETIMEDOUT,          ERROR_WSAETIMEDOUT         },
 {WSAECONNREFUSED,       ERROR_WSAECONNREFUSED      },
 {WSAELOOP,              ERROR_WSAELOOP             },
 {WSAENAMETOOLONG,       ERROR_WSAENAMETOOLONG      },
 {WSAEHOSTDOWN,          ERROR_WSAEHOSTDOWN         },
 {WSAEHOSTUNREACH,       ERROR_WSAEHOSTUNREACH      },
 {WSASYSNOTREADY,        ERROR_WSASYSNOTREADY       },
 {WSAVERNOTSUPPORTED,    ERROR_WSAVERNOTSUPPORTED   },
 {WSAHOST_NOT_FOUND,     ERROR_WSAHOST_NOT_FOUND    },
 {WSATRY_AGAIN,          ERROR_WSATRY_AGAIN         },
 {WSANO_RECOVERY,        ERROR_WSANO_RECOVERY       },
 {WSANO_DATA,            ERROR_WSANO_DATA           },
 {WSAENOTSOCK,           ERROR_WSAENOTSOCK          },
 {WSAEPROTOTYPE,         ERROR_WSAEPROTOTYPE        },
 {WSAENOPROTOOPT,        ERROR_WSAENOPROTOOPT       },
 {WSAEPROTONOSUPPORT,    ERROR_WSAEPROTONOSUPPORT   },
 {WSAEOPNOTSUPP,         ERROR_WSAEOPNOTSUPP        },
 {WSAEPFNOSUPPORT,       ERROR_WSAEPFNOSUPPORT      },
 {WSAEWOULDBLOCK,        ERROR_WSAEWOULDBLOCK       },
 {0,                     ERROR_UNKNOWN              }
};
#endif /* NET_C */

    /* PROTOTYPES */
BOOL netInit(void);
void netError(void);
LRESULT CALLBACK NetProc(HWND, UINT, WPARAM, LPARAM);
BOOL netGetTimeAndDate(LPSTR, int);
int netSendData(struct tagSMTPCLIENT FAR *);
int netReceiveData(struct tagSMTPCLIENT FAR *);
void netClose(void);

#endif /* NET_H */
