/*************************************************************************
 Windows Sockets Application ERROR Support Module
 Written by John A. Junod, 267 Hillwood St., Martinez, GA, 30907 93.10.01

 Released into the public domain with no restrictions other than to give
 me some of the credit if you use this code in other applications.  Some
 code concepts based on code in Windows Sockets Finger Client, copyright
 1992, Network Research Corporation.
*****************************************************************************/

#include "ws_glob.h"
#include "ws_ping.h"

struct WS_ERRORS
{
  UINT uErr;
  LPSTR szText;
};

#define NUMwsErrs 29
struct WS_ERRORS wsErrs[] =
{
   WSAEINTR,         "INTR:Blocking call cancelled", // 4
   WSAEFAULT,        "FAULT:from buf 2 small 4 peer addr", // 14
   WSAEINVAL,        "INVAL:app ver not supported by DLL", // 22
   WSAEMFILE,        "MFILE:no file desc avail", // 24
   WSAEWOULDBLOCK,   "WOULDBLOCK:non-blocking and would block", // 35

   WSAEINPROGRESS,   "INPROGRESS:blocking operation in progress", // 36
   WSAENOTSOCK,      "NOTSOCK:not a socket", // 38
   WSAEPROTOTYPE,    "PROTOTYPE:wrong type for socket", // 41
   WSAEPROTONOSUPPORT,"protocol not supported (try Trumpet Alpha 15)", // 43
   WSAESOCKTNOSUPPORT,"socket type not supported for address family", // 44

   WSAEAFNOSUPPORT,  "address family not supported", // 47
   WSAEADDRINUSE,    "address in use", //48
   WSAENETDOWN,      "ENETDOWN:net subsystem failed (no arp response?)", // 50
   WSAECONNABORTED,  "connection aborted",// 53
   WSAECONNRESET,    "connection reset",// 54

   WSAENOBUFS,       "no buffer space available", // 55
   WSAENOTCONN,      "not connected", //57
   WSAETIMEDOUT,     "connection timed out", // 60
   WSAECONNREFUSED,  "connection refused",  // 61
   WSAEHOSTDOWN,     "host down", // 64

   WSAEHOSTUNREACH,  "host unreachable", // 65
   WSASYSNOTREADY,   "WinSock not present or not responding", // 91
   WSAVERNOTSUPPORTED,"Version of WinSock not supported", // 92
   WSANOTINITIALISED,"WSA Startup not initialized", // 93
   WSAHOST_NOT_FOUND,"Authoritive: Host not found", // 1001

   WSATRY_AGAIN,
        "Non-authoritive: host not found or server failure", // 1002
   WSANO_RECOVERY,   "Non-recoverable: refused or not implemented", // 1003
   WSANO_DATA,       "Valid name, no data record for type", // 1004
   WSANO_ADDRESS,    "Valid name, no MX record", // 1004
};

LPSTR ReturnWSError(UINT nErr,LPSTR szBuf)
{
   int nIndex;
   static char szErrMsg[128];

   if(szBuf==NULL) szBuf=szErrMsg;
   for (nIndex = 0; nIndex < NUMwsErrs; nIndex++)
   {
      if (nErr == wsErrs[nIndex].uErr)
      {
         wsprintf((LPSTR)szBuf,(LPSTR)"%s",wsErrs[nIndex].szText);
         return(szBuf);
      }
   }
   wsprintf((LPSTR)szBuf, (LPSTR)"WS error %u", nErr);
   return(szBuf);
}

VOID ReportWSError(UINT nErr)
{
   DoAddLine(ReturnWSError(nErr,NULL));
}
